/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.enclosure;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarEnclosure;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseExtend;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslate;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslateField;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarPublicEnclosure;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarTemplateUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarTranslateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARFLOWENCLOSURE")
public class OscarFlowEnclosure
implements OscarEnclosure<OscarFlowDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(OscarFlowEnclosure.class);
    public static final String ENCLOSURE = "OSCARFLOWENCLOSURE";

    @Override
    public OscarDataModelBaseDTO enclosure(OscarFlowDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        List<OscarDataModelField> dataModelFieldBases;
        OscarFlowDataModelDTO dataModelBaseDTO = new OscarFlowDataModelDTO();
        dataModelBaseDTO.setUseMybatisPlus(true);
        OscarPublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        if (dataModelBase.getSourceDataModelName() != null) {
            dataModelBaseDTO.setSourceDataModelName(dataModelBase.getSourceDataModelName());
        }
        if (ToolUtil.isEmpty(dataModelFieldBases = dataModelBase.getFlowFields())) {
            logger.error("enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new OscarFlowDataModelDTO();
        }
        ArrayList<OscarDataModelFieldDto> tableFields = new ArrayList<OscarDataModelFieldDto>();
        for (OscarDataModelField dataModelFieldBase : dataModelFieldBases) {
            OscarDataModelFieldDto tableField = new OscarDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        List<OscarTranslate> translates = dataModelBase.getTranslate();
        if (ToolUtil.isNotEmpty(translates)) {
            List rightFields = ModelProvideAdapter.adaptor((String)dataModelBase.getId()).getFields(dataModelBase.getId());
            List<Map<String, Object>> translateAnnotations = OscarTranslateUtil.translate(translates, rightFields);
            if (ToolUtil.isNotEmpty(translateAnnotations)) {
                List<OscarDataModelFieldDto> fields = dataModelBaseDTO.getFields();
                block1: for (Map map : translateAnnotations) {
                    if (!ToolUtil.isNotEmpty((Object)map) || !ToolUtil.isNotEmpty(map.get("fieldId"))) continue;
                    for (OscarDataModelFieldDto field : fields) {
                        if (!field.getId().equals(map.get("fieldId").toString())) continue;
                        field.setFieldAnnotation(map.get("fieldAnnotation").toString());
                        if (!field.isExtend()) continue block1;
                        for (OscarTranslate translate : translates) {
                            if (!field.getId().equals(translate.getSourceFieldId())) continue;
                            List<OscarTranslateField> translateFields = translate.getTranslateFields();
                            for (OscarTranslateField translateField : translateFields) {
                                translateField.setExtend(field.isExtend());
                            }
                        }
                        continue block1;
                    }
                }
                dataModelBaseDTO.setFields(fields);
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.anno.Trans");
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.constant.TransType");
            }
            List<OscarDataModelFieldDto> translateShowFields = OscarTranslateUtil.getTranslateShowFields(translates);
            for (OscarDataModelFieldDto oscarDataModelFieldDto : translateShowFields) {
                if (null == oscarDataModelFieldDto.getColumnType() || null == oscarDataModelFieldDto.getColumnType().getImportT()) continue;
                dataModelBaseDTO.addEntityImport(oscarDataModelFieldDto.getColumnType().getImportT());
            }
            dataModelBaseDTO.setTranslateShowFields(translateShowFields);
        }
        this.structureExtendObj(dataModelBaseDTO);
        PublishTemplateDto publishTemplateDto = OscarTemplateUtil.processTemplate(dataModelBase.getId(), null);
        dataModelBaseDTO.setPublishTemplateDto(publishTemplateDto);
        return dataModelBaseDTO;
    }

    private void structureExtendObj(OscarFlowDataModelDTO dataModelBaseDTO) {
        List<OscarDataModelFieldDto> fields = dataModelBaseDTO.getFields();
        ArrayList<OscarDataModelFieldDto> extendFields = new ArrayList<OscarDataModelFieldDto>();
        if (ToolUtil.isNotEmpty(fields)) {
            for (OscarDataModelFieldDto field : fields) {
                if (!ToolUtil.isNotEmpty((Object)field) || !field.isExtend()) continue;
                extendFields.add(field);
            }
        }
        if (ToolUtil.isNotEmpty(extendFields)) {
            if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getExtendObj())) {
                OscarBaseExtend extend = new OscarBaseExtend();
                extend.setExtendFields(extendFields);
                dataModelBaseDTO.setExtendObj(extend);
            } else {
                dataModelBaseDTO.getExtendObj().setExtendFields(extendFields);
            }
        }
        List<OscarDataModelFieldDto> translateShowFields = dataModelBaseDTO.getTranslateShowFields();
        ArrayList<OscarDataModelFieldDto> translateExtendFields = new ArrayList<OscarDataModelFieldDto>();
        if (ToolUtil.isNotEmpty(translateShowFields)) {
            for (OscarDataModelFieldDto translateShowField : translateShowFields) {
                if (!ToolUtil.isNotEmpty((Object)translateShowField) || !translateShowField.isExtend()) continue;
                translateExtendFields.add(translateShowField);
            }
        }
        if (ToolUtil.isNotEmpty(translateExtendFields)) {
            if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getExtendObj())) {
                OscarBaseExtend extend = new OscarBaseExtend();
                extend.setTranslateExtendFields(translateExtendFields);
                dataModelBaseDTO.setExtendObj(extend);
            } else {
                dataModelBaseDTO.getExtendObj().setTranslateExtendFields(translateExtendFields);
            }
        }
    }
}

