/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.constant.DataImportConstant;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.back.common.util.TemplateUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslate;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslateCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslateField;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarPublicEnclosure;
import com.jxdinfo.hussar.formdesign.printTemplate.service.impl.PrintTemplateServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintGroupInfo;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintInfo;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintGroupInfoService;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class OscarTemplateUtil {
    private static final PrintTemplateServiceImpl printTemplateService = (PrintTemplateServiceImpl)SpringContextHolder.getBean(PrintTemplateServiceImpl.class);
    private static final ISysTemplatePrintGroupInfoService iSysTemplatePrintGroupInfoService = (ISysTemplatePrintGroupInfoService)SpringContextHolder.getBean(ISysTemplatePrintGroupInfoService.class);
    private static final ISysTemplatePrintInfoService iSysTemplatePrintInfoService = (ISysTemplatePrintInfoService)SpringContextHolder.getBean(ISysTemplatePrintInfoService.class);

    @HussarTransactional
    public static PublishTemplateDto processTemplate(String modelBaseId, List<OscarDataModelBase> slaveTables) throws LcdpException, CloneNotSupportedException {
        PublishTemplateDto publishTemplateDto = new PublishTemplateDto();
        DataModelBase modelBase = DataModelUtil.getDataModelBase((String)modelBaseId);
        if (ToolUtil.isNotEmpty((Object)modelBase) && ToolUtil.isNotEmpty((Object)modelBase.getId())) {
            OscarDataModelBase dataModelBase = OscarDataModelUtil.transfer(modelBase);
            String id = dataModelBase.getId();
            List sysTemplatePrintInfoList = iSysTemplatePrintInfoService.getTemplateListByPageId(id);
            ArrayList<Map<String, Object>> addOrUpdateList = new ArrayList<Map<String, Object>>();
            ArrayList<Long> removeList = new ArrayList<Long>();
            if (ToolUtil.isNotEmpty(dataModelBase.getImportTemplate())) {
                Object translates;
                Map<String, Map<String, Object>> importTemplate = dataModelBase.getImportTemplate();
                List<OscarDataModelField> modelFields = dataModelBase.getFields();
                ConcurrentHashMap<String, Object> dictType = new ConcurrentHashMap<String, Object>();
                ConcurrentHashMap<String, Object> associateTable = new ConcurrentHashMap<String, Object>();
                ConcurrentHashMap<String, Object> associateServiceBeanName = new ConcurrentHashMap<String, Object>();
                ConcurrentHashMap<String, Object> associateTableProp = new ConcurrentHashMap<String, Object>();
                ConcurrentHashMap<String, Object> associateTablePropCode = new ConcurrentHashMap<String, Object>();
                ConcurrentHashMap<String, Object> organTranslate = new ConcurrentHashMap<String, Object>();
                ConcurrentHashMap<String, Object> userTranslate = new ConcurrentHashMap<String, Object>();
                if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(dataModelBase.getTranslate()) && ToolUtil.isNotEmpty((Object)(translates = dataModelBase.getTranslate()))) {
                    OscarTemplateUtil.getTranslateInfo((List<OscarTranslate>)translates, modelFields, dictType, associateTable, associateServiceBeanName, associateTableProp, associateTablePropCode, organTranslate, userTranslate);
                }
                if (ToolUtil.isNotEmpty(slaveTables)) {
                    for (OscarDataModelBase slaveTable : slaveTables) {
                        List<OscarDataModelField> sFields = slaveTable.getFields();
                        ArrayList<OscarTranslate> slaveTranslates = new ArrayList<OscarTranslate>();
                        if (ToolUtil.isNotEmpty(dataModelBase.getTranslate())) {
                            block1: for (OscarDataModelField field : sFields) {
                                for (OscarTranslate translate : dataModelBase.getTranslate()) {
                                    if (!translate.getSourceFieldId().equals(field.getId())) continue;
                                    slaveTranslates.add(translate);
                                    continue block1;
                                }
                            }
                        }
                        if (ToolUtil.isNotEmpty(slaveTranslates)) {
                            OscarTemplateUtil.getSlaveTranslateInfo(slaveTranslates, sFields, dictType, associateTable, associateServiceBeanName, associateTableProp, associateTablePropCode, organTranslate, userTranslate);
                        }
                        for (OscarDataModelField oscarMsDataModel : modelFields) {
                            if (!HussarUtils.equals((Object)oscarMsDataModel.getSourceDataModelId(), (Object)slaveTable.getId())) continue;
                            if (HussarUtils.equals((Object)"array", (Object)oscarMsDataModel.getDataType())) {
                                oscarMsDataModel.setDataType("collection");
                                oscarMsDataModel.setProperties(sFields);
                                continue;
                            }
                            oscarMsDataModel.setId(slaveTable.getId());
                            oscarMsDataModel.setName(slaveTable.getName());
                            oscarMsDataModel.setComment(slaveTable.getComment());
                            oscarMsDataModel.setDataType("association");
                            oscarMsDataModel.setUsage("");
                            oscarMsDataModel.setProperties(sFields);
                        }
                    }
                }
                JSONArray fieldControlList = OscarTemplateUtil.processFieldControl(modelBase.getComment(), modelFields, dictType, associateTable, associateServiceBeanName, associateTableProp, associateTablePropCode, organTranslate, userTranslate);
                List sysTemplatePrintGroupInfos = printTemplateService.processParentIds(id);
                SysTemplatePrintGroupInfo sysTemplatePrintGroupInfo = (SysTemplatePrintGroupInfo)sysTemplatePrintGroupInfos.get(0);
                String groupId = String.valueOf(sysTemplatePrintGroupInfo.getGroupId());
                iSysTemplatePrintGroupInfoService.processGroups(sysTemplatePrintGroupInfos);
                ArrayList<Map> projectTemplatePrintInfos = new ArrayList<Map>();
                String entityClassPath = TemplateUtil.getModelPath((DataModelBase)dataModelBase);
                for (Object key : importTemplate.keySet()) {
                    Map map = (Map)importTemplate.get(key);
                    map.put("templateId", key);
                    map.put("pageId", id);
                    map.put("groupId", groupId);
                    map.put("entityClassPath", entityClassPath);
                    map.put("templateStatus", map.get("status"));
                    map.put("templateName", map.get("content"));
                    map.put("businessId", id);
                    map.put("type", "excel-import");
                    map.put("default", map.get("default"));
                    map.put("fieldControl", fieldControlList.toJSONString());
                    projectTemplatePrintInfos.add(map);
                }
                ArrayList<Map<String, Object>> sysTemplatePrintInfos = new ArrayList<Map<String, Object>>();
                if (ToolUtil.isNotEmpty((Object)sysTemplatePrintInfoList)) {
                    for (SysTemplatePrintInfo sysTemplatePrintInfo : sysTemplatePrintInfoList) {
                        sysTemplatePrintInfos.add((Map<String, Object>)((JSONObject)JSONObject.toJSON((Object)sysTemplatePrintInfo)));
                    }
                }
                HashMap<String, Map> tempMapA = new HashMap<String, Map>();
                HashMap<String, Map> tempMapB = new HashMap<String, Map>();
                HashMap<String, Map> tempMapC = new HashMap<String, Map>();
                for (Map map : projectTemplatePrintInfos) {
                    tempMapA.put(String.valueOf(map.get("templateId")), map);
                }
                for (Map map : sysTemplatePrintInfos) {
                    tempMapB.put(String.valueOf(map.get("templateId")), map);
                }
                for (Map map : tempMapB.values()) {
                    if (tempMapA.containsKey(String.valueOf(map.get("templateId")))) continue;
                    removeList.add(Long.valueOf(String.valueOf(map.get("templateId"))));
                    tempMapC.put(String.valueOf(map.get("templateId")), map);
                }
                for (Map map : tempMapA.values()) {
                    if (tempMapC.containsKey(String.valueOf(map.get("templateId")))) continue;
                    addOrUpdateList.add(map);
                }
                ArrayList addList = new ArrayList();
                for (Map map : tempMapA.values()) {
                    if (tempMapB.containsKey(String.valueOf(map.get("templateId")))) continue;
                    addList.add(map.get("templateId"));
                }
                if (ToolUtil.isNotEmpty(addList)) {
                    for (Map map : addOrUpdateList) {
                        String templateName;
                        if (!addList.contains(map.get("templateId"))) continue;
                        String string = templateName = map.get("content") == null ? "" : map.get("content").toString();
                        Map fileMap = iSysTemplatePrintInfoService.generateTemplate(fieldControlList.toJSONString(), templateName);
                        if (!ToolUtil.isNotEmpty((Object)fileMap)) continue;
                        map.put("fileId", String.valueOf(fileMap.get("fileId")));
                        map.put("fileName", String.valueOf(fileMap.get("fileName")));
                    }
                }
                OscarTemplateUtil.compileFieldControl(addOrUpdateList, sysTemplatePrintInfos);
            } else if (ToolUtil.isNotEmpty((Object)sysTemplatePrintInfoList)) {
                for (SysTemplatePrintInfo sysTemplatePrintInfo : sysTemplatePrintInfoList) {
                    removeList.add(sysTemplatePrintInfo.getTemplateId());
                }
            }
            HashMap<String, ArrayList<Object>> params = new HashMap<String, ArrayList<Object>>();
            params.put("removed", removeList);
            params.put("added", addOrUpdateList);
            publishTemplateDto.setParams(params);
        }
        return publishTemplateDto;
    }

    private static Object getNestedOrDefault(Map<String, Object> outerMap, String outerKey, String innerKey, Object defaultValue) {
        if (ToolUtil.isNotEmpty((Object)outerMap.get(outerKey)) && outerMap.get(outerKey) instanceof Map) {
            Map innerMap = (Map)outerMap.get(outerKey);
            if (innerMap == null) {
                return defaultValue;
            }
            return innerMap.getOrDefault(innerKey, defaultValue);
        }
        return outerMap.getOrDefault(outerKey, defaultValue);
    }

    private static JSONArray processFieldControl(String comment, List<OscarDataModelField> modelFields, Map<String, Object> dictType, Map<String, Object> associateTable, Map<String, Object> associateServiceBeanName, Map<String, Object> associateTableProp, Map<String, Object> associateTablePropCode, Map<String, Object> organTranslate, Map<String, Object> userTranslate) {
        JSONArray fieldControlList = new JSONArray();
        ConcurrentHashMap map = new ConcurrentHashMap();
        List newModelFields = modelFields.stream().filter(e -> map.putIfAbsent(e.getId(), e) == null).collect(Collectors.toList());
        for (OscarDataModelField objectMap : newModelFields) {
            Map<String, Object> fieldMap = OscarTemplateUtil.createBaseFieldMap(objectMap, dictType, associateTable, associateServiceBeanName, associateTableProp, associateTablePropCode, organTranslate, userTranslate, comment);
            if (HussarUtils.equals((Object)"collection", (Object)objectMap.getDataType()) || HussarUtils.equals((Object)"association", (Object)objectMap.getDataType())) {
                List<OscarDataModelField> properties = objectMap.getProperties();
                JSONArray children = new JSONArray();
                for (OscarDataModelField slaveModelField : properties) {
                    Map<String, Object> slavefieldMap = OscarTemplateUtil.createSlaveBaseFieldMap(slaveModelField, dictType, associateTable, associateServiceBeanName, associateTableProp, associateTablePropCode, organTranslate, userTranslate);
                    children.add(slavefieldMap);
                }
                fieldMap.put("children", children);
            } else {
                fieldMap.put("children", DataImportConstant.EMPTY_LIST);
            }
            List<SerialNumRuleDTO> serialNum = objectMap.getSerialNum();
            if (ToolUtil.isNotEmpty(serialNum)) {
                serialNum.stream().filter(n -> HussarUtils.equals((Object)n.getType(), (Object)"serialNumber")).forEach(n -> fieldMap.put("serialNumber", n.getConfig().getId()));
            } else {
                fieldMap.put("serialNumber", "");
            }
            fieldControlList.add(fieldMap);
        }
        return fieldControlList;
    }

    private static Map<String, Object> createSlaveBaseFieldMap(OscarDataModelField field, Map<String, Object> dictType, Map<String, Object> associateTable, Map<String, Object> associateServiceBeanName, Map<String, Object> associateTableProp, Map<String, Object> associateTablePropCode, Map<String, Object> organTranslate, Map<String, Object> userTranslate) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("prop", field.getName());
        fieldMap.put("propName", field.getComment());
        fieldMap.put("specialPurpose", field.getUsage());
        String fieldId = field.getId();
        String fieldName = field.getName();
        OscarTemplateUtil.putNestedValue(fieldMap, "dictType", dictType, fieldId, fieldName);
        OscarTemplateUtil.putNestedValue(fieldMap, "associateTable", associateTable, fieldId, fieldName);
        OscarTemplateUtil.putNestedValue(fieldMap, "associateService", associateServiceBeanName, fieldId, fieldName);
        OscarTemplateUtil.putNestedValue(fieldMap, "associateTableProp", associateTableProp, fieldId, fieldName);
        OscarTemplateUtil.putNestedValue(fieldMap, "associateTablePropCode", associateTablePropCode, fieldId, fieldName);
        OscarTemplateUtil.putNestedValue(fieldMap, "organTranslate", organTranslate, fieldId, fieldName);
        OscarTemplateUtil.putNestedValue(fieldMap, "userTranslate", userTranslate, fieldId, fieldName);
        fieldMap.put("propType", field.getDataType());
        fieldMap.put("checkOtherRule", DataImportConstant.EMPTY_LIST);
        fieldMap.put("children", DataImportConstant.EMPTY_LIST);
        for (String key : DataImportConstant.COPY_KEYS) {
            fieldMap.put(key, "");
        }
        fieldMap.put("importField", true);
        return fieldMap;
    }

    private static Map<String, Object> createBaseFieldMap(OscarDataModelField field, Map<String, Object> dictType, Map<String, Object> associateTable, Map<String, Object> associateServiceBeanName, Map<String, Object> associateTableProp, Map<String, Object> associateTablePropCode, Map<String, Object> organTranslate, Map<String, Object> userTranslate, String comment) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("modelName", comment);
        fieldMap.put("prop", field.getName());
        fieldMap.put("propName", field.getComment());
        fieldMap.put("specialPurpose", field.getUsage());
        fieldMap.put("dictType", dictType.getOrDefault(field.getName(), ""));
        fieldMap.put("associateTable", associateTable.getOrDefault(field.getName(), ""));
        fieldMap.put("associateService", associateServiceBeanName.getOrDefault(field.getName(), ""));
        fieldMap.put("associateTableProp", associateTableProp.getOrDefault(field.getName(), ""));
        fieldMap.put("associateTablePropCode", associateTablePropCode.getOrDefault(field.getName(), ""));
        fieldMap.put("organTranslate", organTranslate.getOrDefault(field.getName(), ""));
        fieldMap.put("userTranslate", userTranslate.getOrDefault(field.getName(), ""));
        fieldMap.put("propType", field.getDataType());
        fieldMap.put("checkOtherRule", DataImportConstant.EMPTY_LIST);
        for (String key : DataImportConstant.COPY_KEYS) {
            fieldMap.put(key, "");
        }
        fieldMap.put("importField", true);
        return fieldMap;
    }

    public static void getTranslateInfo(List<OscarTranslate> translates, List<OscarDataModelField> modelFields, Map<String, Object> dictType, Map<String, Object> associateTable, Map<String, Object> associateServiceBeanName, Map<String, Object> associateTableProp, Map<String, Object> associateTablePropCode, Map<String, Object> organTranslate, Map<String, Object> userTranslate) throws LcdpException, CloneNotSupportedException {
        for (OscarTranslate translate : translates) {
            List<OscarTranslateField> translateFields = translate.getTranslateFields();
            if (translateFields == null) continue;
            String translateType = translate.getTranslateType();
            if (HussarUtils.equals((Object)translateType, (Object)"dictTranslate")) {
                modelFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)translate.getSourceFieldId())).forEach(n -> dictType.put(String.valueOf(n.getName()), translate.getSourceId()));
                continue;
            }
            for (OscarTranslateField translateField : translateFields) {
                if (!Boolean.parseBoolean(translateField.getTemplate())) continue;
                if (HussarUtils.equals((Object)translate.getTranslateType(), (Object)"modelTranslate")) {
                    String modelId = translate.getSourceId();
                    DataModelBase associateDataModelBase = DataModelUtil.getDataModelBase((String)modelId);
                    String modelPath = TemplateUtil.getModelPath((DataModelBase)associateDataModelBase);
                    if (ToolUtil.isNotEmpty((Object)associateDataModelBase)) {
                        modelFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)translate.getSourceFieldId())).forEach(n -> associateTable.put(String.valueOf(n.getName()), modelPath));
                        OscarDataModelBase associateModelBase = OscarDataModelUtil.transfer(associateDataModelBase);
                        OscarDataModelBaseDTO dataModelBaseDTO = new OscarDataModelBaseDTO();
                        dataModelBaseDTO.setUseMybatisPlus(true);
                        OscarPublicEnclosure.enclosure(associateModelBase, dataModelBaseDTO);
                        List<OscarTranslateCondition> dataModelCondition = translate.getDataModelCondition();
                        List<OscarDataModelField> associateFields = associateModelBase.getFields();
                        if (Boolean.parseBoolean(translateField.getTemplate())) {
                            for (OscarDataModelField associateField : associateFields) {
                                if (HussarUtils.equals((Object)translateField.getTranslateSource(), (Object)associateField.getId())) {
                                    modelFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)translate.getSourceFieldId())).forEach(n -> {
                                        associateTableProp.put(String.valueOf(n.getName()), associateField.getName());
                                        String serviceBeanName = OscarTemplateUtil.getServiceBeanName(dataModelBaseDTO);
                                        associateServiceBeanName.put(String.valueOf(n.getName()), serviceBeanName);
                                    });
                                }
                                if (dataModelCondition.isEmpty() || !HussarUtils.equals((Object)dataModelCondition.get(0).getGoalsRowId(), (Object)associateField.getId())) continue;
                                modelFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)((OscarTranslateCondition)dataModelCondition.get(0)).getFromModelField())).forEach(n -> associateTablePropCode.put(String.valueOf(n.getName()), associateField.getName()));
                            }
                        }
                    }
                }
                if (HussarUtils.equals((Object)translateType, (Object)"organTranslate")) {
                    modelFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)translate.getSourceFieldId())).forEach(n -> organTranslate.put(String.valueOf(n.getName()), translateField.getTranslateSource()));
                }
                if (!HussarUtils.equals((Object)translateType, (Object)"userTranslate")) continue;
                modelFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)translate.getSourceFieldId())).forEach(n -> userTranslate.put(String.valueOf(n.getName()), translateField.getTranslateSource()));
            }
        }
    }

    public static void getSlaveTranslateInfo(List<OscarTranslate> slaveTranslates, List<OscarDataModelField> sFields, Map<String, Object> dictType, Map<String, Object> associateTable, Map<String, Object> associateServiceBeanName, Map<String, Object> associateTableProp, Map<String, Object> associateTablePropCode, Map<String, Object> organTranslate, Map<String, Object> userTranslate) throws LcdpException, CloneNotSupportedException {
        for (OscarTranslate slaveTranslate : slaveTranslates) {
            List<OscarTranslateField> slaveTranslateFields = slaveTranslate.getTranslateFields();
            List<OscarTranslateCondition> dataModelCondition = slaveTranslate.getDataModelCondition();
            if (HussarUtils.equals((Object)slaveTranslate.getTranslateType(), (Object)"dictTranslate")) {
                sFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)slaveTranslate.getSourceFieldId())).forEach(n -> {
                    ConcurrentHashMap<String, String> dictTypeValue = new ConcurrentHashMap<String, String>();
                    dictTypeValue.put(String.valueOf(n.getName()), slaveTranslate.getSourceId());
                    dictType.put(n.getId(), dictTypeValue);
                });
                continue;
            }
            for (OscarTranslateField translateField : slaveTranslateFields) {
                if (!Boolean.parseBoolean(translateField.getTemplate())) continue;
                if (HussarUtils.equals((Object)slaveTranslate.getTranslateType(), (Object)"modelTranslate")) {
                    ConcurrentHashMap associateTableValue = new ConcurrentHashMap();
                    ConcurrentHashMap associateServiceBeanNameValue = new ConcurrentHashMap();
                    DataModelBase associateDataModelBase = DataModelUtil.getDataModelBase((String)slaveTranslate.getSourceId());
                    if (ToolUtil.isNotEmpty((Object)associateDataModelBase)) {
                        String modelPath = TemplateUtil.getModelPath((DataModelBase)associateDataModelBase);
                        OscarDataModelBase associateModelBase = OscarDataModelUtil.transfer(associateDataModelBase);
                        OscarDataModelBaseDTO dataModelBaseDTO = new OscarDataModelBaseDTO();
                        dataModelBaseDTO.setUseMybatisPlus(true);
                        OscarPublicEnclosure.enclosure(associateModelBase, dataModelBaseDTO);
                        sFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)slaveTranslate.getSourceFieldId())).forEach(n -> {
                            associateTableValue.put(String.valueOf(n.getName()), modelPath);
                            associateTable.put(n.getId(), associateTableValue);
                            String serviceBeanName = OscarTemplateUtil.getServiceBeanName(dataModelBaseDTO);
                            associateServiceBeanNameValue.put(String.valueOf(n.getName()), serviceBeanName);
                            associateServiceBeanName.put(n.getId(), associateServiceBeanNameValue);
                        });
                        List<OscarDataModelField> associateFields = associateModelBase.getFields();
                        if (Boolean.parseBoolean(translateField.getTemplate())) {
                            for (OscarDataModelField associateField : associateFields) {
                                if (HussarUtils.equals((Object)translateField.getTranslateSource(), (Object)associateField.getId())) {
                                    ConcurrentHashMap associateTablePropValue = new ConcurrentHashMap();
                                    sFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)slaveTranslate.getSourceFieldId())).forEach(n -> {
                                        associateTablePropValue.put(String.valueOf(n.getName()), associateField.getName());
                                        associateTableProp.put(n.getId(), associateTablePropValue);
                                    });
                                }
                                if (dataModelCondition.isEmpty() || !HussarUtils.equals((Object)dataModelCondition.get(0).getGoalsRowId(), (Object)associateField.getId())) continue;
                                ConcurrentHashMap associateTablePropCodeValue = new ConcurrentHashMap();
                                sFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)((OscarTranslateCondition)dataModelCondition.get(0)).getFromModelField())).forEach(n -> {
                                    associateTablePropCodeValue.put(String.valueOf(n.getName()), associateField.getName());
                                    associateTablePropCode.put(n.getId(), associateTablePropCodeValue);
                                });
                            }
                        }
                    }
                }
                if (HussarUtils.equals((Object)slaveTranslate.getTranslateType(), (Object)"organTranslate")) {
                    ConcurrentHashMap organTranslateValue = new ConcurrentHashMap();
                    sFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)slaveTranslate.getSourceFieldId())).forEach(n -> {
                        organTranslateValue.put(String.valueOf(n.getName()), translateField.getTranslateSource());
                        organTranslate.put(n.getId(), organTranslateValue);
                    });
                }
                if (!HussarUtils.equals((Object)slaveTranslate.getTranslateType(), (Object)"userTranslate")) continue;
                ConcurrentHashMap associateTablePropCodeValue = new ConcurrentHashMap();
                sFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)slaveTranslate.getSourceFieldId())).forEach(n -> {
                    associateTablePropCodeValue.put(String.valueOf(n.getName()), translateField.getTranslateSource());
                    userTranslate.put(n.getId(), associateTablePropCodeValue);
                });
            }
        }
    }

    private static void compileFieldControl(List<Map<String, Object>> addOrUpdateList, List<Map<String, Object>> sysTemplatePrintInfos) {
        for (Map<String, Object> addListMap : addOrUpdateList) {
            JSONArray add = JSON.parseArray((String)String.valueOf(addListMap.get("fieldControl")));
            for (Map<String, Object> templatePrintInfo : sysTemplatePrintInfos) {
                Map templatePrintInfoContent = (Map)JSON.parseObject((String)String.valueOf(templatePrintInfo.get("content")), Map.class);
                JSONArray fieldControl = JSON.parseArray((String)String.valueOf(templatePrintInfoContent.get("fieldControl")));
                if (!addListMap.get("templateId").equals(String.valueOf(templatePrintInfo.get("templateId")))) continue;
                if (ToolUtil.isNotEmpty(templatePrintInfoContent.get("custom"))) {
                    addListMap.put("custom", templatePrintInfoContent.get("custom"));
                }
                if (ToolUtil.isNotEmpty((Object)fieldControl)) {
                    OscarTemplateUtil.mergeFieldControl(add, fieldControl);
                }
                addListMap.put("fieldControl", add.toJSONString());
                if (!templatePrintInfoContent.containsKey("fileId")) continue;
                addListMap.put("fileId", templatePrintInfoContent.get("fileId"));
                addListMap.put("fileName", templatePrintInfoContent.get("templateFileName"));
            }
        }
    }

    public static void mergeFieldControl(JSONArray add, JSONArray fieldControl) {
        String prop;
        HashMap<String, Map> fieldControlMap = new HashMap<String, Map>();
        for (Object obj : fieldControl) {
            Map field;
            if (!(obj instanceof Map) || (prop = (String)(field = (Map)obj).get("prop")) == null) continue;
            fieldControlMap.put(prop, field);
            if (!ToolUtil.isNotEmpty(field.get("children"))) continue;
            List children = (List)field.get("children");
            for (Map child : children) {
                String childProp = (String)child.get("prop");
                if (childProp == null) continue;
                String fullProp = prop + "." + childProp;
                fieldControlMap.put(fullProp, child);
            }
        }
        for (Object o : add) {
            Map addField = (Map)o;
            prop = (String)addField.get("prop");
            Map matchedField = (Map)fieldControlMap.get(prop);
            if (matchedField != null) {
                for (String key : DataImportConstant.COPY_KEYS) {
                    Object value = matchedField.get(key);
                    if (!ToolUtil.isNotEmpty(value)) continue;
                    addField.put(key, value);
                }
                if (!ToolUtil.isNotEmpty(addField.get("children"))) continue;
                List children = (List)addField.get("children");
                for (Map child : children) {
                    String childProp = (String)child.get("prop");
                    if (!ToolUtil.isNotEmpty((Object)childProp)) continue;
                    String fullProp = prop + "." + childProp;
                    Map subMatchedField = (Map)fieldControlMap.get(fullProp);
                    if (subMatchedField != null) {
                        for (String key : DataImportConstant.COPY_KEYS) {
                            Object value = subMatchedField.get(key);
                            if (!ToolUtil.isNotEmpty(value)) continue;
                            child.put(key, value);
                        }
                        continue;
                    }
                    child.put("importField", false);
                }
                continue;
            }
            addField.put("importField", false);
        }
    }

    private static void putNestedValue(Map<String, Object> map, String key, Map<String, Object> nestedMap, String fieldId, String fieldName) {
        map.put(key, OscarTemplateUtil.getNestedOrDefault(nestedMap, fieldId, fieldName, ""));
    }

    public static String getServiceBeanName(OscarDataModelBaseDTO oscarDataModelBaseDTO) {
        StringBuilder serviceBeanName = new StringBuilder();
        serviceBeanName.append(oscarDataModelBaseDTO.getTablePath().toLowerCase().replace("/", "."));
        serviceBeanName.append(".");
        serviceBeanName.append(oscarDataModelBaseDTO.getServiceImplName());
        return serviceBeanName.deleteCharAt(0).toString();
    }
}

