/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.flow.masterslaveflow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslate;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslateCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslateField;
import com.jxdinfo.hussar.formdesign.oscar.function.render.OscarBaseRender;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARFLOW_MASTER_SLAVEExcelImport")
public class OscarMsFlowExcelImportVisitor
implements OscarOperationVisitor<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsFlowExcelImportVisitor.class);
    public static final String OPERATION_NAME = "OSCARFLOW_MASTER_SLAVEExcelImport";

    @Override
    public void visit(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        OscarFlowMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        List<OscarDataModelBase> oscarDataModelBases = dataModelBase.getSlaveTables();
        OscarDataModelBase masterTable = dataModelBase.getMasterTable();
        OscarFlowMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = dataModelBaseDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName();
        Map<String, OscarDataModelBaseDTO> dataModelDtoMap = dataModelBaseDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("operationName", controllerParams.get("name"));
        controllerParams.put("slaveTable", OscarMsFlowExcelImportVisitor.getSlaveArrayTables(dataModelBaseDTO, dataModelBase));
        controllerParams.put("primaryField", dataModelBaseDTO.getKeyPropertyName());
        OscarDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
        controllerParams.put("masterServiceName", masterDTO.getServiceName());
        for (OscarDataModelBaseDTO gaussDataModelBaseDTO : dataModelDtoMap.values()) {
            backCtx.addServiceImplImport(modelId, gaussDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplImport(modelId, gaussDataModelBaseDTO.getImportInfo().get("Entity"));
        }
        backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u4e3b\u5b50\u8868Excel\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        String controllerPath = "template/gauss/masterslavebackcode/excelImport/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/gauss/masterslavebackcode/excelImport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            for (OscarDataModelFieldDto field : dataModelBaseDTO.getFields()) {
                String typeName = "";
                String fieldAnnotation = field.getFieldAnnotation();
                if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                    int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                    int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                    if (startIndex != -1 && endIndex != -1) {
                        typeName = fieldAnnotation.substring(startIndex, endIndex);
                    }
                }
                field.setDictTyeName(typeName);
            }
            dataModelBaseDTO.getDataModelDtoMap().entrySet().stream().forEach(entry -> {
                if (!((String)entry.getKey()).equals(dataModelBaseDTO.getId())) {
                    for (OscarDataModelFieldDto field : ((OscarDataModelBaseDTO)entry.getValue()).getFields()) {
                        String typeName = "";
                        String fieldAnnotation = field.getFieldAnnotation();
                        if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                            int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                            int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                            if (startIndex != -1 && endIndex != -1) {
                                typeName = fieldAnnotation.substring(startIndex, endIndex);
                            }
                        }
                        field.setDictTyeName(typeName);
                    }
                }
            });
            backCtx.addServiceImplInversion(modelId, "ISysDicRefService");
        }
        String serviceImplPath = "template/oscar/masterslavebackcode/excelImport/service_impl.ftl";
        DataModelBase dataModelBaseNew = DataModelUtil.getDataModelBase((String)modelId);
        OscarDataModelBase currentModelBase = OscarDataModelUtil.transfer(dataModelBaseNew);
        List<OscarTranslate> oscarTranslates = currentModelBase.getTranslate();
        controllerParams.put("modelTranslate", false);
        HashMap sourceClums = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        HashMap<String, String> zzbUseNameMap = new HashMap<String, String>();
        for (OscarTranslate oscarTranslate : oscarTranslates) {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ");
            if (!oscarTranslate.getTranslateType().equals("modelTranslate")) continue;
            ArrayList<String> allClums = new ArrayList<String>();
            JSONArray allFields = (JSONArray)DataModelUtil.getDataModelJson((String)oscarTranslate.getSourceId()).get((Object)"fields");
            if (HussarUtils.isEmpty((Object)allFields)) {
                allFields = (JSONArray)DataModelUtil.getDataModelJson((String)oscarTranslate.getSourceId()).getJSONObject("masterTable").get((Object)"fields");
            }
            ArrayList<String> relationIds = new ArrayList<String>();
            List<OscarTranslateCondition> oscarTranslateConditions = oscarTranslate.getDataModelCondition();
            for (OscarTranslateCondition oscarTranslateCondition : oscarTranslateConditions) {
                relationIds.add(oscarTranslateCondition.getGoalsRowId());
            }
            for (int i = 0; i < allFields.size(); ++i) {
                allClums.add(((JSONObject)allFields.get(i)).get((Object)"sourceFieldName").toString());
            }
            sql.append(String.join((CharSequence)",", allClums));
            sql.append(" FROM ");
            String clumsName = "";
            for (int i = 0; i < masterTable.getFields().size(); ++i) {
                if (!masterTable.getFields().get(i).getId().equals(oscarTranslate.getSourceFieldId())) continue;
                clumsName = masterTable.getFields().get(i).getName();
                List<OscarTranslateField> fields = oscarTranslate.getTranslateFields();
                for (OscarTranslateField oscarTranslateField : fields) {
                    for (int j = 0; j < allFields.size(); ++j) {
                        if (oscarTranslateField.getTranslateSource().equals(((JSONObject)allFields.get(j)).get((Object)"id"))) {
                            map.put(masterTable.getTableDesc() + clumsName, ((JSONObject)allFields.get(j)).get((Object)"sourceFieldName").toString());
                            if (HussarUtils.isNotEmpty((Object)DataModelUtil.getDataModelJson((String)oscarTranslate.getSourceId()).get((Object)"sourceDataModelName"))) {
                                sql.append(DataModelUtil.getDataModelJson((String)oscarTranslate.getSourceId()).get((Object)"sourceDataModelName"));
                            } else {
                                sql.append(DataModelUtil.getDataModelJson((String)oscarTranslate.getSourceId()).getJSONObject("masterTable").get((Object)"sourceDataModelName"));
                            }
                            sqlMap.put(masterTable.getTableDesc() + masterTable.getFields().get(i).getName(), sql.toString());
                        }
                        if (!relationIds.contains(((JSONObject)allFields.get(j)).get((Object)"id"))) continue;
                        zzbUseNameMap.put(masterTable.getTableDesc() + clumsName, ((JSONObject)allFields.get(j)).get((Object)"sourceFieldName").toString());
                    }
                }
            }
            for (OscarDataModelBase modelBase : oscarDataModelBases) {
                for (int i = 0; i < modelBase.getFields().size(); ++i) {
                    if (!modelBase.getFields().get(i).getId().equals(oscarTranslate.getSourceFieldId())) continue;
                    clumsName = modelBase.getFields().get(i).getName();
                    List<OscarTranslateField> fields = oscarTranslate.getTranslateFields();
                    for (OscarTranslateField oscarTranslateField : fields) {
                        for (int j = 0; j < allFields.size(); ++j) {
                            if (oscarTranslateField.getTranslateSource().equals(((JSONObject)allFields.get(j)).get((Object)"id"))) {
                                map.put(modelBase.getTableDesc() + clumsName, ((JSONObject)allFields.get(j)).get((Object)"sourceFieldName").toString());
                                if (HussarUtils.isNotEmpty((Object)DataModelUtil.getDataModelJson((String)oscarTranslate.getSourceId()).get((Object)"sourceDataModelName"))) {
                                    sql.append(DataModelUtil.getDataModelJson((String)oscarTranslate.getSourceId()).get((Object)"sourceDataModelName"));
                                } else {
                                    sql.append(DataModelUtil.getDataModelJson((String)oscarTranslate.getSourceId()).getJSONObject("masterTable").get((Object)"sourceDataModelName"));
                                }
                                sqlMap.put(modelBase.getTableDesc() + modelBase.getFields().get(i).getName(), sql.toString());
                            }
                            if (!relationIds.contains(((JSONObject)allFields.get(j)).get((Object)"id"))) continue;
                            zzbUseNameMap.put(modelBase.getTableDesc() + clumsName, ((JSONObject)allFields.get(j)).get((Object)"sourceFieldName").toString());
                        }
                    }
                }
            }
            controllerParams.put("modelTranslate", true);
        }
        controllerParams.put("mainName", masterTable.getSourceDataModelName());
        controllerParams.put("masterTableName", masterTable.getName().substring(0, 1).toUpperCase() + masterTable.getName().substring(1));
        String sourceMap = map.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(", "));
        controllerParams.put("sourceMap", sourceMap);
        String sqlMapString = sqlMap.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining("; "));
        controllerParams.put("sqlMap", sqlMapString);
        String useName = zzbUseNameMap.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(", "));
        controllerParams.put("useName", useName);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.vo.DictVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.service.ISysDicRefService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.model.DicSingle");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.util.ExcelUtils");
        backCtx.addServiceImplImport(modelId, "java.lang.reflect.Field");
        backCtx.addServiceImplImport(modelId, "java.util.function.Function");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.Collections");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.annotation.TableId");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.annotation.TableField");
        backCtx.addServiceImplImport(modelId, "java.lang.reflect.Method;");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.toolkit.IdWorker");
        backCtx.addServiceImplImport(modelId, "static org.apache.commons.lang.WordUtils.capitalize");
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getServiceName());
        for (OscarDataModelBaseDTO gaussDataModelBaseDTO : dataModelBaseDTO.getDataModelDtoMap().values()) {
            backCtx.addServiceImplInversion(modelId, gaussDataModelBaseDTO.getServiceName());
        }
        String mapperPath = "template/oscar/masterslavebackcode/excelImport/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, "java.util.Map");
        String xmlPath = "template/oscar/masterslavebackcode/excelImport/xml.ftl";
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", url, "\u6d41\u7a0b\u4e3b\u5b50\u8868Excel\u5bfc\u5165");
        backCtx.addApi(modelId, OscarBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static List<OscarDataModelBase> getSlaveArrayTables(OscarFlowMsDataModelDTO dataModelBaseDTO, OscarFlowMsDataModel dataModelBase) {
        CopyOnWriteArrayList<OscarDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<OscarDataModelBase>(dataModelBase.getSlaveTables());
        for (OscarDataModelBase slaveArrayTable : slaveArrayTables) {
            for (OscarDataModelField field : slaveArrayTable.getFields()) {
                if ("foreign".equals(field.getUsage())) {
                    slaveArrayTable.setForeignField(field.getName());
                }
                if (!"primary".equals(field.getUsage())) continue;
                slaveArrayTable.setPrimaryField(field.getName());
            }
        }
        return slaveArrayTables;
    }
}

