/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.processor;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.formdesign.oscar.code.OscarCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarModelFunction;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarRender;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.result.OscarCodeResult;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OscarModelProcessor
implements DataModelProcessor<OscarCodeResult> {
    private static Logger logger = LoggerFactory.getLogger(OscarModelProcessor.class);

    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"OSCAR", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<OscarCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx = this.getOscarBackCtx(publishCtx);
        OscarModelProcessor.init(backCtx, dataModelBase);
        OscarModelProcessor.generateSingleModel(backCtx, publishCtx);
        publishCtx.setPublishDTO(backCtx.getPublishDTO());
    }

    public void generateForExt(PublishCtx<OscarCodeResult> context, JSONObject dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx = this.getOscarBackCtx(context);
        OscarModelProcessor.init(backCtx, dataModelBase);
        OscarModelProcessor.generateSingleModel(backCtx, context);
        context.setPublishDTO(backCtx.getPublishDTO());
    }

    private OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> getOscarBackCtx(PublishCtx<OscarCodeResult> publishCtx) {
        OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx = new OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO>();
        if (publishCtx.getParams() != null) {
            backCtx.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            backCtx.setBaseFile(publishCtx.getBaseFile());
        }
        if (publishCtx.getPublishDTO() != null) {
            backCtx.setPublishDTO(publishCtx.getPublishDTO());
        }
        return backCtx;
    }

    public static void init(OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx, JSONObject dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        OscarDataModelBase currentModelBase = OscarDataModelUtil.transfer(dataModelBase);
        OscarModelFunction currentFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(currentModelBase.getFunctionType());
        String modelId = currentModelBase.getId();
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, OscarDataModelBaseDTO> useDtoMap = new HashMap<String, OscarDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void init(OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx, DataModelBase dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        String modelId = dataModelBase.getId();
        OscarModelFunction currentFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        OscarDataModelBase currentModelBase = OscarDataModelUtil.transfer(dataModelBase);
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, OscarDataModelBaseDTO> useDtoMap = new HashMap<String, OscarDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateSingleModel(OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx, PublishCtx<OscarCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        OscarModelProcessor.visit(backCtx);
        OscarModelProcessor.render(backCtx, publishCtx);
    }

    public static void visit(OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        OscarDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        OscarDataModelBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        PageInfoNode pageInfoNode = null;
        if (backCtx.getUseDataModelBase().getIsPublishResource()) {
            pageInfoNode = DataModelUtil.getDataModelNode((String)useDataModelBase.getId());
        }
        if (HussarUtils.isEmpty(useDataModelBase.getOperations())) {
            useDataModelBase.customOption(backCtx);
            return;
        }
        for (OscarDataModelOperation operation : useDataModelBase.getOperations()) {
            if ("AsyncVerify".equals(operation.getType())) {
                operation.setType("UniqueVerify");
                operation.setName("uniqueVerify");
            }
            OscarOperationVisitor<OscarDataModelBase, OscarDataModelBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().vistor("OSCAR", backCtx.getModelFunctionTye(), operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            try {
                backCtx.getModelFunction().accept(visitor, backCtx, operation);
            }
            catch (Exception var) {
                logger.error("\u6a21\u578b\uff1a{}\uff0c\u65b9\u6cd5\uff1a{} \u6e32\u67d3\u5931\u8d25\uff0c\u6e32\u67d3\u8def\u5f84\uff1a{}", new Object[]{useDataModelBase.getComment(), operation.getName(), visitor.getClass().getName()});
                throw new LcdpException(var, String.format("\u6a21\u578b%s\u6e32\u67d3\u5931\u8d25\uff0c\u5f02\u5e38\uff1a%s", useDataModelBase.getComment(), var.getMessage()));
            }
            if (!backCtx.getUseDataModelBase().getIsPublishResource() || !ToolUtil.isNotEmpty((Object)pageInfoNode)) continue;
            backCtx.addApiResources(ApiResourceAcceptor.of((PageInfoNode)pageInfoNode, (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
        useDataModelBase.customOption(backCtx);
    }

    public static void render(OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx, PublishCtx<OscarCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        OscarRender<OscarDataModelBase, OscarDataModelBaseDTO> render = backCtx.getModelFunction().render();
        List<OscarCodeGenerateInfo> codeGenerateInfos = render.renderCode(backCtx);
        publishCtx.addCodeResults(OscarCodeMergeUtil.mergeBack(codeGenerateInfos, backCtx));
        if (HussarUtils.isNotEmpty((Object)backCtx.getParams())) {
            backCtx.getParams().keySet().forEach(key -> {
                if (ToolUtil.isEmpty((Object)publishCtx.getParams())) {
                    publishCtx.addParams(new HashMap());
                }
                publishCtx.getParams().putIfAbsent(key, backCtx.getParam((String)key));
            });
        }
    }
}

