/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.base;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARBASETableSave")
public class OscarTableSaveVisitor
implements OscarOperationVisitor<OscarBaseDataModel, OscarBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarTableSaveVisitor.class);
    public static final String OPERATION_NAME = "OSCARBASETableSave";

    @Override
    public void visit(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        OscarBaseDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = useDataModelBase.getId();
        OscarBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        this.renderFillCode(backCtx, dataModelBaseDTO, controllerParams);
        String controllerPath = "template/oscar/backcode/tableSave/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/oscar/backcode/tableSave/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        if (useDataModelBase.getLogicallyDelete()) {
            controllerParams.put("logicallyDelete", true);
            String logicallyFieldName = useDataModelBase.getDeleteFlag().getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("logicallyFlag", String.valueOf(chars));
        }
        String serviceImplPath = "template/oscar/backcode/tableSave/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName(), "\u6570\u636e\u8868\u683c\u5bfc\u5165");
        backCtx.addApi(modelId, OscarBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, String modelId, OscarBaseDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
    }

    private Map<String, Object> initParams(OscarDataModelOperation dataModelOperation, OscarBaseDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void renderFillCode(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, OscarBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) throws LcdpException {
        boolean hasFillField = false;
        for (OscarDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "createUser": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.core.util.ToolUtil");
                    if (field.getType().equals("date")) {
                        dataModelBaseDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    hasFillField = true;
                    break;
                }
            }
        }
        if (hasFillField) {
            String fillPath = "template/oscar/backcode/tableSave/fill.ftl";
            String fillCode = RenderUtil.renderTemplate((String)fillPath, controllerParams);
            controllerParams.put("fillCode", fillCode);
        }
    }
}

