/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.enclosure;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.PropertyType;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarEnclosure;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseExtend;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.ResultMapUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipBase;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.source.SourcePackageInfo;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.source.SourceUseItem;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslate;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarPublicEnclosure;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarTemplateUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarTranslateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component(value="OSCARFLOW_MASTER_SLAVEENCLOSURE")
public class OscarFlowMsEnclosure
implements OscarEnclosure<OscarFlowMsDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(OscarFlowMsEnclosure.class);
    public static final String ENCLOSURE = "OSCARFLOW_MASTER_SLAVEENCLOSURE";

    @Override
    public OscarDataModelBaseDTO enclosure(OscarFlowMsDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        OscarFlowMsDataModelDTO dataModelBaseDTO = new OscarFlowMsDataModelDTO();
        OscarPublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        List<OscarDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        HashMap<String, OscarDataModelBaseDTO> dataModelDtoMap = new HashMap<String, OscarDataModelBaseDTO>(slaveTables.size() + 1);
        HashMap<String, OscarDataModelBase> dataModelBaseMap = new HashMap<String, OscarDataModelBase>(slaveTables.size() + 1);
        OscarDataModelBase masterTable = dataModelBase.getMasterTable();
        masterTable.setModelPath(dataModelBase.getModelPath());
        OscarDataModelBaseDTO masterDTO = OscarModelBeanUtil.getFunctionModelVisitorBean(masterTable.getFunctionType()).enclosure().enclosure(masterTable);
        Map masterPackageInfo = EnclosureUtil.getPackageInfo((String)((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
        masterDTO.setPackageInfo(masterPackageInfo);
        masterDTO.setImportInfo(OscarPublicEnclosure.getImportInfo(masterPackageInfo, masterDTO));
        masterDTO.setTablePath(dataModelBaseDTO.getTablePath());
        dataModelDtoMap.put(masterTable.getId(), masterDTO);
        dataModelBaseMap.put(masterTable.getId(), masterTable);
        List<OscarTranslate> translates = dataModelBase.getTranslate();
        List<Object> msTranslates = new ArrayList();
        msTranslates = translates;
        ArrayList<String> slaveId = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dataModelBase.getRelationships())) {
            for (OscarRelationshipBase relationship : dataModelBase.getRelationships()) {
                if (!"collection".equals(relationship.getRelateModelType())) continue;
                slaveId.add(relationship.getSlaveTableId());
            }
        }
        for (OscarDataModelBase slaveTable : slaveTables) {
            slaveTable.setModelPath(dataModelBase.getModelPath());
            OscarDataModelBaseDTO slaveDTO = OscarModelBeanUtil.getFunctionModelVisitorBean(slaveTable.getFunctionType()).enclosure().enclosure(slaveTable);
            if (slaveId.contains(slaveTable.getId())) {
                List<OscarDataModelField> sFields = slaveTable.getFields();
                ArrayList<OscarTranslate> slaveTranslates = new ArrayList<OscarTranslate>();
                if (ToolUtil.isNotEmpty(translates)) {
                    block2: for (OscarDataModelField field : sFields) {
                        for (OscarTranslate translate : translates) {
                            if (!translate.getSourceFieldId().equals(field.getId())) continue;
                            slaveTranslates.add(translate);
                            continue block2;
                        }
                    }
                    OscarTranslateUtil.translateMsEnclosure(slaveTranslates, dataModelBase, slaveDTO);
                    if (ToolUtil.isNotEmpty(slaveDTO.getTranslateShowFields())) {
                        slaveDTO.setHasTranslate(true);
                        dataModelBaseDTO.setHasTranslate(true);
                    }
                    msTranslates.removeAll(slaveTranslates);
                }
            }
            Map slavePackageInfo = EnclosureUtil.getPackageInfo((String)((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
            slaveDTO.setPackageInfo(slavePackageInfo);
            slaveDTO.setImportInfo(OscarPublicEnclosure.getImportInfo(slavePackageInfo, slaveDTO));
            slaveDTO.setTablePath(dataModelBaseDTO.getTablePath());
            dataModelDtoMap.put(slaveTable.getId(), slaveDTO);
            dataModelBaseMap.put(slaveTable.getId(), slaveTable);
        }
        dataModelBaseDTO.setDataModelBaseMap(dataModelBaseMap);
        dataModelBaseDTO.setDataModelDtoMap(dataModelDtoMap);
        dataModelBaseDTO.setResultMapContent(ResultMapUtil.renderResultMap(dataModelBase, dataModelDtoMap, dataModelBaseMap));
        dataModelBaseDTO.setSubSelect(ResultMapUtil.renderSubSelect(dataModelBase, dataModelDtoMap, dataModelBaseMap));
        List<SourcePackageInfo> sourcePackageInfos = this.sourceCodePackage(dataModelBaseDTO, dataModelBase, dataModelDtoMap);
        dataModelBaseDTO.setSourcePackageInfos(sourcePackageInfos);
        this.sourceCodeRelationship(dataModelBaseDTO, dataModelBase);
        List<OscarDataModelField> dataModelFieldBases = dataModelBase.getFlowFields();
        if (ToolUtil.isEmpty(dataModelFieldBases)) {
            logger.error("enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new OscarFlowMsDataModelDTO();
        }
        ArrayList<OscarDataModelFieldDto> tableFields = new ArrayList<OscarDataModelFieldDto>();
        for (OscarDataModelField dataModelFieldBase : dataModelFieldBases) {
            OscarDataModelFieldDto tableField = new OscarDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        OscarTranslateUtil.translateMsEnclosure(msTranslates, dataModelBase, dataModelBaseDTO);
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            dataModelBaseDTO.setHasTranslate(true);
        }
        this.structureExtendObj(dataModelBaseDTO);
        PublishTemplateDto publishTemplateDto = OscarTemplateUtil.processTemplate(dataModelBase.getId(), slaveTables);
        dataModelBaseDTO.setPublishTemplateDto(publishTemplateDto);
        return dataModelBaseDTO;
    }

    private void structureExtendObj(OscarFlowMsDataModelDTO dataModelBaseDTO) {
        List<OscarDataModelFieldDto> fields = dataModelBaseDTO.getFields();
        ArrayList<OscarDataModelFieldDto> extendFields = new ArrayList<OscarDataModelFieldDto>();
        if (ToolUtil.isNotEmpty(fields)) {
            for (OscarDataModelFieldDto field : fields) {
                if (!ToolUtil.isNotEmpty((Object)field) || !field.isExtend()) continue;
                extendFields.add(field);
            }
        }
        if (ToolUtil.isNotEmpty(extendFields)) {
            if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getExtendObj())) {
                OscarBaseExtend extend = new OscarBaseExtend();
                extend.setExtendFields(extendFields);
                dataModelBaseDTO.setExtendObj(extend);
            } else {
                dataModelBaseDTO.getExtendObj().setExtendFields(extendFields);
            }
        }
        List<OscarDataModelFieldDto> translateShowFields = dataModelBaseDTO.getTranslateShowFields();
        ArrayList<OscarDataModelFieldDto> translateExtendFields = new ArrayList<OscarDataModelFieldDto>();
        if (ToolUtil.isNotEmpty(translateShowFields)) {
            for (OscarDataModelFieldDto translateShowField : translateShowFields) {
                if (!ToolUtil.isNotEmpty((Object)translateShowField) || !translateShowField.isExtend()) continue;
                translateExtendFields.add(translateShowField);
            }
        }
        if (ToolUtil.isNotEmpty(translateExtendFields)) {
            if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getExtendObj())) {
                OscarBaseExtend extend = new OscarBaseExtend();
                extend.setTranslateExtendFields(translateExtendFields);
                dataModelBaseDTO.setExtendObj(extend);
            } else {
                dataModelBaseDTO.getExtendObj().setTranslateExtendFields(translateExtendFields);
            }
        }
    }

    private void sourceCodeRelationship(OscarFlowMsDataModelDTO dataModelDto, OscarFlowMsDataModel dataModelBase) throws LcdpException {
        ArrayList<OscarRelationshipDTO> relationshipDtoList = new ArrayList<OscarRelationshipDTO>();
        List<OscarDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        block0: for (OscarRelationshipBase relationship : dataModelBase.getRelationships()) {
            OscarRelationshipDTO relationshipDto = new OscarRelationshipDTO();
            BeanUtils.copyProperties((Object)relationship, (Object)relationshipDto);
            OscarDataModelBaseDTO masterModelDto = dataModelDto.getTableInfo(relationship.getMasterTableId());
            OscarDataModelBase masterModel = dataModelBase.getMasterTable();
            OscarDataModelBaseDTO slaveTableDto = dataModelDto.getTableInfo(relationship.getSlaveTableId());
            relationshipDto.setSlaveTableDto(slaveTableDto);
            OscarDataModelBase slaveTable = slaveTables.stream().filter(e -> e.getId().equals(relationship.getSlaveTableId())).findFirst().orElse(null);
            if (slaveTable == null) continue;
            relationshipDto.setSlaveTableName(slaveTableDto.getEntityName());
            relationshipDto.setSlaveTableServiceName(slaveTableDto.getServiceEnName());
            ArrayList<OscarRelationshipFieldDTO> relationshipFieldDtoList = new ArrayList<OscarRelationshipFieldDTO>();
            for (OscarRelationshipFieldBase relationshipField : relationship.getRelationships()) {
                OscarDataModelField slaveTableField;
                OscarRelationshipFieldDTO relationshipFieldDto = new OscarRelationshipFieldDTO();
                BeanUtils.copyProperties((Object)relationshipField, (Object)relationshipFieldDto);
                String masterTableFieldId = relationshipField.getMasterTableFieldId();
                String slaveTableFieldId = relationshipField.getSlaveTableFieldId();
                OscarDataModelField masterTableField = null;
                if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{masterTableFieldId})) {
                    masterTableField = masterModel.getFields().stream().filter(e -> e.getId().equals(masterTableFieldId)).findFirst().orElse(null);
                }
                if ((slaveTableField = (OscarDataModelField)slaveTable.getFields().stream().filter(e -> e.getId().equals(slaveTableFieldId)).findFirst().orElse(null)) == null) continue block0;
                if (masterTableField != null) {
                    relationshipFieldDto.setMasterFieldCap(masterModelDto.getFieldCapitalName(masterTableField.getName()));
                }
                relationshipFieldDto.setSlaveFieldCap(slaveTableDto.getFieldCapitalName(slaveTableField.getName()));
                relationshipFieldDtoList.add(relationshipFieldDto);
            }
            relationshipDto.setRelationshipDtoList(relationshipFieldDtoList);
            if ("collection".equals(relationshipDto.getRelateModelType())) {
                OscarDataModelField field = dataModelBase.getFields().stream().filter(fieldBase -> fieldBase.getSourceDataModelId().equals(relationship.getSlaveTableId())).findFirst().orElseThrow(() -> new LcdpException(LcdpExceptionEnum.ERROR, "\u672a\u627e\u5230\u5b50\u8868\u5bf9\u5e94\u4e3b\u5b50\u8868\u4e2d\u7684\u5217"));
                relationshipDto.setSlaveTableAlias(field.getName());
            }
            relationshipDtoList.add(relationshipDto);
        }
        dataModelDto.setRelationshipDtoList(relationshipDtoList);
    }

    private List<SourcePackageInfo> sourceCodePackage(OscarFlowMsDataModelDTO dataModelDto, OscarFlowMsDataModel dataModelBase, Map<String, OscarDataModelBaseDTO> tableInfoMap) {
        List<OscarDataModelField> dataModelFieldBases = dataModelBase.getFields();
        HashMap<String, SourcePackageInfo> sourcePackageInfoMap = new HashMap<String, SourcePackageInfo>();
        VoGeneratorInfo voGeneratorInfo = dataModelDto.getVoGeneratorInfo();
        voGeneratorInfo.addImport(Serializable.class.getCanonicalName());
        for (OscarDataModelField dataModelFieldBase : dataModelFieldBases) {
            PropertyType propertyType;
            OscarDataModelBaseDTO sourceDataModelDto;
            String sourceModelId = dataModelFieldBase.getSourceDataModelId();
            if (!ToolUtil.isNotEmpty((Object)sourceModelId) || !ToolUtil.isNotEmpty((Object)(sourceDataModelDto = tableInfoMap.get(sourceModelId)))) continue;
            if (DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType())) {
                if (ToolUtil.isEmpty(sourcePackageInfoMap.get(sourceModelId))) {
                    SourcePackageInfo sourcePackageInfo = new SourcePackageInfo();
                    sourcePackageInfo.setDataType("object");
                    sourcePackageInfo.setObjectName(sourceDataModelDto.getEntityName());
                    sourcePackageInfo.setObjectEnName(sourceDataModelDto.getEName());
                    String entityImport = sourceDataModelDto.getImportInfo().get("Entity");
                    sourcePackageInfoMap.put(sourceModelId, sourcePackageInfo);
                    dataModelDto.addEntityImport(entityImport);
                }
                SourceUseItem sourceUseItem = new SourceUseItem();
                sourceUseItem.setCurrAttr(dataModelFieldBase.getName());
                OscarDataModelFieldDto sourceField = sourceDataModelDto.getCertainField(dataModelFieldBase.getSourceFieldName());
                sourceUseItem.setSourceAttrCapitalName(sourceField.getCapitalName());
                ((SourcePackageInfo)sourcePackageInfoMap.get(sourceModelId)).addSourceItem(sourceUseItem);
                continue;
            }
            List<OscarDataModelFieldDto> dataModelFieldDtoList = dataModelDto.getFields();
            List<OscarDataModelFieldDto> voFields = voGeneratorInfo.getFields();
            for (OscarDataModelFieldDto dataModelFieldDto : dataModelFieldDtoList) {
                if (!dataModelFieldDto.getPropertyName().equals(dataModelFieldBase.getName()) || !ToolUtil.isNotEmpty((Object)(propertyType = OscarDataModelUtil.getEntityPropertyType(dataModelFieldBase.getDataType(), sourceDataModelDto)))) continue;
                dataModelFieldDto.setColumnType(propertyType);
                dataModelDto.addEntityImport(sourceDataModelDto.getImportInfo().get("Entity"));
                dataModelDto.addVoImport(sourceDataModelDto.getImportInfo().get("VO"));
            }
            for (OscarDataModelFieldDto voField : voFields) {
                if (!voField.getPropertyName().equals(dataModelFieldBase.getName()) || !ToolUtil.isNotEmpty((Object)(propertyType = OscarFlowMsEnclosure.getVoPropertyType(dataModelFieldBase.getDataType(), sourceDataModelDto)))) continue;
                voField.setColumnType(propertyType);
                voGeneratorInfo.addImport(sourceDataModelDto.getImportInfo().get("VO"));
            }
            if (!"array".equals(dataModelFieldBase.getDataType())) continue;
            SourcePackageInfo sourcePackageInfo = new SourcePackageInfo();
            sourcePackageInfo.setDataType("array");
            sourcePackageInfo.setObjectName(sourceDataModelDto.getEntityName());
            sourcePackageInfo.setObjectEnName(sourceDataModelDto.getEName());
            sourcePackageInfo.setQuoteAttr(dataModelFieldBase.getName());
            String entityImport = sourceDataModelDto.getImportInfo().get("Entity");
            sourcePackageInfoMap.put(sourceModelId, sourcePackageInfo);
            dataModelDto.addEntityImport(entityImport);
            dataModelDto.addEntityImport("java.util.List");
            voGeneratorInfo.addImport(sourceDataModelDto.getImportInfo().get("VO"));
            voGeneratorInfo.addImport("java.util.List");
        }
        return new ArrayList<SourcePackageInfo>(sourcePackageInfoMap.values());
    }

    private static PropertyType getVoPropertyType(String type, OscarDataModelBaseDTO dataModelDto) {
        PropertyType propertyType = null;
        if (ToolUtil.isNotEmpty((Object)type)) {
            propertyType = new PropertyType();
            propertyType.setImportT(dataModelDto.getImportInfo().get("VO"));
            String modelName = dataModelDto.getVoName();
            if (type.equals("array")) {
                propertyType.setType("List<${model}>".replace("${model}", modelName));
            } else if (type.equals("object")) {
                propertyType.setType(modelName);
            }
        }
        return propertyType;
    }
}

