/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.PropertyType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableIndex;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.dataset.ValueObjectProperty;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarModelFunction;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarQueryDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarEditDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.index.OscarDataModelIndex;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class OscarDataModelUtil {
    public static final String SLAVE_PAGE_VO = "SlavePageVO";
    public static final String PAGE_VO = "PageVO";
    private static final Pattern TPATTERN = Pattern.compile("[A-Z0-9]");

    public static OscarDataModelBase transfer(DataModelBase dataModelBase) throws LcdpException {
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        return modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)dataModelBase.getId()));
    }

    public static OscarDataModelBase transfer(JSONObject jsonObject) throws LcdpException {
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(String.valueOf(jsonObject.get((Object)"functionType")));
        return modelFunction.parseDataModel(jsonObject);
    }

    public static OscarDataModelBase transfer(String jsonData) throws LcdpException {
        DataModelBase dataModel = (DataModelBase)JSONObject.parseObject((String)jsonData, DataModelBase.class);
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        return modelFunction.parseDataModel(JSONObject.parseObject((String)jsonData));
    }

    public static OscarDataModelField getModelFieldById(List<OscarDataModelField> fields, String fieldId) {
        return fields.stream().filter(field -> field.getId().equals(fieldId)).findFirst().orElseGet(OscarDataModelField::new);
    }

    public static void addQueryPageVo(OscarDataModelBaseDTO dataModelBaseDTO) {
        OscarQueryDTO queryDTO = new OscarQueryDTO();
        queryDTO.setFtlPath("template/oscar/backcode/code/page.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + PAGE_VO);
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + PAGE_VO);
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }

    public static void addSlaveQueryPageVo(OscarDataModelBaseDTO dataModelBaseDTO, OscarDataModelOperation dataModelOperation) {
        OscarQueryDTO queryDTO = new OscarQueryDTO();
        queryDTO.setFtlPath("template/oscar/backcode/code/slave_page.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + SLAVE_PAGE_VO);
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + SLAVE_PAGE_VO);
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }

    public static String camelToUnderLine(String str) {
        Matcher matcher = TPATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static void addQueryPageViewVo(OscarDataModelBaseDTO dataModelBaseDTO) {
        OscarDataModelUtil.addQueryPageVo(dataModelBaseDTO);
    }

    public static void addQueryPageMsVo(OscarDataModelBaseDTO msdataModelBaseDTO) {
        OscarDataModelUtil.addQueryPageVo(msdataModelBaseDTO);
    }

    public static OscarQueryDTO getQueryDto(DataSet dataSet, OscarDataModelBaseDTO dataModelDTO) {
        OscarQueryDTO queryDto;
        block4: {
            block3: {
                queryDto = new OscarQueryDTO();
                queryDto.setId(dataSet.getId());
                queryDto.setName(EnclosureUtil.processName((String)dataSet.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null));
                queryDto.setComment(dataSet.getComment());
                Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
                queryDto.setPackageInfo(packageInfo.get("dto"));
                queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataSet.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
                queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
                queryDto.setFtlPath("template/oscar/backcode/code/queryDto.ftl");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("queryDto", queryDto);
                HashMap<String, Boolean> table = new HashMap<String, Boolean>();
                table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
                params.put("table", table);
                queryDto.setParams(params);
                queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
                if (!dataSet.getDataSetObject().getObjectType().equals(ComponentData.DataSetObjectTypeEnum.DATA_MODEL.getValue())) break block3;
                queryDto.setDataModel(true);
                if (!ToolUtil.isNotEmpty(dataModelDTO.getFields())) break block4;
                for (OscarDataModelFieldDto field : dataModelDTO.getFields()) {
                    OscarQueryFieldDTO queryVOFieldDto = new OscarQueryFieldDTO();
                    queryVOFieldDto.setComment(field.getComment());
                    queryVOFieldDto.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)field.getColumnType().getType()));
                    queryVOFieldDto.setPropertyName(field.getName());
                    queryVOFieldDto.setDbColumnType(field.getColumnType());
                    queryDto.addVOField(queryVOFieldDto);
                }
                break block4;
            }
            if (ToolUtil.isNotEmpty((Object)dataSet.getDataSetObject().getProperties())) {
                List<OscarQueryFieldDTO> queryVOFields = OscarDataModelUtil.addQueryVOField(dataSet.getDataSetObject().getProperties(), queryDto);
                for (OscarQueryFieldDTO queryVOField : queryVOFields) {
                    queryDto.addVOField(queryVOField);
                }
            }
        }
        return queryDto;
    }

    public static OscarQueryDTO getFilterDto(OscarDataModelBaseDTO dataModelDTO) {
        OscarQueryDTO queryDto = new OscarQueryDTO();
        Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
        queryDto.setPackageInfo(packageInfo.get("dto"));
        queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setImports(Collections.singleton(dataModelDTO.getImportInfo().get("Entity")));
        queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
        queryDto.setName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setFtlPath("template/oscar/backcode/code/filter.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("queryDto", queryDto);
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("table", table);
        queryDto.setParams(params);
        queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
        return queryDto;
    }

    public static OscarQueryDTO getTotalQueryDto(OscarDataModelBaseDTO dataModelDTO) {
        OscarQueryDTO queryDto = new OscarQueryDTO();
        Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
        queryDto.setPackageInfo(packageInfo.get("dto"));
        queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)(dataModelDTO.getName() + "TotalQuery"), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
        queryDto.setFtlPath("template/backcode/code/filter.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("queryDto", queryDto);
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("table", table);
        queryDto.setParams(params);
        queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
        return queryDto;
    }

    public static List<OscarQueryFieldDTO> addQueryVOField(List<ValueObjectProperty> properties, OscarQueryDTO queryDto) {
        ArrayList<OscarQueryFieldDTO> children = new ArrayList<OscarQueryFieldDTO>();
        for (ValueObjectProperty property : properties) {
            OscarQueryFieldDTO queryVOFieldDto = new OscarQueryFieldDTO();
            queryVOFieldDto.setComment(property.getComment());
            queryVOFieldDto.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)property.getDataType()));
            queryVOFieldDto.setType(property.getDataType());
            queryVOFieldDto.setPropertyName(property.getName());
            if (ToolUtil.isNotEmpty((Object)property.getProperties())) {
                queryVOFieldDto.setChildren(OscarDataModelUtil.addQueryVOField(property.getProperties(), queryDto));
            }
            children.add(queryVOFieldDto);
            if (null == queryVOFieldDto.getDbColumnType() || null == queryVOFieldDto.getDbColumnType().getImportT()) continue;
            queryDto.addImport(queryVOFieldDto.getDbColumnType().getImportT());
        }
        return children;
    }

    public static PropertyType getEntityPropertyType(String type, OscarDataModelBaseDTO dataModelDto) {
        PropertyType propertyType = null;
        if (ToolUtil.isNotEmpty((Object)type)) {
            propertyType = new PropertyType();
            propertyType.setImportT(dataModelDto.getImportInfo().get("Entity"));
            String modelName = dataModelDto.getEntityName();
            if (type.equals("array")) {
                propertyType.setType("List<${model}>".replace("${model}", modelName));
            } else if (type.equals("object")) {
                propertyType.setType(modelName);
            }
        }
        return propertyType;
    }

    private static List<TableField> noStandardTableFields(List<TableField> tableFields, List<OscarDataModelField> standardFields) {
        ArrayList<TableField> noStandardTableFields = new ArrayList<TableField>();
        for (TableField tableField : tableFields) {
            boolean noExist = true;
            for (OscarDataModelField standardField : standardFields) {
                if (!HussarUtils.equals((Object)standardField.getSourceFieldName(), (Object)tableField.getName())) continue;
                noExist = false;
                break;
            }
            if (!noExist) continue;
            noStandardTableFields.add(tableField);
        }
        return noStandardTableFields;
    }

    public static ContrastVO<OscarDataModelField> contrastWith(List<TableField> tableFields, List<OscarDataModelField> standardFields, List<OscarDataModelField> extFields) {
        if (AppContextUtil.isExtension()) {
            List modifyFields;
            ContrastVO<OscarDataModelField> standardContrastTables = OscarDataModelUtil.dbContrastModel(tableFields, standardFields);
            ContrastVO contrast = new ContrastVO();
            List delFields = standardContrastTables.getDelFields();
            if (HussarUtils.isNotEmpty((Object)delFields)) {
                for (Object field : delFields) {
                    if (((OscarDataModelField)((Object)field)).isExtension()) continue;
                    contrast.setErrorMsg("\u5e93\u8868\u6709\u6807\u51c6\u5b57\u6bb5\u88ab\u5220\u9664\uff0c\u8bf7\u4f7f\u7528\u201c\u6a21\u578b\u66f4\u65b0\u5230\u5e93\u8868\u201d\u6062\u590d\uff01");
                    return contrast;
                }
            }
            if (HussarUtils.isNotEmpty((Object)(modifyFields = standardContrastTables.getModifyFields()))) {
                for (OscarDataModelField field : modifyFields) {
                    if (field.isExtension()) continue;
                    contrast.setErrorMsg("\u5e93\u8868\u6709\u6807\u51c6\u5b57\u6bb5\u88ab\u4fee\u6539\uff0c\u8bf7\u4f7f\u7528\u201c\u6a21\u578b\u66f4\u65b0\u5230\u5e93\u8868\u201d\u6062\u590d\uff01");
                    return contrast;
                }
            }
            ContrastVO<OscarDataModelField> contrastVO = OscarDataModelUtil.dbContrastModel(OscarDataModelUtil.noStandardTableFields(tableFields, standardFields), extFields);
            if (HussarUtils.isNotEmpty((Object)delFields)) {
                if (HussarUtils.isEmpty((Object)contrastVO.getDelFields())) {
                    contrastVO.setDelFields(delFields);
                } else {
                    contrastVO.getDelFields().addAll(delFields);
                }
            }
            if (HussarUtils.isNotEmpty((Object)modifyFields)) {
                if (HussarUtils.isEmpty((Object)contrastVO.getModifyFields())) {
                    contrastVO.setModifyFields(modifyFields);
                } else {
                    contrastVO.getModifyFields().addAll(modifyFields);
                }
            }
            return contrastVO;
        }
        return OscarDataModelUtil.dbContrastModel(tableFields, standardFields);
    }

    public static ContrastVO<OscarDataModelField> dbContrastModel(List<TableField> tableFields, List<OscarDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        List<Object> addFields = new ArrayList();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<OscarDataModelField> delFields = new ArrayList<OscarDataModelField>();
        ArrayList<OscarDataModelField> modifyFields = new ArrayList<OscarDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().toUpperCase().equals(tableFields.get(j).getName().toUpperCase())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot() && HussarUtils.equals((Object)modelFields.get(i).getComment(), (Object)tableFields.get(j).getComment()) && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(OscarDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i)));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        addFields = OscarDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<OscarDataModelField> pushContrastWith(List<TableField> tableFields, List<OscarDataModelField> standardFields, List<OscarDataModelField> extFields) {
        if (AppContextUtil.isExtension()) {
            List modifyFields;
            ContrastVO<OscarDataModelField> standardContrastTables = OscarDataModelUtil.pushContrastWithDbContrastModel(tableFields, standardFields);
            ContrastVO contrast = new ContrastVO();
            List delFields = standardContrastTables.getDelFields();
            if (HussarUtils.isNotEmpty((Object)delFields)) {
                for (Object field : delFields) {
                    if (((OscarDataModelField)((Object)field)).isExtension()) continue;
                    contrast.setErrorMsg("\u5e93\u8868\u6709\u6807\u51c6\u5b57\u6bb5\u88ab\u5220\u9664\uff0c\u8bf7\u4f7f\u7528\u201c\u6a21\u578b\u66f4\u65b0\u5230\u5e93\u8868\u201d\u6062\u590d\uff01");
                    return contrast;
                }
            }
            if (HussarUtils.isNotEmpty((Object)(modifyFields = standardContrastTables.getModifyFields()))) {
                for (OscarDataModelField field : modifyFields) {
                    if (field.isExtension()) continue;
                    contrast.setErrorMsg("\u5e93\u8868\u6709\u6807\u51c6\u5b57\u6bb5\u88ab\u4fee\u6539\uff0c\u8bf7\u4f7f\u7528\u201c\u6a21\u578b\u66f4\u65b0\u5230\u5e93\u8868\u201d\u6062\u590d\uff01");
                    return contrast;
                }
            }
            ContrastVO<OscarDataModelField> contrastVO = OscarDataModelUtil.dbContrastModel(OscarDataModelUtil.noStandardTableFields(tableFields, standardFields), extFields);
            if (HussarUtils.isNotEmpty((Object)delFields)) {
                if (HussarUtils.isEmpty((Object)contrastVO.getDelFields())) {
                    contrastVO.setDelFields(delFields);
                } else {
                    contrastVO.getDelFields().addAll(delFields);
                }
            }
            if (HussarUtils.isNotEmpty((Object)modifyFields)) {
                if (HussarUtils.isEmpty((Object)contrastVO.getModifyFields())) {
                    contrastVO.setModifyFields(modifyFields);
                } else {
                    contrastVO.getModifyFields().addAll(modifyFields);
                }
            }
            return contrastVO;
        }
        return OscarDataModelUtil.pushContrastWithDbContrastModel(tableFields, standardFields);
    }

    public static ContrastVO<OscarDataModelField> pushContrastWithDbContrastModel(List<TableField> tableFields, List<OscarDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        List<Object> addFields = new ArrayList();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<OscarDataModelField> delFields = new ArrayList<OscarDataModelField>();
        ArrayList<OscarDataModelField> modifyFields = new ArrayList<OscarDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().toUpperCase().equals(tableFields.get(j).getName().toUpperCase())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(OscarDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i)));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        addFields = OscarDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<OscarDataModelField> contrastWithView(List<TableField> tableFields, List<OscarDataModelField> standardFields, List<OscarDataModelField> extFields) {
        if (AppContextUtil.isExtension()) {
            ContrastVO<OscarDataModelField> standardContrastTables = OscarDataModelUtil.dbContrastView(tableFields, standardFields);
            ContrastVO contrast = new ContrastVO();
            if (HussarUtils.isNotEmpty((Object)standardContrastTables.getDelFields())) {
                contrast.setErrorMsg("\u5e93\u8868\u6709\u6807\u51c6\u5b57\u6bb5\u88ab\u5220\u9664\uff0c\u975e\u6cd5\u64cd\u4f5c\uff01");
                return contrast;
            }
            if (HussarUtils.isNotEmpty((Object)standardContrastTables.getModifyFields())) {
                contrast.setErrorMsg("\u5e93\u8868\u6807\u51c6\u5b57\u6bb5\u88ab\u4fee\u6539\uff0c\u975e\u6cd5\u64cd\u4f5c\uff01");
                return contrast;
            }
            return OscarDataModelUtil.dbContrastView(OscarDataModelUtil.noStandardTableFields(tableFields, standardFields), extFields);
        }
        return OscarDataModelUtil.dbContrastView(tableFields, standardFields);
    }

    public static ContrastVO<OscarDataModelField> dbContrastView(List<TableField> tableFields, List<OscarDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<OscarDataModelField> delFields = new ArrayList<OscarDataModelField>();
        ArrayList<OscarDataModelField> modifyFields = new ArrayList<OscarDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equalsIgnoreCase(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot()) break;
                modifyFields.add(OscarDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i)));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        List<OscarDataModelField> addFields = OscarDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<OscarDataModelField> contrastWithIgnoreCase(List<TableField> tableFields, List<OscarDataModelField> standardFields, List<OscarDataModelField> extFields) {
        if (AppContextUtil.isExtension()) {
            ContrastVO<OscarDataModelField> standardContrastTables = OscarDataModelUtil.contrastViewWithIgnoreCase(tableFields, standardFields);
            ContrastVO contrast = new ContrastVO();
            if (HussarUtils.isNotEmpty((Object)standardContrastTables.getDelFields())) {
                contrast.setErrorMsg("\u5e93\u8868\u6709\u6807\u51c6\u5b57\u6bb5\u88ab\u5220\u9664\uff0c\u975e\u6cd5\u64cd\u4f5c\uff01");
                return contrast;
            }
            if (HussarUtils.isNotEmpty((Object)standardContrastTables.getModifyFields())) {
                contrast.setErrorMsg("\u5e93\u8868\u6807\u51c6\u5b57\u6bb5\u88ab\u4fee\u6539\uff0c\u975e\u6cd5\u64cd\u4f5c\uff01");
                return contrast;
            }
            return OscarDataModelUtil.contrastViewWithIgnoreCase(OscarDataModelUtil.noStandardTableFields(tableFields, standardFields), extFields);
        }
        return OscarDataModelUtil.contrastViewWithIgnoreCase(tableFields, standardFields);
    }

    public static ContrastVO<OscarDataModelField> contrastViewWithIgnoreCase(List<TableField> tableFields, List<OscarDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<OscarDataModelField> delFields = new ArrayList<OscarDataModelField>();
        ArrayList<OscarDataModelField> modifyFields = new ArrayList<OscarDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot()) break;
                modifyFields.add(OscarDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i)));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        List<OscarDataModelField> addFields = OscarDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<OscarDataModelField> mcontrastWith(List<TableField> tableFields, List<OscarDataModelField> standardFields, List<OscarDataModelField> extFields) {
        if (AppContextUtil.isExtension()) {
            ContrastVO<OscarDataModelField> standardContrastTables = OscarDataModelUtil.modelContrastDb(tableFields, standardFields);
            List addFields = standardContrastTables.getAddFields();
            List modifyFields = standardContrastTables.getModifyFields();
            ContrastVO<OscarDataModelField> contrastVO = OscarDataModelUtil.modelContrastDb(OscarDataModelUtil.noStandardTableFields(tableFields, standardFields), extFields);
            if (HussarUtils.isNotEmpty((Object)addFields)) {
                if (HussarUtils.isEmpty((Object)contrastVO.getAddFields())) {
                    contrastVO.setAddFields(addFields);
                } else {
                    contrastVO.getAddFields().addAll(addFields);
                }
            }
            if (HussarUtils.isNotEmpty((Object)modifyFields)) {
                if (HussarUtils.isEmpty((Object)contrastVO.getModifyFields())) {
                    contrastVO.setModifyFields(modifyFields);
                } else {
                    contrastVO.getModifyFields().addAll(modifyFields);
                }
            }
            return contrastVO;
        }
        return OscarDataModelUtil.modelContrastDb(tableFields, standardFields);
    }

    public static ContrastVO<OscarDataModelField> modelContrastDb(List<TableField> tableFields, List<OscarDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<OscarDataModelField> addFields = new ArrayList<OscarDataModelField>();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<OscarDataModelField> modifyFields = new ArrayList<OscarDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            OscarDataModelField oscarDataModelField = modelFields.get(i);
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!oscarDataModelField.getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (oscarDataModelField.getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && oscarDataModelField.getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && oscarDataModelField.getDataLength() == tableFields.get(j).getDataLength() && oscarDataModelField.getDataDot() == tableFields.get(j).getDataDot() && HussarUtils.equals((Object)oscarDataModelField.getComment(), (Object)tableFields.get(j).getComment()) && "primary".equals(oscarDataModelField.getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(oscarDataModelField);
            }
            if (flag) continue;
            addFields.add(oscarDataModelField);
        }
        List<OscarDataModelField> delFields = OscarDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastIndexVO<OscarDataModelIndex> contrastIndexWith(List<TableIndex> tableIndexs, List<OscarDataModelIndex> modelIndexs, TableCorrespond modelFislds) {
        boolean flag;
        ContrastIndexVO index = new ContrastIndexVO();
        ArrayList<OscarDataModelIndex> addIndexs = new ArrayList<OscarDataModelIndex>();
        ArrayList<OscarDataModelIndex> delIndexs = new ArrayList<OscarDataModelIndex>();
        if (!HussarUtils.isEmpty(tableIndexs)) {
            if (!HussarUtils.isEmpty(modelIndexs)) {
                ArrayList<TableIndex> addTableIndexs = new ArrayList<TableIndex>();
                CollectionUtils.addAll(addTableIndexs, (Object[])new Object[tableIndexs.size()]);
                Collections.copy(addTableIndexs, tableIndexs);
                for (int i = 0; i < modelIndexs.size(); ++i) {
                    flag = false;
                    for (int j = 0; j < tableIndexs.size(); ++j) {
                        if (!tableIndexs.get(j).getIndexName().equalsIgnoreCase(modelIndexs.get(i).getIndexName())) continue;
                        flag = true;
                        addTableIndexs.remove(tableIndexs.get(j));
                        if (modelIndexs.get(i).isChkUnique() == (tableIndexs.get(j).getIsNonUnique() == 0) && modelIndexs.get(i).getColumnName().equals(tableIndexs.get(j).getColumnName())) break;
                        delIndexs.add(modelIndexs.get(i));
                        addIndexs.add(OscarDataModelUtil.tabTransmodelIndexOne(tableIndexs.get(j), modelIndexs.get(i).getIndexName()));
                    }
                    if (flag) continue;
                    delIndexs.add(modelIndexs.get(i));
                }
                addIndexs.addAll(OscarDataModelUtil.tabTransmodelIndex(addTableIndexs));
            } else {
                addIndexs.addAll(OscarDataModelUtil.tabTransmodelIndex(tableIndexs));
            }
        } else if (!HussarUtils.isEmpty(modelIndexs)) {
            delIndexs.addAll(modelIndexs);
        }
        if (HussarUtils.isNotEmpty((Object)modelFislds)) {
            List modifyFields;
            ArrayList fields = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)modelFislds.getAddFields())) {
                fields.addAll(JSONArray.parseArray((String)modelFislds.getAddFields(), OscarDataModelField.class));
            }
            if (HussarUtils.isNotEmpty((Object)modelFislds.getDelFields())) {
                fields.addAll(JSONArray.parseArray((String)modelFislds.getDelFields(), OscarDataModelField.class));
            }
            if (HussarUtils.isNotEmpty((Object)(modifyFields = JSONArray.parseArray((String)modelFislds.getModifyFields(), OscarEditDataModelField.class)))) {
                fields.addAll(modifyFields.stream().map(OscarEditDataModelField::getNewField).collect(Collectors.toList()));
            }
            flag = false;
            if (HussarUtils.isNotEmpty(fields) && HussarUtils.isNotEmpty(delIndexs)) {
                Iterator iterator = delIndexs.iterator();
                while (iterator.hasNext()) {
                    OscarDataModelIndex delIndex = (OscarDataModelIndex)((Object)iterator.next());
                    for (OscarDataModelField field : fields) {
                        if (!field.getSourceFieldName().equals(delIndex.getColumnName())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        iterator.remove();
                        continue;
                    }
                    flag = false;
                }
            }
            if (HussarUtils.isNotEmpty(fields) && HussarUtils.isNotEmpty(addIndexs)) {
                Iterator iterator = addIndexs.iterator();
                while (iterator.hasNext()) {
                    OscarDataModelIndex addIndex = (OscarDataModelIndex)((Object)iterator.next());
                    for (OscarDataModelField field : fields) {
                        if (!field.getSourceFieldName().equals(addIndex.getColumnName())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        iterator.remove();
                        continue;
                    }
                    flag = false;
                }
            }
        }
        index.setAddIndexs(addIndexs);
        index.setDelIndexs(delIndexs);
        return index;
    }

    public static ContrastIndexVO<OscarDataModelIndex> mcontrastIndexWith(List<TableIndex> tableIndexs, List<OscarDataModelIndex> modelIndexs) {
        ContrastIndexVO index = new ContrastIndexVO();
        ArrayList<OscarDataModelIndex> addIndexs = new ArrayList<OscarDataModelIndex>();
        ArrayList<OscarDataModelIndex> delIndexs = new ArrayList<OscarDataModelIndex>();
        if (!HussarUtils.isEmpty(modelIndexs)) {
            if (!HussarUtils.isEmpty(tableIndexs)) {
                ArrayList<TableIndex> addTableIndexs = new ArrayList<TableIndex>();
                CollectionUtils.addAll(addTableIndexs, (Object[])new Object[tableIndexs.size()]);
                Collections.copy(addTableIndexs, tableIndexs);
                for (int i = 0; i < modelIndexs.size(); ++i) {
                    boolean flag = false;
                    for (int j = 0; j < tableIndexs.size(); ++j) {
                        if (!tableIndexs.get(j).getIndexName().equalsIgnoreCase(modelIndexs.get(i).getIndexName())) continue;
                        flag = true;
                        addTableIndexs.remove(tableIndexs.get(j));
                        if (modelIndexs.get(i).isChkUnique() == (tableIndexs.get(j).getIsNonUnique() == 0) && modelIndexs.get(i).getColumnName().equals(tableIndexs.get(j).getColumnName())) break;
                        delIndexs.add(OscarDataModelUtil.tabTransmodelIndexOne(tableIndexs.get(j), modelIndexs.get(i).getIndexName()));
                        addIndexs.add(modelIndexs.get(i));
                    }
                    if (flag) continue;
                    addIndexs.add(modelIndexs.get(i));
                }
                delIndexs.addAll(OscarDataModelUtil.tabTransmodelIndex(addTableIndexs));
            } else {
                addIndexs.addAll(modelIndexs);
            }
        } else if (!HussarUtils.isEmpty(tableIndexs)) {
            delIndexs.addAll(OscarDataModelUtil.tabTransmodelIndex(tableIndexs));
        }
        index.setAddIndexs(addIndexs);
        index.setDelIndexs(delIndexs);
        return index;
    }

    public static List<OscarDataModelField> tabTransmodel(List<TableField> tableFields) {
        ArrayList<OscarDataModelField> modelFields = new ArrayList<OscarDataModelField>();
        tableFields.forEach(tab -> {
            OscarDataModelField field = new OscarDataModelField();
            field.setSourceFieldName(tab.getName());
            field.setDataIsEmpty(tab.getDataIsEmpty());
            field.setDataLength(tab.getDataLength());
            field.setDataDot(tab.getDataDot());
            field.setComment(tab.getComment());
            field.setSourceDataType(tab.getType().toUpperCase());
            if ("PRI".equals(tab.getPrimarys())) {
                field.setUsage("primary");
            }
            field.setDataDefaultValue(tab.getDataDefaultValue());
            modelFields.add(field);
        });
        return modelFields;
    }

    public static OscarDataModelField tabTransmodelOne(TableField tableFields, OscarDataModelField modelField) {
        OscarDataModelField field = new OscarDataModelField();
        field.setId(modelField.getId());
        field.setSourceFieldName(tableFields.getName());
        field.setDataIsEmpty(tableFields.getDataIsEmpty());
        field.setDataLength(tableFields.getDataLength());
        field.setDataDot(tableFields.getDataDot());
        field.setComment(tableFields.getComment());
        field.setExtension(modelField.isExtension());
        if ("PRI".equals(tableFields.getPrimarys())) {
            field.setUsage("primary");
        }
        field.setDataDefaultValue(tableFields.getDataDefaultValue());
        field.setSourceDataType(tableFields.getType().toUpperCase());
        return field;
    }

    public static List<OscarDataModelIndex> tabTransmodelIndex(List<TableIndex> tableIndexs) {
        ArrayList<OscarDataModelIndex> modelIndexs = new ArrayList<OscarDataModelIndex>();
        if (tableIndexs != null) {
            tableIndexs.forEach(tab -> {
                OscarDataModelIndex index = new OscarDataModelIndex();
                index.setIndexName(tab.getIndexName().toUpperCase());
                index.setChkUnique(tab.getIsNonUnique() == 0);
                index.setTableSchema(tab.getTableSchema());
                index.setColumnName(tab.getColumnName().toUpperCase());
                index.setIndexType(tab.getIndexType());
                index.setTableName(tab.getTableName().toUpperCase());
                modelIndexs.add(index);
            });
        }
        return modelIndexs;
    }

    public static OscarDataModelIndex tabTransmodelIndexOne(TableIndex tableIndex, String indexName) {
        OscarDataModelIndex index = new OscarDataModelIndex();
        index.setIndexName(indexName.toUpperCase());
        index.setChkUnique(tableIndex.getIsNonUnique() == 0);
        index.setTableSchema(tableIndex.getTableSchema());
        index.setColumnName(tableIndex.getColumnName().toUpperCase());
        index.setIndexType(tableIndex.getIndexType());
        index.setTableName(tableIndex.getTableName().toUpperCase());
        return index;
    }
}

