/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.element.task;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarEnclosure;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarRender;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class OscarTaskDataModel
extends OscarBaseDataModel {
    public static final String FUNCTION_TYPE = "TASK";
    public static final String TASK_KEY = "task";
    public static final String BUSINESS_ID = "businessId";
    private OscarBaseDataModel task;
    private List<OscarRelationshipBase> relationships;
    private List<OscarDataModelField> flowFields;

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"OSCAR.TASK", OscarTaskDataModel.class);
    }

    public OscarBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(OscarBaseDataModel task) {
        this.task = task;
    }

    public List<OscarRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<OscarRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<OscarDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<OscarDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    public OscarTaskDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        OscarTaskDataModel oscarTaskDataModel;
        try {
            oscarTaskDataModel = (OscarTaskDataModel)JSONObject.parseObject((String)jsonObject.toString(), OscarTaskDataModel.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return oscarTaskDataModel;
    }

    @Override
    public OscarEnclosure<OscarDataModelBase> enclosure() throws LcdpException {
        return OscarModelBeanUtil.getEnclosureBean("OSCAR", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public OscarRender<OscarDataModelBase, OscarDataModelBaseDTO> render() throws LcdpException {
        return OscarModelBeanUtil.getRenderBean("OSCAR", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<OscarDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<OscarDataModelField>)fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> modelContrastTable(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<OscarDataModelField>> contrastVOS = this.task.modelContrastTable(fieldsContrastParam);
        contrastVOS.addAll(super.modelContrastTable(fieldsContrastParam));
        return contrastVOS;
    }

    @Override
    public List<ContrastIndexVO> tableContrastModelIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModelIndex(fieldsContrastParam);
    }

    @Override
    public List<ContrastIndexVO> modelContrastTableIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTableIndex(fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId, Map<String, List<JSONObject>> extFields, List<JSONObject> extSlaveTables) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.task.checkTableContrast(modelId, extFields, extSlaveTables).getDetails().get(0));
        details.add(super.checkTableContrast(modelId, extFields, extSlaveTables).getDetails().get(0));
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws Exception {
        this.task.updateTable(fieldsContrastParam);
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws Exception {
        return this.task.copyTableByModel(fieldsContrastParam) + super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "t");
        finalMap.put(this.task.getId(), TASK_KEY);
        return finalMap;
    }

    @Override
    public void customOption(OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx) throws LcdpException {
        OscarModelBeanUtil.getCustomOperationBean("OSCAR", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() throws LcdpException {
        Map<String, Map<String, Object>> slaveModelInfo = super.getSlaveModelInfo();
        HashMap<String, String> val = new HashMap<String, String>();
        val.put("name", this.task.getName());
        val.put("sourceDataModelName", this.task.getSourceDataModelName());
        val.put("type", TASK_KEY);
        slaveModelInfo.put(this.task.getId(), val);
        return slaveModelInfo;
    }
}

