/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.task.masterslavetask;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarQueryDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.querycondition.OscarQueryCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.querycondition.OscarQueryConditionField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortConditionField;
import com.jxdinfo.hussar.formdesign.oscar.function.render.OscarBaseRender;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.SqlReturnUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OscarMsTaskTableQuery {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsTaskTableQuery.class);

    public static void visit(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        OscarFlowMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        OscarFlowMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = OscarMsTaskTableQuery.initParams(dataModelOperation, dataModelBaseDTO, isLogicallyDelete);
        String mastId = useDataModelBase.getMasterTable().getId();
        OscarDataModelFieldDto fieldDto = dataModelBaseDTO.getDataModelDtoMap().get(mastId).getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null);
        boolean hasSecurityLevel = false;
        if (fieldDto != null) {
            controllerParams.put("securityLevel", fieldDto);
            String securityLevelSql = useDataModelBase.getModelAliasName().get(mastId) + "." + fieldDto.getName() + " &lt;= #{securityLevel}";
            controllerParams.put("securityLevelSql", securityLevelSql);
            hasSecurityLevel = true;
        }
        boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortOverall = true;
        boolean isSortCondition = OscarMsTaskTableQuery.renderSort(backCtx, dataModelOperation, modelId, controllerParams, useDataModelBase, isPagination);
        boolean isSelectCondition = OscarMsTaskTableQuery.renderSelect(backCtx, dataModelOperation, modelId, dataModelBaseDTO, controllerParams);
        controllerParams.put("isSortOverall", isSortOverall);
        OscarMsTaskTableQuery.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        SqlReturnUtil.renderAlias(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), dataModelBaseDTO);
        String controllerPath = "template/oscar/taskbackcode/masterslavetaskbackcode/tableQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/oscar/taskbackcode/masterslavetaskbackcode/tableQuery/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/oscar/taskbackcode/masterslavetaskbackcode/tableQuery/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String finalReturn = SqlReturnUtil.renderReturn(useDataModelBase, useDataModelBase.getModelAliasName());
        controllerParams.put("return", finalReturn);
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/oscar/taskbackcode/masterslavetaskbackcode/tableQuery/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/oscar/taskbackcode/masterslavetaskbackcode/tableQuery/xml.ftl";
        String finalRelation = SqlReturnUtil.renderRelation(useDataModelBase, dataModelBaseDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        OscarMsTaskTableQuery.renderImport(backCtx, modelId, dataModelBaseDTO, isPagination, isSelectCondition, isSortCondition, isSortOverall, hasSecurityLevel);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, OscarBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static void renderImport(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, String modelId, OscarFlowMsDataModelDTO dataModelBaseDTO, boolean isPagination, boolean isSelectCondition, boolean isSortCondition, boolean isSortOverall, boolean hasSecurityLevel) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Mapper"));
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        if (hasSecurityLevel) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        }
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
        } else if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isSortCondition) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private static Map<String, Object> initParams(OscarDataModelOperation dataModelOperation, OscarFlowMsDataModelDTO dataModelBaseDTO, boolean isLogicallyDelete) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private static boolean renderSelect(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation, String modelId, OscarFlowMsDataModelDTO dataModelBaseDTO, Map<String, Object> templateParams) {
        OscarFlowMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        boolean logicallyDelete = useDataModelBase.isLogicallyDelete();
        OscarDataModelField deleteField = useDataModelBase.getDeleteFlag();
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        Map<String, String> aliasMap = backCtx.getUseDataModelBase().getModelAliasName();
        String inValuesSql = OscarMsTaskTableQuery.getInValuesSql(backCtx.getUseDataModelBase(), dataModelOperation, aliasMap, selectConditionName);
        if (!StringUtil.isNotBlank((CharSequence)selectConditionName)) {
            if (logicallyDelete) {
                templateParams.put("addLogicallyCondition", true);
                String logicallyFlag = useDataModelBase.getModelAliasName().get(useDataModelBase.getMasterTable().getId()) + "." + deleteField.getSourceFieldName();
                templateParams.put("logicallyFlag", logicallyFlag);
            }
            return false;
        }
        OscarQueryCondition queryCondition = backCtx.getUseDataModelBase().getQuConBaseByName(selectConditionName);
        if (HussarUtils.isNotEmpty((Object)templateParams.get("securityLevel"))) {
            OscarQueryConditionField oredElse;
            boolean flag = true;
            if (ToolUtil.isNotEmpty((Object)queryCondition) && ToolUtil.isNotEmpty(queryCondition.getFields()) && ToolUtil.isNotEmpty((Object)(oredElse = (OscarQueryConditionField)queryCondition.getFields().stream().filter(item -> "securityLevel".equals(item.getUsageType())).findFirst().orElse(null)))) {
                flag = false;
            }
            if (flag) {
                OscarDataModelFieldDto fieldDto = (OscarDataModelFieldDto)templateParams.get("securityLevel");
                OscarQueryConditionField field = new OscarQueryConditionField();
                field.setConnect("and");
                field.setFromModelField(fieldDto.getId());
                field.setQueryAttrName(fieldDto.getPropertyName());
                field.setFromModelId(backCtx.getUseDataModelBase().getMasterTable().getId());
                field.setType("row");
                field.setSymbol("<=");
                field.setUsageType("securityLevel");
                if (HussarUtils.isEmpty(queryCondition.getFields())) {
                    ArrayList<OscarQueryConditionField> newFields = new ArrayList<OscarQueryConditionField>();
                    newFields.add(field);
                    queryCondition.setFields(newFields);
                } else {
                    queryCondition.getFields().add(field);
                }
            }
        }
        ArrayList<String> likeQueryFields = new ArrayList<String>();
        for (OscarQueryConditionField queryConditionField : queryCondition.getFields()) {
            String fromModelField = queryConditionField.getFromModelField();
            List<OscarDataModelField> fields = backCtx.getUseDataModelBase().getFields();
            boolean isStringType = true;
            for (OscarDataModelField field : fields) {
                if (!fromModelField.equals(field.getId()) || "string".equals(field.getDataType())) continue;
                isStringType = false;
                break;
            }
            if (!isStringType) continue;
            String symbol = queryConditionField.getSymbol();
            if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
            likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
        }
        templateParams.put("likeQueryFields", likeQueryFields);
        if (!Optional.ofNullable(queryCondition).map(OscarQueryCondition::getFields).isPresent() || queryCondition.getFields().isEmpty()) {
            return false;
        }
        templateParams.put("isSelectCondition", true);
        DataSet dataSet = backCtx.getUseDataModelBase().getDataSetById(queryCondition.getFromDataSet());
        if (logicallyDelete) {
            QueryConditionUtil.addLogicallyFlag(queryCondition, deleteField.getName(), useDataModelBase.getMasterTable().getId());
        }
        OscarQueryDTO queryDTO = OscarDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
        if (HussarUtils.isNotEmpty((Object)templateParams.get("securityLevel"))) {
            OscarDataModelFieldDto fieldDto = (OscarDataModelFieldDto)templateParams.get("securityLevel");
            OscarQueryFieldDTO field = new OscarQueryFieldDTO();
            field.setPropertyName(fieldDto.getPropertyName());
            field.setDbColumnType(fieldDto.getColumnType());
            field.setType(fieldDto.getType());
            field.setComment(fieldDto.getComment());
            if (HussarUtils.isEmpty(queryDTO.getQueryFields())) {
                ArrayList<OscarQueryFieldDTO> newFields = new ArrayList<OscarQueryFieldDTO>();
                newFields.add(field);
                queryDTO.setQueryFields(newFields);
            } else {
                queryDTO.getQueryFields().add(field);
            }
        }
        dataModelBaseDTO.addQueryDto(queryDTO);
        String finalWhereSql = QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), inValuesSql, dataModelBaseDTO, aliasMap, backCtx.getUseDataModelBase(), deleteField == null ? "" : deleteField.getSourceFieldName());
        if (useDataModelBase.isLogicallyDelete()) {
            QueryConditionUtil.deleteLogicallyFlag(queryCondition);
        }
        templateParams.put("whereSql", finalWhereSql);
        templateParams.put("QueryObj", queryDTO.getEntityName());
        templateParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private static boolean renderSort(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation, String modelId, Map<String, Object> controllerParams, OscarFlowMsDataModel useDataModelBase, boolean isPagination) throws LcdpException {
        OscarSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(OscarSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<OscarSortConditionField> sortConditionFields;
            List<OscarSortConditionField> fields = sortCondition.getFields();
            block0: for (OscarSortConditionField oscarSortConditionField : fields) {
                String fromModelFieldIdSort = oscarSortConditionField.getFromModelFieldIdSort();
                List<OscarDataModelField> fromModelFieldSort = useDataModelBase.getFields();
                for (OscarDataModelField oscarDataModelField : fromModelFieldSort) {
                    if (!oscarDataModelField.getId().equals(fromModelFieldIdSort)) continue;
                    oscarSortConditionField.setFromModelFieldSort(oscarDataModelField.getName());
                    continue block0;
                }
            }
            if (!isPagination) {
                sortConditionFields = sortCondition.getFields();
                for (OscarSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll(useDataModelBase.getMasterTable(), useDataModelBase.getSlaveTables());
                }
            } else {
                sortConditionFields = sortCondition.getFields();
                for (OscarSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName(useDataModelBase.getMasterTable(), useDataModelBase.getSlaveTables());
                }
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", true);
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            return true;
        }
        return false;
    }

    private static void renderPageVo(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, String modelId, OscarFlowMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        OscarDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }

    private static String getInValuesSql(OscarMsDataModel useDataModelBase, OscarDataModelOperation dataModelOperation, Map<String, String> aliasMap, String selectConditionName) {
        OscarDataModelField realFieldBase;
        String template = "<if test=\"inValues != null and inValues.size > 0\">\n ${T_ALIAS}.${REAL_FIELD} in\n    <foreach collection=\"inValues\" item=\"item\" open=\"(\" separator=\",\" close=\")\">\n        #{item}\n    </foreach>\n</if>";
        String entityAttr = (String)dataModelOperation.getParams().get("relateField");
        if (ToolUtil.isNotEmpty((Object)entityAttr) && ToolUtil.isNotEmpty((Object)((Object)(realFieldBase = useDataModelBase.getFields().stream().filter(field -> entityAttr.equals(field.getName())).findAny().orElseGet(OscarDataModelField::new))))) {
            String alias = aliasMap.get(realFieldBase.getSourceDataModelId());
            String sourceFieldName = realFieldBase.getSourceFieldName();
            if (useDataModelBase.isLogicallyDelete() && !StringUtil.isNotBlank((CharSequence)selectConditionName)) {
                String logicallyFlag = useDataModelBase.getModelAliasName().get(useDataModelBase.getMasterTable().getId()) + "." + useDataModelBase.getDeleteFlag().getSourceFieldName();
                template = template + "AND (" + logicallyFlag + " != '1' or " + logicallyFlag + " IS NULL)";
            }
            return template.replace("${T_ALIAS}", alias).replace("${REAL_FIELD}", sourceFieldName);
        }
        return "";
    }
}

