/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.base;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.render.OscarBaseRender;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARBASEFlagDeleteBatch")
public class OscarFlagDeleteVisitor
implements OscarOperationVisitor<OscarBaseDataModel, OscarBaseDataModelDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OscarFlagDeleteVisitor.class);
    public static final String OPERATION_NAME = "OSCARBASEFlagDeleteBatch";

    @Override
    public void visit(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation) throws LcdpException {
        LOGGER.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        OscarBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        OscarBaseDataModel oscarBaseDataModel = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = oscarBaseDataModel.getLogicallyDelete();
        Map<String, Object> flagDeleteParams = this.initParams(dataModelOperation, dataModelBaseDTO, isLogicallyDelete);
        OscarDataModelFieldDto keyFieldDto = dataModelBaseDTO.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            LOGGER.error("\u6a21\u578b\u672a\u8bbe\u7f6e\u4e3b\u952e");
            return;
        }
        String controllerPath = "template/oscar/backcode/flagdelete/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, flagDeleteParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/oscar/backcode/flagdelete/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, flagDeleteParams));
        String serviceImplPath = "template/oscar/backcode/flagdelete/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, flagDeleteParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        if (isLogicallyDelete) {
            flagDeleteParams.put("deleteFlag", oscarBaseDataModel.getDeleteFlag().getSourceFieldName());
            flagDeleteParams.put("primaryKey", oscarBaseDataModel.getPrimaryKey().getSourceFieldName());
            backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
            String mapperPath = "template/oscar/backcode/flagdelete/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, flagDeleteParams));
            String xmlPath = "template/oscar/backcode/flagdelete/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, flagDeleteParams));
        }
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isLogicallyDelete);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5220\u9664");
        backCtx.addApi(modelId, OscarBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, String modelId, OscarBaseDataModelDTO dataModelBaseDTO, Boolean isLogicallyDelete) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "java.util.Arrays");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "org.springframework.beans.factory.annotation.Autowired");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        if (isLogicallyDelete.booleanValue()) {
            backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Mapper"));
            backCtx.addMapperImport(modelId, "java.util.List");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        } else {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
    }

    private Map<String, Object> initParams(OscarDataModelOperation dataModelOperation, OscarBaseDataModelDTO dataModelBaseDTO, boolean isLogicallyDelete) {
        Map<String, Object> flagDeleteParams = dataModelOperation.getParams();
        List<OscarDataModelFieldDto> fields = dataModelBaseDTO.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (fields.get(i).getId().equals(dataModelOperation.getParams().get("mainId"))) {
                flagDeleteParams.put("mainId", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
            }
            if (fields.get(i).getId().equals(dataModelOperation.getParams().get("pId"))) {
                flagDeleteParams.put("pId", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
            }
            if (!HussarUtils.isNotEmpty((Object)fields.get(i).getFill()) || !fields.get(i).getFill().equals("primary")) continue;
            flagDeleteParams.put("mainName", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
        }
        flagDeleteParams.put("table", dataModelBaseDTO);
        flagDeleteParams.put("returnValue", dataModelBaseDTO.getEntityName());
        flagDeleteParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        flagDeleteParams.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u6279\u91cf\u5220\u9664");
            flagDeleteParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return flagDeleteParams;
    }
}

