/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.element.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarEnclosure;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarRender;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OscarTaskMsDataModel
extends OscarMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(OscarTaskMsDataModel.class);
    public static final String FUNCTION_TYPE = "TASK_MASTER_SLAVE";
    public static final String TASK_KEY = "task";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private OscarBaseDataModel task;
    private List<OscarDataModelField> flowFields;

    public List<OscarDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<OscarDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"OSCAR.TASK_MASTER_SLAVE", OscarTaskMsDataModel.class);
    }

    public OscarBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(OscarBaseDataModel task) {
        this.task = task;
    }

    @Override
    public OscarTaskMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        OscarTaskMsDataModel oscarTaskMsDataModel;
        try {
            ArrayList<OscarDataModelField> fieldList = new ArrayList<OscarDataModelField>();
            oscarTaskMsDataModel = (OscarTaskMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), OscarTaskMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                OscarDataModelBase master = OscarDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(oscarTaskMsDataModel.getName() + "Master");
                oscarTaskMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<OscarDataModelBase> slaveTables = new ArrayList<OscarDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    OscarDataModelBase slaveTable = OscarDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (OscarRelationshipBase relationship : oscarTaskMsDataModel.getRelationships()) {
                    if (relationship.getMasterTableId().equals(oscarTaskMsDataModel.task.getId())) continue;
                    OscarDataModelBase dataModelBase = slaveTables.stream().filter(item -> HussarUtils.equals((Object)item.getId(), (Object)relationship.getSlaveTableId())).findFirst().orElseGet(OscarBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    OscarDataModelField oscarDataModelField = new OscarDataModelField();
                    oscarDataModelField.setId(UUID.randomUUID().toString());
                    oscarDataModelField.setName(dataModelBase.getName());
                    oscarDataModelField.setComment(dataModelBase.getComment());
                    oscarDataModelField.setSourceDataModelId(dataModelBase.getId());
                    oscarDataModelField.setDataType("array");
                    fieldList.add(oscarDataModelField);
                }
                oscarTaskMsDataModel.setSlaveTables(slaveTables);
            }
            oscarTaskMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return oscarTaskMsDataModel;
    }

    @Override
    public OscarEnclosure<OscarDataModelBase> enclosure() throws LcdpException {
        return OscarModelBeanUtil.getEnclosureBean("OSCAR", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public OscarRender<OscarDataModelBase, OscarDataModelBaseDTO> render() throws LcdpException {
        return OscarModelBeanUtil.getRenderBean("OSCAR", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<OscarDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<OscarDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<OscarDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<OscarDataModelField>> contrastVOS = this.task.modelContrastTable((FieldsContrastParam<OscarDataModelField>)fieldsContrastParam);
        contrastVOS.addAll(super.modelContrastTable((FieldsContrastParam<OscarDataModelField>)fieldsContrastParam));
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.task.checkTableContrast(modelId).getDetails().get(0));
        details.addAll(super.checkTableContrast(modelId).getDetails());
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws Exception {
        this.task.updateTable(fieldsContrastParam);
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws Exception {
        return this.task.copyTableByModel(fieldsContrastParam) + super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.getMasterTable().getId(), "T2");
        List<OscarRelationshipBase> relationships = super.getRelationships();
        if (ToolUtil.isNotEmpty(relationships) && !relationships.isEmpty()) {
            for (int i = 0; i < relationships.size(); ++i) {
                OscarRelationshipBase relationship = relationships.get(i);
                if (relationship.getSlaveTableId().equals(super.getId())) continue;
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        finalMap.put(this.task.getId(), TASK_KEY);
        return finalMap;
    }

    @Override
    public void customOption(OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx) throws LcdpException {
        OscarModelBeanUtil.getCustomOperationBean("OSCAR", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        return super.getSlaveModelInfo();
    }
}

