/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarEnclosure;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarRender;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.querycondition.OscarQueryCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.querycondition.OscarQueryObject;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortConditionField;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OscarMsDataModel
extends OscarDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(OscarMsDataModel.class);
    public static final String FUNCTION_TYPE = "MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<OscarQueryCondition> queryConditions;
    private List<OscarQueryObject> queryObject;
    private OscarDataModelBase masterTable;
    private List<OscarDataModelBase> slaveTables;
    private List<OscarRelationshipBase> relationships;
    private boolean logicallyDelete;
    private List<OscarSortCondition> sortCondition;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"OSCAR.MASTER_SLAVE", OscarMsDataModel.class);
    }

    @Override
    public OscarMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        OscarMsDataModel oscarMsDataModel;
        try {
            ArrayList<OscarDataModelField> fieldList = new ArrayList<OscarDataModelField>();
            oscarMsDataModel = (OscarMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), OscarMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                OscarDataModelBase master = OscarDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(oscarMsDataModel.getName() + "Master");
                oscarMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<OscarDataModelBase> slaveTables = new ArrayList<OscarDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    OscarDataModelBase slaveTable = OscarDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (OscarRelationshipBase relationship : oscarMsDataModel.getRelationships()) {
                    OscarDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(OscarBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    OscarDataModelField oscarDataModelField = new OscarDataModelField();
                    oscarDataModelField.setId(UUID.randomUUID().toString());
                    oscarDataModelField.setName(dataModelBase.getName());
                    oscarDataModelField.setComment(dataModelBase.getComment());
                    oscarDataModelField.setSourceDataModelId(dataModelBase.getId());
                    oscarDataModelField.setDataType("array");
                    fieldList.add(oscarDataModelField);
                }
                oscarMsDataModel.setSlaveTables(slaveTables);
            }
            oscarMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return oscarMsDataModel;
    }

    @Override
    public OscarEnclosure<OscarDataModelBase> enclosure() throws LcdpException {
        return OscarModelBeanUtil.getEnclosureBean("OSCAR", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public OscarRender<OscarDataModelBase, OscarDataModelBaseDTO> render() throws LcdpException {
        return OscarModelBeanUtil.getRenderBean("OSCAR", FUNCTION_TYPE, "RENDER");
    }

    public OscarDataModelBase getMasterTable() {
        return this.masterTable;
    }

    public void setMasterTable(OscarDataModelBase masterTable) {
        this.masterTable = masterTable;
    }

    public List<OscarDataModelBase> getSlaveTables() {
        return this.slaveTables;
    }

    public void setSlaveTables(List<OscarDataModelBase> slaveTables) {
        this.slaveTables = slaveTables;
    }

    public List<OscarRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<OscarRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<OscarQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<OscarQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<OscarQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<OscarQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<OscarSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (OscarSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (OscarSortConditionField field : condition.getFields()) {
                    Map<String, String> fieldMap;
                    String fieldName;
                    if (HussarUtils.isEmpty((Object)field.getParentModelId())) {
                        field.setParentModelId(field.getFromModelIdSort());
                    }
                    OscarDataModelBase dataModelBase = this.masterTable;
                    if (!this.masterTable.getId().equals(field.getFromModelIdSort())) {
                        for (OscarDataModelBase modelBase : this.slaveTables) {
                            if (!modelBase.getId().equals(field.getFromModelIdSort())) continue;
                            dataModelBase = modelBase;
                            break;
                        }
                    }
                    if (HussarUtils.equals((Object)(fieldName = (fieldMap = dataModelBase.getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName))).get(field.getFromModelFieldIdSort())), (Object)field.getFromModelFieldSort())) continue;
                    field.setFromModelFieldSort(fieldName);
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<OscarSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @Override
    public boolean isLogicallyDelete() {
        return this.logicallyDelete;
    }

    @Override
    public void setLogicallyDelete(boolean logicallyDelete) {
        this.logicallyDelete = logicallyDelete;
    }

    @Override
    public OscarQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (OscarQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return null;
    }

    @Override
    public OscarSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (OscarSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return "";
    }

    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.masterTable.getId(), "T2");
        if (ToolUtil.isNotEmpty(this.relationships) && !this.relationships.isEmpty()) {
            for (int i = 0; i < this.relationships.size(); ++i) {
                OscarRelationshipBase relationship = this.relationships.get(i);
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        return finalMap;
    }

    public DataSet getDataSetById(String dataSetId) {
        if (this.getDataSets() != null) {
            for (DataSet dataSet : this.getDataSets()) {
                if (!dataSet.getId().equals(dataSetId)) continue;
                return dataSet;
            }
        }
        return null;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> findTableContrast() throws IOException, LcdpException {
        List<ContrastVO<OscarDataModelField>> tableContrast = this.masterTable.findTableContrast();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).findTableContrast().get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> tableContrastModel(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<OscarDataModelField>> tableContrast = this.masterTable.tableContrastModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).tableContrastModel(fieldsContrastParam).get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> modelContrastTable(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<OscarDataModelField>> tableContrast = this.masterTable.modelContrastTable(fieldsContrastParam);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            if (!HussarUtils.isEmpty(map.get(this.slaveTables.get(i).getSourceDataModelName()))) continue;
            tableContrast.add(this.slaveTables.get(i).modelContrastTable(fieldsContrastParam).get(0));
            map.put(this.slaveTables.get(i).getSourceDataModelName(), true);
        }
        return tableContrast;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.masterTable.checkTableContrast(modelId).getDetails().get(0));
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            details.add(this.slaveTables.get(i).checkTableContrast(modelId).getDetails().get(0));
        }
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws Exception {
        this.masterTable.updateTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            this.slaveTables.get(i).updateTable(fieldsContrastParam);
        }
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws Exception {
        String sql = this.masterTable.copyTableByModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            sql = sql + this.slaveTables.get(i).copyTableByModel(fieldsContrastParam);
        }
        return sql;
    }

    public OscarDataModelField getDeleteFlag() {
        return this.getMasterTable().getFields().stream().filter(field -> "delDefFlag".equals(field.getUsage())).findFirst().orElse(null);
    }

    public OscarDataModelField getPrimaryKey() {
        return this.getMasterTable().getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(null);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        List<OscarDataModelBase> slaveTables = this.getSlaveTables();
        for (OscarDataModelBase slaveTable : slaveTables) {
            OscarDataModelField oscarDataModelField = slaveTable.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(new OscarDataModelField());
            HashMap<String, Object> val = new HashMap<String, Object>();
            val.put("comment", slaveTable.getComment());
            val.put("primary", oscarDataModelField.getName());
            val.put("fields", slaveTable.getFields());
            boolean association = this.getRelationships().stream().anyMatch(relationship -> relationship.getRelateModelType().equals(ASSOCIATION) && relationship.getSlaveTableId().equals(slaveTable.getId()));
            val.put(ASSOCIATION, association);
            map.put(slaveTable.getId(), val);
        }
        return map;
    }
}

