package ${table.packageInfo.Entity!};

<#assign entity = table.entityGenerateInfo!>
<#include "../../swagger/swagger_model.ftl">
import io.swagger.annotations.ApiModelProperty;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import org.apache.ibatis.type.Alias;
<#list entity.imports! as import>
import ${import};
</#list>
<#if existDate?? && existDate>
    import org.apache.ibatis.type.JdbcType;
</#if>

${entityimport}
<#if table.entityName?contains("Master")>
    /**
    * ${table.entityName?substring(0,table.entityName?index_of("Master"))}主表实体类
    */
<#else >
    /**
    * ${table.comment!}实体类
    */
</#if>
@Alias("${entity.qualifyBeanName!}")
<#if table.entityName?contains("Master")>
    <#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
        @ApiModel(value = "${table.entityName?substring(0,table.entityName?index_of("Master"))}主表")
    </#if>
<#else >
    ${apimodel!}
</#if>
<#if table.sourceDataModelName?? && table.sourceDataModelName != ''>
@TableName("${table.sourceDataModelName!}")
</#if>
public class ${table.entityName!} implements BaseEntity{

    private static final long serialVersionUID = 1L;

<#assign keyPropertyName = "">
<#list table.fields! as field>
    /**
    * ${field.comment}
    */
<#if table.useMybatisPlus && "" != field.name>
    <#if field.keyFlag>
        <#assign keyPropertyName= field.propertyName>
    @TableId("${field.name ? upper_case}")
    <#else >
    @TableField(
        <#if field.type == "date">value=</#if>"${field.name ? upper_case}"
        <#if field.type == "date">,jdbcType = JdbcType.DATETIMEOFFSET, updateStrategy = FieldStrategy.IGNORED</#if>
    )
    </#if>
</#if>
    <#if table.validateAnnotations?? && (table.validateAnnotations?size>0)>
        <#list table.validateAnnotations[field.propertyName]! as annotation>
            ${annotation}
        </#list>
    </#if>
    <#if field.fieldAnnotation??>
        ${field.fieldAnnotation}
    </#if>

    <#if field.comment?? && field.comment!=''>
        @ApiModelProperty(value = "${field.comment!}")
    <#else>
        @ApiModelProperty(value = "${field.propertyName}")
    </#if>

    private ${field.propertyType} ${field.propertyName};

</#list>

<#list table.translateShowFields! as field>
    /**
    * ${field.comment}
    */
    @TableField(exist = false)
    <#if field.comment?? && field.comment!=''>
        @ApiModelProperty(value = "${field.comment!}")
    <#else>
        @ApiModelProperty(value = "${field.propertyName}")
    </#if>
    private ${field.propertyType} ${field.propertyName};
</#list>

/* @begin property #自定义属性 */
/* @end property */

<#list table.fields! as field>
    <#assign getprefix="get">
    <#if field.propertyType == "Boolean">
        <#assign getprefix="is">
    </#if>
    public ${field.propertyType} ${getprefix}${field.capitalName!}() {
        return ${field.propertyName};
    }

    public void set${field.capitalName!}(${field.propertyType} ${field.propertyName}) {
        this.${field.propertyName} = ${field.propertyName};
    }

</#list>

<#list table.translateShowFields! as field>
    <#assign getprefix="get">
    <#if field.propertyType == "Boolean">
        <#assign getprefix="is">
    </#if>
    public ${field.propertyType} ${getprefix}${field.capitalName!}() {
            return ${field.propertyName};
        }

    public void set${field.capitalName!}(${field.propertyType} ${field.propertyName}) {
        this.${field.propertyName} = ${field.propertyName};
    }
</#list>

/* @begin getAndSet #自定义get、set */
/* @end getAndSet */

<#--<#if table.useMybatisPlus>
    @Override
    public Serializable pkVal() {
    <#if keyPropertyName != "">
        return this.${keyPropertyName};
    <#else>
        return null;
    </#if>
    }
</#if>-->

    @Override
    public String toString() {
    return "${table.enName}{" +
    <#list table.fields! as field>
        <#if field_index == 0>
            "${field.propertyName}=" + ${field.propertyName} +
        <#else>
            ", ${field.propertyName}=" + ${field.propertyName} +
        </#if>
    </#list>
    "}";
    }
}
