/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.render;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.OscarCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarRender;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.baseapi.OscarBaseApiDataModel;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARBASE_APIRENDER")
public class OscarBaseApiRender
implements OscarRender<OscarBaseApiDataModel, OscarBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarBaseApiRender.class);
    public static final String RENDER = "OSCARBASE_APIRENDER";

    @Override
    public List<OscarCodeGenerateInfo> renderCode(OscarBackCtx<OscarBaseApiDataModel, OscarBaseDataModelDTO> backCtx) throws LcdpException, IOException {
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<OscarCodeGenerateInfo> oscarCodeGenerateInfos = new ArrayList<OscarCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        OscarBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        oscarCodeGenerateInfos.add(this.genApiCode(dataModelBaseDTO, baseFile));
        return oscarCodeGenerateInfos;
    }

    private OscarCodeGenerateInfo genApiCode(OscarBaseDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/oscar/preview/api/api-${pageType}-file.ftl".replace("${pageType}", ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage");
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }
}

