/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.base;

import com.jxdinfo.hussar.formdesign.back.common.util.ExtensionOperationJudge;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarQueryDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.querycondition.OscarQueryCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.querycondition.OscarQueryConditionField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortConditionField;
import com.jxdinfo.hussar.formdesign.oscar.function.render.OscarBaseRender;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARBASETableQuery")
public class OscarTableQueryVisitor
implements OscarOperationVisitor<OscarBaseDataModel, OscarBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarTableQueryVisitor.class);
    public static final String OPERATION_NAME = "OSCARBASETableQuery";

    @Override
    public void visit(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation) throws LcdpException {
        String modelId = backCtx.getUseDataModelBase().getId();
        OscarBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String type = ExtensionOperationJudge.type(dataModelOperation.getParams());
        if (HussarUtils.equals((Object)ExtensionOperationJudge.REUSED, (Object)type)) {
            this.addApi(backCtx, dataModelOperation, dataModelBaseDTO, "${PREFIX.standardName}");
            return;
        }
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        OscarBaseDataModel oscarBaseDataModel = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = oscarBaseDataModel.getLogicallyDelete();
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO, isLogicallyDelete);
        OscarDataModelFieldDto fieldDto = dataModelBaseDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null);
        boolean hasSecurityLevel = false;
        if (fieldDto != null) {
            controllerParams.put("securityLevel", fieldDto);
            hasSecurityLevel = true;
        }
        boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortOverall = true;
        boolean isSortCondition = this.renderSort(backCtx, dataModelOperation, modelId, controllerParams, oscarBaseDataModel, isPagination);
        boolean isSelectCondition = this.renderSelect(backCtx, dataModelOperation, modelId, dataModelBaseDTO, controllerParams);
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        if (isLogicallyDelete) {
            controllerParams.put("deleteFlag", dataModelBaseDTO.getFieldCapitalName(oscarBaseDataModel.getDeleteFlag().getName()));
            controllerParams.put("deleteFlagName", oscarBaseDataModel.getDeleteFlag().getSourceFieldName());
        }
        String controllerPath = "template/oscar/backcode/tableQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/oscar/backcode/tableQuery/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/oscar/backcode/tableQuery/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        if (isSelectCondition) {
            backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
            String mapperPath = "template/oscar/backcode/tableQuery/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
            String xmlPath = "template/oscar/backcode/tableQuery/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isPagination, isSelectCondition, isSortCondition, isLogicallyDelete, isSortOverall, hasSecurityLevel);
        this.addApi(backCtx, dataModelOperation, dataModelBaseDTO, "${PREFIX.name}");
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void addApi(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation, OscarBaseDataModelDTO dataModelBaseDTO, String prefix) throws LcdpException {
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix(prefix) + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        String modelId = backCtx.getUseDataModelBase().getId();
        backCtx.addApi(modelId, OscarBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, String modelId, OscarBaseDataModelDTO dataModelBaseDTO, boolean isPagination, boolean isSelectCondition, boolean isSortCondition, boolean isLogicallyDelete, boolean isSortOverall, boolean hasSecurityLevel) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        if (hasSecurityLevel) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "java.util.List");
            backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
            if (isPagination) {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            } else if (isSortCondition) {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            }
        }
        if (isSortCondition) {
            if (isPagination) {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            } else {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            }
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
        if (isLogicallyDelete) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private Map<String, Object> initParams(OscarDataModelOperation dataModelOperation, OscarBaseDataModelDTO dataModelBaseDTO, boolean isLogicallyDelete) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderSelect(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation, String modelId, OscarBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        OscarBaseDataModel oscarBaseDataModel = backCtx.getUseDataModelBase();
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        OscarQueryCondition queryCondition = oscarBaseDataModel.getQuConBaseByName(selectConditionName);
        if (HussarUtils.isNotEmpty((Object)controllerParams.get("securityLevel"))) {
            OscarQueryConditionField oredElse;
            boolean flag = true;
            if (ToolUtil.isNotEmpty((Object)queryCondition) && ToolUtil.isNotEmpty(queryCondition.getFields()) && ToolUtil.isNotEmpty((Object)(oredElse = (OscarQueryConditionField)queryCondition.getFields().stream().filter(item -> "securityLevel".equals(item.getUsageType())).findFirst().orElse(null)))) {
                flag = false;
            }
            if (flag) {
                OscarDataModelFieldDto fieldDto = (OscarDataModelFieldDto)controllerParams.get("securityLevel");
                OscarQueryConditionField field = new OscarQueryConditionField();
                field.setConnect("and");
                field.setFromModelField(fieldDto.getId());
                field.setQueryAttrName(fieldDto.getPropertyName());
                field.setFromModelId(oscarBaseDataModel.getId());
                field.setType("row");
                field.setSymbol("<=");
                field.setUsageType("securityLevel");
                queryCondition.getFields().add(field);
            }
        }
        ArrayList<String> likeQueryFields = new ArrayList<String>();
        for (OscarQueryConditionField queryConditionField : queryCondition.getFields()) {
            String fromModelField = queryConditionField.getFromModelField();
            List<OscarDataModelField> fields = oscarBaseDataModel.getFields();
            boolean isStringType = true;
            for (OscarDataModelField field : fields) {
                if (!fromModelField.equals(field.getId()) || "string".equals(field.getDataType())) continue;
                isStringType = false;
                break;
            }
            if (!isStringType) continue;
            String symbol = queryConditionField.getSymbol();
            if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
            likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
        }
        controllerParams.put("likeQueryFields", likeQueryFields);
        if (!Optional.ofNullable(queryCondition).map(OscarQueryCondition::getFields).isPresent() || queryCondition.getFields().isEmpty()) {
            return false;
        }
        controllerParams.put("isSelectCondition", true);
        DataSet dataSet = oscarBaseDataModel.getDataSetById(queryCondition.getFromDataSet());
        if (oscarBaseDataModel.getLogicallyDelete()) {
            QueryConditionUtil.addLogicallyFlag(queryCondition, oscarBaseDataModel.getDeleteFlag().getName(), oscarBaseDataModel.getId());
        }
        OscarQueryDTO queryDTO = OscarDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
        if (HussarUtils.isNotEmpty((Object)controllerParams.get("securityLevel"))) {
            OscarDataModelFieldDto fieldDto = (OscarDataModelFieldDto)controllerParams.get("securityLevel");
            OscarQueryFieldDTO field = new OscarQueryFieldDTO();
            field.setPropertyName(fieldDto.getPropertyName());
            field.setDbColumnType(fieldDto.getColumnType());
            field.setType(fieldDto.getType());
            field.setComment(fieldDto.getComment());
            queryDTO.getQueryFields().add(field);
        }
        dataModelBaseDTO.addQueryDto(queryDTO);
        String finalWhereSql = "";
        finalWhereSql = oscarBaseDataModel.getLogicallyDelete() ? QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), null, dataModelBaseDTO, new HashMap<String, String>(), oscarBaseDataModel.getDeleteFlag().getSourceFieldName()) : QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), null, dataModelBaseDTO, new HashMap<String, String>());
        if (oscarBaseDataModel.getLogicallyDelete()) {
            QueryConditionUtil.deleteLogicallyFlag(queryCondition);
        }
        controllerParams.put("whereSql", finalWhereSql);
        controllerParams.put("QueryObj", queryDTO.getEntityName());
        controllerParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private boolean renderSort(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation, String modelId, Map<String, Object> templateParams, OscarBaseDataModel useDataModelBase, boolean isPagination) throws LcdpException {
        OscarSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(OscarSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            if (!isPagination) {
                List<OscarSortConditionField> sortConditionFields = sortCondition.getFields();
                for (OscarSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll();
                }
            } else {
                List<OscarSortConditionField> sortConditionFields = sortCondition.getFields();
                for (OscarSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName();
                }
            }
            templateParams.put("sortConditionObj", sortCondition);
            templateParams.put("isSortCondition", true);
            return true;
        }
        return false;
    }

    private void renderPageVo(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, String modelId, OscarBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        OscarDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + OscarDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

