package ${table.packageInfo.Entity!};

import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.ExpansionMapEntity;
import com.jxdinfo.hussar.support.mp.base.query.annotations.QueryAlias;
import com.jxdinfo.hussar.support.expansion.core.annotations.ExpansionMasterSlave;
import org.apache.ibatis.type.Alias;
<#assign entity = table.entityGenerateInfo!>
<#include "../../swagger/swagger_model.ftl">
<#list entity.imports! as import>
import ${import};
</#list>
${entityimport!}
/**
* ${table.comment!}实体类
*/
@Alias("${entity.qualifyBeanName!}")
${apimodel!}
<#if table.sourceDataModelName?? && table.sourceDataModelName != ''>
@TableName("${table.sourceDataModelName!}")
</#if>
<#if !table.extensionApp>
@ExpansionMasterSlave
</#if>
public class ${table.entityName!} extends ExpansionMapEntity implements BaseEntity{

    private static final long serialVersionUID = 1L;

    <#list table.groupsInterfaces! as interface>
        public interface ${interface}{}
    </#list>

<#assign keyPropertyName = "">
<#list table.fields! as field>
        <#if !field.extend>
    /**
    * ${field.comment}
    */
    <#if field.aliasName?? && field.aliasName != ''>
        @QueryAlias("${field.aliasName!}")
    </#if>
    <#if table.validateAnnotations?? && (table.validateAnnotations?size>0)>
        <#list table.validateAnnotations[field.propertyName]! as annotation>
            ${annotation}
        </#list>
    </#if>
    <#if field.fieldAnnotation??>
        ${field.fieldAnnotation}
    </#if>
    <#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
        @ApiModelProperty(value = "${field.comment!}")
    </#if>
    private ${field.propertyType} ${field.propertyName};
</#if>
</#list>

<#list table.translateShowFields! as field>
     <#if !field.extend>
    /**
    * ${field.comment}
    */
    @TableField(exist = false)
    private ${field.propertyType} ${field.propertyName};
    </#if>
</#list>

/* @begin property #自定义属性 */
/* @end property */

<#list table.fields! as field>
     <#if !field.extend>
    <#assign getprefix="get">
    <#if field.propertyType == "Boolean">
        <#assign getprefix="is">
    </#if>
    public ${field.propertyType} ${getprefix}${field.capitalName}() {
        return ${field.propertyName};
    }

    public void set${field.capitalName}(${field.propertyType} ${field.propertyName}) {
        this.${field.propertyName} = ${field.propertyName};
    }
    </#if>

</#list>

<#list table.translateShowFields! as field>
     <#if !field.extend>
    <#assign getprefix="get">
    <#if field.propertyType == "Boolean">
        <#assign getprefix="is">
    </#if>
    public ${field.propertyType} ${getprefix}${field.capitalName!}() {
            return ${field.propertyName};
        }

    public void set${field.capitalName!}(${field.propertyType} ${field.propertyName}) {
        this.${field.propertyName} = ${field.propertyName};
    }
    </#if>
</#list>

<#--扩展属性 渲染范围-->
<#if table.extendObj?? && (table.extendObj.extendFields?has_content || table.extendObj.translateExtendFields?has_content)>
    /* begin ExtendProperty:${table.entityName!} #扩展字段属性 */
<#-- 普通字段属性 开始 -->
    <#list table.extendObj.extendFields! as field>
        /**
        * ${field.comment}
        */
        <#if field.aliasName?? && field.aliasName != ''>
            @QueryAlias("${field.aliasName!}")
        </#if>
        <#if table.validateAnnotations?? && (table.validateAnnotations?size>0)>
            <#list table.validateAnnotations[field.propertyName]! as annotation>
                ${annotation}
            </#list>
        </#if>
        <#if field.fieldAnnotation??>
            ${field.fieldAnnotation}
        </#if>
        <#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
            @ApiModelProperty(value = "${field.comment!}")
        </#if>
        private ${field.propertyType} ${field.propertyName};
    </#list>
<#-- 普通字段属性 结束 -->
<#-- 附加字段 属性开始   -->
    <#list table.extendObj.translateExtendFields! as field>
        /**
         * ${field.comment}
        */
        @TableField(exist = false)
        private ${field.propertyType} ${field.propertyName};
    </#list>
<#-- 附加字段 属性结束   -->


<#-- 扩展字段get  set 方法 开始 -->
    <#list table.extendObj.extendFields! as field>
        <#assign getprefix="get">
        <#if field.propertyType == "Boolean">
            <#assign getprefix="is">
        </#if>
        public ${field.propertyType} ${getprefix}${field.capitalName}() {
        return ${field.propertyName};
        }

        public void set${field.capitalName}(${field.propertyType} ${field.propertyName}) {
        this.${field.propertyName} = ${field.propertyName};
        }
    </#list>
<#-- 扩展字段get  set 方法 结束 -->

<#-- 附加字段get  set 方法 开始 -->
    <#list table.extendObj.translateExtendFields! as field>
        <#assign getprefix="get">
        <#if field.propertyType == "Boolean">
            <#assign getprefix="is">
        </#if>
        public ${field.propertyType} ${getprefix}${field.capitalName!}() {
        return ${field.propertyName};
        }

        public void set${field.capitalName!}(${field.propertyType} ${field.propertyName}) {
        this.${field.propertyName} = ${field.propertyName};
        }
    </#list>
<#-- 附加字段get  set 方法 结束 -->

    /* end ExtendProperty:${table.entityName!} */
</#if>


/* @begin getAndSet #自定义get、set */
/* @end getAndSet */

    @Override
    public String toString() {
    return "${table.enName}{" +
    <#list table.fields! as field>
        <#if !field.extend>
            <#if field_index == 0>
                "${field.propertyName}=" + ${field.propertyName} +
            <#else>
                ", ${field.propertyName}=" + ${field.propertyName} +
            </#if>
        </#if>
    </#list>
    <#if table.extendObj?? && table.extendObj.extendFields?has_content>
        <#assign nl = "\n">
        ${nl}/* begin ExtendToString:${table.entityName!} #扩展字段方法 */${nl}
        <#list table.extendObj.extendFields! as field>
            <#if field.extend>
                ", ${field.propertyName}=" + ${field.propertyName} + ${nl}
            </#if>
        </#list>
        ${nl}/* end ExtendToString:${table.entityName!} */ ${nl}
    </#if>
    "}";
    }

<#list table.sourcePackageInfos! as item>
    <#if "object" == item.dataType>
        public ${item.objectName} gain${item.objectName}() {
            ${item.objectName} ${item.objectEnName} = new ${item.objectName}();
            <#list item.sourceUseItems! as ite>
                ${item.objectEnName}.set${ite.sourceAttrCapitalName}(this.${ite.currAttr});
            </#list>
            return ${item.objectEnName};
        }
    <#elseif "array" == item.dataType>
        public List<${item.objectName}> gain${item.quoteAttr?cap_first}Array() {
            return get${item.quoteAttrCapitalName}();
        }
    </#if>
</#list>

}
