/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.render;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.PrefixUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.OscarCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.AspectGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.EntityGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.MapperGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ServiceImplGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarRender;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarQueryDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.render.OscarMsRender;
import com.jxdinfo.hussar.formdesign.oscar.function.visitor.task.basetask.util.OscarTaskBaseUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataSourceUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARTASKRENDER")
public class OscarTaskRender
implements OscarRender<OscarTaskDataModel, OscarTaskDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsRender.class);
    public static final String RENDER = "OSCARTASKRENDER";

    @Override
    public List<OscarCodeGenerateInfo> renderCode(OscarBackCtx<OscarTaskDataModel, OscarTaskDataModelDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        Map<String, OscarQueryDTO> queryDtoMap;
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<OscarCodeGenerateInfo> oscarCodeGenerateInfos = new ArrayList<OscarCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        OscarTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        boolean extension = backCtx.getUseDataModelBase().isExtension();
        useDataModelDTO.setExtension(extension);
        Map<String, OscarDataModelBase> dataModelBaseMap = useDataModelDTO.getDataModelBaseMap();
        Map<String, OscarDataModelBaseDTO> dataModelDtoMap = useDataModelDTO.getDataModelDtoMap();
        if (ToolUtil.isNotEmpty(dataModelBaseMap)) {
            for (String string : dataModelBaseMap.keySet()) {
                List<OscarCodeGenerateInfo> childGenerators;
                OscarBackCtx oscarBackCtx = new OscarBackCtx();
                OscarDataModelBase oscarDataModelBase = dataModelBaseMap.get(string);
                OscarDataModelBaseDTO oscarDataModelBaseDTO = dataModelDtoMap.get(string);
                HashMap<String, OscarDataModelBaseDTO> map = new HashMap<String, OscarDataModelBaseDTO>();
                map.put(string, oscarDataModelBaseDTO);
                oscarBackCtx.setRenderPoint(true);
                oscarBackCtx.setBaseFile(baseFile);
                oscarBackCtx.setUseDataModelBase(oscarDataModelBase);
                oscarBackCtx.setUseDataModelDtoMap(map);
                oscarBackCtx.setModelFunctionTye(oscarDataModelBase.getFunctionType());
                if (HussarUtils.equals((Object)string, (Object)modelId)) {
                    OscarTaskBaseUtil.transferControllerCode(oscarDataModelBaseDTO, useDataModelDTO);
                }
                if (!ToolUtil.isNotEmpty(childGenerators = OscarModelBeanUtil.getFunctionModelVisitorBean(oscarBackCtx.getUseDataModelBase().getFunctionType()).render().renderCode(oscarBackCtx))) continue;
                for (OscarCodeGenerateInfo childGenerator : childGenerators) {
                    if ("controller".equals(childGenerator.getFileType()) || "js".equals(childGenerator.getFileType())) continue;
                    oscarCodeGenerateInfos.add(childGenerator);
                }
            }
        }
        oscarCodeGenerateInfos.add(this.genEntityCode(useDataModelDTO));
        oscarCodeGenerateInfos.add(this.genVoCode(useDataModelDTO));
        oscarCodeGenerateInfos.add(this.genControllerCode(useDataModelDTO));
        oscarCodeGenerateInfos.add(this.genServiceCode(useDataModelDTO));
        oscarCodeGenerateInfos.add(this.genServiceImplCode(useDataModelDTO));
        oscarCodeGenerateInfos.add(this.genMapperCode(useDataModelDTO));
        oscarCodeGenerateInfos.add(this.genXmlCode(useDataModelDTO));
        oscarCodeGenerateInfos.add(this.genApiCode(useDataModelDTO, baseFile));
        if (AppContextUtil.isHTSZMode() && !AppContextUtil.isExtension() && !backCtx.isRenderPoint()) {
            oscarCodeGenerateInfos.add(OscarRenderUtil.genHookServiceImplCode(useDataModelDTO));
            backCtx.setRenderPoint(true);
        }
        if (ToolUtil.isNotEmpty(queryDtoMap = useDataModelDTO.getQueryDtoMap())) {
            for (Map.Entry<String, OscarQueryDTO> entry : queryDtoMap.entrySet()) {
                OscarQueryDTO queryDTO = entry.getValue();
                OscarCodeGenerateInfo queryCodeGenerateInfo = this.dynamicModelCode(queryDTO, useDataModelDTO);
                if (null == queryCodeGenerateInfo) continue;
                oscarCodeGenerateInfos.add(queryCodeGenerateInfo);
            }
        }
        if (ToolUtil.isNotEmpty(useDataModelDTO.getCustomCodeGenerateInfo()) && ToolUtil.isNotEmpty((Object)((Object)useDataModelDTO.getCustomCodeGenerateInfo().get(modelId)))) {
            oscarCodeGenerateInfos.add(useDataModelDTO.getCustomCodeGenerateInfo().get(modelId));
        }
        Map<String, AspectGenerateInfo> map = useDataModelDTO.getAspectGenerateInfoMap();
        if (ToolUtil.isNotEmpty(useDataModelDTO.getAnnotationNames()) && ToolUtil.isNotEmpty(map)) {
            for (String annotationName : useDataModelDTO.getAnnotationNames()) {
                oscarCodeGenerateInfos.add(this.genAnnotationCode(useDataModelDTO, annotationName));
                AspectGenerateInfo aspectGenerateInfo = Optional.ofNullable(map.get(map.keySet().stream().filter(key -> HussarUtils.equals((Object)key, (Object)annotationName)).findFirst().orElse(""))).orElseGet(AspectGenerateInfo::new);
                oscarCodeGenerateInfos.add(this.genAspectCode(useDataModelDTO, annotationName, aspectGenerateInfo));
            }
        }
        return oscarCodeGenerateInfos;
    }

    private OscarCodeGenerateInfo genEntityCode(OscarTaskDataModelDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "model" + File.separator + dataModelBaseDTO.getEntityName() + ".java";
        String filePath = "template/oscar/taskbackcode/code/entity.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getEntityName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getEntityGenerateInfo())) {
            EntityGenerateInfo entityGenerateInfo = new EntityGenerateInfo();
            entityGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setEntityGenerateInfo(entityGenerateInfo);
        } else {
            dataModelBaseDTO.getEntityGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            Set imports = Optional.ofNullable(dataModelBaseDTO.getEntityGenerateInfo().getImports()).orElseGet(HashSet::new);
            imports.add("com.baomidou.mybatisplus.annotation.TableField");
            dataModelBaseDTO.getEntityGenerateInfo().setImports(imports);
        }
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("entity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getEntityName() + ".java");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genVoCode(OscarTaskDataModelDTO dto) throws LcdpException {
        String modulePath = dto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "VO".toLowerCase() + File.separator + dto.getVoName() + ".java";
        String filePath = "template/oscar/taskbackcode/code/vo.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dto.getVoName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dto.getVoGeneratorInfo())) {
            VoGeneratorInfo info = new VoGeneratorInfo();
            info.setQualifyBeanName(qualifyBeanName);
            dto.setVoGeneratorInfo(info);
        } else {
            dto.getVoGeneratorInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("vo");
        codeGenerateInfo.setFileId(dto.getId());
        codeGenerateInfo.setFileName(dto.getVoName() + ".java");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genControllerCode(OscarTaskDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Controller".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Controller" + ".java";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getControllerName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getControllerGenerateInfo())) {
            ControllerGenerateInfo controllerGenerateInfo = new ControllerGenerateInfo();
            controllerGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setControllerGenerateInfo(controllerGenerateInfo);
        } else {
            dataModelDto.getControllerGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getControllerGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(dataModelDto.getImportInfo().get("Entity"));
        imports.add(dataModelDto.getImportInfo().get("Service"));
        dataModelDto.getControllerGenerateInfo().setImports(imports);
        String filePath = "template/oscar/taskbackcode/code/controller.ftl";
        dataModelDto.setExtensionApp(AppContextUtil.isExtension());
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(PrefixUtil.replacePrefix((String)newCode));
        codeGenerateInfo.setFileType("controller");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getControllerName() + ".java");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genServiceCode(OscarTaskDataModelDTO dataModelDto) throws LcdpException, IOException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Service" + ".java";
        String filePath = "template/oscar/taskbackcode/code/service.ftl";
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("service");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Service" + ".java");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genServiceImplCode(OscarTaskDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + "impl" + File.separator + dataModelDto.getEntityName() + "ServiceImpl" + ".java";
        String filePath = "template/oscar/taskbackcode/code/service_impl.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getServiceImplGenerateInfo())) {
            ServiceImplGenerateInfo serviceImplGenerateInfo = new ServiceImplGenerateInfo();
            serviceImplGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setServiceImplGenerateInfo(serviceImplGenerateInfo);
        } else {
            dataModelDto.getServiceImplGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getServiceImplGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(OscarDataSourceUtil.getDataSourceServiceImpl(dataModelDto.getDataSourceName()));
        imports.add("java.util.List");
        imports.add("java.util.Map");
        imports.add("com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
        imports.add("com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        dataModelDto.getServiceImplGenerateInfo().setImports(imports);
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("serviceImpl");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "ServiceImpl" + ".java");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genMapperCode(OscarTaskDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".java";
        String filePath = "template/oscar/taskbackcode/code/mapper.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getMapperName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getMapperGenerateInfo())) {
            MapperGenerateInfo mapperGenerateInfo = new MapperGenerateInfo();
            mapperGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setMapperGenerateInfo(mapperGenerateInfo);
        } else {
            dataModelDto.getMapperGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("mapper");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".java");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genXmlCode(OscarTaskDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + "mapping" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".xml";
        String filePath = "template/oscar/masterslavebackcode/code/xml.ftl";
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("xml");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".xml");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genAnnotationCode(OscarTaskDataModelDTO dataModelDto, String annotationName) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "annotation" + File.separator + annotationName + ".java";
        String filePath = "template/oscar/taskbackcode/code/annotation.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("annotation");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(annotationName);
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genApiCode(OscarTaskDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/oscar/preview/api/api-${pageType}-file.ftl".replace("${pageType}", ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage");
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genAspectCode(OscarTaskDataModelDTO dataModelDto, String annotationName, AspectGenerateInfo aspectGenerateInfo) throws LcdpException {
        String aspectName = annotationName + NamingStrategy.capitalFirst((String)"aspect");
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "aspect" + File.separator + aspectName + ".java";
        String filePath = "/template/oscar/taskbackcode/code/aspect.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("aspectName", aspectName);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        params.put("aspect", aspectGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("aspect");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(aspectName);
        return codeGenerateInfo;
    }

    public static String renderTemplate(String templatePath, ApiGenerateInfo apiGenerateInfo) throws LcdpException {
        HashMap<String, ApiGenerateInfo> params = new HashMap<String, ApiGenerateInfo>();
        params.put("api", apiGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(templatePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }

    private OscarCodeGenerateInfo dynamicModelCode(OscarQueryDTO queryDTO, OscarDataModelBaseDTO dataModelDto) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryDTO)) {
            String writePath = queryDTO.getWriteFilePath();
            String filePath = queryDTO.getFtlPath();
            String newCode = RenderUtil.renderTemplate((String)filePath, queryDTO.getParams());
            OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(queryDTO.getEntityName());
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private OscarCodeGenerateInfo genQueryVoCode(OscarQueryDTO queryVODto, OscarTaskDataModelDTO dataModelDto, String modulePath, OscarMsDataModel oscarMsDataModel) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryVODto)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("queryDto", queryVODto);
            params.put("model", dataModelDto);
            params.put("modelArrayWithPage", oscarMsDataModel.getOperations().get(0).getReturnValue());
            String writePath = modulePath + File.separator + "qo" + File.separator + this.upperCase(oscarMsDataModel.getOperations().get(0).getReturnValue()) + ".java";
            String filePath = "template/oscar/taskbackcode/code/queryVo.ftl";
            String newCode = RenderUtil.renderTemplate((String)filePath, params);
            OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(this.upperCase(oscarMsDataModel.getOperations().get(0).getReturnValue()));
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private String upperCase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }
}

