/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.task.masterslavetask;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarQueryDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.visitor.constant.OscarConstUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.visitor.masterslave.util.OscarMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARTASK_MASTER_SLAVEFormSave")
public class OscarMsTaskFormSaveVisitor
implements OscarOperationVisitor<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsTaskFormSaveVisitor.class);
    public static final String OPERATION_NAME = "OSCARTASK_MASTER_SLAVEFormSave";

    @Override
    public void visit(OscarBackCtx<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> taskBackCtx, OscarDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        OscarFlowMsDataModelDTO oscarFlowMsDataModelDTO = (OscarFlowMsDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        OscarFlowMsDataModel dataModelBase = (OscarFlowMsDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx = new OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO>();
        backCtx.setUseDataModelBase(dataModelBase);
        HashMap<String, OscarFlowMsDataModelDTO> map = new HashMap<String, OscarFlowMsDataModelDTO>();
        map.put(modelId, oscarFlowMsDataModelDTO);
        backCtx.setUseDataModelDtoMap(map);
        OscarMsDataModelDTO oscarMsDataModelDTO = (OscarMsDataModelDTO)backCtx.getUseDataModelDtoMap().get(modelId);
        String url = oscarMsDataModelDTO.getApiPrefix(new String[0]) + "/" + operation.getName();
        Map<String, Object> controllerParams = operation.getParams();
        OscarDataModelFieldDto keyField = oscarMsDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map slaveTablePlusSave = (Map)operation.getParams().get("slaveTablePlusSave");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        for (OscarDataModelBase oscarDataModelBase : dataModelBase.getSlaveTables()) {
            OscarDataModelBaseDTO oscarDataModelBaseDTO = oscarMsDataModelDTO.getDataModelDtoMap().get(oscarDataModelBase.getId());
            String slaveModelName = oscarDataModelBase.getName();
            for (OscarDataModelFieldDto oscarDataModelFieldDto : oscarDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(oscarDataModelFieldDto.getFill())) continue;
                relationTagKeys.put(slaveModelName, oscarDataModelFieldDto.getCapitalName());
            }
        }
        if (HussarUtils.isNotEmpty(relationTagKeys)) {
            controllerParams.put("relationTagKeys", relationTagKeys);
        }
        boolean plusFlag = false;
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                plusFlag = true;
                break;
            }
        }
        if (plusFlag) {
            for (OscarRelationshipDTO relationshipDTO : oscarMsDataModelDTO.getRelationshipDtoList()) {
                if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
                slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
            }
            for (OscarDataModelBase modelBase : dataModelBase.getSlaveTables()) {
                isLogicallyDelete.put(modelBase.getId(), ((OscarBaseDataModel)modelBase).getLogicallyDelete());
                OscarDataModelBaseDTO oscarDataModelBaseDTO = oscarMsDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
                String slaveModelName = modelBase.getName();
                capitalNameList.put(slaveModelName, OscarMasterSlaveUtil.getCapitalName(slaveModelName));
                for (OscarDataModelField oscarDataModelField : modelBase.getFields()) {
                    if (!"delDefFlag".equals(oscarDataModelField.getUsage())) continue;
                    logicallyDelField.put(slaveModelName, oscarDataModelField.getName());
                }
                for (OscarDataModelFieldDto oscarDataModelFieldDto : oscarDataModelBaseDTO.getFields()) {
                    if ("primary".equals(oscarDataModelFieldDto.getFill())) {
                        primaryKeys.put(slaveModelName, oscarDataModelFieldDto.getCapitalName());
                    }
                    if (!"foreign".equals(oscarDataModelFieldDto.getFill())) continue;
                    foreignKeys.put(slaveModelName, oscarDataModelFieldDto.getCapitalName());
                }
            }
            OscarMsTaskFormSaveVisitor.addFormPlusSaveDto(dataModelBase, oscarMsDataModelDTO, backCtx, slaveTablePlusSave);
        }
        controllerParams.put("table", oscarMsDataModelDTO);
        controllerParams.put("returnValue", oscarMsDataModelDTO.getEntityName());
        if (plusFlag) {
            controllerParams.put("returnValue", oscarMsDataModelDTO.getEntityName() + "IncrementDTO");
        }
        controllerParams.put("url", url);
        OscarDataModelBaseDTO oscarDataModelBaseDTO = oscarMsDataModelDTO.getDataModelDtoMap().get(dataModelBase.getMasterTable().getId());
        controllerParams.put("masterTable", oscarDataModelBaseDTO);
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(oscarMsDataModelDTO.getComment() + "\u65b0\u589e\u6216\u4fee\u6539");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        controllerParams.put("expansionModelId", oscarFlowMsDataModelDTO.getControllerGenerateInfo().getExpansionModelId());
        String controllerPath = "template/oscar/taskbackcode/masterslavetaskbackcode/formsave/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, oscarMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, oscarMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerInversion(modelId, oscarMsDataModelDTO.getServiceName());
        String servicePath = "template/oscar/taskbackcode/masterslavetaskbackcode/formsave/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        this.masterSlaveCode(backCtx, controllerParams);
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        if (plusFlag) {
            controllerParams.put("primaryKeys", primaryKeys);
            controllerParams.put("foreignKeys", foreignKeys);
            controllerParams.put("slaveTable", OscarMasterSlaveUtil.ofSlaveParam(dataModelBase, oscarMsDataModelDTO));
            controllerParams.put("isPlusSave", true);
            controllerParams.put("isLogicallyDelete", isLogicallyDelete);
            controllerParams.put("logicallyDelField", logicallyDelField);
            controllerParams.put("capitalNameList", capitalNameList);
        }
        String serviceImplPath = "template/oscar/taskbackcode/masterslavetaskbackcode/formsave/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.dto.Increment");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        if (AppContextUtil.isHTSZMode()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.formDesign.extension.method.ExtensionAnchorpointService");
            backCtx.addServiceImplResourceInversion(modelId, backCtx.getResourceInversion(oscarFlowMsDataModelDTO, DataModelUtil.getDataModelBase((String)modelId).getName(), true));
        }
        OscarMsDataModelDTO oscarMsDataModelDTO2 = new OscarMsDataModelDTO();
        backCtx.addServiceImplResourceInversion(modelId, backCtx.getResourceInversion(oscarMsDataModelDTO, DataModelUtil.getDataModelBase((String)modelId).getName(), true));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", url, "\u65b0\u589e\u6216\u4fee\u6539");
        backCtx.addApi(modelId, OscarBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void masterSlaveCode(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        OscarMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        OscarMsDataModelDTO oscarMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<OscarRelationshipDTO> relationshipDtoList = oscarMsDataModelDTO.getRelationshipDtoList();
        OscarDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, OscarDataModelBaseDTO> dataModelDtoMap = oscarMsDataModelDTO.getDataModelDtoMap();
        OscarDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(backCtx, mainDataModelDto, oscarMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (OscarRelationshipDTO oscarRelationshipDTO : relationshipDtoList) {
                List<OscarRelationshipFieldDTO> oscarRelationshipFieldDTOS;
                String slaveTableId = oscarRelationshipDTO.getSlaveTableId();
                String relateModelType = oscarRelationshipDTO.getRelateModelType();
                OscarDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(backCtx, slaveModelDto, oscarMsDataModelDTO, false, mainDataModelDto);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                controllerParams.put("slaveFillCodeList", slaveFillCodeList);
                if (slaveFillCode != null) {
                    oscarRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(oscarRelationshipFieldDTOS = oscarRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    public static void addFormPlusSaveDto(OscarMsDataModel dataModelBase, OscarMsDataModelDTO dataModelDTO, OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, Map<String, Boolean> slaveTablePlusSave) {
        OscarQueryDTO queryDTO = new OscarQueryDTO();
        String modelId = dataModelBase.getId();
        String masterId = dataModelBase.getMasterTable().getId();
        queryDTO.setFtlPath("template/oscar/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", dataModelDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", OscarMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("queryDto", queryDTO);
        params.put("table", dataModelDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelDTO.getName() + "IncrementDTO");
        queryDTO.setEntityName(dataModelDTO.getEntityName() + "IncrementDTO");
        queryDTO.setPackageInfo(dataModelDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importDTOPath = dataModelDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        dataModelDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }

    private String renderFillCode(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, OscarDataModelBaseDTO dataModelBaseDTO, OscarMsDataModelDTO msDataModelDTO, boolean isMs, OscarDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (OscarDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", OscarConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", OscarConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", OscarConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/oscar/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }
}

