/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.task.basetask;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarResourceInversion;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARTASKFormSave")
public class OscarTaskFormSaveVisitor
implements OscarOperationVisitor<OscarTaskDataModel, OscarTaskDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarTaskFormSaveVisitor.class);
    public static final String OPERATION_NAME = "OSCARTASKFormSave";

    @Override
    public void visit(OscarBackCtx<OscarTaskDataModel, OscarTaskDataModelDTO> taskBackCtx, OscarDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        OscarFlowDataModelDTO dataModelBaseDTO = (OscarFlowDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        OscarFlowDataModel useDataModelBase = (OscarFlowDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        OscarBackCtx<OscarFlowDataModel, OscarFlowDataModelDTO> backCtx = new OscarBackCtx<OscarFlowDataModel, OscarFlowDataModelDTO>();
        backCtx.setUseDataModelBase(useDataModelBase);
        HashMap<String, OscarFlowDataModelDTO> map = new HashMap<String, OscarFlowDataModelDTO>();
        map.put(modelId, dataModelBaseDTO);
        backCtx.setUseDataModelDtoMap(map);
        OscarDataModelFieldDto keyField = dataModelBaseDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        controllerParams.put("primaryField", keyField.getCapitalName());
        this.renderFillCode(backCtx, dataModelBaseDTO, controllerParams);
        String controllerPath = "template/oscar/taskbackcode/basetaskbackcode/formsave/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/oscar/taskbackcode/basetaskbackcode/formsave/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/oscar/taskbackcode/basetaskbackcode/formsave/service_impl.ftl";
        String resourceName = AppContextUtil.getServicePrefix() + dataModelBaseDTO.getModuleName() + "." + taskBackCtx.getUseDataModelDtoMap().get(modelId).getName();
        backCtx.addServiceImplResourceInversion(modelId, new OscarResourceInversion("ExtensionAnchorpointService", resourceName, ""));
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName(), "\u65b0\u589e\u6216\u4fee\u6539");
        backCtx.addApi(modelId, OscarBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderFillCode(OscarBackCtx<OscarFlowDataModel, OscarFlowDataModelDTO> backCtx, OscarBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) throws LcdpException {
        boolean insertFill = false;
        boolean updateFill = false;
        for (OscarDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    controllerParams.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)dataModelBaseDTO.getId()), dataModelBaseDTO.getComment(), dataModelBaseDTO.getSourceDataModelName(), field.getName(), controllerParams, false, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        dataModelBaseDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    controllerParams.put("insertFill", true);
                    break;
                }
                case "updateUser": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        dataModelBaseDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    controllerParams.put("insertFill", true);
                    updateFill = true;
                    controllerParams.put("updateFill", true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return;
        }
        String fillPath = "template/oscar/taskbackcode/basetaskbackcode/addorupdate/fill.ftl";
        String fillCode = RenderUtil.renderTemplate((String)fillPath, controllerParams);
        controllerParams.put("fillCode", fillCode);
    }

    private void renderImport(OscarBackCtx<OscarFlowDataModel, OscarFlowDataModelDTO> backCtx, String modelId, OscarBaseDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.formDesign.extension.method.ExtensionAnchorpointService");
    }

    private Map<String, Object> initParams(OscarDataModelOperation dataModelOperation, OscarBaseDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u65b0\u589e\u6216\u4fee\u6539");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }
}

