/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.flow.masterslaveflow;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARFLOW_MASTER_SLAVESerialNumber")
public class OscarMsFlowSerialNumberVisitor
implements OscarOperationVisitor<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsFlowSerialNumberVisitor.class);
    public static final String OPERATION_NAME = "OSCARFLOW_MASTER_SLAVESerialNumber";

    @Override
    public void visit(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> flowBackCtx, OscarDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = flowBackCtx.getUseDataModelBase().getId();
        OscarFlowMsDataModelDTO oscarFlowMsDataModelDTO = flowBackCtx.getUseDataModelDtoMap().get(modelId);
        OscarFlowMsDataModel dataModelBase = flowBackCtx.getUseDataModelBase();
        OscarBackCtx backCtx = new OscarBackCtx();
        backCtx.setUseDataModelBase(dataModelBase);
        HashMap<String, OscarFlowMsDataModelDTO> map = new HashMap<String, OscarFlowMsDataModelDTO>();
        map.put(modelId, oscarFlowMsDataModelDTO);
        backCtx.setUseDataModelDtoMap(map);
        Map<String, OscarDataModelBaseDTO> dataModelDtoMap = oscarFlowMsDataModelDTO.getDataModelDtoMap();
        OscarDataModelBase masterTable = dataModelBase.getMasterTable();
        OscarDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterTable.getId());
        Optional<OscarDataModelFieldDto> serialFieldOpt = mainDataModelDto.getFields().stream().filter(m -> HussarUtils.equals((Object)"serialNumber", (Object)m.getFill())).findFirst();
        if (!serialFieldOpt.isPresent()) {
            return;
        }
        if (HussarUtils.isEmpty(operation.getParams())) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", mainDataModelDto);
        params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        OscarDataModelFieldDto field = serialFieldOpt.get();
        params.put("field", field);
        params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
        params.put("parameter", oscarFlowMsDataModelDTO.getQueryDtoMap().get(oscarFlowMsDataModelDTO.getName()).getEntityName());
        params.put("returnValue", mainDataModelDto.getEntityName());
        oscarFlowMsDataModelDTO.addServiceImplImport(mainDataModelDto.getImportInfo().get("Entity"));
        oscarFlowMsDataModelDTO.addServiceImport(mainDataModelDto.getImportInfo().get("Entity"));
        oscarFlowMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
        oscarFlowMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
        oscarFlowMsDataModelDTO.addServiceImplImport("java.util.HashMap");
        oscarFlowMsDataModelDTO.addServiceImplImport("java.util.Map");
        oscarFlowMsDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSONObject");
        oscarFlowMsDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSON");
        oscarFlowMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        oscarFlowMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        oscarFlowMsDataModelDTO.addServiceImplImport("org.apache.commons.beanutils.BeanUtils");
        oscarFlowMsDataModelDTO.addServiceImplImport("java.lang.reflect.InvocationTargetException");
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        backCtx.addServiceImplInversion(((OscarFlowMsDataModel)backCtx.getUseDataModelBase()).getId(), "ISysCodeRuleService");
        String implPath = "template/oscar/flowbackcode/masterslaveflowbackcode/serialNumber/serialNumberServiceImpl.ftl";
        String servicePath = "template/oscar/flowbackcode/masterslaveflowbackcode/serialNumber/serialNumberService.ftl";
        SerialNumberUtil.saveCodeRule(JSONObject.parseObject((String)JSON.toJSONString((Object)masterTable)), masterTable.getComment(), masterTable.getSourceDataModelName(), field.getName(), params, false, field.getId());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, params));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

