/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.element.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.CheckTable;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.IndexCorrespond;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarEnclosure;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarRender;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseConnector;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarEditDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.index.OscarDataModelIndex;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.querycondition.OscarQueryCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.querycondition.OscarQueryObject;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortConditionField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslate;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OscarBaseDataModel
extends OscarDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(OscarBaseDataModel.class);
    public static final String FUNCTION_TYPE = "BASE";
    public static final int OK = 1;
    public static final int ERROR = -1;
    public static final int UN = 0;
    private List<OscarTranslate> translate;
    private String sourceDataModelName;
    private List<OscarQueryCondition> queryConditions;
    private List<OscarQueryObject> queryObject;
    private List<OscarSortCondition> sortCondition;
    private List<OscarDataModelField> addFields;
    private List<OscarDataModelField> delFields;
    private List<OscarEditDataModelField> editFields;
    private boolean logicallyDelete;
    private OscarBaseDataModel taskModel;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"OSCAR.BASE", OscarBaseDataModel.class);
    }

    @Override
    public OscarBaseDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        OscarBaseDataModel oscarBaseDataModel;
        try {
            oscarBaseDataModel = (OscarBaseDataModel)JSONObject.parseObject((String)jsonObject.toString(), OscarBaseDataModel.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return oscarBaseDataModel;
    }

    @Override
    public OscarEnclosure<OscarDataModelBase> enclosure() throws LcdpException {
        return OscarModelBeanUtil.getEnclosureBean("OSCAR", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public OscarRender<OscarDataModelBase, OscarDataModelBaseDTO> render() throws LcdpException {
        return OscarModelBeanUtil.getRenderBean("OSCAR", FUNCTION_TYPE, "RENDER");
    }

    @Override
    public List<OscarTranslate> getTranslate() {
        return this.translate;
    }

    @Override
    public void setTranslate(List<OscarTranslate> translate) {
        this.translate = translate;
    }

    public OscarBaseDataModel getTaskModel() {
        return this.taskModel;
    }

    public void setTaskModel(OscarBaseDataModel taskModel) {
        this.taskModel = taskModel;
    }

    @Override
    public String getSourceDataModelName() {
        return this.sourceDataModelName;
    }

    public void setSourceDataModelName(String sourceDataModelName) {
        this.sourceDataModelName = sourceDataModelName;
    }

    public List<OscarQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<OscarQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<OscarQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<OscarQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<OscarSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (OscarSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (OscarSortConditionField field : condition.getFields()) {
                    try {
                        Map<String, String> fieldMap = OscarDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)field.getFromModelIdSort())).getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName));
                        String fieldName = fieldMap.get(field.getFromModelFieldIdSort());
                        if (HussarUtils.equals((Object)fieldName, (Object)field.getFromModelFieldSort())) continue;
                        field.setFromModelFieldSort(fieldName);
                    }
                    catch (LcdpException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<OscarSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    public List<OscarDataModelField> getAddFields() {
        return this.addFields;
    }

    public void setAddFields(List<OscarDataModelField> addFields) {
        this.addFields = addFields;
    }

    public List<OscarDataModelField> getDelFields() {
        return this.delFields;
    }

    public void setDelFields(List<OscarDataModelField> delFields) {
        this.delFields = delFields;
    }

    public List<OscarEditDataModelField> getEditFields() {
        return this.editFields;
    }

    public void setEditFields(List<OscarEditDataModelField> editFields) {
        this.editFields = editFields;
    }

    public boolean getLogicallyDelete() {
        return this.logicallyDelete;
    }

    @Override
    public void setLogicallyDelete(boolean logicallyDelete) {
        this.logicallyDelete = logicallyDelete;
    }

    @Override
    public OscarQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (OscarQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return new OscarQueryCondition();
    }

    @Override
    public OscarSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (OscarSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return new OscarSortCondition();
    }

    public Optional<TableInfo> findTable(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional infoOptional;
        TableInfo table = null;
        boolean findCurrentTable = false;
        List tableCorresponds = fieldsContrastParam.getTableCorresponds();
        if (tableCorresponds != null) {
            for (TableCorrespond tableCorrespond : tableCorresponds) {
                if (!this.getId().equals(tableCorrespond.getModelId())) continue;
                String changeName = tableCorrespond.getTableName().toUpperCase();
                Optional infoOptional2 = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)changeName);
                findCurrentTable = infoOptional2.isPresent();
                if (!findCurrentTable) break;
                table = (TableInfo)infoOptional2.get();
                break;
            }
        }
        if (!findCurrentTable && (findCurrentTable = (infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase())).isPresent())) {
            table = (TableInfo)infoOptional.get();
        }
        return Optional.ofNullable(table);
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> tableContrastModel(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable(fieldsContrastParam);
        ContrastVO<OscarDataModelField> contrast = new ContrastVO<OscarDataModelField>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = OscarDataModelUtil.contrastWith(table.getFields(), this.getFields(), this.extFields(fieldsContrastParam));
            contrast.setTableFields(OscarDataModelUtil.tabTransmodel(table.getFields()));
        }
        contrast.setModelId(this.getId());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        ArrayList<ContrastVO<OscarDataModelField>> contrastVOS = new ArrayList<ContrastVO<OscarDataModelField>>();
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> tableContrastModelIn(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        ArrayList<ContrastVO<OscarDataModelField>> tableContrast = new ArrayList<ContrastVO<OscarDataModelField>>();
        List tableInfos = DataModelUtil.filterInTables((String)this.getDataSourceName(), (String)"BASE TABLE", this.getTableNames(fieldsContrastParam));
        TableInfo masterTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> this.getTableName(fieldsContrastParam).equals(table.getName())).findFirst().orElse(null) : null;
        tableContrast.add(this.tableContrastModel(masterTableInfo, fieldsContrastParam));
        if (HussarUtils.isNotEmpty((Object)this.taskModel)) {
            TableInfo taskModelInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> this.taskModel.getTableName(fieldsContrastParam).equals(table.getName())).findFirst().orElse(null) : null;
            tableContrast.add(this.taskModel.tableContrastModel(taskModelInfo, fieldsContrastParam));
        }
        return tableContrast;
    }

    @Override
    public ContrastVO<OscarDataModelField> tableContrastModel(TableInfo table, FieldsContrastParam<OscarDataModelField> fieldsContrastParam) {
        ContrastVO<OscarDataModelField> contrast = new ContrastVO<OscarDataModelField>();
        if (HussarUtils.isNotEmpty((Object)table)) {
            contrast = OscarDataModelUtil.contrastWith(table.getFields(), this.getFields(), this.extFields(fieldsContrastParam));
            contrast.setTableFields(OscarDataModelUtil.tabTransmodel(table.getFields()));
        }
        contrast.setModelId(this.getId());
        contrast.setTableContrast(Integer.valueOf(HussarUtils.isNotEmpty((Object)table) ? 0 : 1));
        return contrast;
    }

    private List<OscarDataModelField> extFields(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) {
        List extFieldJsons;
        List<OscarDataModelField> extFields = new ArrayList<OscarDataModelField>();
        if (HussarUtils.isNotEmpty((Object)fieldsContrastParam.getExtFields()) && HussarUtils.isNotEmpty((Object)(extFieldJsons = (List)fieldsContrastParam.getExtFields().get(this.getId())))) {
            extFields = JSONArray.parseArray((String)JSON.toJSONString((Object)extFieldJsons), OscarDataModelField.class);
        }
        return extFields;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> modelContrastTable(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable(fieldsContrastParam);
        ContrastVO<OscarDataModelField> contrast = new ContrastVO<OscarDataModelField>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = OscarDataModelUtil.mcontrastWith(table.getFields(), this.getFields(), this.extFields(fieldsContrastParam));
            contrast.setTableFields(OscarDataModelUtil.tabTransmodel(table.getFields()));
        }
        contrast.setModelId(this.getId());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        ArrayList<ContrastVO<OscarDataModelField>> contrastVOS = new ArrayList<ContrastVO<OscarDataModelField>>();
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    public List<String> getTableNames(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws LcdpException {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.getTableName(fieldsContrastParam));
        if (HussarUtils.isNotEmpty((Object)this.taskModel)) {
            tableNames.add(this.taskModel.getTableName(fieldsContrastParam));
        }
        return tableNames;
    }

    @Override
    public ContrastVO<OscarDataModelField> modelContrastTable(TableInfo table, FieldsContrastParam<OscarDataModelField> fieldsContrastParam) {
        ContrastVO<OscarDataModelField> contrast = new ContrastVO<OscarDataModelField>();
        if (HussarUtils.isNotEmpty((Object)table)) {
            contrast = OscarDataModelUtil.mcontrastWith(table.getFields(), this.getFields(), this.extFields(fieldsContrastParam));
            contrast.setTableFields(OscarDataModelUtil.tabTransmodel(table.getFields()));
        }
        contrast.setModelId(this.getId());
        contrast.setTableContrast(Integer.valueOf(HussarUtils.isNotEmpty((Object)table) ? 0 : 1));
        return contrast;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> modelContrastTableIn(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        ArrayList<ContrastVO<OscarDataModelField>> tableContrast = new ArrayList<ContrastVO<OscarDataModelField>>();
        List tableInfos = DataModelUtil.filterInTables((String)this.getDataSourceName(), (String)"BASE TABLE", this.getTableNames(fieldsContrastParam));
        TableInfo masterTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> this.getTableName(fieldsContrastParam).equals(table.getName())).findFirst().orElse(null) : null;
        tableContrast.add(this.modelContrastTable(masterTableInfo, fieldsContrastParam));
        if (HussarUtils.isNotEmpty((Object)this.taskModel)) {
            TableInfo taskModelInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> this.taskModel.getTableName(fieldsContrastParam).equals(table.getName())).findFirst().orElse(null) : null;
            tableContrast.add(this.taskModel.modelContrastTable(taskModelInfo, fieldsContrastParam));
        }
        return tableContrast;
    }

    @Override
    public String getTableName(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) {
        String tableName = "";
        boolean findCurrentTable = false;
        List tableCorresponds = fieldsContrastParam.getTableCorresponds();
        if (tableCorresponds != null) {
            for (TableCorrespond tableCorrespond : tableCorresponds) {
                if (!this.getId().equals(tableCorrespond.getModelId())) continue;
                tableName = tableCorrespond.getTableName().toUpperCase();
                break;
            }
        }
        if (!findCurrentTable) {
            tableName = this.sourceDataModelName.toUpperCase();
        }
        return tableName;
    }

    @Override
    public List<ContrastIndexVO> tableContrastModelIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable((FieldsContrastParam<OscarDataModelField>)fieldsContrastParam);
        ContrastIndexVO<OscarDataModelIndex> contrast = new ContrastIndexVO<OscarDataModelIndex>();
        TableCorrespond info = new TableCorrespond();
        if (HussarUtils.isNotEmpty((Object)fieldsContrastParam.getTableCorresponds())) {
            info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(0);
        }
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = OscarDataModelUtil.contrastIndexWith(table.getIndexs(), this.getIndexList(), info);
            contrast.setTableIndexs(OscarDataModelUtil.tabTransmodelIndex(table.getIndexs()));
        }
        contrast.setModelId(this.getId());
        ArrayList<ContrastIndexVO> contrastIndexVOS = new ArrayList<ContrastIndexVO>();
        contrastIndexVOS.add(contrast);
        return contrastIndexVOS;
    }

    @Override
    public List<ContrastIndexVO> modelContrastTableIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable((FieldsContrastParam<OscarDataModelField>)fieldsContrastParam);
        ContrastIndexVO<OscarDataModelIndex> contrast = new ContrastIndexVO<OscarDataModelIndex>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = OscarDataModelUtil.mcontrastIndexWith(table.getIndexs(), this.getIndexList());
            contrast.setTableIndexs(OscarDataModelUtil.tabTransmodelIndex(table.getIndexs()));
        }
        contrast.setModelId(this.getId());
        ArrayList<ContrastIndexVO> contrastIndexVOS = new ArrayList<ContrastIndexVO>();
        contrastIndexVOS.add(contrast);
        return contrastIndexVOS;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> findTableContrast() throws IOException, LcdpException {
        ArrayList<ContrastVO<OscarDataModelField>> contrastVOS = new ArrayList<ContrastVO<OscarDataModelField>>();
        ContrastVO contrast = new ContrastVO();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        contrast.setModelId(this.getId());
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId, Map<String, List<JSONObject>> extFields, List<JSONObject> extSlaveTables) throws IOException, LcdpException {
        PublishCheckVO contrastVOS = new PublishCheckVO();
        contrastVOS.setModelId(modelId);
        ArrayList<CheckTable> contrast = new ArrayList<CheckTable>();
        CheckTable info = new CheckTable();
        long start = System.currentTimeMillis();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase());
        if (!infoOptional.isPresent()) {
            info.setModelId(modelId);
            info.setState(Integer.valueOf(0));
            contrast.add(info);
            contrastVOS.setDetails(contrast);
            return contrastVOS;
        }
        TableInfo table = (TableInfo)infoOptional.get();
        LOGGER.info("\u53d1\u5e03\u65f6\u6821\u9a8c\u67e5\u8be2\u5355\u8868{}\u8017\u65f6\uff1a{}", (Object)this.sourceDataModelName.toUpperCase(), (Object)ToolUtil.logTime((long)start));
        if (ToolUtil.isNotEmpty((Object)table)) {
            ContrastVO<OscarDataModelField> model;
            List<JSONObject> extFieldJsons = extFields.get(this.getId());
            ArrayList<OscarDataModelField> fields = new ArrayList();
            if (HussarUtils.isNotEmpty(extFieldJsons)) {
                fields = JSONArray.parseArray((String)JSON.toJSONString(extFieldJsons), OscarDataModelField.class);
            }
            if (!(!HussarUtils.isEmpty((Object)(model = OscarDataModelUtil.pushContrastWith(table.getFields(), this.getFields(), fields)).getAddFields()) && model.getAddFields().size() != 0 || !HussarUtils.isEmpty((Object)model.getDelFields()) && model.getDelFields().size() != 0 || !HussarUtils.isEmpty((Object)model.getModifyFields()) && model.getModifyFields().size() != 0)) {
                info.setState(Integer.valueOf(2));
            } else {
                info.setState(Integer.valueOf(1));
            }
        } else {
            info.setState(Integer.valueOf(0));
        }
        info.setModelId(this.getId());
        contrast.add(info);
        contrastVOS.setDetails(contrast);
        return contrastVOS;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws Exception {
        int x;
        String dataSourceName = this.getDataSourceName();
        if (ToolUtil.isEmpty((Object)dataSourceName)) {
            return false;
        }
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasourceLr = sysDataSourceService.getByConnName(dataSourceName);
        TableCorrespond info = new TableCorrespond();
        IndexCorrespond indexInfo = new IndexCorrespond();
        boolean findTable = false;
        if (fieldsContrastParam.getTableCorresponds() != null) {
            for (x = 0; x < fieldsContrastParam.getTableCorresponds().size(); ++x) {
                if (!this.getId().equals(((TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x)).getModelId())) continue;
                info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x);
                findTable = true;
                break;
            }
        }
        if (fieldsContrastParam.getIndexCorresponds() != null) {
            for (x = 0; x < fieldsContrastParam.getIndexCorresponds().size(); ++x) {
                if (!this.getId().equals(((IndexCorrespond)fieldsContrastParam.getIndexCorresponds().get(x)).getModelId())) continue;
                indexInfo = (IndexCorrespond)fieldsContrastParam.getIndexCorresponds().get(x);
                findTable = true;
                break;
            }
        }
        if (!findTable) {
            return true;
        }
        boolean findCurrentTable = info.getTableName() != null && ToolUtil.isNotEmpty((Object)info.getTableName()) ? DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)info.getTableName()).isPresent() : DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase()).isPresent();
        if (!findCurrentTable) {
            this.creatTabs(datasourceLr);
        } else {
            this.editTabs(datasourceLr, (TableCorrespond<OscarDataModelField>)info, indexInfo);
        }
        return true;
    }

    public int creatTabs(SysDataSource datasourceLr) {
        MetadataParam metadataParam = new MetadataParam();
        TableInfoDto tableInfoDto = OscarBaseConnector.tableInfoInCreate(datasourceLr, this);
        metadataParam.setTableInfo(tableInfoDto);
        metadataParam.setColumnInfo(OscarBaseConnector.transferColumn(this.getFields(), ""));
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ddlService.createTable(metadataParam);
        return 1;
    }

    public int editTabs(SysDataSource datasourceLr, TableCorrespond<OscarDataModelField> info, IndexCorrespond indexInfo) throws Exception {
        MetadataParam paramData = new MetadataParam();
        TableInfoDto tableInfoDto = OscarBaseConnector.tableInfoInEdit(datasourceLr, this);
        paramData.setTableInfo(tableInfoDto);
        ArrayList<ColumnInfoDto> deletedCols = new ArrayList<ColumnInfoDto>();
        List delFields = JSONArray.parseArray((String)info.getDelFields(), OscarDataModelField.class);
        if (!HussarUtils.isEmpty((Object)delFields)) {
            for (int y = 0; y < delFields.size(); ++y) {
                ColumnInfoDto del = new ColumnInfoDto();
                del.setColumnName(((OscarDataModelField)((Object)delFields.get(y))).getSourceFieldName());
                deletedCols.add(del);
            }
        }
        paramData.setDeletedCols(deletedCols);
        List addFields = JSONArray.parseArray((String)info.getAddFields(), OscarDataModelField.class);
        List editFields = JSONArray.parseArray((String)info.getModifyFields(), OscarEditDataModelField.class);
        List<ColumnInfoDto> add = this.transformDto(addFields, "add");
        List<ColumnInfoDto> edit = this.transformEdit(editFields, "edit");
        ArrayList<ColumnInfoDto> column = new ArrayList<ColumnInfoDto>();
        column.addAll(add);
        column.addAll(edit);
        paramData.setColumnInfo(column);
        String oldTableName = !HussarUtils.isEmpty((Object)info.getOldTableName()) ? info.getOldTableName() : indexInfo.getOldTableName();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)oldTableName.toUpperCase());
        if (!infoOptional.isPresent()) {
            return 0;
        }
        TableInfo table = (TableInfo)infoOptional.get();
        List<ColumnInfoDto> oldColumn = this.transform(OscarDataModelUtil.tabTransmodel(table.getFields()));
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ddlService.editTable(paramData, oldColumn, info.getOldTableName());
        return 1;
    }

    public List<ColumnInfoDto> transformDto(List<OscarDataModelField> getFields, String state) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        if (HussarUtils.isNotEmpty(getFields)) {
            for (int i = 0; i < getFields.size(); ++i) {
                Optional engineColumnType;
                ColumnInfoDto columnInfo = new ColumnInfoDto();
                columnInfo.setColumnName(getFields.get(i).getSourceFieldName());
                columnInfo.setColumnComment(getFields.get(i).getComment());
                columnInfo.setColumnAlias(getFields.get(i).getName());
                columnInfo.setRequired("0");
                if ("primary".equals(getFields.get(i).getUsage())) {
                    columnInfo.setPk("1");
                    columnInfo.setRequired("1");
                    columnInfo.setPrimarys("1");
                } else {
                    columnInfo.setPk("0");
                }
                if (getFields.get(i).getDataIsEmpty()) {
                    columnInfo.setRequired("1");
                }
                columnInfo.setDataLength(Long.valueOf(getFields.get(i).getDataLength()));
                columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getDataDot()));
                columnInfo.setDataType(getFields.get(i).getSourceDataType());
                columnInfo.setDataIsEmpty(Integer.valueOf(getFields.get(i).getDataIsEmpty() ? 1 : 0));
                if (!"all".equals(state)) {
                    columnInfo.setOperation(state);
                }
                if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)getFields.get(i).getDataType())).isPresent()) {
                    columnInfo.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
                    columnInfo.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
                }
                columnInfos.add(columnInfo);
            }
        }
        return columnInfos;
    }

    public List<ColumnInfoDto> transformEdit(List<OscarEditDataModelField> getFields, String state) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        if (HussarUtils.isNotEmpty(getFields)) {
            for (int i = 0; i < getFields.size(); ++i) {
                Optional engineColumnType;
                ColumnInfoDto columnInfo = new ColumnInfoDto();
                columnInfo.setColumnName(getFields.get(i).getNewField().getSourceFieldName());
                columnInfo.setColumnComment(getFields.get(i).getNewField().getComment());
                columnInfo.setColumnAlias(getFields.get(i).getNewField().getName());
                columnInfo.setRequired("0");
                if ("primary".equals(getFields.get(i).getNewField().getUsage())) {
                    columnInfo.setPk("1");
                    columnInfo.setRequired("1");
                    columnInfo.setPrimarys("1");
                } else {
                    columnInfo.setPk("0");
                }
                if (getFields.get(i).getNewField().getDataIsEmpty()) {
                    columnInfo.setRequired("1");
                }
                columnInfo.setPurpose(getFields.get(i).getNewField().getUsage());
                columnInfo.setDataLength(Long.valueOf(getFields.get(i).getNewField().getDataLength()));
                columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getNewField().getDataDot()));
                columnInfo.setDataType(getFields.get(i).getNewField().getSourceDataType());
                columnInfo.setOldColumnName(getFields.get(i).getOldField().getSourceFieldName());
                columnInfo.setDataIsEmpty(Integer.valueOf(getFields.get(i).getNewField().getDataIsEmpty() ? 1 : 0));
                if (!"all".equals(state)) {
                    columnInfo.setOperation(state);
                }
                if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)getFields.get(i).getNewField().getDataType())).isPresent()) {
                    columnInfo.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
                    columnInfo.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
                }
                columnInfos.add(columnInfo);
            }
        }
        return columnInfos;
    }

    public List<ColumnInfoDto> transform(List<OscarDataModelField> getFields) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        if (HussarUtils.isNotEmpty(getFields)) {
            for (int i = 0; i < getFields.size(); ++i) {
                ColumnInfoDto columnInfo = new ColumnInfoDto();
                columnInfo.setColumnName(getFields.get(i).getSourceFieldName());
                columnInfo.setColumnComment(getFields.get(i).getComment());
                columnInfo.setRequired("0");
                if ("primary".equals(getFields.get(i).getUsage())) {
                    columnInfo.setPk("1");
                    columnInfo.setRequired("1");
                } else {
                    columnInfo.setPk("0");
                }
                if (getFields.get(i).getDataIsEmpty()) {
                    columnInfo.setRequired("1");
                }
                columnInfo.setDataLength(Long.valueOf(getFields.get(i).getDataLength()));
                columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getDataDot()));
                columnInfo.setDataType(getFields.get(i).getSourceDataType());
                columnInfos.add(columnInfo);
            }
        }
        return columnInfos;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws Exception {
        int x;
        String dataSourceName = this.getDataSourceName();
        if (ToolUtil.isEmpty((Object)dataSourceName)) {
            return "";
        }
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasourceLr = sysDataSourceService.getByConnName(dataSourceName);
        datasourceLr.setDbName(dataSourceName);
        TableCorrespond info = new TableCorrespond();
        IndexCorrespond indexInfo = new IndexCorrespond();
        boolean findTable = false;
        if (fieldsContrastParam.getTableCorresponds() != null) {
            for (x = 0; x < fieldsContrastParam.getTableCorresponds().size(); ++x) {
                if (!this.getId().equals(((TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x)).getModelId())) continue;
                info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x);
                findTable = true;
                break;
            }
        }
        if (fieldsContrastParam.getIndexCorresponds() != null) {
            for (x = 0; x < fieldsContrastParam.getIndexCorresponds().size(); ++x) {
                if (!this.getId().equals(((IndexCorrespond)fieldsContrastParam.getIndexCorresponds().get(x)).getModelId())) continue;
                indexInfo = (IndexCorrespond)fieldsContrastParam.getIndexCorresponds().get(x);
                findTable = true;
                break;
            }
        }
        boolean isCopy = true;
        if (!findTable) {
            isCopy = false;
        } else if (info.getTableName() == null || "".equals(info.getTableName())) {
            if (!("[]".equals(info.getAddFields()) && "[]".equals(info.getDelFields()) && "[]".equals(info.getModifyFields()))) {
                isCopy = true;
            } else if ("[]".equals(indexInfo.getAddIndexs()) && "[]".equals(indexInfo.getDelIndexs())) {
                boolean findCurrentTable = info.getTableName() != null && ToolUtil.isNotEmpty((Object)info.getTableName()) || indexInfo.getTableName() != null && ToolUtil.isNotEmpty((Object)indexInfo.getTableName()) ? DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)info.getTableName()).isPresent() : DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase()).isPresent();
                isCopy = !findCurrentTable;
            }
        }
        String sql = "";
        if (isCopy) {
            sql = this.doCopy(datasourceLr, (TableCorrespond<OscarDataModelField>)info, indexInfo);
        }
        return sql;
    }

    private String doCopy(SysDataSource datasourceLr, TableCorrespond<OscarDataModelField> info, IndexCorrespond indexInfo) throws Exception {
        MetadataParam paramData = new MetadataParam();
        ArrayList<ColumnInfoDto> deletedCols = new ArrayList<ColumnInfoDto>();
        List delFields = JSONArray.parseArray((String)info.getDelFields(), OscarDataModelField.class);
        if (HussarUtils.isNotEmpty((Object)delFields)) {
            for (int y = 0; y < delFields.size(); ++y) {
                ColumnInfoDto del = new ColumnInfoDto();
                del.setColumnName(((OscarDataModelField)((Object)delFields.get(y))).getSourceFieldName());
                deletedCols.add(del);
            }
        }
        paramData.setDeletedCols(deletedCols);
        List delIndexs = JSONArray.parseArray((String)indexInfo.getDelIndexs(), OscarDataModelIndex.class);
        List addFields = JSONArray.parseArray((String)info.getAddFields(), OscarDataModelField.class);
        List editFields = JSONArray.parseArray((String)info.getModifyFields(), OscarEditDataModelField.class);
        List<ColumnInfoDto> add = this.transformDto(addFields, "add");
        List<ColumnInfoDto> edit = this.transformEdit(editFields, "edit");
        ArrayList<ColumnInfoDto> column = new ArrayList<ColumnInfoDto>();
        column.addAll(add);
        column.addAll(edit);
        paramData.setColumnInfo(column);
        String oldTableName = !HussarUtils.isEmpty((Object)info.getOldTableName()) ? info.getOldTableName() : indexInfo.getOldTableName();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)oldTableName.toUpperCase());
        List addIndexs = JSONArray.parseArray((String)indexInfo.getAddIndexs(), OscarDataModelIndex.class);
        TableInfo table = infoOptional.orElseGet(TableInfo::new);
        ArrayList<ColumnInfoDto> oldColumn = new ArrayList();
        TableInfoDto tableInfoDto = OscarBaseConnector.tableInfoInCreate(datasourceLr, this);
        paramData.setTableInfo(tableInfoDto);
        if (table.getFields() != null) {
            oldColumn = this.transform(OscarDataModelUtil.tabTransmodel(table.getFields()));
            if (StringUtil.isNotEmpty((Object)tableInfoDto.getTableDec()) && tableInfoDto.getTableDec().equals(table.getComment())) {
                tableInfoDto.setTableDec(null);
            }
        } else {
            paramData.setColumnInfo(this.transformDto(this.getFields(), "all"));
        }
        return this.getDdlSql(paramData, oldColumn, info.getOldTableName());
    }

    public OscarDataModelField getDeleteFlag() {
        return this.getFields().stream().filter(field -> "delDefFlag".equals(field.getUsage())).findFirst().orElse(null);
    }

    public OscarDataModelField getPrimaryKey() {
        return this.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(null);
    }

    private String getDdlSql(MetadataParam paramData, List<ColumnInfoDto> oldColumn, String oldTableName) throws Exception {
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        return ddlService.getDdlSql(paramData, oldColumn, oldTableName);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() throws LcdpException {
        return super.getSlaveModelInfo();
    }
}

