/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarModelFunction;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslate;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslateCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.translate.OscarTranslateField;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarPublicEnclosure;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OscarTranslateUtil {
    public static void translateMsEnclosure(List<OscarTranslate> translates, OscarMsDataModel dataModelBase, OscarDataModelBaseDTO dataModelBaseDTO) throws LcdpException {
        if (ToolUtil.isNotEmpty(translates)) {
            List<Map<String, Object>> translateAnnotations;
            ArrayList<DataModelFieldBase> rightFields = new ArrayList<DataModelFieldBase>();
            rightFields.addAll(dataModelBase.getMasterTable().getFields());
            if (ToolUtil.isNotEmpty(dataModelBase.getSlaveTables())) {
                List<OscarDataModelBase> slaveTables = dataModelBase.getSlaveTables();
                for (OscarDataModelBase slaveTable : slaveTables) {
                    rightFields.addAll(slaveTable.getFields());
                }
            }
            if (ToolUtil.isNotEmpty(translateAnnotations = OscarTranslateUtil.translate(translates, rightFields))) {
                List<OscarDataModelFieldDto> fields = dataModelBaseDTO.getFields();
                List<OscarDataModelFieldDto> voFields = dataModelBaseDTO.getVoGeneratorInfo().getFields();
                OscarTranslateUtil.setFieldAnnotations(translateAnnotations, fields);
                OscarTranslateUtil.setFieldAnnotations(translateAnnotations, voFields);
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.anno.Trans");
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.constant.TransType");
            }
            List<OscarDataModelFieldDto> translateShowFields = OscarTranslateUtil.getTranslateShowFields(translates);
            for (OscarDataModelFieldDto translateShowField : translateShowFields) {
                if (null == translateShowField.getColumnType() || null == translateShowField.getColumnType().getImportT()) continue;
                dataModelBaseDTO.addEntityImport(translateShowField.getColumnType().getImportT());
            }
            dataModelBaseDTO.setTranslateShowFields(translateShowFields);
        }
    }

    private static void setFieldAnnotations(List<Map<String, Object>> translateAnnotations, List<OscarDataModelFieldDto> fields) {
        block0: for (Map<String, Object> translateAnnotation : translateAnnotations) {
            if (!ToolUtil.isNotEmpty(translateAnnotation) || !ToolUtil.isNotEmpty((Object)translateAnnotation.get("fieldId"))) continue;
            for (OscarDataModelFieldDto field : fields) {
                if (!field.getId().equals(translateAnnotation.get("fieldId").toString())) continue;
                field.setFieldAnnotation(translateAnnotation.get("fieldAnnotation").toString());
                continue block0;
            }
        }
    }

    public static List<OscarDataModelFieldDto> getTranslateShowFields(List<OscarTranslate> translateConfigs) {
        ArrayList<OscarDataModelFieldDto> showFields = new ArrayList<OscarDataModelFieldDto>();
        for (OscarTranslate translateConfig : translateConfigs) {
            if (!ToolUtil.isNotEmpty(translateConfig.getTranslateFields())) continue;
            List<OscarTranslateField> translateFields = translateConfig.getTranslateFields();
            for (OscarTranslateField translateField : translateFields) {
                if (!ToolUtil.isNotEmpty((Object)translateField) || !ToolUtil.isNotEmpty((Object)translateField.getName())) continue;
                OscarDataModelFieldDto dataModelFieldDto = new OscarDataModelFieldDto();
                dataModelFieldDto.setId(translateField.getId());
                dataModelFieldDto.setPropertyName(translateField.getName());
                dataModelFieldDto.setComment(translateField.getComment());
                dataModelFieldDto.setType(translateField.getDataType());
                dataModelFieldDto.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)translateField.getDataType()));
                showFields.add(dataModelFieldDto);
            }
        }
        return showFields;
    }

    public static List<Map<String, Object>> translate(List<OscarTranslate> translateConfigs, List<DataModelFieldBase> rightFields) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (ToolUtil.isNotEmpty(translateConfigs)) {
            for (OscarTranslate translate : translateConfigs) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (ToolUtil.isNotEmpty((Object)translate.getSourceFieldId()) && ToolUtil.isNotEmpty((Object)translate.getTranslateType())) {
                    map.put("fieldId", translate.getSourceFieldId());
                    switch (translate.getTranslateType()) {
                        case "dictTranslate": {
                            map.put("fieldAnnotation", OscarTranslateUtil.dictTranslate(translate));
                            break;
                        }
                        case "userTranslate": {
                            map.put("fieldAnnotation", OscarTranslateUtil.userTranslate(translate));
                            break;
                        }
                        case "organTranslate": {
                            map.put("fieldAnnotation", OscarTranslateUtil.organTranslate(translate));
                            break;
                        }
                        case "modelTranslate": {
                            map.put("fieldAnnotation", OscarTranslateUtil.modelTranslate(translate, rightFields));
                            break;
                        }
                    }
                }
                list.add(map);
            }
        }
        return list;
    }

    private static String dictTranslate(OscarTranslate translate) {
        List<OscarTranslateField> translateFields = translate.getTranslateFields();
        String label = translateFields.get(0).getName();
        String key = translate.getSourceId();
        String annotation = "@Trans(type = TransType.FIELD_TRANS, queryFields = { \"value\", \"type\" }, namespace = \"TranslateDict\", key = \"" + key + "\", ref = \"";
        annotation = annotation + label + "#label\" )";
        return annotation;
    }

    private static String userTranslate(OscarTranslate translate) {
        List<OscarTranslateField> translateFields = translate.getTranslateFields();
        String annotation = "@Trans(type = TransType.ID_TRANS, namespace = \"TranslateUser\", refs = {";
        String refs = "";
        for (int i = 0; i < translateFields.size(); ++i) {
            if (i == translateFields.size() - 1) {
                refs = refs + " \"" + translateFields.get(i).getName() + "#" + translateFields.get(i).getTranslateSource() + "\"} )";
                break;
            }
            refs = refs + " \"" + translateFields.get(i).getName() + "#" + translateFields.get(i).getTranslateSource() + "\",";
        }
        annotation = annotation + refs;
        return annotation;
    }

    private static String organTranslate(OscarTranslate translate) {
        List<OscarTranslateField> translateFields = translate.getTranslateFields();
        String annotation = "@Trans(type = TransType.ID_TRANS, namespace = \"TranslateOrganization\", refs = {";
        String refs = "";
        for (int i = 0; i < translateFields.size(); ++i) {
            if (i == translateFields.size() - 1) {
                refs = refs + " \"" + translateFields.get(i).getName() + "#" + translateFields.get(i).getTranslateSource() + "\"} )";
                break;
            }
            refs = refs + " \"" + translateFields.get(i).getName() + "#" + translateFields.get(i).getTranslateSource() + "\",";
        }
        annotation = annotation + refs;
        return annotation;
    }

    private static String modelTranslate(OscarTranslate translate, List<DataModelFieldBase> rightFields) {
        String sourceId = translate.getSourceId();
        try {
            JSONObject dataModelBase = DataModelUtil.getDataModelJson((String)sourceId);
            OscarModelFunction currentFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(String.valueOf(dataModelBase.get((Object)"functionType")));
            OscarDataModelBase currentModelBase = OscarDataModelUtil.transfer(dataModelBase);
            OscarDataModelBaseDTO dataModelDto = new OscarDataModelBaseDTO();
            OscarPublicEnclosure.enclosure(currentModelBase, dataModelDto);
            String modulePath = dataModelDto.getTablePath().toLowerCase();
            String namespace = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
            List<OscarDataModelFieldDto> leftFields = dataModelDto.getFields();
            List<OscarTranslateCondition> dataModelCondition = translate.getDataModelCondition();
            ArrayList<String> queryFields = new ArrayList<String>();
            ArrayList<String> keyRefs = new ArrayList<String>();
            String queryField = "";
            String keyRef = "";
            if (ToolUtil.isNotEmpty(dataModelCondition)) {
                for (OscarTranslateCondition translateCondition : dataModelCondition) {
                    String goalsRowId = translateCondition.getGoalsRowId();
                    String fromModelField = translateCondition.getFromModelField();
                    if (!ToolUtil.isNotEmpty((Object)goalsRowId) || !ToolUtil.isNotEmpty((Object)fromModelField)) continue;
                    OscarDataModelFieldDto leftDataModelFieldDto = leftFields.stream().filter(field -> HussarUtils.equals((Object)field.getId(), (Object)goalsRowId)).findFirst().orElseGet(OscarDataModelFieldDto::new);
                    queryFields.add(leftDataModelFieldDto.getPropertyName());
                    DataModelFieldBase dataModelFieldBase = rightFields.stream().filter(field -> HussarUtils.equals((Object)field.getId(), (Object)fromModelField)).findFirst().orElseGet(DataModelFieldBase::new);
                    keyRefs.add(dataModelFieldBase.getName());
                }
                if (queryFields.size() > 1) {
                    for (int i = 0; i < queryFields.size(); ++i) {
                        if (i == 0) {
                            queryField = queryField + "{ \"" + (String)queryFields.get(i) + "\",";
                            continue;
                        }
                        if (i == queryFields.size() - 1) {
                            queryField = queryField + " \"" + (String)queryFields.get(i) + "\" }";
                            break;
                        }
                        queryField = queryField + " \"" + (String)queryFields.get(i) + "\",";
                    }
                } else {
                    queryField = "{ \"" + (String)queryFields.get(0) + "\" }";
                }
                if (keyRefs.size() > 2) {
                    for (int i = 1; i < keyRefs.size(); ++i) {
                        if (i == 1) {
                            keyRef = keyRef + "keyRef = { \"" + (String)keyRefs.get(i) + "\",";
                            continue;
                        }
                        if (i == keyRefs.size() - 1) {
                            keyRef = keyRef + " \"" + (String)keyRefs.get(i) + "\" },";
                            break;
                        }
                        keyRef = keyRef + " \"" + (String)keyRefs.get(i) + "\",";
                    }
                } else {
                    keyRef = keyRefs.size() == 2 ? "keyRef = { \"" + (String)keyRefs.get(1) + "\" }," : "";
                }
            }
            List<OscarTranslateField> translateFields = translate.getTranslateFields();
            ArrayList<String> refs = new ArrayList<String>();
            if (ToolUtil.isNotEmpty(translateFields)) {
                for (OscarTranslateField translateField : translateFields) {
                    String rightTranslateSource = translateField.getTranslateSource();
                    if (!ToolUtil.isNotEmpty((Object)rightTranslateSource)) continue;
                    OscarDataModelFieldDto rightDataModelFieldDto = leftFields.stream().filter(field -> HussarUtils.equals((Object)field.getId(), (Object)rightTranslateSource)).findFirst().orElseGet(OscarDataModelFieldDto::new);
                    refs.add(translateField.getName() + "#" + rightDataModelFieldDto.getPropertyName());
                }
            }
            String ref = "";
            if (refs.size() > 1) {
                for (int i = 0; i < refs.size(); ++i) {
                    if (i == 0) {
                        ref = ref + "{ \"" + (String)refs.get(i) + "\",";
                        continue;
                    }
                    if (i == refs.size() - 1) {
                        ref = ref + " \"" + (String)refs.get(i) + "\" }";
                        break;
                    }
                    ref = ref + " \"" + (String)refs.get(i) + "\",";
                }
            } else {
                ref = "{ \"" + (String)refs.get(0) + "\" }";
            }
            String annotation = "@Trans(type = TransType.FIELD_TRANS, queryFields = ";
            annotation = annotation + queryField + ", namespace = \"" + namespace + "\", " + keyRef + " refs = " + ref + " )";
            return annotation;
        }
        catch (LcdpException | CloneNotSupportedException e) {
            throw new HussarException();
        }
    }
}

