/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.util;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.JavaCodeFormatUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.XMLCodeParserUtil;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatResult;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.FrontClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.devtools.invocation.service.CompileInvokeHelper;
import com.jxdinfo.hussar.formdesign.oscar.code.OscarCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.result.OscarCodeResult;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class OscarCodeMergeUtil {
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private static VersionManageService versionManageService = (VersionManageService)SpringContextUtil.getBean(VersionManageService.class);
    private static CodeMergeService codeMergeService = (CodeMergeService)SpringContextUtil.getBean(CodeMergeService.class);
    private static final String CLIENT_TYPE = "publishIds";

    public static List<OscarCodeResult> mergeBack(List<OscarCodeGenerateInfo> codeGenerateInfos, OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx) throws IOException, LcdpException {
        ArrayList<OscarCodeResult> results = new ArrayList<OscarCodeResult>();
        String ifEnvIp = (String)BaseSecurityUtil.getUser().getExtendUserMap().get("ifEnvIp");
        if (ToolUtil.isNotEmpty(codeGenerateInfos)) {
            List<Object> publishIds = new ArrayList();
            if (null != Optional.ofNullable(backCtx.getParams()).orElseGet(HashMap::new).get(CLIENT_TYPE)) {
                publishIds = Arrays.asList(backCtx.getParams().get(CLIENT_TYPE).toString().split(","));
            }
            long l = System.currentTimeMillis();
            for (OscarCodeGenerateInfo codeGenerateInfo : codeGenerateInfos) {
                OscarCodeMergeUtil.formatCode(codeGenerateInfo);
            }
            ToolUtil.getLogger(OscarCodeMergeUtil.class).info("java\u4ee3\u7801\u683c\u5f0f\u5316\u603b\u8017\u65f6\uff1a{}", (Object)ToolUtil.logTime((long)l));
            for (OscarCodeGenerateInfo codeGenerateInfo : codeGenerateInfos) {
                if ("js".equals(codeGenerateInfo.getFileType()) && ToolUtil.isNotEmpty(publishIds)) {
                    for (String string : publishIds) {
                        results.add(OscarCodeMergeUtil.mergeBackCode(codeGenerateInfo, string, backCtx, ifEnvIp));
                    }
                    continue;
                }
                results.add(OscarCodeMergeUtil.mergeBackCode(codeGenerateInfo, "", backCtx, ifEnvIp));
            }
        }
        return results;
    }

    private static OscarCodeResult mergeBackCode(OscarCodeGenerateInfo codeGenerateInfo, String publishId, OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx, String ifEnvIp) throws IOException, LcdpException {
        BaseFile baseFile = HussarUtils.isNotEmpty((Object)backCtx.getBaseFile()) ? backCtx.getBaseFile() : new BaseFile();
        String absolutePath = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().backProjectJava(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
        OscarCodeResult genCodeResult = new OscarCodeResult();
        genCodeResult.setResultType(ResultBeanEnum.OSCAR_RESULT);
        String mergeCode = "";
        if (!codeGenerateInfo.isCodeFormatSucceed()) {
            genCodeResult.setId(baseFile.getId());
            genCodeResult.setFilePath(ToolUtil.pathFomatterByOS((String)absolutePath));
            genCodeResult.setNewCode(codeGenerateInfo.getFileContent());
            genCodeResult.setCodeFormatMessages(codeGenerateInfo.getCodeFormatMessages());
            genCodeResult.setMsg(codeGenerateInfo.getCodeFormatMsg());
            genCodeResult.setCodeFormatSucceed(codeGenerateInfo.isCodeFormatSucceed());
            return genCodeResult;
        }
        if (!(baseFile instanceof PageInfo)) {
            baseFile.setId(backCtx.getUseDataModelBase().getId());
        }
        String dataId = OscarCodeMergeUtil.getVersionFileKey(codeGenerateInfo);
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileContent())) {
            String writeFile;
            boolean isCodeComparison;
            try {
                isCodeComparison = ((CompileInvokeHelper)SpringContextHolder.getBean(CompileInvokeHelper.class)).isCodeComparison();
            }
            catch (Exception e) {
                isCodeComparison = true;
            }
            if (!VfgModeTool.isRemote() || "1".equals(ifEnvIp) && isCodeComparison) {
                mergeCode = OscarCodeMergeUtil.merge(codeGenerateInfo, genCodeResult, baseFile);
            }
            String string = writeFile = ToolUtil.isEmpty((Object)mergeCode) ? codeGenerateInfo.getFileContent() : mergeCode;
            absolutePath = !genCodeResult.isExistConflict() ? OscarCodeMergeUtil.writeNoConflictCode(codeGenerateInfo, baseFile, dataId, writeFile) : ("js".equals(codeGenerateInfo.getFileType()) ? FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage")).projectApiFullPath(codeGenerateInfo.getFileWriteRelativePath()).getLocalPath() : ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().backProjectJava(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath());
        }
        genCodeResult.setFilePath(ToolUtil.pathFomatterByOS((String)absolutePath));
        genCodeResult.setDataId(dataId);
        genCodeResult.setId(baseFile.getId());
        if (genCodeResult.isExistConflict()) {
            filePublishService.writePublishResult((CodeResult)genCodeResult);
            genCodeResult = genCodeResult.reduceCodeResult();
        }
        return genCodeResult;
    }

    private static String merge(OscarCodeGenerateInfo codeGenerateInfo, OscarCodeResult genCodeResult, BaseFile baseFile) throws IOException {
        Optional<String> currentCode;
        String mergeCode = "";
        String dataId = OscarCodeMergeUtil.getVersionFileKey(codeGenerateInfo);
        String jsPath = FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage")).projectApiFullPath(codeGenerateInfo.getFileWriteRelativePath()).getLocalPath();
        if ("js".equals(codeGenerateInfo.getFileType())) {
            currentCode = Optional.ofNullable(filePublishService.readCurrentPublishedFile(jsPath));
        } else {
            String currentPath = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().backProjectJava(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
            currentCode = Optional.ofNullable(filePublishService.readCurrentPublishedFile(currentPath));
        }
        Optional<String> versionCode = Optional.ofNullable(versionManageService.getAncestorCodeById(dataId));
        String lastFileCode = versionManageService.getLastFileCode(dataId);
        if (currentCode.isPresent() && versionCode.isPresent()) {
            MergeResult mergeResult;
            String currentFile = currentCode.get();
            String lastPublish = versionCode.get();
            if (codeGenerateInfo.getFileType().equals("xml")) {
                currentFile = CodeSplitUtil.setEndOnlyLine((String)currentFile);
                lastPublish = CodeSplitUtil.setEndOnlyLine((String)lastPublish);
            }
            if ((mergeResult = codeMergeService.structuralMerge(jsPath, ExtractFileType.JS, lastPublish, currentFile, codeGenerateInfo.getFileContent(), lastFileCode, false)).isConflict()) {
                genCodeResult.setExistConflict(true);
                genCodeResult.setMergeCode(mergeResult.getMergedCode());
                genCodeResult.setConflictCode(mergeResult.getConflictsCode());
                genCodeResult.setOriginCode(currentCode.get());
                genCodeResult.setNewCode(codeGenerateInfo.getFileContent());
                genCodeResult.setLastPublish(mergeResult.getLastPublish());
                genCodeResult.setCurrentPublish(mergeResult.getCurrentPublish());
                genCodeResult.setCurrentFile(mergeResult.getCurrentFile());
                genCodeResult.setMergeInfo(mergeResult.getMergeInfo());
            } else {
                mergeCode = mergeResult.getMergedCode();
            }
            switch (codeGenerateInfo.getFileType()) {
                case "controller": 
                case "entity": 
                case "service": 
                case "serviceImpl": 
                case "mapper": {
                    genCodeResult.setType("java");
                    break;
                }
                case "xml": {
                    genCodeResult.setType("xml");
                    break;
                }
                case "js": {
                    genCodeResult.setType("js");
                    break;
                }
            }
        }
        return mergeCode;
    }

    private static void formatCode(OscarCodeGenerateInfo codeGenerateInfo) {
        String fileType = codeGenerateInfo.getFileType();
        if (ToolUtil.isNotEmpty((Object)fileType) && ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileContent())) {
            CodeFormatResult codeFormatResult;
            if (fileType.equals("controller") || fileType.equals("entity") || fileType.equals("mapper") || fileType.equals("service") || fileType.equals("serviceImpl") || fileType.equals("queryEntity") || fileType.equals("vo")) {
                codeFormatResult = JavaCodeFormatUtil.format((String)codeGenerateInfo.getFileContent());
                codeGenerateInfo.setFileContent(codeFormatResult.getCodeFormatCode());
                codeGenerateInfo.setCodeFormatSucceed(codeFormatResult.isSucceed());
                codeGenerateInfo.setCodeFormatMessages(codeFormatResult.getMessages());
            }
            if (fileType.equals("js")) {
                codeFormatResult = CodeFormatter.formatterHtml((String)codeGenerateInfo.getFileContent(), (String)"typescript");
                codeGenerateInfo.setFileContent(codeFormatResult.getCodeFormatCode());
                codeGenerateInfo.setCodeFormatSucceed(codeFormatResult.isSucceed());
                codeGenerateInfo.setCodeFormatMsg(codeFormatResult.getMsg());
                codeGenerateInfo.setCodeFormatMessages(codeFormatResult.getMessages());
            }
            if (fileType.equals("xml")) {
                codeGenerateInfo.setFileContent(CodeSplitUtil.setEndOnlyLine((String)codeGenerateInfo.getFileContent()));
            }
            FormDesignProperties formDesignProperties = (FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class);
            if (fileType.equals("xml") && formDesignProperties.isCheckedCode()) {
                CodeFormatResult codeFormatResult2 = XMLCodeParserUtil.parser((String)codeGenerateInfo.getFileContent());
                codeGenerateInfo.setFileContent(codeFormatResult2.getCodeFormatCode());
                codeGenerateInfo.setCodeFormatSucceed(codeFormatResult2.isSucceed());
                codeGenerateInfo.setCodeFormatMessages(codeFormatResult2.getMessages());
            }
        }
    }

    public static String writeNoConflictCode(OscarCodeGenerateInfo codeGenerateInfo, BaseFile baseFile, String dataId, String writeFile) throws LcdpException, IOException {
        String absolutePath = "js".equals(codeGenerateInfo.getFileType()) ? filePublishService.writeApiCode(writeFile, codeGenerateInfo.getFileWriteRelativePath(), baseFile.getId()) : filePublishService.writeMVCCode(writeFile, codeGenerateInfo.getFileWriteRelativePath(), baseFile.getId());
        versionManageService.saveCacheLastPublishCode(dataId, codeGenerateInfo.getFileContent(), baseFile.getId());
        versionManageService.saveCacheLastFileCode(dataId, writeFile, baseFile.getId());
        return absolutePath;
    }

    private static String getVersionFileKey(OscarCodeGenerateInfo codeGenerateInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(codeGenerateInfo.getFileId());
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getPageType()) && !"WebPage".equals(codeGenerateInfo.getPageType()) && !"MobilePage".equals(codeGenerateInfo.getPageType())) {
            stringBuilder.append(codeGenerateInfo.getPageType());
        }
        stringBuilder.append(codeGenerateInfo.getFileType());
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileName())) {
            stringBuilder.append(codeGenerateInfo.getFileName());
        }
        return stringBuilder.toString();
    }
}

