/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.provider;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarModelFunction;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.service.OscarWorkFlowVisitorServiceImpl;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OscarModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(OscarModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"OSCAR", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + dataModelBase.getName();
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            String tenantCodePrefix = Optional.ofNullable(AppContextUtil.getAppInfo()).map(e -> "/" + e.getTenantId()).orElse("");
            return FileUtil.posixPath((String[])new String[]{tenantCodePrefix, apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        JSONObject dataModelJson = DataModelUtil.getDataModelJson((String)modelId);
        if (ToolUtil.isEmpty((Object)dataModelJson)) {
            return "";
        }
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModelJson.getString("functionType"));
        OscarDataModelBase lrDataModelBase = modelFunction.parseDataModel(dataModelJson);
        return lrDataModelBase.getFields().stream().filter(e -> "primary".equals(e.getUsage())).findFirst().orElseGet(OscarDataModelField::new).getName();
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        OscarDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if (ToolUtil.isNotEmpty(dataModelBase.getOperations())) {
            for (OscarDataModelOperation operation : dataModelBase.getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                return operation.getName();
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId, String oldVersion, String organId, String newOrganId) throws LcdpException, IOException, CloneNotSupportedException {
        return new OscarWorkFlowVisitorServiceImpl().visitorGeneration(identityKey, workFlowName, modelName, modelId, workflowId, oldVersion, organId, newOrganId);
    }

    public void sync(String modelId) throws LcdpException, IOException {
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        OscarDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        ArrayList<DataModelFieldBase> oscarDataModelFields = new ArrayList<DataModelFieldBase>();
        List<OscarDataModelField> fields = dataModelBase.getFields();
        if (ToolUtil.isNotEmpty(fields)) {
            oscarDataModelFields.addAll(fields);
        } else {
            List<OscarDataModelBase> slaveTables = null;
            OscarDataModelBase masterTable = new OscarBaseDataModel();
            if (modelFunction instanceof OscarFlowMsDataModel) {
                slaveTables = ((OscarFlowMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((OscarFlowMsDataModel)dataModelBase).getMasterTable();
            } else if (modelFunction instanceof OscarMsDataModel) {
                slaveTables = ((OscarMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((OscarMsDataModel)dataModelBase).getMasterTable();
            }
            oscarDataModelFields.addAll(masterTable.getFields());
            if (ToolUtil.isNotEmpty(slaveTables)) {
                for (OscarDataModelBase slaveTable : slaveTables) {
                    oscarDataModelFields.addAll(slaveTable.getFields());
                }
            }
        }
        if (modelFunction instanceof OscarTaskDataModel) {
            oscarDataModelFields.addAll(((OscarTaskDataModel)dataModelBase).getTask().getFields());
        } else if (modelFunction instanceof OscarTaskMsDataModel) {
            oscarDataModelFields.addAll(((OscarTaskMsDataModel)dataModelBase).getTask().getFields());
        }
        return oscarDataModelFields;
    }

    public void delete(String s) throws LcdpException {
    }

    public Map<String, Map<String, Object>> getSlaveModelInfos(String modelId) throws LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        OscarDataModelBase model = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return model.getSlaveModelInfo();
    }
}

