/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.task.masterslavetask;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.source.SourcePackageInfo;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarQueryDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.visitor.constant.OscarConstUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.visitor.masterslave.util.OscarMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARTASK_MASTER_SLAVEFormQuery")
public class OscarMsTaskFormQueryVisitor
implements OscarOperationVisitor<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsTaskFormQueryVisitor.class);
    public static final String OPERATION_NAME = "OSCARTASK_MASTER_SLAVEFormQuery";

    @Override
    public void visit(OscarBackCtx<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> taskBackCtx, OscarDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        OscarFlowMsDataModelDTO oscarFlowMsDataModelDTO = (OscarFlowMsDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        OscarFlowMsDataModel dataModelBase = (OscarFlowMsDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        OscarDataModelBase masterTable = dataModelBase.getMasterTable();
        OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx = new OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO>();
        backCtx.setUseDataModelBase(dataModelBase);
        HashMap<String, OscarFlowMsDataModelDTO> map = new HashMap<String, OscarFlowMsDataModelDTO>();
        map.put(modelId, oscarFlowMsDataModelDTO);
        backCtx.setUseDataModelDtoMap(map);
        String url = oscarFlowMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, OscarDataModelBase> dataModelBaseMap = oscarFlowMsDataModelDTO.getDataModelBaseMap();
        Map<String, OscarDataModelBaseDTO> dataModelDtoMap = oscarFlowMsDataModelDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = operation.getParams();
        Map slaveTablePlusSave = (Map)controllerParams.get("slaveTablePlusSave");
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        controllerParams.put("table", oscarFlowMsDataModelDTO);
        controllerParams.put("returnValue", oscarFlowMsDataModelDTO.getEntityName());
        controllerParams.put("url", url);
        controllerParams.put("isPlusQuery", false);
        controllerParams.put("operationName", controllerParams.get("name"));
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            Map<String, String> slaveQueryNames;
            for (OscarDataModelBase slaveTable : dataModelBase.getSlaveTables()) {
                capitalNameList.put(slaveTable.getName(), OscarMasterSlaveUtil.getCapitalName(slaveTable.getName()));
            }
            controllerParams.put("boolFields", oscarFlowMsDataModelDTO.getFields().stream().filter(o -> "boolean".equals(o.getType())).collect(Collectors.toList()));
            controllerParams.put("capitalNameList", capitalNameList);
            controllerParams.put("returnIncrementValue", oscarFlowMsDataModelDTO.getEntityName() + "FormVO");
            controllerParams.put("slaveTable", OscarMsTaskFormQueryVisitor.getSlaveArrayTables(oscarFlowMsDataModelDTO, dataModelBase));
            controllerParams.put("primaryField", oscarFlowMsDataModelDTO.getKeyPropertyName());
            controllerParams.put("pageDTO", oscarFlowMsDataModelDTO.getEntityName() + "PageDTO");
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                controllerParams.put("isPlusQuery", true);
                break;
            }
            if (ToolUtil.isNotEmpty(slaveQueryNames = OscarMsTaskFormQueryVisitor.getSlaveQueryName(dataModelBase))) {
                controllerParams.put("slaveQueryNames", slaveQueryNames);
            }
            OscarDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
            backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
            backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Entity"));
            OscarMsTaskFormQueryVisitor.addFormVO(oscarFlowMsDataModelDTO, dataModelBase, slaveTablePlusSave, backCtx);
            OscarMsTaskFormQueryVisitor.addFormQueryDto(oscarFlowMsDataModelDTO, dataModelBase, slaveTablePlusSave, backCtx);
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(oscarFlowMsDataModelDTO.getComment() + "\u8868\u5355\u67e5\u8be2");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/oscar/taskbackcode/masterslavetaskbackcode/get/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, oscarFlowMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, oscarFlowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(modelId, oscarFlowMsDataModelDTO.getServiceName());
        String servicePath = "template/oscar/taskbackcode/masterslavetaskbackcode/get/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, oscarFlowMsDataModelDTO.getImportInfo().get("Entity"));
        String serviceImplPath = "template/oscar/taskbackcode/masterslavetaskbackcode/get/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, oscarFlowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImplImport(modelId, oscarFlowMsDataModelDTO.getImportInfo().get("Mapper"));
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        }
        if (ToolUtil.isNotEmpty((Object)oscarFlowMsDataModelDTO.isHasTranslate()) && oscarFlowMsDataModelDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addServiceImplInversion(modelId, oscarFlowMsDataModelDTO.getMapperName());
        String mapperPath = "template/oscar/taskbackcode/masterslavetaskbackcode/get/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, oscarFlowMsDataModelDTO.getImportInfo().get("Entity"));
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        String finalReturn = SqlReturnUtil.renderReturn(dataModelBase, aliasMap);
        controllerParams.put("return", finalReturn);
        String finalRelation = SqlReturnUtil.renderRelation(dataModelBase, dataModelBaseMap);
        controllerParams.put("relation", finalRelation);
        controllerParams.put("quoteModel", OscarConstUtil.TRUE);
        String whereTemplate = "where ${T}.${primary} = #{id}";
        String masterTableId = masterTable.getId();
        OscarDataModelBaseDTO oscarDataModelBaseDTO = dataModelDtoMap.get(masterTableId);
        if (ToolUtil.isNotEmpty((Object)oscarDataModelBaseDTO)) {
            controllerParams.put("whereSql", whereTemplate.replace("${T}", aliasMap.get(masterTableId)).replace("${primary}", oscarDataModelBaseDTO.getKeyField().getName()));
        }
        if (ToolUtil.isNotEmpty((Object)controllerParams.get("customizeSql"))) {
            backCtx.addXmlCode(modelId, (String)controllerParams.get("customizeSql"));
        } else {
            String xmlPath = "template/oscar/taskbackcode/masterslavetaskbackcode/get/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", (Boolean)controllerParams.get("isPlusQuery") != false ? "postJson" : "get", url, "\u8868\u5355\u67e5\u8be2");
        backCtx.addApi(modelId, OscarBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static void addFormVO(OscarMsDataModelDTO dataModelBaseDTO, OscarMsDataModel dataModelBase, Map<String, Boolean> slaveTablePlusSave, OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx) {
        OscarQueryDTO queryDTO = new OscarQueryDTO();
        String modelId = dataModelBase.getId();
        queryDTO.setFtlPath("template/oscar/backcode/code/formVo.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        params.put("voImport", dataModelBaseDTO.getPackageInfo().get("VO"));
        params.put("importInfo", dataModelBaseDTO.getPackageInfo().get("Entity"));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("masterTable", dataModelBaseDTO.getFields());
        params.put("slaveTable", OscarMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelBaseDTO));
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + "FormVO");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "FormVO");
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("VO"));
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importVOPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + queryDTO.getEntityName();
        dataModelBaseDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importVOPath);
        backCtx.addServiceImport(modelId, importVOPath);
        backCtx.addServiceImplImport(modelId, importVOPath);
    }

    private static void addFormQueryDto(OscarMsDataModelDTO dataModelBaseDTO, OscarMsDataModel dataModelBase, Map<String, Boolean> slaveTablePlusSave, OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx) {
        OscarQueryDTO queryDTO = new OscarQueryDTO();
        String modelId = dataModelBase.getId();
        queryDTO.setFtlPath("template/oscar/backcode/code/formDto.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("slaveTable", OscarMsTaskFormQueryVisitor.getSlaveArrayTables(dataModelBaseDTO, dataModelBase));
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("table", table);
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("importInfo", dataModelBaseDTO.getPackageInfo().get("dto"));
        params.put("queryDto", queryDTO);
        params.put("priType", dataModelBaseDTO.getKeyField().getPropertyType());
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + "PageDTO");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "PageDTO");
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
        String importDTOPath = dataModelBaseDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }

    private static List<OscarDataModelBase> getSlaveArrayTables(OscarMsDataModelDTO dataModelBaseDTO, OscarMsDataModel dataModelBase) {
        CopyOnWriteArrayList<OscarDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<OscarDataModelBase>(dataModelBase.getSlaveTables());
        for (OscarDataModelBase slaveArrayTable : slaveArrayTables) {
            for (SourcePackageInfo sourcePackageInfo : dataModelBaseDTO.getSourcePackageInfos()) {
                if (!"object".equals(sourcePackageInfo.getDataType()) || !slaveArrayTable.getName().equals(sourcePackageInfo.getObjectEnName())) continue;
                slaveArrayTables.remove(slaveArrayTable);
            }
        }
        return slaveArrayTables;
    }

    private static Map<String, String> getSlaveQueryName(OscarFlowMsDataModel dataModelBase) {
        List<OscarDataModelOperation> operations = dataModelBase.getOperations();
        HashMap<String, String> slaveQueryNameMap = new HashMap<String, String>();
        List<OscarDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        if (ToolUtil.isNotEmpty(slaveTables)) {
            block0: for (OscarDataModelOperation operation : operations) {
                if (!ToolUtil.isNotEmpty((Object)operation) || !"SlaveQuery".equals(operation.getType()) || !ToolUtil.isNotEmpty((Object)operation.getName()) || !ToolUtil.isNotEmpty(operation.getParams()) || !ToolUtil.isNotEmpty((Object)operation.getParams().get("slaveModelId"))) continue;
                String slaveModelId = operation.getParams().get("slaveModelId").toString();
                for (OscarDataModelBase slaveTable : slaveTables) {
                    if (!ToolUtil.isNotEmpty((Object)slaveTable) || !ToolUtil.isNotEmpty((Object)slaveModelId) || !slaveModelId.equals(slaveTable.getId())) continue;
                    slaveQueryNameMap.put(operation.getParams().get("slaveModelId").toString(), operation.getName());
                    continue block0;
                }
            }
        }
        return slaveQueryNameMap;
    }
}

