/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.flow.masterslaveflow.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarQueryDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.visitor.masterslave.util.OscarMasterSlaveUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OscarFlowMsUtil {
    private static final String INSERT_FILL = "insertFill";
    private static final String UPDATE_FILL = "updateFill";
    private static final String DELGETSTR = "::get";
    private static final String FLOW_INCREMENT_NAME = "FlowIncrementDTO";

    public static void renderMsInsertOrUpdate(Map<String, Object> controllerParams, OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx) throws LcdpException {
        OscarFlowMsUtil.masterSlaveCode(backCtx, controllerParams);
    }

    public static void renderMsDelete(Map<String, Object> controllerParams, OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx) throws LcdpException {
        OscarFlowMsUtil.masterSlaveCodeDel(backCtx, controllerParams);
    }

    private static void masterSlaveCodeDel(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, Map<String, Object> params) {
        String currentModelId = backCtx.getUseDataModelBase().getId();
        OscarMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        OscarMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        OscarDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<OscarRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            return;
        }
        OscarDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            return;
        }
        if (params.get("logicallyDelete") != null) {
            for (OscarRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.init();
            }
        } else {
            for (OscarRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.setLogicallyDelete(false);
            }
        }
        StringBuilder relationStr = OscarFlowMsUtil.getDelStr(relationshipDtoList, masterDto);
        OscarFlowMsUtil.renderTransaction(backCtx, params, currentModelId);
        params.put("masterTable", masterDto);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        boolean delFlag = true;
        for (OscarRelationshipDTO oscarRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            OscarDataModelBaseDTO oscarDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(oscarRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, oscarDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, oscarDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, oscarDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.utils.StringUtil");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }

    private static void masterSlaveCode(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        OscarMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        OscarMsDataModelDTO oscarMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<OscarRelationshipDTO> relationshipDtoList = oscarMsDataModelDTO.getRelationshipDtoList();
        OscarDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, OscarDataModelBaseDTO> dataModelDtoMap = oscarMsDataModelDTO.getDataModelDtoMap();
        OscarDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        controllerParams.put("masterTable", mainDataModelDto);
        OscarFlowMsUtil.renderTransaction(backCtx, controllerParams, modelId);
        String masterFillCode = OscarFlowMsUtil.renderFillCode(mainDataModelDto, oscarMsDataModelDTO);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (OscarRelationshipDTO relationshipDTO : relationshipDtoList) {
                List<OscarRelationshipFieldDTO> oscarRelationshipFieldDTOS;
                String slaveTableId = relationshipDTO.getSlaveTableId();
                String relateModelType = relationshipDTO.getRelateModelType();
                OscarDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                String slaveFillCode = OscarFlowMsUtil.renderFillCode(slaveModelDto, oscarMsDataModelDTO);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                if (slaveFillCode != null) {
                    relationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(oscarRelationshipFieldDTOS = relationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
            controllerParams.put("slaveFillCodeList", slaveFillCodeList);
        }
    }

    private static void renderTransaction(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams, String modelId) {
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
        }
    }

    private static String renderFillCode(OscarDataModelBaseDTO dataModelBaseDTO, OscarMsDataModelDTO msDataModelDTO) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        boolean insertFill = false;
        boolean updateFill = false;
        for (OscarDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "createTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "delDefFlag": {
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
                case "updateTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/oscar/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private static StringBuilder getDelStr(List<OscarRelationshipDTO> relationshipDtoList, OscarDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (OscarRelationshipDTO relationtMap : relationshipDtoList) {
            List<OscarRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            OscarRelationshipFieldDTO oscarRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(oscarRelationshipFieldDTO.getSlaveFieldCap()).append(",idList));\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(oscarRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                OscarRelationshipFieldDTO oscarRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(oscarRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(oscarRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(oscarRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(OscarFlowMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(oscarRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(oscarRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(OscarFlowMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(oscarRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }

    public static void generateIncrementDTO(OscarMsDataModelDTO oscarFlowDataModelDTO, OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation) {
        Map<String, Object> params = dataModelOperation.getParams();
        Map slaveTablePlusSave = (Map)params.get("slaveTablePlusSave");
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        boolean plusFlag = false;
        if (HussarUtils.isNotEmpty((Object)slaveTablePlusSave)) {
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                plusFlag = true;
                break;
            }
        }
        params.put("ifPlusSave", plusFlag);
        if (!plusFlag) {
            return;
        }
        for (OscarRelationshipDTO relationshipDTO : oscarFlowDataModelDTO.getRelationshipDtoList()) {
            if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
            slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
        }
        OscarMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        OscarFlowMsUtil.addIncrementTable(oscarFlowDataModelDTO, slaveTablePlusSave, dataModelBase);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        for (OscarDataModelBase modelBase : dataModelBase.getSlaveTables()) {
            isLogicallyDelete.put(modelBase.getId(), ((OscarBaseDataModel)modelBase).getLogicallyDelete());
            OscarDataModelBaseDTO oscarDataModelBaseDTO = oscarFlowDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
            String slaveModelName = modelBase.getName();
            capitalNameList.put(slaveModelName, OscarMasterSlaveUtil.getCapitalName(slaveModelName));
            for (OscarDataModelField oscarDataModelField : modelBase.getFields()) {
                if (!"delDefFlag".equals(oscarDataModelField.getUsage())) continue;
                logicallyDelField.put(slaveModelName, oscarDataModelField.getName());
                break;
            }
            for (OscarDataModelFieldDto oscarDataModelFieldDto : oscarDataModelBaseDTO.getFields()) {
                if ("primary".equals(oscarDataModelFieldDto.getFill())) {
                    primaryKeys.put(slaveModelName, oscarDataModelFieldDto.getCapitalName());
                }
                if (!"foreign".equals(oscarDataModelFieldDto.getFill())) continue;
                foreignKeys.put(slaveModelName, oscarDataModelFieldDto.getCapitalName());
            }
        }
        params.put("primaryKeys", primaryKeys);
        params.put("foreignKeys", foreignKeys);
        params.put("slaveTablePlusSave", slaveTablePlusSave);
        params.put("slaveTable", OscarMasterSlaveUtil.ofSlaveParam(dataModelBase, oscarFlowDataModelDTO));
        params.put("isLogicallyDelete", isLogicallyDelete);
        params.put("logicallyDelField", logicallyDelField);
        params.put("capitalNameList", capitalNameList);
        String modelId = backCtx.getUseDataModelBase().getId();
        if (HussarUtils.isEmpty((Object)oscarFlowDataModelDTO.getQueryDtoMap().get(oscarFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME))) {
            OscarQueryDTO oldDTO = oscarFlowDataModelDTO.getQueryDtoMap().get(oscarFlowDataModelDTO.getName());
            OscarQueryDTO oscarQueryDTO = (OscarQueryDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)oldDTO), OscarQueryDTO.class);
            HashMap<String, Object> newParams = new HashMap<String, Object>();
            newParams.put("queryDto", oscarQueryDTO);
            HashMap<String, Boolean> table = new HashMap<String, Boolean>();
            table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
            newParams.put("table", table);
            oscarQueryDTO.setParams(newParams);
            String string = oscarFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME;
            String plusTableName = oscarFlowDataModelDTO.getEntityName() + "IncrementTable";
            for (OscarQueryFieldDTO dto : oscarQueryDTO.getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                dto.getDbColumnType().setType(plusTableName);
                dto.getDbColumnType().setImportT(oscarQueryDTO.getPackageInfo() + "." + plusTableName);
                params.put("incrementTable", dto.getDbColumnType());
                backCtx.addServiceImplImport(modelId, dto.getDbColumnType().getImportT());
                break;
            }
            oscarQueryDTO.setName(oscarQueryDTO.getName() + FLOW_INCREMENT_NAME);
            oscarQueryDTO.setEntityName(string);
            oscarQueryDTO.setImportInfo(oscarQueryDTO.getPackageInfo() + "." + string);
            oscarQueryDTO.setWriteFilePath(FileUtil.systemPath((String[])new String[]{oscarFlowDataModelDTO.getTablePath(), "dto", string + ".java"}));
            oscarFlowDataModelDTO.getQueryDtoMap().put(oscarQueryDTO.getName(), oscarQueryDTO);
            params.put("parameter", string);
            backCtx.addControllerImport(modelId, oscarQueryDTO.getImportInfo());
            backCtx.addServiceImport(modelId, oscarQueryDTO.getImportInfo());
            backCtx.addServiceImplImport(modelId, oscarQueryDTO.getImportInfo());
        } else {
            for (OscarQueryFieldDTO dto : oscarFlowDataModelDTO.getQueryDtoMap().get(oscarFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME).getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                params.put("incrementTable", dto.getDbColumnType());
                break;
            }
            params.put("parameter", oscarFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME);
        }
    }

    private static void addIncrementTable(OscarMsDataModelDTO dataModelBaseDTO, Map<String, Boolean> slaveTablePlusSave, OscarMsDataModel dataModelBase) {
        OscarQueryDTO queryDTO = new OscarQueryDTO();
        String masterId = dataModelBase.getMasterTable().getId();
        queryDTO.setFtlPath("template/oscar/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", dataModelBaseDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", OscarMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelBaseDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setName(dataModelBaseDTO.getName() + "IncrementTable");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "IncrementTable");
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }
}

