/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.base;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.render.OscarBaseRender;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARBASEDeleteBatch")
public class OscarDeleteListCodeVisitor
implements OscarOperationVisitor<OscarBaseDataModel, OscarBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarDeleteListCodeVisitor.class);
    public static final String OPERATION_NAME = "OSCARBASEDeleteBatch";

    @Override
    public void visit(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        OscarBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        OscarDataModelFieldDto keyFieldDto = dataModelBaseDTO.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            logger.error("\u6a21\u578b\u672a\u8bbe\u7f6e\u4e3b\u952e");
            return;
        }
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        String controllerPath = "template/oscar/backcode/deletelist/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/oscar/backcode/deletelist/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/oscar/backcode/deletelist/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5220\u9664");
        backCtx.addApi(modelId, OscarBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, String modelId, OscarBaseDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "java.util.Arrays");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
    }

    private Map<String, Object> initParams(OscarDataModelOperation dataModelOperation, OscarBaseDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u6279\u91cf\u7269\u7406\u5220\u9664");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }
}

