/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.element.base;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.IndexInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.index.OscarDataModelIndex;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class OscarBaseConnector {
    public static TableInfoDto tableInfoInEdit(SysDataSource sysDataSource, OscarDataModelBase dataModel) {
        TableInfoDto tableDto = new TableInfoDto();
        tableDto.setTableName(dataModel.getSourceDataModelName());
        tableDto.setPollName(dataModel.getDataSourceName());
        tableDto.setTableAlias(dataModel.getName());
        tableDto.setDatasourceId(sysDataSource.getId());
        tableDto.setColumnList(OscarBaseConnector.transfer(dataModel.getFields()));
        return tableDto;
    }

    public static TableInfoDto tableInfoInCreate(SysDataSource sysDataSource, OscarDataModelBase dataModel) {
        TableInfoDto tableDto = OscarBaseConnector.tableInfoInEdit(sysDataSource, dataModel);
        tableDto.setTableDec(dataModel.getTableDesc());
        return tableDto;
    }

    public static List<ColumnInfoDto> transferColumn(List<OscarDataModelField> fields, String updateType) {
        ArrayList<ColumnInfoDto> columns = new ArrayList<ColumnInfoDto>();
        for (OscarDataModelField x : fields) {
            MetadataColumn metadataColumn = OscarBaseConnector.getMetadataColumn(x);
            ColumnInfoDto columnInfoDto = (ColumnInfoDto)BeanUtil.copyProperties((Object)metadataColumn, ColumnInfoDto.class);
            String isPk = "primary".equals(x.getUsage()) ? "1" : "0";
            String isRequired = x.getDataIsEmpty() ? "1" : "0";
            columnInfoDto.setPk(isPk);
            columnInfoDto.setIncrease("0");
            columnInfoDto.setRequired(isRequired);
            if (ToolUtil.isNotEmpty((Object)updateType)) {
                columnInfoDto.setOperation(updateType);
            }
            columns.add(columnInfoDto);
        }
        return columns;
    }

    public static List<IndexInfoDto> transferIndex(List<OscarDataModelIndex> indexes) {
        ArrayList<IndexInfoDto> indexInfos = new ArrayList<IndexInfoDto>();
        if (indexes != null) {
            for (OscarDataModelIndex index : indexes) {
                IndexInfoDto indexInfoDto = new IndexInfoDto();
                indexInfoDto.setIndexName(index.getIndexName());
                indexInfoDto.setIndexType(index.getIndexType());
                indexInfoDto.setIndexComment(index.getRemark());
                indexInfoDto.setUnique(index.isChkUnique());
                indexInfoDto.setIndexColumn(index.getColumnName());
                indexInfos.add(indexInfoDto);
            }
        }
        return indexInfos;
    }

    private static List<MetadataColumn> transfer(List<OscarDataModelField> fields) {
        ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
        for (OscarDataModelField x : fields) {
            MetadataColumn metadataColumn = OscarBaseConnector.getMetadataColumn(x);
            columns.add(metadataColumn);
        }
        return columns;
    }

    private static MetadataColumn getMetadataColumn(OscarDataModelField modelField) {
        Optional engineColumnType;
        String fieldSourceDataType = modelField.getSourceDataType();
        int preIndex = fieldSourceDataType.indexOf("(");
        String dataType = preIndex > -1 ? fieldSourceDataType.substring(0, preIndex) : modelField.getSourceDataType();
        MetadataColumn metadataColumn = new MetadataColumn();
        metadataColumn.setColumnAlias(modelField.getName());
        metadataColumn.setColumnName(modelField.getSourceFieldName());
        metadataColumn.setColumnComment(modelField.getComment());
        metadataColumn.setDataType(dataType);
        metadataColumn.setDataDot(Integer.valueOf(modelField.getDataDot()));
        metadataColumn.setDataLength(Long.valueOf(modelField.getDataLength()));
        metadataColumn.setDataIsEmpty(Integer.valueOf(modelField.getDataIsEmpty() ? 1 : 0));
        if (ToolUtil.isNotEmpty((Object)modelField.getUsage())) {
            if ("primary".equals(modelField.getUsage())) {
                metadataColumn.setPrimarys("1");
            }
            metadataColumn.setPurpose(modelField.getUsage());
        }
        if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)modelField.getDataType())).isPresent()) {
            metadataColumn.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
            metadataColumn.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        }
        return metadataColumn;
    }
}

