<#assign dto = queryDto>
package ${dto.packageInfo!};

<#list dto.imports! as import>
import ${import};
</#list>
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import java.util.List;

/**
* ${dto.comment!}数据集
*/
public class ${dto.entityName!} implements BaseEntity{

private static final long serialVersionUID = 1L;

<#list dto.groupsInterfaces! as interface>
public interface ${interface}{}
</#list>
<#--使用的是getQueryFieldsList将树形的列的所有叶子节点的list-->
<#list dto.queryFieldsList! as field>
<#if field.propertyName !="size" && field.propertyName !="current">
/**
* ${field.comment}
*/
<#if dto.currentAnnotations?? && (dto.currentAnnotations?size>0)>
<#list dto.currentAnnotations[field.propertyName]! as annotation>
${annotation}
</#list>
</#if>
<#if field.children?? && (field.children?size>0)>
<#if field.type == "array">
private ${field.propertyType}<${dto.entityName!}.${field.propertyName!}> ${field.propertyName};
<#elseif field.type == "object">
private ${dto.entityName!}.${field.propertyName!} ${field.propertyName};
</#if>
<#else>
private ${field.propertyType} ${field.propertyName};
</#if>


<#if field.children?? && (field.children?size>0)>
public class ${field.propertyName}{
<#list field.children! as childrenField>
/**
* ${childrenField.comment}
*/
<#if dto.childAnnotations?? && (dto.childAnnotations?size>0)>
    <#list dto.childAnnotations[field.propertyName][childrenField.propertyName]! as annotation>
        ${annotation}
    </#list>
</#if>
private ${childrenField.propertyType} ${childrenField.propertyName};
</#list>

<#list field.children! as childrenField>
<#assign getprefix="get">
<#if field.propertyType == "Boolean">
    <#assign getprefix="is">
</#if>
<#if field.children?? && (field.children?size>0)>
    public ${childrenField.propertyType} ${getprefix}${childrenField.capitalName}() {
    return ${childrenField.propertyName};
    }

    public void set${childrenField.capitalName}(${childrenField.propertyType} ${childrenField.propertyName}) {
    this.${childrenField.propertyName} = ${childrenField.propertyName};
    }
</#if>
</#list>
}

</#if>
</#if>

</#list>

/**
* 当前页
*/
private int current;

/**
* 每页显示数
*/
private int size;

/**
* 排序列及类型
*/
private List
<OrderItem> orders;

/**
* 数据展示in条件
*/
private String inValues;

<#list dto.queryFieldsList! as field>
<#assign getprefix="get">
<#if field.propertyType == "Boolean">
<#assign getprefix="is">
</#if>
<#if field.children?? && (field.children?size>0)>
<#if field.type == "array">
public ${field.propertyType}<${dto.entityName!}.${field.propertyName!}> ${getprefix}${field.capitalName}() {
return ${field.propertyName};
}

public void set${field.capitalName}(${field.propertyType}<${dto.entityName!}.${field.propertyName!}> ${field.propertyName}) {
this.${field.propertyName} = ${field.propertyName};
}
<#elseif field.type == "object">
public ${dto.entityName!}.${field.propertyName!} ${getprefix}${field.capitalName}() {
return ${field.propertyName};
}

public void set${field.capitalName}(${dto.entityName!}.${field.propertyName!} ${field.propertyName}) {
this.${field.propertyName} = ${field.propertyName};
}
</#if>
<#elseif  field.propertyName !="size" && field.propertyName !="current">
public ${field.propertyType} ${getprefix}${field.capitalName}() {
return ${field.propertyName};
}

public void set${field.capitalName}(${field.propertyType} ${field.propertyName}) {
this.${field.propertyName} = ${field.propertyName};
}
</#if>


</#list>
public int getCurrent() {
return current;
}

public void setCurrent(int current) {
this.current = current;
}

public int getSize() {
return size;
}

public void setSize(int size) {
this.size = size;
}

public List
<OrderItem> getOrders() {
return orders;
}

public void setOrders(List
<OrderItem> orders) {
this.orders = orders;
}

public String getInValues() {
return this.inValues;
}

public void setInValues(String inValues) {
this.inValues = inValues;
}

@Override
public String toString() {
return "${dto.enName}{" +
<#list dto.queryFieldsList! as field>
<#if field_index == 0>
    "${field.propertyName}=" + ${field.propertyName} +
<#else>
    ", ${field.propertyName}=" + ${field.propertyName} +
</#if>
</#list>
"}";
}

}
