package ${table.packageInfo.Entity!};

<#assign entity = table.entityGenerateInfo!>
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import org.apache.ibatis.type.Alias;
<#list entity.imports! as import>
import ${import};
</#list>
<#if existDate?? && existDate>
    import org.apache.ibatis.type.JdbcType;
</#if>

/**
* ${table.comment!}实体类
*/
@Alias("${entity.qualifyBeanName!}")
<#if table.sourceDataModelName?? && table.sourceDataModelName != ''>
@TableName("${table.sourceDataModelName!}")
</#if>
public class ${table.entityName!} implements BaseEntity{

    private static final long serialVersionUID = 1L;

<#assign keyPropertyName = "">
<#list table.fields! as field>
    /**
    * ${field.comment}
    */
<#if table.useMybatisPlus && "" != field.name>
    <#if field.keyFlag>
        <#assign keyPropertyName= field.propertyName>
    @TableId("${field.name ? upper_case}")
    <#else >
    @TableField(
        <#if field.type == "date">value=</#if>"${field.name ? upper_case}"
        <#if field.type == "date">,jdbcType = JdbcType.DATETIMEOFFSET, updateStrategy = FieldStrategy.IGNORED</#if>
    )
    </#if>
</#if>
    <#if table.validateAnnotations?? && (table.validateAnnotations?size>0)>
        <#list table.validateAnnotations[field.propertyName]! as annotation>
            ${annotation}
        </#list>
    </#if>
    private ${field.propertyType} ${field.propertyName};

</#list>

<#list table.fields! as field>
    <#assign getprefix="get">
    <#if field.propertyType == "Boolean">
        <#assign getprefix="is">
    </#if>
    public ${field.propertyType} ${getprefix}${field.capitalName!}() {
        return ${field.propertyName};
    }

    public void set${field.capitalName!}(${field.propertyType} ${field.propertyName}) {
        this.${field.propertyName} = ${field.propertyName};
    }

</#list>
<#--<#if table.useMybatisPlus>
    @Override
    public Serializable pkVal() {
    <#if keyPropertyName != "">
        return this.${keyPropertyName};
    <#else>
        return null;
    </#if>
    }
</#if>-->

    @Override
    public String toString() {
    return "${table.enName}{" +
    <#list table.fields! as field>
        <#if field_index == 0>
            "${field.propertyName}=" + ${field.propertyName} +
        <#else>
            ", ${field.propertyName}=" + ${field.propertyName} +
        </#if>
    </#list>
    "}";
    }
}
