/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.processor;

import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.OscarCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarModelFunction;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarRender;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortConditionField;
import com.jxdinfo.hussar.formdesign.oscar.result.OscarCodeResult;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OscarModelProcessor
implements DataModelProcessor<OscarCodeResult> {
    private static Logger logger = LoggerFactory.getLogger(OscarModelProcessor.class);

    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"OSCAR", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<OscarCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx = this.getOscarBackCtx(publishCtx);
        OscarModelProcessor.init(backCtx, dataModelBase);
        OscarModelProcessor.generateSingleModel(backCtx, publishCtx);
        publishCtx.setPublishDTO(backCtx.getPublishDTO());
    }

    private OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> getOscarBackCtx(PublishCtx<OscarCodeResult> publishCtx) {
        OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx = new OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO>();
        if (publishCtx.getParams() != null) {
            backCtx.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            backCtx.setBaseFile(publishCtx.getBaseFile());
        }
        return backCtx;
    }

    public static void init(OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx, DataModelBase dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        String modelId = dataModelBase.getId();
        OscarModelFunction currentFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        OscarDataModelBase currentModelBase = OscarDataModelUtil.transfer(dataModelBase);
        List<OscarSortCondition> sortConditions = currentModelBase.getSortCondition();
        if (HussarUtils.isNotEmpty(sortConditions)) {
            for (OscarSortCondition sortCondition : sortConditions) {
                List<OscarSortConditionField> sortConditionFields = sortCondition.getFields();
                for (OscarSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName();
                }
            }
        }
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, OscarDataModelBaseDTO> useDtoMap = new HashMap<String, OscarDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateSingleModel(OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx, PublishCtx<OscarCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        OscarModelProcessor.visit(backCtx);
        OscarModelProcessor.render(backCtx, publishCtx);
    }

    public static void visit(OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        OscarDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        OscarDataModelBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        for (OscarDataModelOperation operation : useDataModelBase.getOperations()) {
            OscarOperationVisitor<OscarDataModelBase, OscarDataModelBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().vistor("OSCAR", backCtx.getModelFunctionTye(), operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            backCtx.getModelFunction().accept(visitor, backCtx, operation);
            if (!backCtx.getUseDataModelBase().getIsPublishResource()) continue;
            backCtx.addApiResources(ApiResourceAcceptor.of((String)useDataModelBase.getId(), (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
    }

    public static void render(OscarBackCtx<OscarDataModelBase, OscarDataModelBaseDTO> backCtx, PublishCtx<OscarCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        OscarRender<OscarDataModelBase, OscarDataModelBaseDTO> render = backCtx.getModelFunction().render();
        List<OscarCodeGenerateInfo> codeGenerateInfos = render.renderCode(backCtx);
        publishCtx.addCodeResults(OscarCodeMergeUtil.mergeBack(codeGenerateInfos, backCtx));
    }
}

