/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.visitor.constant.OscarConstUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARMASTER_SLAVEFormSave")
public class OscarMsFormSaveVisitor
implements OscarOperationVisitor<OscarMsDataModel, OscarMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsFormSaveVisitor.class);
    public static final String OPERATION_NAME = "OSCARMASTER_SLAVEFormSave";

    @Override
    public void visit(OscarBackCtx<OscarMsDataModel, OscarMsDataModelDTO> backCtx, OscarDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        OscarMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        OscarMsDataModelDTO oscarMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = oscarMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        OscarDataModelFieldDto keyField = oscarMsDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", oscarMsDataModelDTO);
        controllerParams.put("returnValue", oscarMsDataModelDTO.getEntityName());
        controllerParams.put("url", url);
        OscarDataModelBaseDTO masterBaseDto = oscarMsDataModelDTO.getDataModelDtoMap().get(dataModelBase.getMasterTable().getId());
        controllerParams.put("masterTable", masterBaseDto);
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(oscarMsDataModelDTO.getComment() + "\u65b0\u589e\u6216\u4fee\u6539");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/oscar/masterslavebackcode/addorupdate/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, oscarMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, oscarMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerInversion(modelId, oscarMsDataModelDTO.getServiceName());
        String servicePath = "template/oscar/masterslavebackcode/addorupdate/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        this.masterSlaveCode(backCtx, controllerParams);
        controllerParams.put("primaryField", keyField.getCapitalName());
        String serviceImplPath = "template/oscar/masterslavebackcode/addorupdate/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", url, "\u65b0\u589e\u6216\u4fee\u6539");
        backCtx.addApi(modelId, OscarBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void masterSlaveCode(OscarBackCtx<OscarMsDataModel, OscarMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        OscarMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        OscarMsDataModelDTO oscarMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<OscarRelationshipDTO> relationshipDtoList = oscarMsDataModelDTO.getRelationshipDtoList();
        OscarDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, OscarDataModelBaseDTO> dataModelDtoMap = oscarMsDataModelDTO.getDataModelDtoMap();
        OscarDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(mainDataModelDto, oscarMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            for (OscarRelationshipDTO oscarRelationshipDTO : relationshipDtoList) {
                List<OscarRelationshipFieldDTO> oscarRelationshipFieldDTOS;
                String slaveTableId = oscarRelationshipDTO.getSlaveTableId();
                String relateModelType = oscarRelationshipDTO.getRelateModelType();
                OscarDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(slaveModelDto, oscarMsDataModelDTO, false, mainDataModelDto);
                if (slaveFillCode != null) {
                    oscarRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(oscarRelationshipFieldDTOS = oscarRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private String renderFillCode(OscarDataModelBaseDTO dataModelBaseDTO, OscarMsDataModelDTO msDataModelDTO, boolean isMs, OscarDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (OscarDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": 
                case "companyId": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", OscarConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", OscarConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", OscarConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/oscar/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }
}

