/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.visitor.constant.OscarConstUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARFLOW_MASTER_SLAVEFormQuery")
public class OscarMsFlowFormQueryVisitor
implements OscarOperationVisitor<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsFlowFormQueryVisitor.class);
    public static final String OPERATION_NAME = "OSCARFLOW_MASTER_SLAVEFormQuery";

    @Override
    public void visit(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, OscarDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        OscarFlowMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        OscarFlowMsDataModelDTO oscarFlowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = oscarFlowMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, OscarDataModelBase> dataModelBaseMap = oscarFlowMsDataModelDTO.getDataModelBaseMap();
        Map<String, OscarDataModelBaseDTO> dataModelDtoMap = oscarFlowMsDataModelDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", oscarFlowMsDataModelDTO);
        controllerParams.put("returnValue", oscarFlowMsDataModelDTO.getEntityName());
        controllerParams.put("url", url);
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(oscarFlowMsDataModelDTO.getComment() + "\u8868\u5355\u67e5\u8be2");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/oscar/masterslavebackcode/get/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, oscarFlowMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, oscarFlowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(modelId, oscarFlowMsDataModelDTO.getServiceName());
        String servicePath = "template/oscar/masterslavebackcode/get/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, oscarFlowMsDataModelDTO.getImportInfo().get("Entity"));
        String serviceImplPath = "template/oscar/masterslavebackcode/get/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, oscarFlowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImplImport(modelId, oscarFlowMsDataModelDTO.getImportInfo().get("Mapper"));
        backCtx.addServiceImplInversion(modelId, oscarFlowMsDataModelDTO.getMapperName());
        String mapperPath = "template/oscar/masterslavebackcode/get/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, oscarFlowMsDataModelDTO.getImportInfo().get("Entity"));
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        String finalReturn = SqlReturnUtil.renderReturn(dataModelBase, aliasMap);
        controllerParams.put("return", finalReturn);
        String finalRelation = SqlReturnUtil.renderRelation(dataModelBase, dataModelBaseMap);
        controllerParams.put("relation", finalRelation);
        controllerParams.put("quoteModel", OscarConstUtil.TRUE);
        String whereTemplate = "where ${T}.${primary} = #{id}";
        String masterTableId = dataModelBase.getMasterTable().getId();
        OscarDataModelBaseDTO oscarDataModelBaseDTO = dataModelDtoMap.get(masterTableId);
        if (ToolUtil.isNotEmpty((Object)oscarDataModelBaseDTO)) {
            controllerParams.put("whereSql", whereTemplate.replace("${T}", aliasMap.get(masterTableId)).replace("${primary}", oscarDataModelBaseDTO.getKeyField().getName()));
        }
        if (ToolUtil.isNotEmpty((Object)controllerParams.get("customizeSql"))) {
            backCtx.addXmlCode(modelId, (String)controllerParams.get("customizeSql"));
        } else {
            String xmlPath = "template/oscar/masterslavebackcode/get/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "get", url, "\u8868\u5355\u67e5\u8be2");
        backCtx.addApi(modelId, OscarBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

