/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.flow.masterslaveflow;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARFLOW_MASTER_SLAVEAsyncVerify")
public class OscarMsFlowAsyncVerifyVisitor
implements OscarOperationVisitor<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsFlowAsyncVerifyVisitor.class);
    public static final String OPERATION_NAME = "OSCARFLOW_MASTER_SLAVEAsyncVerify";

    @Override
    public void visit(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        OscarFlowMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = backCtx.getUseDataModelBase().getId();
        OscarFlowMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        HashMap<String, Object> controllerParams = new HashMap<String, Object>();
        controllerParams.put("name", dataModelOperation.getName());
        if (ToolUtil.isNotEmpty((Object)dataModelOperation.getExegesis())) {
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        } else {
            controllerParams.put("exegesis", dataModelBaseDTO.getComment() + "\u5f02\u6b65\u6821\u9a8c");
        }
        controllerParams.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        String controllerPath = "template/oscar/flowbackcode/masterslaveflowbackcode/asyncverify/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/oscar/flowbackcode/masterslaveflowbackcode/asyncverify/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/oscar/flowbackcode/masterslaveflowbackcode/asyncverify/service_impl.ftl";
        ArrayList<JSONObject> columnList = new ArrayList<JSONObject>();
        ArrayList<OscarBaseDataModel> allModel = new ArrayList<OscarBaseDataModel>();
        String masterTableId = useDataModelBase.getMasterTable().getId();
        allModel.add((OscarBaseDataModel)useDataModelBase.getMasterTable());
        List<OscarDataModelBase> slaveTables = useDataModelBase.getSlaveTables();
        for (OscarRelationshipBase relationship : useDataModelBase.getRelationships()) {
            if (!"association".equals(relationship.getRelateModelType())) continue;
            for (OscarDataModelBase slaveTable : slaveTables) {
                if (!slaveTable.getId().equals(relationship.getSlaveTableId())) continue;
                allModel.add((OscarBaseDataModel)slaveTable);
            }
        }
        for (OscarBaseDataModel oscarDataModelBase : allModel) {
            OscarDataModelBaseDTO oscarDataModelDTO = dataModelBaseDTO.getDataModelDtoMap().get(oscarDataModelBase.getId());
            boolean isMasterTable = oscarDataModelBase.getId().equals(masterTableId);
            List<OscarDataModelFieldDto> modelDtoFields = oscarDataModelDTO.getFields();
            String getPrimaryMethod = "";
            if (isMasterTable) {
                for (OscarDataModelFieldDto field : modelDtoFields) {
                    if (!field.isKeyFlag()) continue;
                    getPrimaryMethod = "Boolean".equals(field.getPropertyType()) ? "is" + field.getCapitalName() : "get" + field.getCapitalName();
                    break;
                }
            } else {
                for (OscarDataModelFieldDto field : modelDtoFields) {
                    if (!"foreign".equals(field.getFill())) continue;
                    getPrimaryMethod = "Boolean".equals(field.getPropertyType()) ? "is" + field.getCapitalName() : "get" + field.getCapitalName();
                    break;
                }
            }
            boolean logicallyFlag = false;
            OscarDataModelField logicallyField = oscarDataModelBase.getDeleteFlag();
            if (ToolUtil.isNotEmpty((Object)((Object)logicallyField))) {
                logicallyFlag = true;
            }
            String flagFieldName = "";
            if (logicallyFlag) {
                for (OscarDataModelFieldDto field : modelDtoFields) {
                    if (!field.getId().equals(logicallyField.getId())) continue;
                    flagFieldName = field.getCapitalName();
                    break;
                }
            }
            String serviceName = oscarDataModelDTO.getServiceEnName();
            List<OscarDataModelField> modelTableFields = oscarDataModelBase.getFields();
            boolean flag = false;
            for (OscarDataModelField modelTableField : modelTableFields) {
                if (!ToolUtil.isNotEmpty((Object)((Object)modelTableField)) || !modelTableField.isChkUnique()) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("columnName", (Object)modelTableField.getName());
                ArrayList<JSONObject> rulesList = new ArrayList<JSONObject>();
                if (modelTableField.isChkUnique()) {
                    flag = true;
                    JSONObject obj = new JSONObject();
                    obj.put("type", (Object)"unique");
                    obj.put("sourceFieldName", (Object)modelTableField.getSourceFieldName());
                    obj.put("errorMsg", (Object)(modelTableField.getName() + "\u5217\u552f\u4e00\u503c\u6821\u9a8c\u672a\u901a\u8fc7"));
                    obj.put("entityName", (Object)oscarDataModelDTO.getEntityName());
                    obj.put("getPrimaryMethod", (Object)getPrimaryMethod);
                    obj.put("serviceName", (Object)serviceName);
                    obj.put("logicallyDelete", (Object)logicallyFlag);
                    obj.put("logicallyFlag", (Object)flagFieldName);
                    Map<String, Object> params = dataModelOperation.getParams();
                    List asyncVerifyParams = (List)params.get("asyncVerifyParams");
                    for (JSONObject asyncVerifyParam : asyncVerifyParams) {
                        if (!ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"columnId")) || !asyncVerifyParam.get((Object)"columnId").equals(modelTableField.getId()) || !ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"rules"))) continue;
                        List paramRules = (List)asyncVerifyParam.get((Object)"rules");
                        for (JSONObject paramRule : paramRules) {
                            if (!ToolUtil.isNotEmpty((Object)paramRule) || !ToolUtil.isNotEmpty((Object)paramRule.get((Object)"ruleType")) || !"unique".equals(paramRule.get((Object)"ruleType"))) continue;
                            obj.put("errorMsg", paramRule.get((Object)"errorMsg"));
                        }
                    }
                    rulesList.add(obj);
                }
                jsonObject.put("rules", rulesList);
                columnList.add(jsonObject);
            }
            if (!flag) continue;
            backCtx.addServiceImplImport(modelId, oscarDataModelDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplImport(modelId, oscarDataModelDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplInversion(modelId, oscarDataModelDTO.getServiceName());
        }
        controllerParams.put("columnList", columnList);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5f02\u6b65\u6821\u9a8c");
        backCtx.addApi(modelId, OscarBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, String modelId, OscarFlowMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
    }
}

