/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARFLOWFlowTableDeleteBatch")
public class OscarFlowDeleteListCodeVisitor
implements OscarOperationVisitor<OscarFlowDataModel, OscarFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarFlowDeleteListCodeVisitor.class);
    public static final String OPERATION_NAME = "OSCARFLOWFlowTableDeleteBatch";

    @Override
    public void visit(OscarBackCtx<OscarFlowDataModel, OscarFlowDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation) throws LcdpException, IOException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        OscarFlowDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        OscarDataModelFieldDto keyField = useDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> params = this.initParams(dataModelOperation, useDataModelDTO);
        this.renderImport(backCtx, modelId, useDataModelDTO);
        String controllerPath = "template/oscar/flowbackcode/baseflowbackcode/deletebatch/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, params));
        backCtx.addControllerInversion(modelId, useDataModelDTO.getServiceName());
        String servicePath = "template/oscar/flowbackcode/baseflowbackcode/deletebatch/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, params));
        String serviceImplPath = "template/oscar/flowbackcode/baseflowbackcode/deletebatch/service_impl.ftl";
        backCtx.addServiceImplInversion(modelId, "StandardInstanceEngineApiService");
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, params));
        ApiGenerateInfo deleteStart = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postForm", useDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6d41\u7a0b\u5217\u8868\u6279\u91cf\u5220\u9664");
        backCtx.addApi(modelId, OscarBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", deleteStart));
    }

    private void renderImport(OscarBackCtx<OscarFlowDataModel, OscarFlowDataModelDTO> backCtx, String modelId, OscarFlowDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "org.springframework.aop.framework.AopContext");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.constant.BpmConstant");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.upgrade.StandardInstanceEngineApiService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstBatchDeleteDto");
    }

    private Map<String, Object> initParams(OscarDataModelOperation dataModelOperation, OscarFlowDataModelDTO flowDataModelDTO) {
        Map<String, Object> params = dataModelOperation.getParams();
        params.put("flowDatasourceName", OscarDataSourceUtil.getDefaultDataSourceName());
        params.put("table", flowDataModelDTO);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(flowDataModelDTO.getComment() + "\u6d41\u7a0b\u5217\u8868\u6279\u91cf\u7269\u7406\u5220\u9664");
            params.put("exegesis", dataModelOperation.getExegesis());
        }
        return params;
    }
}

