/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.enclosure;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarEnclosure;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarPublicEnclosure;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARFLOWENCLOSURE")
public class OscarFlowEnclosure
implements OscarEnclosure<OscarFlowDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(OscarFlowEnclosure.class);
    public static final String ENCLOSURE = "OSCARFLOWENCLOSURE";

    @Override
    public OscarDataModelBaseDTO enclosure(OscarFlowDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        List<OscarDataModelField> dataModelFieldBases;
        OscarFlowDataModelDTO dataModelBaseDTO = new OscarFlowDataModelDTO();
        dataModelBaseDTO.setUseMybatisPlus(true);
        OscarPublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        if (dataModelBase.getSourceDataModelName() != null) {
            dataModelBaseDTO.setSourceDataModelName(dataModelBase.getSourceDataModelName());
        }
        if (ToolUtil.isEmpty(dataModelFieldBases = dataModelBase.getFlowFields())) {
            logger.error("enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new OscarFlowDataModelDTO();
        }
        ArrayList<OscarDataModelFieldDto> tableFields = new ArrayList<OscarDataModelFieldDto>();
        for (OscarDataModelField dataModelFieldBase : dataModelFieldBases) {
            OscarDataModelFieldDto tableField = new OscarDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        return dataModelBaseDTO;
    }
}

