/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.function.element.task;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.annotation.BuilderType;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipBase;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.BaseModelBuilder;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.NoCodeBaseDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.task.TaskDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.BuilderTool;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineBuildStrategyEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.builder.BuilderCtx;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.flow.FlowFormVO;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeanUtils;

@BuilderType(type="NO.TASK_BASE")
public class TaskModelBuilder
extends DataModelBuilder {
    private TaskDataModel task;
    private FormSchema form;
    private static final String TASK_PREFIX = "process_task_info_";

    public String strategy() {
        return String.format("%s%s", "NO.", EngineBuildStrategyEnum.TASK_BASE);
    }

    public void init(FormSchema form) {
        this.form = form;
        this.task = new TaskDataModel();
    }

    public TaskDataModel direct() throws IOException {
        return this.buildBusiness().buildTask().buildRelation().buildOperation().build();
    }

    public TaskDataModel build() {
        return this.task;
    }

    public void build(BuilderCtx ctx) throws IOException {
        ctx.setDataModelBase((DataModelBase)this.direct());
    }

    public FieldsContrastParam<DataModelFieldBase> updateContrast() throws IOException, LcdpException {
        return BaseModelBuilder.updateContrast(this.task);
    }

    public FieldsContrastParam<DataModelFieldBase> createContrast() throws IOException, LcdpException {
        FieldsContrastParam contrast = new FieldsContrastParam();
        ArrayList<Object> tableCorresponds = new ArrayList<Object>();
        NoCodeBaseDataModel master = this.task.getTask();
        TableCorrespond<DataModelFieldBase> taskTableCorrespond = BuilderTool.contrast(master);
        taskTableCorrespond.setModelId(master.getId());
        taskTableCorrespond.setOldTableName(master.getSourceDataModelName());
        tableCorresponds.add(taskTableCorrespond);
        tableCorresponds.add(this.updateContrast().getTableCorresponds().get(0));
        contrast.setTableCorresponds(tableCorresponds);
        contrast.setModelId(this.task.getId());
        return contrast;
    }

    public FlowFormVO getFlowFormVO() {
        FlowFormVO flowFormVO = new FlowFormVO();
        flowFormVO.setMasterTableName(this.task.getSourceDataModelName());
        flowFormVO.setTaskTableName(this.task.getTask().getSourceDataModelName());
        flowFormVO.setMasterTablePrimary(this.primary().getSourceFieldName());
        flowFormVO.setIdentity(this.form.getIdentity());
        flowFormVO.setFormPath("");
        return flowFormVO;
    }

    public void clearFieldForImport(DataModelBase dataModelBase) {
        TaskDataModel dataModel = (TaskDataModel)dataModelBase;
        List fields = dataModel.getFields();
        for (HeDataModelField field : fields) {
            if (!HussarUtils.isNotEmpty((Object)field.getUsage()) || !WidgetTool.anyMatch((String)field.getUsage(), (String[])new String[]{"createUser", "updateUser", "createTime", "updateTime", "serialNumber", "dataOrgan", "title"})) continue;
            field.setUsage(null);
        }
    }

    public TaskModelBuilder buildTask() {
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        if (HussarUtils.equals((Object)DbType.ORACLE.name(), (Object)dbType)) {
            this.task.setTask(TaskModelBuilder.task(this.form.getFormCanvas(), "/task/process_task_info_oracle.json"));
        } else {
            this.task.setTask(TaskModelBuilder.task(this.form.getFormCanvas(), "/task/process_task_info.json"));
        }
        return this;
    }

    public static NoCodeBaseDataModel task(FormCanvasSchema canvas, String path) {
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        NoCodeBaseDataModel taskField = new NoCodeBaseDataModel();
        taskField.setId(String.format("%s%s", TASK_PREFIX, canvas.getId()));
        taskField.setName(String.format("%s%s", TASK_PREFIX, canvas.getName()));
        taskField.setComment(String.format("%s-%s", canvas.getTitle(), "\u4efb\u52a1\u8868"));
        taskField.setDataSourceName(NoCodeBusinessDB.getNocodeBusinessDB());
        taskField.setTableDesc(taskField.getComment());
        taskField.setFunctionType("BASE");
        if (HussarUtils.isNotEmpty((Object)canvas.getCreateSource()) && "1".equals(canvas.getCreateSource())) {
            taskField.setSourceDataModelName(taskField.getName());
        } else {
            taskField.setSourceDataModelName(BaseModelBuilder.sourceDataModelName(taskField.getName()));
        }
        taskField.setCreateSource(canvas.getCreateSource());
        taskField.setNocode(true);
        String content = ToolUtil.loadResource(TaskModelBuilder.class, (String)path);
        List fields = JSON.parseArray((String)content, HeDataModelField.class);
        fields.forEach(f -> f.setSourceDataModelId(taskField.getId()));
        taskField.setFields(fields);
        return taskField;
    }

    public TaskModelBuilder buildBusiness() throws IOException {
        BaseModelBuilder builder = new BaseModelBuilder();
        builder.init(this.form);
        NoCodeBaseDataModel base = builder.buildBase().buildFields().buildDataTitle().buildDataSummary().buildSerialNumber().build();
        String content = "";
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        content = HussarUtils.equals((Object)DbType.ORACLE.name(), (Object)dbType) ? ToolUtil.loadResource(((Object)((Object)this)).getClass(), (String)"/task/process_info_oracle.json") : PageBuilderFactory.getTaskProcessInfo();
        List fields = JSON.parseArray((String)content, HeDataModelField.class);
        List fieldAll = base.getFields();
        HashMap<String, HeDataModelField> fieldMap = new HashMap<String, HeDataModelField>();
        for (HeDataModelField heDataModelField : fieldAll) {
            fieldMap.put(heDataModelField.getName(), heDataModelField);
        }
        for (HeDataModelField field : fields) {
            if (HussarUtils.isEmpty(fieldMap.get(field.getName()))) {
                fieldAll.add(field);
                continue;
            }
            ((HeDataModelField)fieldMap.get(field.getName())).setUsage(field.getUsage());
        }
        base.getFields().forEach(f -> f.setSourceDataModelId(base.getId()));
        BeanUtils.copyProperties((Object)((Object)base), (Object)((Object)this.task));
        this.task.setFunctionType("TASK");
        this.task.setProcessKey(this.form.getFormCanvas().getIdentity());
        return this;
    }

    public TaskModelBuilder buildRelation() {
        HeRelationshipBase relationshipBase = new HeRelationshipBase();
        ArrayList<HeRelationshipFieldBase> relationships = new ArrayList<HeRelationshipFieldBase>();
        relationshipBase.setCascadeDelete(false);
        relationshipBase.setCascadeUpdate(false);
        relationshipBase.setRelateModelType("association");
        HeRelationshipFieldBase fieldBase = new HeRelationshipFieldBase();
        fieldBase.setMode("model");
        fieldBase.setSymbol(SqlConnectEnum._EQUAL.getValue());
        fieldBase.setConnect(ConnectEnum._AND.getType());
        relationshipBase.setMasterTableId(this.task.getTask().getId());
        relationshipBase.setSlaveTableId(this.task.getId());
        relationshipBase.setSlaveTableName(this.task.getName());
        fieldBase.setMasterTableFieldId(this.task.getTask().getFields().stream().filter(field -> "foreign".equals(field.getUsage())).findFirst().orElseGet(HeDataModelField::new).getId());
        fieldBase.setSlaveTableFieldId(this.primary().getId());
        relationships.add(fieldBase);
        relationshipBase.setRelationships(relationships);
        this.task.setRelationship(relationshipBase);
        return this;
    }

    private HeDataModelField primary() {
        return this.task.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElseGet(HeDataModelField::new);
    }

    public TaskModelBuilder buildOperation() {
        if (HussarUtils.isEmpty((Object)this.task.getOperations())) {
            ArrayList operations = new ArrayList();
            this.task.setOperations(operations);
        }
        BuilderTool.buildOperation(this.task, this.form, "TableQuery").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "FormQuery").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "FormVerify").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "DeleteBatch").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "FlagDeleteBatch").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "FormSave").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "TableSave").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "EndProcess").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "FlowFormRecall").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "FlowFormSubmit").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "InitialNodeReject").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "PrevNodeReject").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "AnyNodeReject").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "FlowSubmitReject").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "FlowRejectBatch").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "FlowSubmitBatch").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "AddOrDelAssignee").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "FreeJump").ifPresent(ops -> this.task.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.task, this.form, "TaskEntrust").ifPresent(ops -> this.task.getOperations().addAll(ops));
        List widgets = this.form.getFormCanvas().widgets();
        Optional<Widget> first = widgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.JXDNSerialNumber.getType())).findFirst();
        if (first.isPresent()) {
            BuilderTool.buildOperation(this.task, this.form, "SelectCount").ifPresent(ops -> this.task.getOperations().addAll(ops));
        }
        return this;
    }
}

