/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.function.element.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormCreateTypeEnum;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.common.annotation.BuilderType;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.BaseModelBuilder;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.EngineBaseModelBuilder;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.task.TaskModelBuilder;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineOperationType;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineTypeStrategyEnum;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.EngineDataModelBuilder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelIndexDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

@BuilderType(type="10")
public class EngineTaskModelBuilder
extends EngineDataModelBuilder {
    private ModelInfoDto model;
    private FormSchema form;
    private static final String MYSQL = "MYSQL";
    private static final String ORACLE = "ORACLE";

    public String strategy() {
        return EngineTypeStrategyEnum.TASK_BASE.getType();
    }

    public void init(FormSchema form) {
        this.form = form;
        this.model = new ModelInfoDto();
    }

    public ModelInfoDto direct(String operationType, FormSchema oldCanvas) throws Exception {
        return this.flowBuildBase(operationType, oldCanvas).buildMsBusiness(operationType, oldCanvas).build();
    }

    private EngineTaskModelBuilder buildMsBusiness(String operationType, FormSchema oldCanvas) throws Exception {
        EngineBaseModelBuilder baseModelBuilder = new EngineBaseModelBuilder();
        baseModelBuilder.init(this.form);
        ModelInfoDto modelInfoDto = baseModelBuilder.buildBase(operationType, oldCanvas).buildFields(oldCanvas).build();
        modelInfoDto.getFieldList().addAll(this.getFlowColumnField());
        baseModelBuilder.setModel(modelInfoDto);
        modelInfoDto.setType(this.model.getType());
        baseModelBuilder.buildDataTitle(oldCanvas).buildDataSummary(oldCanvas).buildSerialNumber(oldCanvas).contrast(oldCanvas).build();
        if (CollectionUtils.isEmpty((Collection)modelInfoDto.getIndexList())) {
            modelInfoDto.setIndexList((List)Lists.newArrayListWithExpectedSize((int)0));
        }
        ArrayList children = Lists.newArrayListWithExpectedSize((int)1);
        children.add(modelInfoDto);
        this.model.setChildren((List)children);
        return this;
    }

    public EngineTaskModelBuilder flowBuildBase(String operationType, FormSchema oldCanvas) throws IOException, LcdpException {
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        FormCanvasSchema formCanvas = this.form.getFormCanvas();
        this.model.setModelId("process_task_info_" + formCanvas.getId());
        String modelNameCompatible = "process_task_info_" + formCanvas.getName();
        String modelName = "";
        modelName = HussarUtils.equals((Object)DbType.ORACLE.name(), (Object)dbType) ? "TASK_" + formCanvas.getName() : "PROCESS_TASK_INFO_" + formCanvas.getName();
        this.model.setModelName(BaseModelBuilder.sourceDataModelName(modelName));
        this.model.setModelDec(formCanvas.getTitle() + "\u4efb\u52a1\u8868");
        String dataSourceName = DataModelUtil.currentDsName();
        this.model.setDatasourceId(DataModelUtil.getDataSourceConfigByName((String)dataSourceName).getId());
        this.model.setPollName(dataSourceName);
        if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(formCanvas.getCreateSource())) {
            this.model.setSourceModelId(String.valueOf(formCanvas.getSourceFormId()));
        }
        Optional tableInfo = DataModelUtil.filterTable((String)this.model.getPollName(), (String)"BASE TABLE", (String)this.model.getModelName());
        Optional tableInfoCompatible = DataModelUtil.filterTable((String)this.model.getPollName(), (String)"BASE TABLE", (String)modelNameCompatible);
        if (tableInfo.isPresent()) {
            this.model.setTableName(((TableInfo)tableInfo.get()).getName());
        } else if (tableInfoCompatible.isPresent()) {
            this.model.setTableName(((TableInfo)tableInfoCompatible.get()).getName());
        } else {
            this.model.setTableName(this.model.getModelName());
        }
        if (HussarUtils.isNotEmpty((Object)oldCanvas) && !this.form.getFormCanvas().getFormType().equals(oldCanvas.getFormCanvas().getFormType())) {
            if (tableInfo.isPresent()) {
                this.model.setOperationType(EngineOperationType.UPDATE.getOperationType());
            } else if (tableInfoCompatible.isPresent()) {
                this.model.setOperationType(EngineOperationType.UPDATE.getOperationType());
            } else {
                this.model.setOperationType(operationType);
            }
        } else {
            this.model.setOperationType(operationType);
        }
        if (tableInfo.isPresent() || tableInfoCompatible.isPresent()) {
            this.model.setSyncToTable(false);
        } else {
            this.model.setIndexList(this.getFlowTableIndex(operationType));
            this.model.setSyncToTable(true);
        }
        this.model.setType(EngineTypeStrategyEnum.TASK_MASTER_SLAVE.getTypeDesc());
        this.model.setFieldList(this.getFlowTableField(operationType, oldCanvas, tableInfo));
        return this;
    }

    private List<ModelIndexDto> getFlowTableIndex(String operationType) {
        ArrayList indexDtos = Lists.newArrayListWithCapacity((int)5);
        if (EngineOperationType.ADD.getOperationType().equals(operationType)) {
            ModelIndexDto businessIdIndexDto = new ModelIndexDto();
            businessIdIndexDto.setIndexName("INDEX_" + EngineUtil.getId());
            businessIdIndexDto.setIndexField(Arrays.asList("BUSINESS_ID"));
            businessIdIndexDto.setUnique(false);
            businessIdIndexDto.setIndexComment("\u4e1a\u52a1\u4e3b\u952e\u7d22\u5f15");
            businessIdIndexDto.setOperationType(operationType);
            indexDtos.add(businessIdIndexDto);
            ModelIndexDto taskIdIndexDto = new ModelIndexDto();
            taskIdIndexDto.setIndexName("INDEX_" + EngineUtil.getId());
            taskIdIndexDto.setIndexField(Arrays.asList("TASK_ID"));
            taskIdIndexDto.setUnique(false);
            taskIdIndexDto.setIndexComment("\u4efb\u52a1ID\u7d22\u5f15");
            taskIdIndexDto.setOperationType(operationType);
            indexDtos.add(taskIdIndexDto);
        }
        return indexDtos;
    }

    private List<ModelFieldDto> getFlowTableField(String operationType, FormSchema oldCanvas, Optional<TableInfo> tableInfo) {
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        String content = "";
        content = HussarUtils.equals((Object)DbType.ORACLE.name(), (Object)dbType) ? ToolUtil.loadResource(TaskModelBuilder.class, (String)"/task/process_task_info_oracle.json") : ToolUtil.loadResource(TaskModelBuilder.class, (String)"/task/process_task_info.json");
        List fields = JSON.parseArray((String)content, HeDataModelField.class);
        ArrayList modelFields = Lists.newArrayListWithCapacity((int)5);
        for (HeDataModelField jsonField : fields) {
            ModelFieldDto modelField = new ModelFieldDto();
            modelField.setFieldName(jsonField.getName());
            modelField.setFieldComment(jsonField.getComment());
            modelField.setDataIsEmpty(Integer.valueOf(jsonField.getDataIsEmpty() ? 1 : 0));
            modelField.setDefaultValue(jsonField.getDataDefaultValue());
            modelField.setDataLength(Long.valueOf(jsonField.getDataLength()));
            modelField.setDataType(jsonField.getSourceDataType());
            Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)jsonField.getDataType());
            modelField.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
            modelField.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
            modelField.setPurpose(jsonField.getUsage());
            if (HussarUtils.isNotEmpty((Object)oldCanvas) && !this.form.getFormCanvas().getFormType().equals(oldCanvas.getFormCanvas().getFormType())) {
                if (tableInfo.isPresent()) {
                    modelField.setOperationType(EngineOperationType.UPDATE.getOperationType());
                } else {
                    modelField.setOperationType(operationType);
                }
            } else {
                modelField.setOperationType(operationType);
            }
            if (tableInfo.isPresent()) {
                modelField.setSyncToTable(false);
            } else {
                modelField.setSyncToTable(true);
            }
            modelFields.add(modelField);
        }
        return modelFields;
    }

    private List<ModelFieldDto> getFlowColumnField() {
        String content = "";
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        content = HussarUtils.equals((Object)DbType.ORACLE.name(), (Object)dbType) ? ToolUtil.loadResource(((Object)((Object)this)).getClass(), (String)"/task/process_info_oracle.json") : PageBuilderFactory.getTaskProcessInfo();
        List fields = JSON.parseArray((String)content, HeDataModelField.class);
        ArrayList modelFields = Lists.newArrayListWithCapacity((int)5);
        for (HeDataModelField jsonField : fields) {
            ModelFieldDto modelField = new ModelFieldDto();
            modelField.setFieldName(jsonField.getName());
            modelField.setFieldComment(jsonField.getComment());
            modelField.setDataIsEmpty(Integer.valueOf(jsonField.getDataIsEmpty() ? 1 : 0));
            modelField.setDefaultValue(jsonField.getDataDefaultValue());
            modelField.setDataLength(Long.valueOf(jsonField.getDataLength()));
            modelField.setDataType(jsonField.getSourceDataType());
            Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)jsonField.getDataType());
            modelField.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
            modelField.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
            modelField.setPurpose(jsonField.getUsage());
            modelField.setOperationType(EngineOperationType.ADD.getOperationType());
            modelField.setSyncToTable(true);
            modelFields.add(modelField);
        }
        return modelFields;
    }

    public ModelInfoDto build() throws IOException {
        return this.model;
    }
}

