/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleInfo;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormCreateTypeEnum;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.common.annotation.BuilderType;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.BuilderTool;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.EngineHEDataModelUtil;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineOperationType;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineTypeStrategyEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OracleTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleConfig;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.SerialNumSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.EngineDataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.mail.core.collection.CollUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldRulesDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

@BuilderType(type="00")
public class EngineBaseModelBuilder
extends EngineDataModelBuilder {
    private ModelInfoDto model;
    private FormSchema form;
    private static List<String> serialNumberColumn;

    public String strategy() {
        return EngineTypeStrategyEnum.BASE.getType();
    }

    public void init(FormSchema form) {
        this.form = form;
        this.model = new ModelInfoDto();
    }

    public ModelInfoDto direct(String operationType, FormSchema oldCanvas) throws Exception {
        return this.buildBase(operationType, oldCanvas).buildFields(oldCanvas).buildDataTitle(oldCanvas).buildDataSummary(oldCanvas).buildSerialNumber(oldCanvas).contrast(oldCanvas).build();
    }

    public EngineBaseModelBuilder buildSlaves(FormSchema oldCanvas) throws Exception {
        List allWidgets = this.form.getFormCanvas().childTables();
        List oldWidgets = Lists.newArrayListWithCapacity((int)5);
        if (HussarUtils.isNotEmpty((Object)oldCanvas)) {
            oldWidgets = oldCanvas.getFormCanvas().childTables();
        }
        this.model.setChildren(this.slaves(this.form.getFormCanvas(), oldCanvas, allWidgets, oldWidgets, true));
        return this;
    }

    private List<ModelInfoDto> slaves(FormCanvasSchema canvasSchema, FormSchema oldCanvas, List<Widget> allWidgets, List<Widget> oldWidgets, boolean isChild) throws Exception {
        ArrayList slaveModels = Lists.newArrayListWithCapacity((int)5);
        if (CollectionUtils.isEmpty(allWidgets)) {
            return slaveModels;
        }
        for (Widget widget : allWidgets) {
            ModelInfoDto slaveModel = new ModelInfoDto();
            if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(this.form.getFormCanvas().getCreateSource())) {
                slaveModel.setSyncToTable(false);
                slaveModel.setModelId(widget.getName() + this.model.getModelId());
            } else {
                slaveModel.setSyncToTable(true);
                slaveModel.setModelId(widget.getName());
            }
            slaveModel.setModelName(widget.getName());
            DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
            String jdbcUrl = bean.getCurrentDatasource().getUrl();
            String dbType = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
            if (HussarUtils.equals((Object)DbType.KINGBASE.name(), (Object)dbType) || HussarUtils.equals((Object)com.baomidou.mybatisplus.annotation.DbType.KINGBASE_ES.name().replace("_", ""), (Object)dbType) || HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.HIGHGO.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.POSTGRE_SQL.name(), (Object)dbType)) {
                slaveModel.setTableName(widget.getName().toLowerCase(Locale.CHINA));
            } else {
                slaveModel.setTableName(widget.getName().toUpperCase(Locale.CHINA));
            }
            slaveModel.setModelDec(widget.getTitle());
            slaveModel.setDatasourceId(this.model.getDatasourceId());
            slaveModel.setPollName(this.model.getPollName());
            slaveModel.setType(this.model.getType());
            slaveModel.setOperationType(EngineOperationType.ADD.getOperationType());
            slaveModel.setOperationType(this.getModelOperType(canvasSchema, oldCanvas, EngineOperationType.ADD.getOperationType()));
            FormCanvasSchema formCanvas = this.form.getFormCanvas();
            List childrenWidgets = WidgetTool.flatButNotChildren(new ArrayList(), (List)widget.getChildren());
            if (WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())) {
                for (Widget widget1 : formCanvas.systemWidgets()) {
                    if (widget1.getName().equals("title")) continue;
                    widget1.setParentKey(widget.getName());
                    childrenWidgets.add(widget1);
                }
            }
            List<ModelFieldDto> fields = EngineBaseModelBuilder.fields(this.form, slaveModel, childrenWidgets, null);
            this.buildSubSerialNumber(fields, childrenWidgets);
            fields.add(this.foreign("F_"));
            if (!isChild) {
                fields.add(this.foreign("G_"));
            }
            fields.add(this.subSort());
            fields.add(this.extraInfoField());
            if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(this.form.getFormCanvas().getCreateSource()) && HussarUtils.isEmpty(oldWidgets)) {
                fields.forEach(f -> f.setSyncToTable(false));
            }
            slaveModel.setFieldList(fields);
            slaveModel.setRelation(ModelRelation.ONE_N);
            List children = WidgetTool.flatButChildren(new ArrayList(), (List)widget.getChildren());
            if (!CollUtil.isEmpty((Collection)children)) {
                slaveModel.setChildren(this.slaves(children, WidgetTool.flatButChildren(new ArrayList(), oldWidgets.stream().filter(e -> e.getName().equals(widget.getName())).findAny().map(Widget::getChildren).orElse(Collections.emptyList())), false));
            }
            slaveModels.add(slaveModel);
        }
        ArrayList oldSlaveModels = Lists.newArrayListWithCapacity((int)5);
        for (Widget widget : oldWidgets) {
            ModelInfoDto slaveModel = new ModelInfoDto();
            slaveModel.setModelId(widget.getName());
            slaveModel.setModelName(widget.getName());
            slaveModel.setModelDec(widget.getTitle());
            slaveModel.setDatasourceId(this.model.getDatasourceId());
            slaveModel.setPollName(this.model.getPollName());
            slaveModel.setType(EngineTypeStrategyEnum.MASTER_SLAVE.getTypeDesc());
            slaveModel.setOperationType(EngineOperationType.ADD.getOperationType());
            if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(this.form.getFormCanvas().getCreateSource())) {
                slaveModel.setSyncToTable(false);
            } else {
                slaveModel.setSyncToTable(true);
            }
            slaveModel.setRelation(ModelRelation.ONE_N);
            List children = WidgetTool.flatButChildren(new ArrayList(), (List)widget.getChildren());
            if (!CollUtil.isEmpty((Collection)children)) {
                slaveModel.setChildren(this.slaves(canvasSchema, oldCanvas, WidgetTool.flatButChildren(new ArrayList(), allWidgets.stream().filter(e -> e.getName().equals(widget.getName())).findAny().map(Widget::getChildren).orElse(Collections.emptyList())), children, false));
            }
            oldSlaveModels.add(slaveModel);
        }
        return this.compareSlave(slaveModels, oldSlaveModels);
    }

    private String getModelOperType(FormCanvasSchema formCanvas, FormSchema oldCanvas, String operationType) {
        if (HussarUtils.isEmpty((Object)oldCanvas)) {
            if (FormCreateTypeEnum.TABLE_TO_FORM.getType().equals(formCanvas.getCreateSource())) {
                return operationType;
            }
            if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(formCanvas.getCreateSource())) {
                ISysFormService formService = (ISysFormService)SpringUtil.getBean(ISysFormService.class);
                SysForm sysForm = (SysForm)formService.getById((Serializable)formCanvas.getSourceFormId());
                if (HussarUtils.isNotEmpty((Object)sysForm)) {
                    if (!formCanvas.getFormType().equals(sysForm.getFormType())) {
                        return EngineOperationType.UPDATE.getOperationType();
                    }
                    return operationType;
                }
                return operationType;
            }
            return operationType;
        }
        if (!formCanvas.getFormType().equals(oldCanvas.getFormCanvas().getFormType())) {
            return EngineOperationType.UPDATE.getOperationType();
        }
        return operationType;
    }

    private List<ModelInfoDto> slaves(List<Widget> allWidgets, List<Widget> oldWidgets, boolean isChild) throws Exception {
        ArrayList slaveModels = Lists.newArrayListWithCapacity((int)5);
        if (CollectionUtils.isEmpty(allWidgets)) {
            return slaveModels;
        }
        for (Widget widget : allWidgets) {
            ModelInfoDto slaveModel = new ModelInfoDto();
            if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(this.form.getFormCanvas().getCreateSource())) {
                slaveModel.setSyncToTable(false);
                slaveModel.setModelId(widget.getName() + this.model.getModelId());
            } else {
                slaveModel.setSyncToTable(true);
                slaveModel.setModelId(widget.getName());
            }
            slaveModel.setModelName(widget.getName());
            DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
            String jdbcUrl = bean.getCurrentDatasource().getUrl();
            String dbType = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
            if (HussarUtils.equals((Object)DbType.KINGBASE.name(), (Object)dbType) || HussarUtils.equals((Object)com.baomidou.mybatisplus.annotation.DbType.KINGBASE_ES.name().replace("_", ""), (Object)dbType) || HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.HIGHGO.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.POSTGRE_SQL.name(), (Object)dbType)) {
                slaveModel.setTableName(widget.getName().toLowerCase(Locale.CHINA));
            } else {
                slaveModel.setTableName(widget.getName().toUpperCase(Locale.CHINA));
            }
            slaveModel.setModelDec(widget.getTitle());
            slaveModel.setDatasourceId(this.model.getDatasourceId());
            slaveModel.setPollName(this.model.getPollName());
            slaveModel.setType(this.model.getType());
            slaveModel.setOperationType(EngineOperationType.ADD.getOperationType());
            FormCanvasSchema formCanvas = this.form.getFormCanvas();
            List childrenWidgets = WidgetTool.flatButNotChildren(new ArrayList(), (List)widget.getChildren());
            if (WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())) {
                for (Widget widget1 : formCanvas.systemWidgets()) {
                    if (widget1.getName().equals("title")) continue;
                    widget1.setParentKey(widget.getName());
                    childrenWidgets.add(widget1);
                }
            }
            List<ModelFieldDto> fields = EngineBaseModelBuilder.fields(this.form, slaveModel, childrenWidgets, null);
            this.buildSubSerialNumber(fields, childrenWidgets);
            fields.add(this.foreign("F_"));
            if (!isChild) {
                fields.add(this.foreign("G_"));
            }
            fields.add(this.subSort());
            fields.add(this.extraInfoField());
            if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(this.form.getFormCanvas().getCreateSource()) && HussarUtils.isEmpty(oldWidgets)) {
                fields.forEach(f -> f.setSyncToTable(false));
            }
            slaveModel.setFieldList(fields);
            slaveModel.setRelation(ModelRelation.ONE_N);
            List children = WidgetTool.flatButChildren(new ArrayList(), (List)widget.getChildren());
            if (!CollUtil.isEmpty((Collection)children)) {
                slaveModel.setChildren(this.slaves(children, WidgetTool.flatButChildren(new ArrayList(), oldWidgets.stream().filter(e -> e.getName().equals(widget.getName())).findAny().map(Widget::getChildren).orElse(Collections.emptyList())), false));
            }
            slaveModels.add(slaveModel);
        }
        ArrayList oldSlaveModels = Lists.newArrayListWithCapacity((int)5);
        for (Widget widget : oldWidgets) {
            ModelInfoDto slaveModel = new ModelInfoDto();
            slaveModel.setModelId(widget.getName());
            slaveModel.setModelName(widget.getName());
            slaveModel.setModelDec(widget.getTitle());
            slaveModel.setDatasourceId(this.model.getDatasourceId());
            slaveModel.setPollName(this.model.getPollName());
            slaveModel.setType(EngineTypeStrategyEnum.MASTER_SLAVE.getTypeDesc());
            slaveModel.setOperationType(EngineOperationType.ADD.getOperationType());
            if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(this.form.getFormCanvas().getCreateSource())) {
                slaveModel.setSyncToTable(false);
            } else {
                slaveModel.setSyncToTable(true);
            }
            slaveModel.setRelation(ModelRelation.ONE_N);
            List children = WidgetTool.flatButChildren(new ArrayList(), (List)widget.getChildren());
            if (!CollUtil.isEmpty((Collection)children)) {
                slaveModel.setChildren(this.slaves(WidgetTool.flatButChildren(new ArrayList(), allWidgets.stream().filter(e -> e.getName().equals(widget.getName())).findAny().map(Widget::getChildren).orElse(Collections.emptyList())), children, false));
            }
            oldSlaveModels.add(slaveModel);
        }
        return this.compareSlave(slaveModels, oldSlaveModels);
    }

    private ModelFieldDto subSort() {
        ModelFieldDto fieldDto = new ModelFieldDto();
        fieldDto.setFieldName("SEQ");
        fieldDto.setFieldComment("\u6392\u5e8f");
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        String jdbcUrl = bean.getCurrentDatasource().getUrl();
        String type = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
        if (HussarUtils.equals((Object)com.baomidou.mybatisplus.annotation.DbType.KINGBASE_ES.name().replace("_", ""), (Object)type)) {
            type = DbType.KINGBASE.name();
        }
        fieldDto.setDataType((String)fieldDbType.get(type));
        fieldDto.setDataLength(Long.valueOf(11L));
        Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)"int");
        fieldDto.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDto.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        if (HussarUtils.equals((Object)com.baomidou.mybatisplus.annotation.DbType.HIGH_GO.name().replace("_", ""), (Object)type)) {
            fieldDto.setDataType("integer");
        }
        fieldDto.setPurpose("seq");
        fieldDto.setOperationType(EngineOperationType.ADD.getOperationType());
        fieldDto.setSyncToTable(true);
        return fieldDto;
    }

    private ModelFieldDto extraInfoField() {
        ModelFieldDto fieldDto = new ModelFieldDto();
        fieldDto.setFieldName("EXTRA_INFO");
        fieldDto.setDataLength(Long.valueOf(2000L));
        fieldDto.setFieldComment("\u989d\u5916\u4fe1\u606f");
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        String jdbcUrl = bean.getCurrentDatasource().getUrl();
        String type = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
        if (HussarUtils.equals((Object)com.baomidou.mybatisplus.annotation.DbType.KINGBASE_ES.name().replace("_", ""), (Object)type)) {
            type = DbType.KINGBASE.name();
        }
        fieldDto.setDataType((String)textDbType.get(type));
        Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)"string");
        fieldDto.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDto.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        if (HussarUtils.equals((Object)com.baomidou.mybatisplus.annotation.DbType.HIGH_GO.name().replace("_", ""), (Object)type)) {
            fieldDto.setDataType("text");
        }
        fieldDto.setPurpose("extraInfo");
        fieldDto.setOperationType(EngineOperationType.ADD.getOperationType());
        fieldDto.setSyncToTable(true);
        return fieldDto;
    }

    private ModelFieldDto primary() {
        return this.model.getFieldList().stream().filter(field -> "primary".equals(field.getPurpose())).findFirst().orElseGet(ModelFieldDto::new);
    }

    private ModelFieldDto foreign(String prefix) {
        ModelFieldDto fieldDto = new ModelFieldDto();
        fieldDto.setFieldName(prefix + this.primary().getFieldName());
        fieldDto.setFieldComment(fieldDto.getFieldName());
        fieldDto.setDataLength(Long.valueOf(36L));
        EngineColumnTypeUtil.getEngineColumnType((String)"string").ifPresent(engineColumnType -> fieldDto.setDataType(engineColumnType.getJdbcType().getName()));
        Optional engineColumnType2 = EngineColumnTypeUtil.getEngineColumnType((String)"string");
        fieldDto.setJdbcType(((EngineColumnType)engineColumnType2.get()).getJdbcType().getName());
        fieldDto.setJavaType(((EngineColumnType)engineColumnType2.get()).getJavaType());
        fieldDto.setPurpose("foreign");
        fieldDto.setOperationType(EngineOperationType.ADD.getOperationType());
        fieldDto.setSyncToTable(true);
        return fieldDto;
    }

    private List<ModelInfoDto> compareSlave(List<ModelInfoDto> slaveModels, List<ModelInfoDto> oldSlaveModels) throws Exception {
        if (CollectionUtils.isEmpty(oldSlaveModels)) {
            return slaveModels;
        }
        ArrayList costantSlaveModels = Lists.newArrayListWithCapacity((int)5);
        ArrayList addSlaveModels = Lists.newArrayListWithCapacity((int)5);
        ArrayList deleteSlaveModels = Lists.newArrayListWithCapacity((int)5);
        ArrayList updateSlaveModels = Lists.newArrayListWithCapacity((int)5);
        Map oldSlaveModelMap = oldSlaveModels.stream().collect(Collectors.toMap(ModelInfoDto::getModelName, Function.identity()));
        for (ModelInfoDto slaveModel : slaveModels) {
            String tablelName = slaveModel.getModelName();
            String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
            String tableNameQuery = HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.HIGHGO.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.POSTGRE_SQL.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.KINGBASE.name(), (Object)dbType) ? tablelName.toLowerCase() : tablelName.toUpperCase();
            Optional tableInfo = DataModelUtil.filterTable((String)this.model.getPollName(), (String)"BASE TABLE", (String)tableNameQuery);
            if (tableInfo.isPresent()) {
                oldSlaveModelMap.remove(tablelName);
                slaveModel.setOperationType(EngineOperationType.UPDATE.getOperationType());
                TableInfo table = (TableInfo)tableInfo.get();
                List<ModelFieldDto> oldFields = EngineHEDataModelUtil.tableDBTransmodel(table.getFields());
                slaveModel.setFieldList(EngineBaseModelBuilder.compareField(this.form.getFormCanvas(), slaveModel.getFieldList(), oldFields));
                if (HussarUtils.isNotEmpty((Object)slaveModel.getFieldList()) && HussarUtils.isNotEmpty(slaveModel.getFieldList().stream().filter(f -> f.isSyncToTable()).collect(Collectors.toList()))) {
                    slaveModel.setSyncToTable(true);
                }
                updateSlaveModels.add(slaveModel);
                continue;
            }
            addSlaveModels.add(slaveModel);
        }
        if (HussarUtils.isNotEmpty(oldSlaveModelMap)) {
            oldSlaveModelMap.values().forEach(m -> {
                m.setOperationType(EngineOperationType.LOGICDELETE.getOperationType());
                m.setFieldList((List)Lists.newArrayListWithExpectedSize((int)0));
                deleteSlaveModels.add(m);
            });
        }
        costantSlaveModels.addAll(addSlaveModels);
        costantSlaveModels.addAll(deleteSlaveModels);
        costantSlaveModels.addAll(updateSlaveModels);
        return costantSlaveModels;
    }

    private void buildSubSerialNumber(List<ModelFieldDto> fields, List<Widget> childrenWidgets) {
        SerialNumSchema serialNumSchema = new SerialNumSchema();
        ArrayList<TitleParam> titleParams = new ArrayList<TitleParam>();
        Optional<Widget> first = childrenWidgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.JXDNSerialNumber.getType())).findFirst();
        if (first.isPresent()) {
            Widget serialNum = first.get();
            JSONObject props = serialNum.getProps();
            Optional value = Optional.of(new ArrayList());
            String code = "";
            if (HussarUtils.isNotEmpty((Object)props)) {
                if ("existing".equals(props.getString("defaultRule"))) {
                    String ruleCodeId = props.getString("defaultRuleExisting");
                    ISysCodeRuleService iSysCodeRuleService = (ISysCodeRuleService)SpringUtil.getBean(ISysCodeRuleService.class);
                    ApiResponse pageApiResponse = iSysCodeRuleService.getCodeRule(Long.valueOf(ruleCodeId));
                    SysCodeRuleVo record = (SysCodeRuleVo)pageApiResponse.getData();
                    if (HussarUtils.isEmpty((Object)record)) {
                        throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d41\u2f54\u53f7\u2f63\u6210\u89c4\u5219\uff0c\u8bf7\u786e\u8ba4\u89c4\u5219\u914d\u7f6e\u662f\u5426\u6b63\u786e");
                    }
                    List rules = record.getSysCodeRuleInfoList().stream().map(this::convertToSerialNumRuleDTO).collect(Collectors.toList());
                    value = Optional.of(rules);
                    code = record.getCodeRuleCode();
                } else {
                    value = JsonParser.value((Object)props, (String)"$rules", List.class);
                    code = serialNum.getParentKey();
                }
            }
            JSONArray jsonArray = new JSONArray();
            jsonArray.addAll((Collection)value.orElse(new ArrayList()));
            List serialNumRuleDTOs = jsonArray.toJavaList(SerialNumRuleDTO.class);
            int paramIndex = 1;
            for (SerialNumRuleDTO serialNumRuleDTO : serialNumRuleDTOs) {
                if (HussarUtils.equals((Object)"field", (Object)serialNumRuleDTO.getName())) continue;
                for (Widget find : childrenWidgets) {
                    if (!HussarUtils.equals((Object)find.getName(), (Object)serialNumRuleDTO.getName())) continue;
                    TitleParam param = new TitleParam.TitleParamBuilder().withId("param" + paramIndex).withType("field").withName(find.getName()).withWidgetTitle(find.getTitle()).withWidgetType(find.getType()).build();
                    find.newInstance(this.form).wrapTitle(new TitleSchema(), param);
                    titleParams.add(param);
                    ++paramIndex;
                }
            }
            serialNumSchema.setCode(code);
            serialNumSchema.setParams(titleParams);
        }
        ModelFieldRulesDto rulesDto = new ModelFieldRulesDto();
        rulesDto.setRuleContent(JSON.toJSONString((Object)serialNumSchema));
        rulesDto.setRuleType("7");
        fields.forEach(f -> {
            if (serialNumberColumn.contains(f.getFieldName())) {
                List rulesDtos = f.getFieldRules();
                if (CollectionUtils.isEmpty((Collection)rulesDtos)) {
                    rulesDtos = Lists.newArrayListWithExpectedSize((int)1);
                }
                rulesDtos.add(rulesDto);
                f.setFieldRules(rulesDtos);
            }
        });
    }

    public EngineBaseModelBuilder buildSerialNumber(FormSchema oldCanvas) {
        if (CollectionUtils.isEmpty(serialNumberColumn)) {
            return this;
        }
        SerialNumSchema serialNumSchema = new SerialNumSchema();
        List widgets = this.form.getFormCanvas().widgets();
        ArrayList<TitleParam> titleParams = new ArrayList<TitleParam>();
        Optional<Widget> first = widgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.JXDNSerialNumber.getType())).findFirst();
        if (first.isPresent()) {
            Widget serialNum = first.get();
            JSONObject props = serialNum.getProps();
            Optional value = Optional.of(new ArrayList());
            String code = "";
            if (HussarUtils.isNotEmpty((Object)props)) {
                if ("existing".equals(props.getString("defaultRule"))) {
                    String ruleCodeId = props.getString("defaultRuleExisting");
                    ISysCodeRuleService iSysCodeRuleService = (ISysCodeRuleService)SpringUtil.getBean(ISysCodeRuleService.class);
                    ApiResponse pageApiResponse = iSysCodeRuleService.getCodeRule(Long.valueOf(ruleCodeId));
                    SysCodeRuleVo record = (SysCodeRuleVo)pageApiResponse.getData();
                    if (HussarUtils.isEmpty((Object)record)) {
                        throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d41\u2f54\u53f7\u2f63\u6210\u89c4\u5219\uff0c\u8bf7\u786e\u8ba4\u89c4\u5219\u914d\u7f6e\u662f\u5426\u6b63\u786e");
                    }
                    List rules = record.getSysCodeRuleInfoList().stream().map(this::convertToSerialNumRuleDTO).collect(Collectors.toList());
                    value = Optional.of(rules);
                    code = record.getCodeRuleCode();
                } else {
                    value = JsonParser.value((Object)props, (String)"$rules", List.class);
                    code = this.form.getFormCanvas().getName();
                }
            }
            JSONArray jsonArray = new JSONArray();
            jsonArray.addAll((Collection)value.orElse(new ArrayList()));
            List serialNumRuleDTOs = jsonArray.toJavaList(SerialNumRuleDTO.class);
            int paramIndex = 1;
            for (SerialNumRuleDTO serialNumRuleDTO : serialNumRuleDTOs) {
                if (HussarUtils.equals((Object)"field", (Object)serialNumRuleDTO.getName())) continue;
                for (Widget find : widgets) {
                    if (!HussarUtils.equals((Object)find.getName(), (Object)serialNumRuleDTO.getName())) continue;
                    TitleParam param = new TitleParam.TitleParamBuilder().withId("param" + paramIndex).withType("field").withName(find.getName()).withWidgetTitle(find.getTitle()).withWidgetType(find.getType()).build();
                    find.newInstance(this.form).wrapTitle(new TitleSchema(), param);
                    titleParams.add(param);
                    ++paramIndex;
                }
            }
            serialNumSchema.setCode(code);
            serialNumSchema.setParams(titleParams);
        }
        ModelFieldRulesDto rulesDto = new ModelFieldRulesDto();
        rulesDto.setRuleContent(JSON.toJSONString((Object)serialNumSchema));
        rulesDto.setRuleType("7");
        if (HussarUtils.isEmpty((Object)oldCanvas)) {
            rulesDto.setOperationType(EngineOperationType.ADD.getOperationType());
        } else {
            rulesDto.setOperationType(EngineOperationType.UPDATE.getOperationType());
        }
        this.model.getFieldList().forEach(f -> {
            if (serialNumberColumn.contains(f.getFieldName())) {
                List rulesDtos = f.getFieldRules();
                if (CollectionUtils.isEmpty((Collection)rulesDtos)) {
                    rulesDtos = Lists.newArrayListWithExpectedSize((int)1);
                }
                rulesDtos.add(rulesDto);
                f.setFieldRules(rulesDtos);
            }
        });
        return this;
    }

    private SerialNumRuleDTO convertToSerialNumRuleDTO(SysCodeRuleInfo sysCodeRuleInfo) {
        SerialNumRuleDTO serialNumRuleDTO = new SerialNumRuleDTO();
        SerialNumRuleConfig config = new SerialNumRuleConfig();
        String type = sysCodeRuleInfo.getElementType();
        serialNumRuleDTO.setType(type);
        if (HussarUtils.equals((Object)"variable", (Object)type)) {
            serialNumRuleDTO.setName(sysCodeRuleInfo.getElementPattern());
            serialNumRuleDTO.setType("field");
            config.setLengthFixed(false);
        } else {
            serialNumRuleDTO.setName(type);
            serialNumRuleDTO.setType(type);
        }
        config.setValue("");
        config.setId(sysCodeRuleInfo.getId());
        serialNumRuleDTO.setConfig(config);
        return serialNumRuleDTO;
    }

    public EngineBaseModelBuilder contrast(FormSchema oldCanvas) throws Exception {
        FormCanvasSchema formCanvas = this.form.getFormCanvas();
        List fieldListNew = this.model.getFieldList();
        String tablelName = this.model.getModelName();
        List<ModelFieldDto> oldFields = this.getFieldDtos(tablelName);
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        Map oldFieldNameMap = oldFields.stream().collect(Collectors.toMap(modelFieldDto -> modelFieldDto.getFieldName().toUpperCase(), Function.identity()));
        if (dbType.equals("DM") && "1".equals(formCanvas.getCreateSource())) {
            for (ModelFieldDto field : fieldListNew) {
                String newFieldName = field.getFieldName().toUpperCase();
                if (!oldFieldNameMap.containsKey(newFieldName)) continue;
                field.setDataType(((ModelFieldDto)oldFieldNameMap.get(newFieldName)).getDataType());
            }
        }
        this.model.setFieldList(EngineBaseModelBuilder.compareField(formCanvas, fieldListNew, oldFields));
        return this;
    }

    private List<ModelFieldDto> getFieldDtos(String tablelName) throws IOException, LcdpException {
        List<ModelFieldDto> oldFields = new ArrayList<ModelFieldDto>();
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        String jdbcUrl = bean.getCurrentDatasource().getUrl();
        String dbType = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
        String tableNameQuery = HussarUtils.equals((Object)DbType.KINGBASE.name(), (Object)dbType) || HussarUtils.equals((Object)com.baomidou.mybatisplus.annotation.DbType.KINGBASE_ES.name().replace("_", ""), (Object)dbType) || HussarUtils.equals((Object)DbType.POSTGRE_SQL.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.HIGHGO.name(), (Object)dbType) ? tablelName.toLowerCase() : tablelName.toUpperCase();
        Optional tableInfo = DataModelUtil.filterTable((String)this.model.getPollName(), (String)"BASE TABLE", (String)tableNameQuery);
        if (tableInfo.isPresent()) {
            TableInfo table = (TableInfo)tableInfo.get();
            oldFields = EngineHEDataModelUtil.tableDBTransmodel(table.getFields());
        }
        return oldFields;
    }

    public static List<ModelFieldDto> compareField(FormCanvasSchema formCanvas, List<ModelFieldDto> fieldListNew, List<ModelFieldDto> oldFields) {
        ArrayList costantField = Lists.newArrayListWithExpectedSize((int)5);
        if (HussarUtils.isEmpty(oldFields)) {
            return fieldListNew;
        }
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        Map oldFieldNameMap = oldFields.stream().collect(Collectors.toMap(modelFieldDto -> modelFieldDto.getFieldName().toUpperCase(), Function.identity()));
        ArrayList addField = Lists.newArrayListWithExpectedSize((int)5);
        ArrayList upField = Lists.newArrayListWithExpectedSize((int)5);
        ArrayList deleteField = Lists.newArrayListWithExpectedSize((int)5);
        for (ModelFieldDto newField : fieldListNew) {
            String newFieldName = newField.getFieldName().toUpperCase();
            if (oldFieldNameMap.containsKey(newFieldName)) {
                if (!FormCreateTypeEnum.TABLE_TO_FORM.getType().equals(formCanvas.getCreateSource())) {
                    ModelFieldDto oldField = (ModelFieldDto)oldFieldNameMap.get(newFieldName);
                    if ("primary".equals(oldField.getPurpose())) {
                        newField.setSyncToTable(false);
                        newField.setPurpose("primary");
                    } else if (!((!HussarUtils.isNotEmpty((Object)newField.getDefaultValue()) || !HussarUtils.isNotEmpty((Object)oldField.getDefaultValue()) || HussarUtils.equals((Object)newField.getDefaultValue(), (Object)oldField.getDefaultValue())) && newField.getFieldComment().equals(oldField.getFieldComment()) && !CollectionUtil.isNotEmpty((Collection)newField.getFieldRules()) && newField.getDataType().toUpperCase().equals(oldField.getDataType().toUpperCase()) || HussarUtils.equals((Object)dbType, (Object)"ORACLE") && HussarUtils.equals((Object)oldField.getDataType(), (Object)OracleTypeEnum.CLOB.getTypeName()))) {
                        newField.setOperationType(EngineOperationType.UPDATE.getOperationType());
                        newField.setSyncToTable(true);
                    } else {
                        newField.setSyncToTable(false);
                    }
                } else {
                    newField.setSyncToTable(false);
                }
                upField.add(newField);
                oldFieldNameMap.remove(newFieldName);
                continue;
            }
            addField.add(newField);
        }
        if (CollectionUtil.isNotEmpty(oldFieldNameMap)) {
            oldFieldNameMap.values().forEach(f -> {
                f.setOperationType(EngineOperationType.LOGICDELETE.getOperationType());
                deleteField.add(f);
            });
        }
        costantField.addAll(addField);
        costantField.addAll(upField);
        costantField.addAll(deleteField);
        return costantField;
    }

    public EngineBaseModelBuilder buildDataSummary(FormSchema oldCanvas) {
        FormSettingSchema setting = this.form.getSetting();
        TitleSchema summaryNew = new TitleSchema();
        summaryNew.setMode("default");
        ArrayList<TitleParam> params = new ArrayList<TitleParam>();
        if (HussarUtils.isEmpty((Object)setting) || HussarUtils.isNotEmpty((Object)setting) && HussarUtils.isEmpty((Object)setting.getDataSummary())) {
            summaryNew.setParams(params);
            summaryNew.setCustom("");
        } else {
            int paramIndex = 1;
            StringBuilder custom = new StringBuilder();
            List widgets = this.form.getFormCanvas().widgetsWithSys();
            for (String summaryStr : setting.getDataSummary()) {
                Widget find = widgets.stream().filter(widget -> widget.getName().equals(summaryStr)).findFirst().orElseGet(Widget::new);
                TitleParam param = new TitleParam.TitleParamBuilder().withId("param" + paramIndex).withName(summaryStr).withType("field").withWidgetTitle(find.getTitle()).withWidgetType(find.getType()).build();
                if (!WidgetType.JXDNLinkForm.getType().equals(find.getType())) {
                    find.newInstance(this.form).wrapTitle(new TitleSchema(), param);
                }
                params.add(param);
                custom.append("${param").append(paramIndex).append("}");
                ++paramIndex;
            }
            summaryNew.setParams(params);
            summaryNew.setCustom(custom.toString());
        }
        ModelFieldRulesDto rulesDto = new ModelFieldRulesDto();
        rulesDto.setRuleContent(JSON.toJSONString((Object)summaryNew));
        rulesDto.setRuleType("4");
        if (HussarUtils.isEmpty((Object)oldCanvas)) {
            rulesDto.setOperationType(EngineOperationType.ADD.getOperationType());
        } else {
            Set newSu;
            List dataSummaryOld = oldCanvas.getSetting().getDataSummary();
            HashSet oldSu = new HashSet(dataSummaryOld);
            if (oldSu.equals(newSu = summaryNew.getParams().stream().map(TitleParam::getName).collect(Collectors.toSet()))) {
                rulesDto.setOperationType(EngineOperationType.NOOPER.getOperationType());
            } else {
                rulesDto.setOperationType(EngineOperationType.UPDATE.getOperationType());
            }
        }
        List fieldList = this.model.getFieldList();
        fieldList.forEach(f -> {
            if ("title".equals(f.getFieldName())) {
                List rulesDtos = f.getFieldRules();
                if (CollectionUtils.isEmpty((Collection)rulesDtos)) {
                    rulesDtos = Lists.newArrayListWithExpectedSize((int)1);
                }
                rulesDtos.add(rulesDto);
                f.setFieldRules(rulesDtos);
            }
        });
        return this;
    }

    public EngineBaseModelBuilder buildDataTitle(FormSchema oldCanvas) {
        ModelFieldRulesDto rulesDto = new ModelFieldRulesDto();
        TitleSchema titleNew = new TitleSchema();
        FormSettingSchema setting = this.form.getSetting();
        if (HussarUtils.isEmpty((Object)this.form.getSetting()) || HussarUtils.isNotEmpty((Object)setting) && HussarUtils.isEmpty((Object)setting.getDataTitle())) {
            if (HussarUtils.isNotEmpty((Object)oldCanvas) && HussarUtils.isNotEmpty((Object)oldCanvas.getSetting()) && !this.form.getFormCanvas().getFormType().equals(oldCanvas.getFormCanvas().getFormType())) {
                titleNew = oldCanvas.getSetting().getDataTitle();
                BuilderTool.wrapTitle(this.form, titleNew);
            } else {
                ArrayList<TitleParam> params = new ArrayList<TitleParam>();
                TitleParam createUserParam = new TitleParam();
                createUserParam.setId("param1");
                createUserParam.setName("createUserName");
                createUserParam.setType("field");
                params.add(createUserParam);
                TitleParam formNameParam = new TitleParam();
                formNameParam.setId("param2");
                formNameParam.setName(this.form.getFormCanvas().getId());
                formNameParam.setType("formName");
                params.add(formNameParam);
                titleNew.setParams(params);
                titleNew.setCustom("${param1}\u53d1\u8d77\u7684${param2}");
                titleNew.setDefaultVal("${param1}\u53d1\u8d77\u7684${param2}");
                titleNew.setMode("defaultVal");
            }
        } else {
            BeanUtils.copyProperties((Object)this.form.getSetting().getDataTitle(), (Object)titleNew);
            BuilderTool.wrapTitle(this.form, titleNew);
        }
        rulesDto.setRuleContent(JSON.toJSONString((Object)titleNew));
        rulesDto.setRuleType("3");
        if (HussarUtils.isEmpty((Object)oldCanvas) || HussarUtils.isEmpty((Object)oldCanvas.getSetting())) {
            rulesDto.setOperationType(EngineOperationType.ADD.getOperationType());
        } else {
            TitleSchema oldDataTitle = oldCanvas.getSetting().getDataTitle();
            BuilderTool.wrapTitle(oldCanvas, oldDataTitle);
            if (JSON.toJSONString((Object)titleNew).equals(JSON.toJSONString((Object)oldDataTitle))) {
                List formNameTitle = titleNew.getParams().stream().filter(p -> p.getType().equals("formName")).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty(formNameTitle)) {
                    rulesDto.setOperationType(EngineOperationType.UPDATE.getOperationType());
                } else {
                    rulesDto.setOperationType(EngineOperationType.NOOPER.getOperationType());
                }
            } else {
                rulesDto.setOperationType(EngineOperationType.UPDATE.getOperationType());
            }
        }
        List fieldList = this.model.getFieldList();
        fieldList.forEach(f -> {
            if ("title".equals(f.getFieldName())) {
                List rulesDtos = f.getFieldRules();
                if (CollectionUtils.isEmpty((Collection)rulesDtos)) {
                    rulesDtos = Lists.newArrayListWithExpectedSize((int)1);
                }
                rulesDtos.add(rulesDto);
                f.setFieldRules(rulesDtos);
            }
        });
        return this;
    }

    public EngineBaseModelBuilder buildFields(FormSchema oldCanvas) throws Exception {
        List<ModelFieldDto> oldSysFields;
        FormCanvasSchema formCanvas = this.form.getFormCanvas();
        List widgets = formCanvas.widgetsWithSys();
        widgets = WidgetTool.settingWidgets((List)widgets, x -> HussarUtils.equals((Object)true, (Object)x.isVirtualField()));
        Map<Object, Object> fieldDtoMap = Maps.newHashMapWithExpectedSize((int)5);
        if (FormCreateTypeEnum.TABLE_TO_FORM.getType().equals(formCanvas.getCreateSource()) && HussarUtils.isEmpty((Object)oldCanvas) && CollectionUtil.isNotEmpty(oldSysFields = this.getFieldDtos(this.model.getTableName()))) {
            fieldDtoMap = oldSysFields.stream().collect(Collectors.toMap(ModelFieldDto::getFieldName, Function.identity()));
        }
        this.model.setFieldList(EngineBaseModelBuilder.fields(this.form, this.model, widgets, fieldDtoMap));
        return this;
    }

    public static List<ModelFieldDto> fields(FormSchema form, ModelInfoDto model, List<Widget> widgets, Map<String, ModelFieldDto> fieldDtoMap) throws Exception {
        List<ModelFieldDto> sysFields = EngineBaseModelBuilder.toFields(form, model, widgets, fieldDtoMap);
        sysFields.add(EngineBaseModelBuilder.primary(form, model));
        sysFields.add(EngineBaseModelBuilder.tableNameColumn(form, model));
        sysFields.add(EngineBaseModelBuilder.delFlag(form, model));
        sysFields.add(EngineBaseModelBuilder.formId(form, model));
        return sysFields;
    }

    private static ModelFieldDto primary(FormSchema form, ModelInfoDto model) {
        ModelFieldDto field = new ModelFieldDto();
        String primaryKey = Strings.isBlank((String)form.getFormCanvas().getPrimaryKey()) ? "RECORD_ID" : form.getFormCanvas().getPrimaryKey();
        field.setFieldName(primaryKey);
        field.setFieldComment("\u4e3b\u952e");
        EngineColumnTypeUtil.getEngineColumnType((String)"string").ifPresent(engineColumnType -> field.setDataType(engineColumnType.getJdbcType().getName()));
        Optional engineColumnType2 = EngineColumnTypeUtil.getEngineColumnType((String)"string");
        field.setJdbcType(((EngineColumnType)engineColumnType2.get()).getJdbcType().getName());
        field.setJavaType(((EngineColumnType)engineColumnType2.get()).getJavaType());
        field.setDataLength(Long.valueOf(36L));
        field.setOperationType(EngineOperationType.ADD.getOperationType());
        field.setPurpose("primary");
        field.setSyncToTable(true);
        return field;
    }

    private static ModelFieldDto delFlag(FormSchema form, ModelInfoDto model) {
        ModelFieldDto field = new ModelFieldDto();
        field.setFieldName("DEL_FLAG");
        field.setFieldComment("DEL_FLAG");
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        if (HussarUtils.equals((Object)DbType.ORACLE.name(), (Object)dbType)) {
            field.setDataType("CHAR");
        } else {
            EngineColumnTypeUtil.getEngineColumnType((String)"string").ifPresent(engineColumnType -> field.setDataType(engineColumnType.getJdbcType().getName()));
        }
        Optional engineColumnType2 = EngineColumnTypeUtil.getEngineColumnType((String)"string");
        field.setJdbcType(((EngineColumnType)engineColumnType2.get()).getJdbcType().getName());
        field.setJavaType(((EngineColumnType)engineColumnType2.get()).getJavaType());
        field.setDataLength(Long.valueOf(1L));
        field.setOperationType(EngineOperationType.ADD.getOperationType());
        field.setPurpose("delDefFlag");
        field.setSyncToTable(true);
        return field;
    }

    private static ModelFieldDto tableNameColumn(FormSchema form, ModelInfoDto model) {
        ModelFieldDto field = new ModelFieldDto();
        field.setFieldName(model.getModelName());
        field.setFieldComment(model.getModelName());
        EngineColumnTypeUtil.getEngineColumnType((String)"string").ifPresent(engineColumnType -> field.setDataType(engineColumnType.getJdbcType().getName()));
        Optional engineColumnType2 = EngineColumnTypeUtil.getEngineColumnType((String)"string");
        field.setJdbcType(((EngineColumnType)engineColumnType2.get()).getJdbcType().getName());
        field.setJavaType(((EngineColumnType)engineColumnType2.get()).getJavaType());
        field.setDataLength(Long.valueOf(36L));
        field.setOperationType(EngineOperationType.ADD.getOperationType());
        field.setSyncToTable(true);
        return field;
    }

    private static ModelFieldDto formId(FormSchema form, ModelInfoDto model) {
        ModelFieldDto field = new ModelFieldDto();
        field.setFieldName("FORM_ID");
        field.setFieldComment("FORM_ID");
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        if (HussarUtils.equals((Object)DbType.ORACLE.name(), (Object)dbType)) {
            field.setDataType("NUMBER");
        } else {
            EngineColumnTypeUtil.getEngineColumnType((String)"long").ifPresent(engineColumnType -> field.setDataType(engineColumnType.getJdbcType().getName()));
        }
        Optional engineColumnType2 = EngineColumnTypeUtil.getEngineColumnType((String)"long");
        field.setJdbcType(((EngineColumnType)engineColumnType2.get()).getJdbcType().getName());
        field.setJavaType(((EngineColumnType)engineColumnType2.get()).getJavaType());
        field.setDataLength(Long.valueOf(19L));
        field.setOperationType(EngineOperationType.ADD.getOperationType());
        if (HussarUtils.isEmpty((Object)form.getFormCanvas().getSourceFormId())) {
            field.setDefaultValue(form.getFormCanvas().getId());
        } else {
            field.setDefaultValue(String.valueOf(form.getFormCanvas().getSourceFormId()));
        }
        field.setPurpose("formId");
        field.setSyncToTable(true);
        return field;
    }

    private static List<ModelFieldDto> toFields(FormSchema form, ModelInfoDto model, List<Widget> widgets, Map<String, ModelFieldDto> fieldDtoMap) {
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)5);
        serialNumberColumn = Lists.newArrayListWithExpectedSize((int)1);
        if (HussarUtils.isEmpty(widgets)) {
            return fields;
        }
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        String jdbcUrl = bean.getCurrentDatasource().getUrl();
        String type = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
        if (HussarUtils.equals((Object)com.baomidou.mybatisplus.annotation.DbType.KINGBASE_ES.name().replace("_", ""), (Object)type)) {
            type = DbType.KINGBASE.name();
        }
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)5);
        for (Widget widget : widgets) {
            Object object;
            boolean noRepeat = false;
            JSONObject props = widget.getProps();
            if (HussarUtils.isNotEmpty((Object)props) && HussarUtils.isNotEmpty((Object)(object = props.get((Object)"noRepeat")))) {
                noRepeat = (Boolean)object;
            }
            Widget ins = widget.newInstance(form);
            if (WidgetType.JXDNSerialNumber.getType().equals(widget.getType())) {
                serialNumberColumn.add(widget.getName());
            }
            for (ModelFieldDto fieldBase : ins.withEngineField(type, widget)) {
                ArrayList<ModelFieldRulesDto> fieldRules = fieldBase.getFieldRules();
                if (noRepeat && !widget.getIsInChild()) {
                    if (HussarUtils.isEmpty((Object)fieldRules)) {
                        fieldRules = new ArrayList<ModelFieldRulesDto>();
                    }
                    ModelFieldRulesDto modelFieldRulesDto = new ModelFieldRulesDto();
                    modelFieldRulesDto.setRuleType("5");
                    fieldRules.add(modelFieldRulesDto);
                    fieldBase.setFieldRules(fieldRules);
                }
                ModelFieldDto field = (ModelFieldDto)JSON.parseObject((String)JSON.toJSONString((Object)fieldBase), ModelFieldDto.class);
                if (!EngineColumnTypeUtil.getEngineColumnType((String)widget.getDataType()).isPresent()) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u8f6c\u6362\u672a\u5339\u914d\u5230\u8868\u5b57\u6bb5\u7c7b\u578b\uff0c\u7ec4\u4ef6\uff1a" + widget.getName());
                }
                field.setOperationType(EngineOperationType.ADD.getOperationType());
                if (CollectionUtil.isNotEmpty(fieldDtoMap) && fieldDtoMap.containsKey(fieldBase.getFieldName())) {
                    field.setSyncToTable(false);
                    if ("primary".equals(fieldDtoMap.get(fieldBase.getFieldName()).getPurpose())) {
                        field.setPurpose("primary");
                    }
                } else {
                    field.setSyncToTable(true);
                }
                newFields.add(field);
            }
        }
        return newFields;
    }

    public EngineBaseModelBuilder buildBase(String operationType, FormSchema oldCanvas) throws IOException {
        super.buildBase(this.model, this.form, oldCanvas, operationType);
        return this;
    }

    public ModelInfoDto build() throws IOException {
        return this.model;
    }

    public ModelInfoDto getModel() {
        return this.model;
    }

    public void setModel(ModelInfoDto model) {
        this.model = model;
    }

    public FormSchema getForm() {
        return this.form;
    }

    public void setForm(FormSchema form) {
        this.form = form;
    }

    public static List<String> getSerialNumberColumn() {
        return serialNumberColumn;
    }

    public static void setSerialNumberColumn(List<String> serialNumberColumn) {
        EngineBaseModelBuilder.serialNumberColumn = serialNumberColumn;
    }
}

