/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleInfo;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.annotation.BuilderType;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.DataCellInfo;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.rule.HeVerifyRule;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.CharacterConversService;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.NoCodeBaseDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.model.rule.HeColumRule;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.BuilderTool;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineBuildStrategyEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.Path;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.builder.BuilderCtx;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleConfig;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.SerialNumSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.BeanUtils;

@BuilderType(type="NO.BASE")
public class BaseModelBuilder
extends DataModelBuilder {
    private NoCodeBaseDataModel model;
    private FormSchema form;
    private static final String MYSQL = "MYSQL";
    private static final String ORACLE = "ORACLE";

    public String strategy() {
        return String.format("%s%s", "NO.", EngineBuildStrategyEnum.BASE);
    }

    public void init(FormSchema form) {
        this.form = form;
        this.model = new NoCodeBaseDataModel();
    }

    public NoCodeBaseDataModel direct() throws IOException {
        return this.buildBase().buildFields().buildOperation().buildDataTitle().buildDataSummary().buildSerialNumber().build();
    }

    public NoCodeBaseDataModel build() {
        return this.model;
    }

    public void build(BuilderCtx ctx) throws IOException {
        NoCodeBaseDataModel data = this.direct();
        CharacterConversService characterConversService = (CharacterConversService)SpringUtil.getBean(CharacterConversService.class);
        String id = ctx.getForm().getFormCanvas().getId();
        DataCellInfo dataCellInfo = new DataCellInfo();
        dataCellInfo.setId(id);
        dataCellInfo.setParentId(ctx.getFormModuleId());
        dataCellInfo.setDesc(this.form.getFormCanvas().getTitle());
        dataCellInfo.setName(characterConversService.changeToPinyinFirstLow(this.form.getFormCanvas().getTitle(), HanyuPinyinCaseType.LOWERCASE));
        dataCellInfo.setData(JSON.toJSONString((Object)((Object)data)));
        dataCellInfo.setType("DataModel");
        ctx.putMeta(id, (BaseFile)dataCellInfo);
        ctx.setDataModelBase((DataModelBase)data);
    }

    public FieldsContrastParam<DataModelFieldBase> updateContrast() throws IOException, LcdpException {
        return BaseModelBuilder.updateContrast(this.model);
    }

    public FieldsContrastParam<DataModelFieldBase> createContrast() throws IOException, LcdpException {
        return this.updateContrast();
    }

    public void clearFieldForImport(DataModelBase dataModelBase) {
        NoCodeBaseDataModel dataModel = (NoCodeBaseDataModel)dataModelBase;
        List fields = dataModel.getFields();
        for (HeDataModelField field : fields) {
            if (!HussarUtils.isNotEmpty((Object)field.getUsage()) || !WidgetTool.anyMatch((String)field.getUsage(), (String[])new String[]{"createUser", "updateUser", "createTime", "updateTime", "serialNumber", "dataOrgan", "title"})) continue;
            field.setUsage(null);
        }
    }

    public static FieldsContrastParam<DataModelFieldBase> updateContrast(HeDataModelBase model) throws IOException, LcdpException {
        List<TableCorrespond<DataModelFieldBase>> tableCorresponds = Collections.singletonList(BuilderTool.contrast(model));
        FieldsContrastParam contrast = new FieldsContrastParam();
        contrast.setModelId(model.getId());
        contrast.setTableCorresponds(tableCorresponds);
        return contrast;
    }

    public BaseModelBuilder buildBase() {
        this.model.setId(this.form.getFormCanvas().getId());
        this.model.setName(this.form.getFormCanvas().getName());
        this.model.setComment(this.form.getFormCanvas().getTitle());
        this.model.setDataSourceName(DataModelUtil.currentDsName());
        this.model.setFunctionType("BASE");
        if (HussarUtils.isNotEmpty((Object)this.form.getFormCanvas().getCreateSource()) && "1".equals(this.form.getFormCanvas().getCreateSource())) {
            this.model.setSourceDataModelName(this.model.getName());
        } else {
            this.model.setSourceDataModelName(BaseModelBuilder.sourceDataModelName(this.model.getName()));
        }
        this.model.setTableDesc(this.model.getComment());
        this.model.setCreateSource(this.form.getFormCanvas().getCreateSource());
        this.model.setNocode(true);
        this.model.setModelPath(FileUtil.posixPath((String[])new String[]{"/", AppContextUtil.getAppId()}));
        this.model.setHeColumRule(new HeColumRule());
        this.model.setIdentity(this.form.getIdentity());
        return this;
    }

    public static String sourceDataModelName(String name) {
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        String tableName = null;
        tableName = HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.HIGHGO.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.POSTGRE_SQL.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.KINGBASE.name(), (Object)dbType) ? name.toLowerCase() : name.toUpperCase();
        return tableName;
    }

    public BaseModelBuilder buildFields() throws IOException {
        List widgets = this.form.getFormCanvas().widgetsWithSys();
        widgets = WidgetTool.settingWidgets((List)widgets, x -> HussarUtils.equals((Object)true, (Object)x.isVirtualField()));
        this.model.setFields(BaseModelBuilder.fields(this.form, this.model, widgets));
        return this;
    }

    public static List<HeDataModelField> fields(FormSchema form, HeDataModelBase model, List<Widget> widgets) throws IOException {
        List<HeDataModelField> sysFields = BaseModelBuilder.toFields(form, model, widgets);
        sysFields.add(BaseModelBuilder.primary(form, model));
        sysFields.add(BaseModelBuilder.tableNameColumn(form, model));
        sysFields.add(BaseModelBuilder.delFlag(form, model));
        sysFields.add(BaseModelBuilder.formId(form, model));
        return sysFields;
    }

    private static HeDataModelField primary(FormSchema form, HeDataModelBase model) {
        HeDataModelField field = new HeDataModelField();
        String primaryKey = Strings.isBlank((String)form.getFormCanvas().getPrimaryKey()) ? "RECORD_ID" : form.getFormCanvas().getPrimaryKey();
        field.setId(primaryKey);
        field.setName(primaryKey);
        field.setSourceFieldName(primaryKey);
        field.setDataType("string");
        EngineColumnTypeUtil.getEngineColumnType((String)field.getDataType()).ifPresent(engineColumnType -> field.setSourceDataType(engineColumnType.getJdbcType().getName()));
        field.setDataLength(36);
        field.setSourceDataModelId(model.getId());
        field.setUsage("primary");
        return field;
    }

    private static HeDataModelField formId(FormSchema form, HeDataModelBase model) {
        HeDataModelField field = new HeDataModelField();
        field.setId("FORM_ID");
        field.setName("FORM_ID");
        field.setSourceFieldName("FORM_ID");
        field.setDataType("long");
        EngineColumnTypeUtil.getEngineColumnType((String)field.getDataType()).ifPresent(engineColumnType -> field.setSourceDataType(engineColumnType.getJdbcType().getName()));
        field.setDataLength(19);
        field.setSourceDataModelId(model.getId());
        if (HussarUtils.isEmpty((Object)form.getFormCanvas().getSourceFormId())) {
            field.setDataDefaultValue(form.getFormCanvas().getId());
        } else {
            field.setDataDefaultValue(String.valueOf(form.getFormCanvas().getSourceFormId()));
        }
        field.setUsage("formId");
        return field;
    }

    private static HeDataModelField tableNameColumn(FormSchema form, HeDataModelBase model) {
        HeDataModelField field = new HeDataModelField();
        field.setId(model.getName());
        field.setName(model.getName());
        field.setSourceFieldName(model.getName());
        field.setDataType("string");
        EngineColumnTypeUtil.getEngineColumnType((String)field.getDataType()).ifPresent(engineColumnType -> field.setSourceDataType(engineColumnType.getJdbcType().getName()));
        field.setDataLength(36);
        field.setSourceDataModelId(model.getId());
        field.setUsage(null);
        return field;
    }

    private static HeDataModelField delFlag(FormSchema form, HeDataModelBase model) {
        HeDataModelField field = new HeDataModelField();
        field.setId("DEL_FLAG");
        field.setName("DEL_FLAG");
        field.setSourceFieldName("DEL_FLAG");
        field.setDataType("string");
        EngineColumnTypeUtil.getEngineColumnType((String)field.getDataType()).ifPresent(engineColumnType -> field.setSourceDataType(engineColumnType.getJdbcType().getName()));
        field.setDataLength(1);
        field.setSourceDataModelId(model.getId());
        field.setUsage("delDefFlag");
        return field;
    }

    public static List<HeDataModelField> toFields(FormSchema form, HeDataModelBase model, List<Widget> widgets) throws IOException {
        ArrayList<HeDataModelField> fields = new ArrayList<HeDataModelField>();
        if (HussarUtils.isEmpty(widgets)) {
            return fields;
        }
        String type = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        for (Widget widget : widgets) {
            Widget ins = widget.newInstance(form);
            for (DataModelFieldBase fieldBase : ins.withField(type, widget)) {
                HeDataModelField field = (HeDataModelField)JSON.parseObject((String)JSON.toJSONString((Object)fieldBase), HeDataModelField.class);
                field.setSourceFieldName(field.getName());
                if (!EngineColumnTypeUtil.getEngineColumnType((String)widget.getDataType()).isPresent()) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u8f6c\u6362\u672a\u5339\u914d\u5230\u8868\u5b57\u6bb5\u7c7b\u578b\uff0c\u7ec4\u4ef6\uff1a" + widget.getName());
                }
                field.setUsage(widget.getUsage());
                field.setSourceDataModelId(model.getId());
                JsonParser.value((Object)widget, (String)Path.Widgets.NO_REPEAT.getPath(), String.class).ifPresent(v -> {
                    HeVerifyRule heVerifyRule = new HeVerifyRule();
                    heVerifyRule.setType("noRepeat");
                    heVerifyRule.setValue(Boolean.parseBoolean(v));
                    ArrayList<HeVerifyRule> heVerifyRules = new ArrayList<HeVerifyRule>();
                    heVerifyRules.add(heVerifyRule);
                    field.setVerifyRules(heVerifyRules);
                });
                fields.add(field);
            }
        }
        return fields;
    }

    public BaseModelBuilder buildOperation() {
        if (HussarUtils.isEmpty((Object)this.model.getOperations())) {
            ArrayList operations = new ArrayList();
            this.model.setOperations(operations);
        }
        BuilderTool.buildOperation(this.model, this.form, "TableQuery").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FlagDeleteBatch").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "DeleteBatch").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FormQuery").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FormVerify").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FormSave").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "TableSave").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "echartQuery").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "saveBatchMore").ifPresent(ops -> this.model.getOperations().addAll(ops));
        List widgets = this.form.getFormCanvas().widgets();
        Optional<Widget> first = widgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.JXDNSerialNumber.getType())).findFirst();
        if (first.isPresent()) {
            BuilderTool.buildOperation(this.model, this.form, "SelectCount").ifPresent(ops -> this.model.getOperations().addAll(ops));
        }
        return this;
    }

    public BaseModelBuilder buildDataTitle() {
        FormSettingSchema setting = this.form.getSetting();
        if (HussarUtils.isEmpty((Object)this.form.getSetting()) || HussarUtils.isNotEmpty((Object)setting) && HussarUtils.isEmpty((Object)setting.getDataTitle())) {
            TitleSchema defaultTitle = new TitleSchema();
            ArrayList<TitleParam> params = new ArrayList<TitleParam>();
            TitleParam createUserParam = new TitleParam();
            createUserParam.setId("param1");
            createUserParam.setName("createUserName");
            createUserParam.setType("field");
            params.add(createUserParam);
            TitleParam formNameParam = new TitleParam();
            formNameParam.setId("param2");
            formNameParam.setName(this.form.getFormCanvas().getId());
            formNameParam.setType("formName");
            params.add(formNameParam);
            defaultTitle.setParams(params);
            defaultTitle.setCustom("${param1}\u53d1\u8d77\u7684${param2}");
            defaultTitle.setDefaultVal("${param1}\u53d1\u8d77\u7684${param2}");
            defaultTitle.setMode("defaultVal");
            this.model.getHeColumRule().setDataTitle(defaultTitle);
            return this;
        }
        TitleSchema title = new TitleSchema();
        BeanUtils.copyProperties((Object)this.form.getSetting().getDataTitle(), (Object)title);
        BuilderTool.wrapTitle(this.form, title);
        this.model.getHeColumRule().setDataTitle(title);
        return this;
    }

    public BaseModelBuilder buildDataSummary() {
        FormSettingSchema setting = this.form.getSetting();
        TitleSchema summary = new TitleSchema();
        summary.setMode("default");
        ArrayList<TitleParam> params = new ArrayList<TitleParam>();
        if (HussarUtils.isEmpty((Object)setting) || HussarUtils.isNotEmpty((Object)setting) && HussarUtils.isEmpty((Object)setting.getDataSummary())) {
            summary.setParams(params);
            summary.setCustom("");
            this.model.getHeColumRule().setDataSummary(summary);
            return this;
        }
        int paramIndex = 1;
        StringBuilder custom = new StringBuilder();
        List widgets = this.form.getFormCanvas().widgetsWithSys();
        for (String summaryStr : setting.getDataSummary()) {
            Widget find = widgets.stream().filter(widget -> widget.getName().equals(summaryStr)).findFirst().orElseGet(Widget::new);
            TitleParam param = new TitleParam.TitleParamBuilder().withId("param" + paramIndex).withName(summaryStr).withType("field").withWidgetTitle(find.getTitle()).withWidgetType(find.getType()).build();
            find.newInstance(this.form).wrapTitle(new TitleSchema(), param);
            params.add(param);
            custom.append("${param").append(paramIndex).append("}");
            ++paramIndex;
        }
        summary.setParams(params);
        summary.setCustom(custom.toString());
        this.model.getHeColumRule().setDataSummary(summary);
        return this;
    }

    public BaseModelBuilder buildSerialNumber() {
        SerialNumSchema serialNumSchema = new SerialNumSchema();
        List widgets = this.form.getFormCanvas().widgets();
        ArrayList<TitleParam> titleParams = new ArrayList<TitleParam>();
        Optional<Widget> first = widgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.JXDNSerialNumber.getType())).findFirst();
        if (first.isPresent()) {
            Widget serialNum = first.get();
            JSONObject props = serialNum.getProps();
            Optional value = Optional.of(new ArrayList());
            String code = "";
            if (HussarUtils.isNotEmpty((Object)props)) {
                if ("existing".equals(props.getString("defaultRule"))) {
                    String ruleCodeId = props.getString("defaultRuleExisting");
                    ISysCodeRuleService iSysCodeRuleService = (ISysCodeRuleService)SpringUtil.getBean(ISysCodeRuleService.class);
                    ApiResponse pageApiResponse = iSysCodeRuleService.getCodeRule(Long.valueOf(ruleCodeId));
                    SysCodeRuleVo record = (SysCodeRuleVo)pageApiResponse.getData();
                    if (HussarUtils.isEmpty((Object)record)) {
                        throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d41\u2f54\u53f7\u2f63\u6210\u89c4\u5219\uff0c\u8bf7\u786e\u8ba4\u89c4\u5219\u914d\u7f6e\u662f\u5426\u6b63\u786e");
                    }
                    List rules = record.getSysCodeRuleInfoList().stream().map(this::convertToSerialNumRuleDTO).collect(Collectors.toList());
                    value = Optional.of(rules);
                    code = record.getCodeRuleCode();
                } else {
                    value = JsonParser.value((Object)props, (String)"$rules", List.class);
                    code = this.form.getFormCanvas().getName();
                }
            }
            JSONArray jsonArray = new JSONArray();
            jsonArray.addAll((Collection)value.orElse(new ArrayList()));
            List serialNumRuleDTOs = jsonArray.toJavaList(SerialNumRuleDTO.class);
            int paramIndex = 1;
            for (SerialNumRuleDTO serialNumRuleDTO : serialNumRuleDTOs) {
                if (HussarUtils.equals((Object)"field", (Object)serialNumRuleDTO.getName())) continue;
                for (Widget find : widgets) {
                    if (!HussarUtils.equals((Object)find.getName(), (Object)serialNumRuleDTO.getName())) continue;
                    TitleParam param = new TitleParam.TitleParamBuilder().withId("param" + paramIndex).withType("field").withName(find.getName()).withWidgetTitle(find.getTitle()).withWidgetType(find.getType()).build();
                    find.newInstance(this.form).wrapTitle(new TitleSchema(), param);
                    titleParams.add(param);
                    ++paramIndex;
                }
            }
            serialNumSchema.setCode(code);
            serialNumSchema.setParams(titleParams);
        }
        this.model.getHeColumRule().setSerialNumber(serialNumSchema);
        return this;
    }

    private SerialNumRuleDTO convertToSerialNumRuleDTO(SysCodeRuleInfo sysCodeRuleInfo) {
        SerialNumRuleDTO serialNumRuleDTO = new SerialNumRuleDTO();
        SerialNumRuleConfig config = new SerialNumRuleConfig();
        String type = sysCodeRuleInfo.getElementType();
        serialNumRuleDTO.setType(type);
        if (HussarUtils.equals((Object)"variable", (Object)type)) {
            serialNumRuleDTO.setName(sysCodeRuleInfo.getElementPattern());
            serialNumRuleDTO.setType("field");
            config.setLengthFixed(false);
        } else {
            serialNumRuleDTO.setName(type);
            serialNumRuleDTO.setType(type);
        }
        config.setValue("");
        config.setId(sysCodeRuleInfo.getId());
        serialNumRuleDTO.setConfig(config);
        return serialNumRuleDTO;
    }
}

