/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.function.visitor.task;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.HeOperationVisitor;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryConditionField;
import com.jxdinfo.hussar.formdesign.engine.function.model.sortcondition.HeSortCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.sortcondition.HeSortConditionField;
import com.jxdinfo.hussar.formdesign.engine.util.HeEnginePushUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.NoCodeBaseDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.task.TaskDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.visitor.HeOperationDefault;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.enums.UserEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="NO_CODE_ENGINETASKTableQuery")
public class TaskTableQueryVisitor
extends HeOperationDefault<TaskDataModel>
implements HeOperationVisitor<TaskDataModel, HeDataModelBaseDTO> {
    private static final Logger logger = LoggerFactory.getLogger(TaskTableQueryVisitor.class);
    public static final String OPERATION_NAME = "NO_CODE_ENGINETASKTableQuery";

    public void visit(HeBackCtx<TaskDataModel, HeDataModelBaseDTO> backCtx, HeDataModelOperation dataModelOperation, PushBackCtx engineCtx) {
        logger.debug("{}\u65b9\u6cd5\u5f00\u59cb", (Object)OPERATION_NAME);
        String currentModelId = ((TaskDataModel)backCtx.getUseDataModelBase()).getId();
        TaskDataModel dataModelBase = (TaskDataModel)backCtx.getUseDataModelBase();
        Object tabTypeObj = dataModelOperation.getParams().get("tabType");
        if (HussarUtils.isEmpty(tabTypeObj)) {
            return;
        }
        String tabType = tabTypeObj.toString();
        if (HussarUtils.isNotEmpty((Object)tabType) && ("0".equals(tabType) || "3".equals(tabType))) {
            engineCtx.isMs = false;
            engineCtx.setModelId(((TaskDataModel)backCtx.getUseDataModelBase()).getBusinessId());
            HeDataModelBaseDTO businessDataModelBaseDTO = (HeDataModelBaseDTO)backCtx.getUseDataModelDtoMap().get(currentModelId);
            HeEnginePushUtil.pushTableQuery(backCtx, (HeDataModelOperation)dataModelOperation, (HeDataModelBase)dataModelBase, (PushBackCtx)engineCtx, (HeDataModelBaseDTO)businessDataModelBaseDTO);
            return;
        }
        HeDataModelBaseDTO dataModelBaseDTO = (HeDataModelBaseDTO)backCtx.getTaskDtoMap().get(currentModelId);
        logger.debug("\u63a8\u9001\u89e3\u6790\u5f15\u64ce");
        engineCtx.isMs = true;
        engineCtx.setModelId(((TaskDataModel)backCtx.getUseDataModelBase()).getMasterId());
        HeEnginePushUtil.pushTableQuery(backCtx, (HeDataModelOperation)dataModelOperation, (HeDataModelBase)dataModelBase, (PushBackCtx)engineCtx, (HeDataModelBaseDTO)dataModelBaseDTO);
    }

    @Override
    public Optional<List<HeDataModelOperation>> build(TaskDataModel model, FormSchema form, String operationType) {
        ArrayList<HeDataModelOperation> operations = new ArrayList<HeDataModelOperation>();
        if (HussarUtils.isEmpty((Object)form.getView()) || HussarUtils.isEmpty((Object)form.getView().getViews())) {
            return Optional.empty();
        }
        block3: for (int i = 0; i < form.getView().getViews().size(); ++i) {
            DataView dataView = (DataView)form.getView().getViews().get(i);
            int viewType = dataView.getViewType();
            switch (viewType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    HeDataModelOperation operation = new HeDataModelOperation();
                    String id = operationType + dataView.getId();
                    operation.setId(id);
                    operation.setName(id);
                    operation.setType(operationType);
                    HashMap<String, Object> params = new HashMap<String, Object>(3);
                    String conditionName = model.getName() + "Condition_" + i;
                    this.buildQuery(model, dataView, conditionName);
                    params.put("selectCondition", conditionName);
                    String sortName = model.getName() + "Sort_" + i;
                    this.buildSort(model, dataView.getOrderBy(), sortName);
                    params.put("sortCondition", sortName);
                    params.put("isPagination", true);
                    params.put("tabType", dataView.getTabType());
                    operation.setParams(params);
                    operations.add(operation);
                    continue block3;
                }
            }
        }
        HeDataModelOperation operation = new HeDataModelOperation();
        operation.setId(operationType);
        operation.setName(operationType);
        operation.setType(operationType);
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("selectCondition", "");
        String sortName = model.getName() + "Sort_" + 0;
        params.put("sortCondition", sortName);
        params.put("isPagination", true);
        params.put("tabType", "0");
        operation.setParams(params);
        operations.add(operation);
        HeDataModelOperation operation1 = new HeDataModelOperation();
        operation1.setId(operationType + "All");
        operation1.setName(operationType + "All");
        operation1.setType(operationType);
        HashMap<String, Object> params1 = new HashMap<String, Object>();
        params1.put("isPagination", false);
        params1.put("tabType", "0");
        operation1.setParams(params1);
        operations.add(operation1);
        return Optional.of(operations);
    }

    public void buildSort(TaskDataModel model, List<OrderItem> orderBy, String sortName) {
        if (HussarUtils.isEmpty(model.getSortCondition())) {
            ArrayList<HeSortCondition> sortConditions = new ArrayList<HeSortCondition>();
            model.setSortCondition(sortConditions);
        }
        HeSortCondition sortCondition = new HeSortCondition();
        sortCondition.setName(sortName);
        ArrayList<HeSortConditionField> fields = new ArrayList<HeSortConditionField>();
        for (OrderItem orderItem : orderBy) {
            HeSortConditionField field = new HeSortConditionField();
            field.setSortCondition(orderItem.isAsc() ? "asc" : "desc");
            field.setFromModelFieldSort(orderItem.getColumn());
            NoCodeBaseDataModel task = model.getTask();
            if (HussarUtils.isNotEmpty((Object)((Object)task))) {
                List taskFields = task.getFields().stream().map(HeDataModelField::getSourceFieldName).collect(Collectors.toList());
                if (taskFields.contains(orderItem.getColumn())) {
                    field.setFromModelIdSort(task.getId());
                } else {
                    field.setFromModelIdSort(model.getId());
                }
            } else {
                field.setFromModelIdSort(model.getId());
            }
            fields.add(field);
        }
        sortCondition.setFields(fields);
        model.getSortCondition().add(sortCondition);
    }

    public void buildQuery(TaskDataModel model, DataView dataView, String conditionName) {
        if (HussarUtils.isEmpty(model.getQueryConditions())) {
            ArrayList<HeQueryCondition> queryConditions = new ArrayList<HeQueryCondition>();
            model.setQueryConditions(queryConditions);
        }
        HeQueryCondition queryCondition = new HeQueryCondition();
        queryCondition.setName(conditionName);
        ArrayList<HeQueryConditionField> fields = new ArrayList<HeQueryConditionField>();
        ArrayList allFields = new ArrayList();
        allFields.addAll(model.getFields());
        allFields.addAll(model.getTask().getFields());
        if (HussarUtils.isNotEmpty((Object)dataView.getTabType())) {
            fields.addAll(this.viewTabQuery(model, dataView.getTabType()));
        }
        int flag = 1;
        for (Filter filter : dataView.getFilters()) {
            HeQueryConditionField field = new HeQueryConditionField();
            String sourceDataModelId = allFields.stream().filter(f -> f.getName().equals(filter.getField())).findFirst().orElseGet(HeDataModelField::new).getSourceDataModelId();
            field.setFromModelId(sourceDataModelId);
            field.setFromModelField(filter.getField());
            field.setSymbol(filter.getRule());
            field.setType(ConnectEnum._ROW.getType());
            field.setConnect(filter.getMatch());
            field.setQueryAttrName(model.getName() + filter.getField() + filter.getRule() + flag++);
            field.setVal(filter.getVal());
            fields.add(field);
        }
        queryCondition.setFields(fields);
        model.getQueryConditions().add(queryCondition);
    }

    private List<HeQueryConditionField> viewTabQuery(TaskDataModel model, String tabType) {
        switch (tabType) {
            case "0": {
                return this.all(model);
            }
            case "2": {
                return this.todo(model);
            }
            case "1": {
                return this.done(model);
            }
            case "3": {
                return this.draft(model);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u89c6\u56fe\u7c7b\u578b\uff1a" + tabType);
    }

    private List<HeQueryConditionField> all(TaskDataModel model) {
        HeQueryConditionField field = new HeQueryConditionField();
        field.setFromModelId(model.getId());
        field.setFromModelField("PROCESS_KEY");
        field.setSymbol(SqlConnectEnum._IS_NOT_NULL.getKey());
        field.setType(ConnectEnum._ROW.getType());
        field.setConnect(ConnectEnum._AND.getType());
        field.setQueryAttrName(model.getName() + field.getFromModelField() + field.getSymbol());
        return Collections.singletonList(field);
    }

    private List<HeQueryConditionField> todo(TaskDataModel model) {
        HeQueryConditionField assine = new HeQueryConditionField();
        assine.setFromModelId(model.getTask().getId());
        assine.setFromModelField("ASSIGNEE");
        assine.setSymbol(SqlConnectEnum._USER_ENUM.getKey());
        assine.setType(ConnectEnum._ROW.getType());
        assine.setConnect(ConnectEnum._AND.getType());
        assine.setQueryAttrName(model.getTask().getName() + assine.getFromModelField() + assine.getSymbol());
        assine.setVal(UserEnum.USER_ID.getValue());
        HeQueryConditionField state = new HeQueryConditionField();
        state.setFromModelId(model.getTask().getId());
        state.setFromModelField("TASK_STATE");
        state.setSymbol(SqlConnectEnum._EQUAL.getKey());
        state.setType(ConnectEnum._ROW.getType());
        state.setConnect(ConnectEnum._AND.getType());
        state.setQueryAttrName(model.getTask().getName() + state.getFromModelField() + state.getSymbol());
        state.setVal("0");
        HeQueryConditionField processKey = new HeQueryConditionField();
        processKey.setFromModelId(model.getId());
        processKey.setFromModelField("PROCESS_KEY");
        processKey.setSymbol(SqlConnectEnum._EQUAL.getKey());
        processKey.setType(ConnectEnum._ROW.getType());
        processKey.setConnect(ConnectEnum._AND.getType());
        processKey.setQueryAttrName(model.getTask().getName() + processKey.getFromModelField() + processKey.getSymbol());
        processKey.setVal(model.getProcessKey());
        return Arrays.asList(assine, state, processKey);
    }

    private List<HeQueryConditionField> done(TaskDataModel model) {
        List<HeQueryConditionField> todo = this.todo(model);
        HeQueryConditionField field = todo.get(1);
        field.setVal("1");
        return todo;
    }

    private List<HeQueryConditionField> draft(TaskDataModel model) {
        ArrayList<HeQueryConditionField> all = new ArrayList<HeQueryConditionField>(this.all(model));
        HeQueryConditionField field = (HeQueryConditionField)all.get(0);
        field.setSymbol(SqlConnectEnum._IS_NULL.getKey());
        field.setQueryAttrName(model.getName() + field.getFromModelField() + field.getSymbol());
        HeQueryConditionField createUser = new HeQueryConditionField();
        createUser.setFromModelId(model.getId());
        createUser.setFromModelField("createUser_user");
        createUser.setSymbol(SqlConnectEnum._USER_ENUM.getKey());
        createUser.setType(ConnectEnum._ROW.getType());
        createUser.setConnect(ConnectEnum._AND.getType());
        createUser.setQueryAttrName(model.getTask().getName() + createUser.getFromModelField() + createUser.getSymbol());
        createUser.setVal(UserEnum.USER_ID.getValue());
        all.add(createUser);
        return all;
    }
}

