/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.function.visitor.taskms;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.HeOperationVisitor;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryConditionField;
import com.jxdinfo.hussar.formdesign.engine.function.model.sortcondition.HeSortCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.sortcondition.HeSortConditionField;
import com.jxdinfo.hussar.formdesign.engine.util.HeEnginePushUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.NoCodeBaseDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.task.TaskMsDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.visitor.HeOperationDefault;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.dto.SingleTableDto;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.enums.UserEnum;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="NO_CODE_ENGINETASK_MASTER_SLAVETableQuery")
public class TaskMsTableQueryVisitor
extends HeOperationDefault<TaskMsDataModel>
implements HeOperationVisitor<TaskMsDataModel, HeDataModelBaseDTO> {
    private static final Logger logger = LoggerFactory.getLogger(TaskMsTableQueryVisitor.class);
    public static final String OPERATION_NAME = "NO_CODE_ENGINETASK_MASTER_SLAVETableQuery";

    public void visit(HeBackCtx<TaskMsDataModel, HeDataModelBaseDTO> backCtx, HeDataModelOperation dataModelOperation, PushBackCtx engineCtx) {
        logger.debug("{}\u65b9\u6cd5\u5f00\u59cb", (Object)OPERATION_NAME);
        String currentModelId = ((TaskMsDataModel)backCtx.getUseDataModelBase()).getId();
        TaskMsDataModel dataModelBase = (TaskMsDataModel)backCtx.getUseDataModelBase();
        HeDataModelBaseDTO dataModelBaseDTO = (HeDataModelBaseDTO)backCtx.getTaskDtoMap().get(currentModelId);
        logger.debug("\u63a8\u9001\u89e3\u6790\u5f15\u64ce");
        Object tabTypeObj = dataModelOperation.getParams().get("tabType");
        if (HussarUtils.isEmpty(tabTypeObj)) {
            return;
        }
        String tabType = tabTypeObj.toString();
        if (HussarUtils.isNotEmpty((Object)tabType) && ("0".equals(tabType) || "3".equals(tabType))) {
            engineCtx.setModelId(dataModelBase.getRelationById("").getRelatedId());
            HeDataModelBaseDTO businessDataModelBaseDTO = (HeDataModelBaseDTO)backCtx.getUseDataModelDtoMap().get(currentModelId);
            SingleTableDto dto = HeEnginePushUtil.getTableQueryDto(backCtx, (HeDataModelOperation)dataModelOperation, (HeDataModelBase)dataModelBase, (PushBackCtx)engineCtx, (HeDataModelBaseDTO)businessDataModelBaseDTO, (boolean)true);
            HeEnginePushUtil.push((PushBackCtx)engineCtx, null, (SingleTableDto)dto, (int)2);
            return;
        }
        if (HussarUtils.isNotEmpty((Object)tabType) && "4".equals(tabType)) {
            engineCtx.setModelId(dataModelBase.getRelationById("").getRelatedId());
            HeDataModelBaseDTO businessDataModelBaseDTO = (HeDataModelBaseDTO)backCtx.getUseDataModelDtoMap().get(currentModelId);
            SingleTableDto dto = HeEnginePushUtil.getTableQueryDto(backCtx, (HeDataModelOperation)dataModelOperation, (HeDataModelBase)dataModelBase, (PushBackCtx)engineCtx, (HeDataModelBaseDTO)businessDataModelBaseDTO, (boolean)true);
            HeEnginePushUtil.push((PushBackCtx)engineCtx, null, (SingleTableDto)dto, (int)2);
            return;
        }
        engineCtx.setModelId(((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(dataModelBase.getTask().getId()).getRelatedId());
        engineCtx.setColumnMap(dataModelBase.getTaskColumnMap());
        engineCtx.isMs = true;
        HeEnginePushUtil.pushTableQuery(backCtx, (HeDataModelOperation)dataModelOperation, (HeDataModelBase)dataModelBase, (PushBackCtx)engineCtx, (HeDataModelBaseDTO)dataModelBaseDTO);
    }

    @Override
    public Optional<List<HeDataModelOperation>> build(TaskMsDataModel model, FormSchema form, String operationType) {
        ArrayList<HeDataModelOperation> operations = new ArrayList<HeDataModelOperation>();
        if (HussarUtils.isEmpty((Object)form.getView()) || HussarUtils.isEmpty((Object)form.getView().getViews())) {
            return Optional.empty();
        }
        block3: for (int i = 0; i < form.getView().getViews().size(); ++i) {
            DataView dataView = (DataView)form.getView().getViews().get(i);
            int viewType = dataView.getViewType();
            switch (viewType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    HeDataModelOperation operation = new HeDataModelOperation();
                    String id = operationType + dataView.getId();
                    operation.setId(id);
                    operation.setName(id);
                    operation.setType(operationType);
                    HashMap<String, Object> params = new HashMap<String, Object>(3);
                    String conditionName = model.getName() + "Condition_" + i;
                    this.buildQuery(model, dataView, conditionName);
                    params.put("selectCondition", conditionName);
                    String sortName = model.getName() + "Sort_" + i;
                    this.buildSort(model, dataView.getOrderBy(), sortName);
                    params.put("sortCondition", sortName);
                    params.put("isPagination", true);
                    params.put("tabType", dataView.getTabType());
                    params.put("isMsPage", true);
                    operation.setParams(params);
                    operations.add(operation);
                    continue block3;
                }
            }
        }
        HeDataModelOperation operation = new HeDataModelOperation();
        operation.setId(operationType);
        operation.setName(operationType);
        operation.setType(operationType);
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("selectCondition", "");
        String sortName = model.getName() + "Sort_" + 0;
        params.put("sortCondition", sortName);
        params.put("isPagination", true);
        params.put("tabType", "0");
        params.put("isMsPage", true);
        operation.setParams(params);
        operations.add(operation);
        HeDataModelOperation operation1 = new HeDataModelOperation();
        operation1.setId(operationType + "All");
        operation1.setName(operationType + "All");
        operation1.setType(operationType);
        HashMap<String, Comparable<Boolean>> params1 = new HashMap<String, Comparable<Boolean>>();
        params1.put("isPagination", Boolean.valueOf(false));
        params1.put("tabType", Character.valueOf('4'));
        operation1.setParams(params1);
        operations.add(operation1);
        HeDataModelOperation operation2 = new HeDataModelOperation();
        operation2.setId(operationType + "Slave");
        operation2.setName(operationType + "Slave");
        operation2.setType(operationType);
        HashMap<String, Comparable<Boolean>> params2 = new HashMap<String, Comparable<Boolean>>();
        params2.put("isPagination", Boolean.valueOf(true));
        params2.put("tabType", Character.valueOf('4'));
        params2.put("isMsPage", Boolean.valueOf(true));
        operation2.setParams(params2);
        operations.add(operation2);
        return Optional.of(operations);
    }

    public void buildSort(TaskMsDataModel model, List<OrderItem> orderBy, String sortName) {
        if (HussarUtils.isEmpty(model.getSortCondition())) {
            ArrayList<HeSortCondition> sortConditions = new ArrayList<HeSortCondition>();
            model.setSortCondition(sortConditions);
        }
        HeSortCondition sortCondition = new HeSortCondition();
        sortCondition.setName(sortName);
        ArrayList<HeSortConditionField> fields = new ArrayList<HeSortConditionField>();
        for (OrderItem orderItem : orderBy) {
            HeSortConditionField field = new HeSortConditionField();
            field.setSortCondition(orderItem.isAsc() ? "asc" : "desc");
            field.setFromModelFieldSort(orderItem.getColumn());
            NoCodeBaseDataModel task = model.getTask();
            if (HussarUtils.isNotEmpty((Object)((Object)task))) {
                List taskFields = task.getFields().stream().map(HeDataModelField::getSourceFieldName).collect(Collectors.toList());
                if (taskFields.contains(orderItem.getColumn())) {
                    field.setFromModelIdSort(task.getId());
                } else {
                    field.setFromModelIdSort(model.getMasterTable().getId());
                }
            } else {
                field.setFromModelIdSort(model.getMasterTable().getId());
            }
            fields.add(field);
        }
        sortCondition.setFields(fields);
        model.getSortCondition().removeIf(x -> x.getName().equals(sortName));
        model.getSortCondition().add(sortCondition);
    }

    public void buildQuery(TaskMsDataModel model, DataView dataView, String conditionName) {
        if (HussarUtils.isEmpty(model.getQueryConditions())) {
            ArrayList<HeQueryCondition> queryConditions = new ArrayList<HeQueryCondition>();
            model.setQueryConditions(queryConditions);
        }
        HeQueryCondition queryCondition = new HeQueryCondition();
        queryCondition.setName(conditionName);
        ArrayList<HeQueryConditionField> fields = new ArrayList<HeQueryConditionField>();
        ArrayList allFields = new ArrayList();
        allFields.addAll(model.getMasterTable().getFields());
        allFields.addAll(model.getTask().getFields());
        ArrayList<HeDataModelField> slaveFields = new ArrayList<HeDataModelField>();
        for (HeDataModelBase slaveTable : model.getSlaveTables()) {
            HeDataModelField heDataModelField = new HeDataModelField();
            heDataModelField.setSourceDataModelId(slaveTable.getId());
            heDataModelField.setName(slaveTable.getName());
            slaveFields.add(heDataModelField);
        }
        allFields.addAll(slaveFields);
        if (HussarUtils.isNotEmpty((Object)dataView.getTabType())) {
            fields.addAll(this.viewTabQuery(model, dataView.getTabType()));
        }
        for (Filter filter : dataView.getFilters()) {
            HeQueryConditionField field = new HeQueryConditionField();
            String[] fieldSplit = filter.getField().split("\\.");
            String sourceDataModelId = allFields.stream().filter(f -> f.getName().equals(fieldSplit[0])).findFirst().orElseGet(HeDataModelField::new).getSourceDataModelId();
            field.setFromModelId(sourceDataModelId);
            if (HussarUtils.equals((Object)fieldSplit.length, (Object)1)) {
                field.setFromModelField(fieldSplit[0]);
                field.setQueryAttrName(model.getName() + fieldSplit[0] + filter.getRule());
            } else {
                field.setFromModelField(fieldSplit[1]);
                field.setQueryAttrName(model.getName() + fieldSplit[1] + filter.getRule());
            }
            field.setSymbol(filter.getRule());
            field.setType(ConnectEnum._ROW.getType());
            field.setConnect(filter.getMatch());
            field.setVal(filter.getVal());
            fields.add(field);
        }
        queryCondition.setFields(fields);
        model.getQueryConditions().add(queryCondition);
    }

    private List<HeQueryConditionField> viewTabQuery(TaskMsDataModel model, String tabType) {
        switch (tabType) {
            case "0": {
                return this.all(model);
            }
            case "2": {
                return this.todo(model);
            }
            case "1": {
                return this.done(model);
            }
            case "3": {
                return this.draft(model);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u89c6\u56fe\u7c7b\u578b\uff1a" + tabType);
    }

    private List<HeQueryConditionField> all(TaskMsDataModel model) {
        HeQueryConditionField field = new HeQueryConditionField();
        field.setFromModelId(model.getMasterTable().getId());
        field.setFromModelField("PROCESS_KEY");
        field.setSymbol(SqlConnectEnum._IS_NOT_NULL.getKey());
        field.setType(ConnectEnum._ROW.getType());
        field.setConnect(ConnectEnum._AND.getType());
        field.setQueryAttrName(model.getMasterTable().getName() + field.getFromModelField() + field.getSymbol());
        return Collections.singletonList(field);
    }

    private List<HeQueryConditionField> todo(TaskMsDataModel model) {
        HeQueryConditionField assine = new HeQueryConditionField();
        assine.setFromModelId(model.getTask().getId());
        assine.setFromModelField("ASSIGNEE");
        assine.setSymbol(SqlConnectEnum._USER_ENUM.getKey());
        assine.setType(ConnectEnum._ROW.getType());
        assine.setConnect(ConnectEnum._AND.getType());
        assine.setQueryAttrName(model.getTask().getName() + assine.getFromModelField() + assine.getSymbol());
        assine.setVal(UserEnum.USER_ID.getValue());
        HeQueryConditionField state = new HeQueryConditionField();
        state.setFromModelId(model.getTask().getId());
        state.setFromModelField("TASK_STATE");
        state.setSymbol(SqlConnectEnum._EQUAL.getKey());
        state.setType(ConnectEnum._ROW.getType());
        state.setConnect(ConnectEnum._AND.getType());
        state.setQueryAttrName(model.getTask().getName() + state.getFromModelField() + state.getSymbol());
        state.setVal("0");
        HeQueryConditionField processKey = new HeQueryConditionField();
        processKey.setFromModelId(model.getMasterTable().getId());
        processKey.setFromModelField("PROCESS_KEY");
        processKey.setSymbol(SqlConnectEnum._EQUAL.getKey());
        processKey.setType(ConnectEnum._ROW.getType());
        processKey.setConnect(ConnectEnum._AND.getType());
        processKey.setQueryAttrName(model.getTask().getName() + processKey.getFromModelField() + processKey.getSymbol());
        processKey.setVal(model.getProcessKey());
        return Arrays.asList(assine, state, processKey);
    }

    private List<HeQueryConditionField> done(TaskMsDataModel model) {
        List<HeQueryConditionField> todo = this.todo(model);
        HeQueryConditionField field = todo.get(1);
        field.setVal("1");
        return todo;
    }

    private List<HeQueryConditionField> draft(TaskMsDataModel model) {
        HeQueryConditionField proKey = new HeQueryConditionField();
        proKey.setFromModelId(model.getMasterTable().getId());
        proKey.setFromModelField("PROCESS_KEY");
        proKey.setType(ConnectEnum._ROW.getType());
        proKey.setConnect(ConnectEnum._AND.getType());
        proKey.setSymbol(SqlConnectEnum._IS_NULL.getKey());
        proKey.setQueryAttrName(model.getMasterTable().getName() + proKey.getFromModelField() + proKey.getSymbol());
        HeQueryConditionField createUser = new HeQueryConditionField();
        createUser.setFromModelId(model.getMasterTable().getId());
        createUser.setFromModelField("createUser_user");
        createUser.setSymbol(SqlConnectEnum._USER_ENUM.getKey());
        createUser.setType(ConnectEnum._ROW.getType());
        createUser.setConnect(ConnectEnum._AND.getType());
        createUser.setQueryAttrName(model.getMasterTable().getName() + createUser.getFromModelField() + createUser.getSymbol());
        createUser.setVal(UserEnum.USER_ID.getValue());
        return Arrays.asList(proKey, createUser);
    }
}

