/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.function.element.masterslave;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleInfo;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormCreateTypeEnum;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.annotation.BuilderType;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipBase;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.BaseModelBuilder;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.NoCodeBaseDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.masterslave.NoCodeMSDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.model.rule.HeColumRule;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.BuilderTool;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineBuildStrategyEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.builder.BuilderCtx;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleConfig;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.SerialNumSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.mail.core.collection.CollUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@BuilderType(type="NO.MASTER_SLAVE")
public class MsModelBuilder
extends DataModelBuilder {
    private NoCodeMSDataModel model;
    private FormSchema form;
    private static final String MS_PREFIX = "ms_";

    public String strategy() {
        return "NO." + EngineBuildStrategyEnum.MASTER_SLAVE;
    }

    public void init(FormSchema form) {
        this.form = form;
        this.model = new NoCodeMSDataModel();
    }

    public NoCodeMSDataModel direct() throws IOException {
        return this.buildBase().buildMaster().buildSlaves().buildRelation().buildOperation().buildDataTitle().buildDataSummary().buildSerialNumber().build();
    }

    public NoCodeMSDataModel build() {
        return this.model;
    }

    public void build(BuilderCtx ctx) throws IOException {
        ctx.setDataModelBase((DataModelBase)this.direct());
    }

    public FieldsContrastParam<DataModelFieldBase> updateContrast() throws IOException, LcdpException {
        return MsModelBuilder.contrast(this.model);
    }

    public FieldsContrastParam<DataModelFieldBase> createContrast() throws IOException, LcdpException {
        return this.updateContrast();
    }

    public void clearFieldForImport(DataModelBase dataModelBase) {
        NoCodeMSDataModel dataModel = (NoCodeMSDataModel)dataModelBase;
        HeDataModelBase masterTable = dataModel.getMasterTable();
        List fields = masterTable.getFields();
        for (HeDataModelField field : fields) {
            if (!HussarUtils.isNotEmpty((Object)field.getUsage()) || !WidgetTool.anyMatch((String)field.getUsage(), (String[])new String[]{"createUser", "updateUser", "createTime", "updateTime", "serialNumber", "dataOrgan", "title"})) continue;
            field.setUsage(null);
        }
    }

    public static FieldsContrastParam<DataModelFieldBase> contrast(NoCodeMSDataModel model) throws IOException, LcdpException {
        ArrayList<TableCorrespond<DataModelFieldBase>> corresponds = new ArrayList<TableCorrespond<DataModelFieldBase>>();
        HeDataModelBase masterTable = model.getMasterTable();
        TableCorrespond<DataModelFieldBase> masterCorrespond = BuilderTool.contrast(masterTable);
        corresponds.add(masterCorrespond);
        List<HeDataModelBase> slaveTables = model.getSlaveTables();
        for (HeDataModelBase slave : slaveTables) {
            TableCorrespond<DataModelFieldBase> correspond = BuilderTool.contrast(slave);
            corresponds.add(correspond);
        }
        FieldsContrastParam contrast = new FieldsContrastParam();
        contrast.setModelId(model.getId());
        contrast.setTableCorresponds(corresponds);
        return contrast;
    }

    public MsModelBuilder buildBase() {
        this.model.setId(MS_PREFIX + this.form.getFormCanvas().getId());
        this.model.setName(this.form.getFormCanvas().getName());
        this.model.setComment(this.form.getFormCanvas().getTitle());
        this.model.setDataSourceName(NoCodeBusinessDB.getNocodeBusinessDB());
        this.model.setFunctionType("MASTER_SLAVE");
        this.model.setTableDesc(this.model.getComment());
        this.model.setCreateSource(this.form.getFormCanvas().getCreateSource());
        this.model.setNocode(true);
        this.model.setModelPath(FileUtil.posixPath((String[])new String[]{"/", AppContextUtil.getAppId()}));
        this.model.setHeColumRule(new HeColumRule());
        this.model.setIdentity(this.form.getIdentity());
        return this;
    }

    public MsModelBuilder buildMaster() throws IOException {
        this.model.setMasterTable(this.master(this.form));
        return this;
    }

    public MsModelBuilder buildSlaves() throws IOException {
        List allWidgets = this.form.getFormCanvas().childTables();
        this.model.setSlaveTables(this.slaves(allWidgets, true));
        return this;
    }

    public NoCodeBaseDataModel master(FormSchema form) throws IOException {
        BaseModelBuilder builder = new BaseModelBuilder();
        builder.init(form);
        if (HussarUtils.isEmpty((Object)form.getFormCanvas()) || HussarUtils.isEmpty((Object)form.getFormCanvas().getId())) {
            return new NoCodeBaseDataModel();
        }
        return builder.buildBase().buildFields().build();
    }

    public List<HeDataModelBase> slaves(List<Widget> children, boolean isChild) throws IOException {
        ArrayList<HeDataModelBase> slaves = new ArrayList<HeDataModelBase>();
        if (HussarUtils.isEmpty(children)) {
            return slaves;
        }
        for (Widget widget : children) {
            NoCodeBaseDataModel base = new NoCodeBaseDataModel();
            this.buildBaseSlave(base, widget, isChild);
            if (HussarUtils.isNotEmpty((Object)this.form.getFormCanvas().getCreateSource()) && "1".equals(this.form.getFormCanvas().getCreateSource())) {
                base.setSourceDataModelName(base.getName());
            } else {
                base.setSourceDataModelName(BaseModelBuilder.sourceDataModelName(base.getName()));
            }
            if (CollUtil.isEmpty((Collection)WidgetTool.flatButChildren(new ArrayList(), (List)widget.getChildren()))) {
                slaves.add(base);
                continue;
            }
            NoCodeMSDataModel msModel = new NoCodeMSDataModel();
            this.buildBaseSlave(msModel, widget, isChild);
            msModel.setMasterTable(base);
            msModel.setSlaveTables(this.slaves(WidgetTool.flatButChildren(new ArrayList(), (List)widget.getChildren()), false));
            slaves.add(msModel);
        }
        return slaves;
    }

    public HeDataModelBase buildBaseSlave(HeDataModelBase base, Widget widget, boolean isChild) throws IOException {
        if (HussarUtils.equals((Object)FormCreateTypeEnum.FORM_TO_FORM.getType(), (Object)this.form.getFormCanvas().getCreateSource())) {
            base.setId(widget.getName() + this.form.getFormCanvas().getId());
        } else {
            base.setId(widget.getName());
        }
        base.setName(widget.getName());
        base.setComment(widget.getTitle());
        base.setDataSourceName(NoCodeBusinessDB.getNocodeBusinessDB());
        base.setFunctionType("BASE");
        base.setTableDesc(base.getComment());
        this.model.setCreateSource(this.form.getFormCanvas().getCreateSource());
        this.model.setNocode(true);
        BaseModelBuilder builder = new BaseModelBuilder();
        builder.init(this.form);
        List<HeDataModelField> fields = BaseModelBuilder.fields(this.form, base, widget.getChildren());
        fields.add(this.foreign("F_", base.getId()));
        if (!isChild) {
            fields.add(this.foreign("G_", base.getId()));
        }
        fields.add(this.subSort(base.getId()));
        fields.add(this.extraInfoField(base.getId()));
        base.setFields(fields);
        return base;
    }

    private HeDataModelField foreign(String prefix, String modelId) {
        HeDataModelField field = new HeDataModelField();
        field.setId(prefix + this.primary().getName());
        field.setName(prefix + this.primary().getName());
        field.setSourceFieldName(prefix + this.primary().getSourceFieldName());
        field.setDataType("string");
        EngineColumnTypeUtil.getEngineColumnType((String)field.getDataType()).ifPresent(engineColumnType -> field.setSourceDataType(engineColumnType.getJdbcType().getName()));
        field.setDataLength(36);
        field.setSourceDataModelId(modelId);
        field.setUsage("foreign");
        return field;
    }

    private HeDataModelField subSort(String modelId) {
        HeDataModelField field = new HeDataModelField();
        field.setId("SEQ");
        field.setName("SEQ");
        field.setSourceFieldName("SEQ");
        field.setDataType("int");
        EngineColumnTypeUtil.getEngineColumnType((String)field.getDataType()).ifPresent(engineColumnType -> field.setSourceDataType(engineColumnType.getJdbcType().getName()));
        field.setSourceDataModelId(modelId);
        field.setUsage("seq");
        field.setComment("\u6392\u5e8f");
        return field;
    }

    private HeDataModelField extraInfoField(String modelId) {
        HeDataModelField field = new HeDataModelField();
        field.setId("EXTRA_INFO");
        field.setName("EXTRA_INFO");
        field.setSourceFieldName("EXTRA_INFO");
        field.setDataType("text");
        EngineColumnTypeUtil.getEngineColumnType((String)field.getDataType()).ifPresent(engineColumnType -> field.setSourceDataType(engineColumnType.getMysqlType().getName()));
        field.setSourceDataModelId(modelId);
        field.setUsage("extraInfo");
        field.setComment("\u989d\u5916\u4fe1\u606f");
        return field;
    }

    public MsModelBuilder buildRelation() {
        ArrayList<HeRelationshipBase> relationshipBases = new ArrayList<HeRelationshipBase>();
        for (HeDataModelBase slaveTable : this.model.getSlaveTables()) {
            HeRelationshipBase relationshipBase = new HeRelationshipBase();
            ArrayList<HeRelationshipFieldBase> relationships = new ArrayList<HeRelationshipFieldBase>();
            relationshipBase.setCascadeDelete(false);
            relationshipBase.setCascadeUpdate(false);
            relationshipBase.setRelateModelType("collection");
            relationshipBase.setMasterTableId(this.model.getMasterTable().getId());
            relationshipBase.setSlaveTableId(slaveTable.getId());
            relationshipBase.setSlaveTableName(slaveTable.getName());
            HeRelationshipFieldBase fieldBase = new HeRelationshipFieldBase();
            fieldBase.setMode("model");
            fieldBase.setSymbol(SqlConnectEnum._EQUAL.getValue());
            fieldBase.setConnect(ConnectEnum._AND.getType());
            fieldBase.setMasterTableFieldId(this.primary().getId());
            fieldBase.setSlaveTableFieldId(slaveTable.getFields().stream().filter(field -> "foreign".equals(field.getUsage())).findFirst().orElseGet(HeDataModelField::new).getId());
            relationships.add(fieldBase);
            relationshipBase.setRelationships(relationships);
            relationshipBases.add(relationshipBase);
        }
        this.model.setRelationships(relationshipBases);
        return this;
    }

    private HeDataModelField primary() {
        return this.model.getMasterTable().getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElseGet(HeDataModelField::new);
    }

    public MsModelBuilder buildOperation() {
        if (HussarUtils.isEmpty((Object)this.model.getOperations())) {
            ArrayList operations = new ArrayList();
            this.model.setOperations(operations);
        }
        BuilderTool.buildOperation(this.model, this.form, "TableQuery").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FlagDeleteBatch").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "DeleteBatch").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FormQuery").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FormVerify").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FormSave").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FormIncrementSave").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "TableSave").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "echartQuery").ifPresent(ops -> this.model.getOperations().addAll(ops));
        List widgets = this.form.getFormCanvas().widgets();
        Optional<Widget> first = widgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.JXDNSerialNumber.getType())).findFirst();
        if (first.isPresent()) {
            BuilderTool.buildOperation(this.model, this.form, "SelectCount").ifPresent(ops -> this.model.getOperations().addAll(ops));
        }
        return this;
    }

    public MsModelBuilder buildDataTitle() {
        FormSettingSchema setting = this.form.getSetting();
        if (HussarUtils.isEmpty((Object)this.form.getSetting()) || HussarUtils.isNotEmpty((Object)setting) && HussarUtils.isEmpty((Object)setting.getDataTitle())) {
            TitleSchema defaultTitle = new TitleSchema();
            ArrayList<TitleParam> params = new ArrayList<TitleParam>();
            TitleParam createUserParam = new TitleParam();
            createUserParam.setId("param1");
            createUserParam.setName("createUserName");
            createUserParam.setType("field");
            params.add(createUserParam);
            TitleParam formNameParam = new TitleParam();
            formNameParam.setId("param2");
            formNameParam.setName(this.form.getFormCanvas().getId());
            formNameParam.setType("formName");
            params.add(formNameParam);
            defaultTitle.setParams(params);
            defaultTitle.setCustom("${param1}\u53d1\u8d77\u7684${param2}");
            defaultTitle.setDefaultVal("${param1}\u53d1\u8d77\u7684${param2}");
            defaultTitle.setMode("defaultVal");
            this.model.getHeColumRule().setDataTitle(defaultTitle);
            return this;
        }
        TitleSchema title = new TitleSchema();
        BeanUtil.copyProperties((Object)this.form.getSetting().getDataTitle(), (Object)title);
        BuilderTool.wrapTitle(this.form, title);
        this.model.getHeColumRule().setDataTitle(title);
        return this;
    }

    public MsModelBuilder buildDataSummary() {
        FormSettingSchema setting = this.form.getSetting();
        TitleSchema summary = new TitleSchema();
        summary.setMode("default");
        ArrayList<TitleParam> params = new ArrayList<TitleParam>();
        if (HussarUtils.isEmpty((Object)setting) || HussarUtils.isNotEmpty((Object)setting) && HussarUtils.isEmpty((Object)setting.getDataSummary())) {
            summary.setParams(params);
            summary.setCustom("");
            this.model.getHeColumRule().setDataSummary(summary);
            return this;
        }
        int paramIndex = 1;
        StringBuilder custom = new StringBuilder();
        List widgets = this.form.getFormCanvas().widgetsWithSys();
        for (String summaryStr : setting.getDataSummary()) {
            Widget find = widgets.stream().filter(widget -> widget.getName().equals(summaryStr)).findFirst().orElseGet(Widget::new);
            TitleParam param = new TitleParam.TitleParamBuilder().withId("param" + paramIndex).withName(summaryStr).withType("field").withWidgetTitle(find.getTitle()).withWidgetType(find.getType()).build();
            find.newInstance(this.form).wrapTitle(new TitleSchema(), param);
            params.add(param);
            custom.append("${param").append(paramIndex).append("}");
            ++paramIndex;
        }
        summary.setParams(params);
        summary.setCustom(custom.toString());
        this.model.getHeColumRule().setDataSummary(summary);
        return this;
    }

    public MsModelBuilder buildSerialNumber() {
        SerialNumSchema serialNumSchema = new SerialNumSchema();
        List widgets = this.form.getFormCanvas().widgets();
        ArrayList<TitleParam> titleParams = new ArrayList<TitleParam>();
        Optional<Widget> first = widgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.JXDNSerialNumber.getType())).findFirst();
        if (first.isPresent()) {
            Widget serialNum = first.get();
            JSONObject props = serialNum.getProps();
            Optional value = Optional.of(new ArrayList());
            String code = "";
            if (HussarUtils.isNotEmpty((Object)props)) {
                if ("existing".equals(props.getString("defaultRule"))) {
                    String ruleCodeId = props.getString("defaultRuleExisting");
                    ISysCodeRuleService iSysCodeRuleService = (ISysCodeRuleService)SpringUtil.getBean(ISysCodeRuleService.class);
                    ApiResponse pageApiResponse = iSysCodeRuleService.getCodeRule(Long.valueOf(ruleCodeId));
                    SysCodeRuleVo record = (SysCodeRuleVo)pageApiResponse.getData();
                    if (HussarUtils.isEmpty((Object)record)) {
                        throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d41\u2f54\u53f7\u2f63\u6210\u89c4\u5219\uff0c\u8bf7\u786e\u8ba4\u89c4\u5219\u914d\u7f6e\u662f\u5426\u6b63\u786e");
                    }
                    List rules = record.getSysCodeRuleInfoList().stream().map(this::convertToSerialNumRuleDTO).collect(Collectors.toList());
                    value = Optional.of(rules);
                    code = record.getCodeRuleCode();
                } else {
                    value = JsonParser.value((Object)props, (String)"$rules", List.class);
                    code = this.form.getFormCanvas().getName();
                }
            }
            JSONArray jsonArray = new JSONArray();
            jsonArray.addAll((Collection)value.orElse(new ArrayList()));
            List serialNumRuleDTOs = jsonArray.toJavaList(SerialNumRuleDTO.class);
            int paramIndex = 1;
            for (SerialNumRuleDTO serialNumRuleDTO : serialNumRuleDTOs) {
                if (HussarUtils.equals((Object)"field", (Object)serialNumRuleDTO.getName())) continue;
                for (Widget find : widgets) {
                    if (!HussarUtils.equals((Object)find.getName(), (Object)serialNumRuleDTO.getName())) continue;
                    TitleParam param = new TitleParam.TitleParamBuilder().withId("param" + paramIndex).withType("field").withName(find.getName()).withWidgetTitle(find.getTitle()).withWidgetType(find.getType()).build();
                    find.newInstance(this.form).wrapTitle(new TitleSchema(), param);
                    titleParams.add(param);
                    ++paramIndex;
                }
            }
            serialNumSchema.setCode(code);
            serialNumSchema.setParams(titleParams);
        }
        this.model.getHeColumRule().setSerialNumber(serialNumSchema);
        return this;
    }

    private SerialNumRuleDTO convertToSerialNumRuleDTO(SysCodeRuleInfo sysCodeRuleInfo) {
        SerialNumRuleDTO serialNumRuleDTO = new SerialNumRuleDTO();
        SerialNumRuleConfig config = new SerialNumRuleConfig();
        String type = sysCodeRuleInfo.getElementType();
        serialNumRuleDTO.setType(type);
        if (HussarUtils.equals((Object)"variable", (Object)type)) {
            serialNumRuleDTO.setName(sysCodeRuleInfo.getElementPattern());
            serialNumRuleDTO.setType("field");
            config.setLengthFixed(false);
        } else {
            serialNumRuleDTO.setName(type);
            serialNumRuleDTO.setType(type);
        }
        config.setValue("");
        config.setId(sysCodeRuleInfo.getId());
        serialNumRuleDTO.setConfig(config);
        return serialNumRuleDTO;
    }
}

