/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.function.visitor.task;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.HeOperationVisitor;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryConditionField;
import com.jxdinfo.hussar.formdesign.engine.util.HeEnginePushUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.NoCodeBaseDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.task.TaskDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.visitor.HeOperationDefault;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.choreo.api.dto.SingleTableDto;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessPmDto;
import com.jxdinfo.hussar.support.engine.api.enums.ConditionType;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.ParameterType;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessPm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component(value="NO_CODE_ENGINETASKSelectCount")
public class TaskSelectCountVisitor
extends HeOperationDefault<TaskDataModel>
implements HeOperationVisitor<TaskDataModel, HeDataModelBaseDTO> {
    private static final String methodDesc = "\u8ba1\u7b97\u6570\u91cf";
    private static final Logger logger = LoggerFactory.getLogger(TaskSelectCountVisitor.class);
    public static final String OPERATION_NAME = "NO_CODE_ENGINETASKSelectCount";

    public void visit(HeBackCtx<TaskDataModel, HeDataModelBaseDTO> backCtx, HeDataModelOperation dataModelOperation, PushBackCtx engineCtx) throws LcdpException, IOException {
        logger.debug("\u8c03\u7528\u4efb\u52a1\u5355\u8868\u6a21\u578b\uff1a\u63a8\u9001\u8ba1\u7b97\u6570\u91cf\u65b9\u6cd5\u5f00\u59cb");
        TaskDataModel taskDataModel = (TaskDataModel)backCtx.getUseDataModelBase();
        HeDataModelBaseDTO dataModelBaseDTO = (HeDataModelBaseDTO)backCtx.getUseDataModelDtoMap().get(taskDataModel.getId());
        logger.debug("\u4efb\u52a1\u6a21\u578b\uff1a\u63a8\u9001\u5b50\u8868\uff08\u4e1a\u52a1\u5355\u8868\uff09\u81f3\u89e3\u6790\u5f15\u64ce");
        SingleTableDto dto = new SingleTableDto();
        dto.setBusinessId(HeEnginePushUtil.getUrl((String)HttpMethod.POST.name(), (String)dataModelOperation.getName(), (HeDataModelBaseDTO)dataModelBaseDTO));
        dto.setMethodDesc(methodDesc);
        dto.setMethodName("selectObjs");
        dto.setPagination(false);
        NodeBusinessPm nodeBusinessPm = new NodeBusinessPm();
        nodeBusinessPm.setFunctionName("COUNT");
        nodeBusinessPm.setParameterType(ParameterType.fun);
        nodeBusinessPm.setParameterAlias("count");
        NodeBusinessPmDto businessPmDto = new NodeBusinessPmDto();
        businessPmDto.setValueType("java.lang.Integer");
        businessPmDto.setConstValue("1");
        businessPmDto.setParameterType(ParameterType.cons);
        ArrayList<NodeBusinessPmDto> businessPmDtos = new ArrayList<NodeBusinessPmDto>();
        businessPmDtos.add(businessPmDto);
        nodeBusinessPm.setParameters(businessPmDtos);
        ArrayList<NodeBusinessPm> pms = new ArrayList<NodeBusinessPm>();
        pms.add(nodeBusinessPm);
        dto.setPmList(pms);
        dto.setWhereList(new ArrayList());
        NoCodeBaseDataModel dataModelBase = (NoCodeBaseDataModel)backCtx.getUseDataModelBase();
        String selectConditionStr = Optional.ofNullable(dataModelOperation.getParams()).map(o -> o.get("selectCondition")).orElse(null);
        HeQueryCondition selectCondition = HussarUtils.isNotBlank((CharSequence)selectConditionStr) ? dataModelBase.getQuConBaseByName(selectConditionStr) : null;
        Map<String, String> tableNameFiledName2ColumnName = dataModelBaseDTO.getFields().stream().collect(Collectors.toMap(x -> x.getTableName() + "." + x.getPropertyName(), HeDataModelFieldDto::getName));
        TaskSelectCountVisitor.getWhere(backCtx, tableNameFiledName2ColumnName, dto.getWhereList(), engineCtx.getColumnMap(), selectCondition.getFields(), null);
        engineCtx.setModelId(taskDataModel.getBusinessId());
        HeEnginePushUtil.push((PushBackCtx)engineCtx, null, (SingleTableDto)dto, (int)1);
        HeDataModelBaseDTO taskDto = (HeDataModelBaseDTO)backCtx.getUseDataModelDtoMap().get(((TaskDataModel)backCtx.getUseDataModelBase()).getId());
        logger.debug("api\u751f\u6210");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "get", taskDto.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5355\u8868\u8ba1\u7b97\u6570\u91cf\u67e5\u8be2");
        logger.debug("\u4efb\u52a1\u5355\u8868\u6a21\u578b\uff1a\u63a8\u9001\u8ba1\u7b97\u6570\u91cf\u65b9\u6cd5\u7ed3\u675f");
    }

    @Override
    public Optional<List<HeDataModelOperation>> build(TaskDataModel model, FormSchema form, String operationType) throws LcdpException {
        List<HeDataModelOperation> operations = super.build(model, form, operationType).get();
        List widgets = form.getFormCanvas().widgets();
        Optional<Widget> first = widgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.JXDNSerialNumber.getType())).findFirst();
        if (!first.isPresent()) {
            return Optional.of(operations);
        }
        Widget widget = first.get();
        HashMap<String, String> params = new HashMap<String, String>(3);
        String conditionName = model.getName() + "Condition_count";
        params.put("selectCondition", conditionName);
        ArrayList<HeQueryCondition> heQueryConditions = new ArrayList<HeQueryCondition>();
        HeQueryCondition queryCondition = new HeQueryCondition();
        queryCondition.setName(conditionName);
        ArrayList<HeQueryConditionField> fields = new ArrayList<HeQueryConditionField>();
        HeQueryConditionField field = new HeQueryConditionField();
        field.setFromModelId(model.getId());
        field.setFromModelField(widget.getName());
        field.setSymbol(SqlConnectEnum._IS_NULL.getKey());
        field.setType(ConnectEnum._ROW.getType());
        field.setConnect(ConnectEnum._AND.getType());
        field.setQueryAttrName(model.getName() + field.getFromModelField() + field.getSymbol());
        fields.add(field);
        queryCondition.setFields(fields);
        heQueryConditions.add(queryCondition);
        List<HeQueryCondition> queryConditions = model.getQueryConditions();
        if (HussarUtils.isEmpty(queryConditions)) {
            queryConditions = new ArrayList<HeQueryCondition>();
        }
        queryConditions.addAll(heQueryConditions);
        model.setQueryConditions(queryConditions);
        operations.get(0).setParams(params);
        return Optional.of(operations);
    }

    private static void getWhere(HeBackCtx<TaskDataModel, HeDataModelBaseDTO> backCtx, Map<String, String> tableNameFiledName2ColumnName, List<NodeBusinessPm> whereList, Map<String, MetadataColumn> columnMap, List<HeQueryConditionField> fields, Long pId) {
        for (HeQueryConditionField field : fields) {
            if (ToolUtil.isEmpty((Object)backCtx.getUseDataModelDtoMap())) {
                logger.error("\u672a\u521d\u59cb\u5316\u53d1\u5e03\u4e0a\u4e0b\u6587\uff0c\u6a21\u578bmap\u4e3a\u7a7a");
                continue;
            }
            HeDataModelBaseDTO heDataModelBaseDTO = (HeDataModelBaseDTO)backCtx.getUseDataModelDtoMap().get(field.getFromModelId());
            if (heDataModelBaseDTO == null) {
                logger.error("\u6a21\u578bid\u672a\u627e\u5230");
                continue;
            }
            List heDataModelBaseFields = heDataModelBaseDTO.getFields();
            if (ToolUtil.isEmpty((Object)heDataModelBaseFields)) {
                logger.error("\u6a21\u578b\u672a\u627e\u5230\u5217");
                continue;
            }
            String fromModelFieldName = field.getFromModelField();
            for (HeDataModelFieldDto heDataModelBaseField : heDataModelBaseFields) {
                if (!heDataModelBaseField.getId().equals(field.getFromModelField()) && !heDataModelBaseField.getPropertyName().equals(field.getFromModelField())) continue;
                fromModelFieldName = heDataModelBaseField.getPropertyName();
            }
            MetadataColumn column = HeEnginePushUtil.getMetadataColumn(columnMap, (String)(heDataModelBaseDTO.getSourceDataModelName() + "-" + fromModelFieldName));
            if (column == null) continue;
            NodeBusinessPm nodeBusinessPm = HeEnginePushUtil.getNodeBusinessPm((String)field.getQueryAttrName(), (MetadataColumn)column);
            nodeBusinessPm.setMatchType("and".equals(field.getConnect()) ? MatchTypeEnum.AND : MatchTypeEnum.OR);
            nodeBusinessPm.setOperatorType(HeExternalApiUtil.getOperatorType((String)field.getSymbol()));
            nodeBusinessPm.setParameterType(ParameterType.where);
            nodeBusinessPm.setParentId(pId);
            nodeBusinessPm.setDefaultValue(field.getVal());
            nodeBusinessPm.setConditionType(ConditionType.PRE);
            whereList.add(nodeBusinessPm);
        }
    }
}

