/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.tool;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.datasource.manager.api.entity.RecycleBin;
import com.jxdinfo.hussar.datasource.manager.api.service.RecycleBinService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeEditDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.util.HEDataModelUtil;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.visitor.HeOperationDefault;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeModelTool;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public class BuilderTool {
    public static TableCorrespond<DataModelFieldBase> contrast(HeDataModelBase newModel) throws IOException, LcdpException {
        String tablelName = newModel.getSourceDataModelName();
        List recycleBins = new ArrayList();
        RecycleBinService recycleBinService = (RecycleBinService)SpringUtil.getBean(RecycleBinService.class);
        List<Object> oldFields = new ArrayList<HeDataModelField>();
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        String tableNameQuery = HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.POSTGRE_SQL.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.KINGBASE.name(), (Object)dbType) ? tablelName.toLowerCase() : tablelName.toUpperCase();
        Optional tableInfo = DataModelUtil.filterTable((String)newModel.getDataSourceName(), (String)"BASE TABLE", (String)tableNameQuery);
        if (tableInfo.isPresent()) {
            TableInfo table = (TableInfo)tableInfo.get();
            oldFields = HEDataModelUtil.htabTransmodel((List)table.getFields());
            recycleBins = recycleBinService.getByTableName(table.getName());
        }
        TableCorrespond<DataModelFieldBase> tableCorrespond = BuilderTool.compare(oldFields, newModel.getFields());
        ArrayList<HeDataModelField> copyOldFields = new ArrayList<HeDataModelField>();
        copyOldFields.addAll(oldFields);
        block0: for (HeDataModelField heDataModelField : oldFields) {
            for (RecycleBin recycleBin : recycleBins) {
                if (!heDataModelField.getSourceFieldName().equals(recycleBin.getColumnName())) continue;
                copyOldFields.remove(heDataModelField);
                continue block0;
            }
        }
        TableCorrespond<DataModelFieldBase> recycleCompare = BuilderTool.compare(copyOldFields, newModel.getFields());
        List list = JSON.parseArray((String)recycleCompare.getDelFields(), HeDataModelField.class);
        ArrayList<RecycleBin> appendRecycleBins = new ArrayList<RecycleBin>();
        for (HeDataModelField field : list) {
            RecycleBin recycleBin = new RecycleBin();
            recycleBin.setTableName(tablelName);
            recycleBin.setColumnName(field.getSourceFieldName());
            recycleBin.setColumnJson(JSON.toJSONString((Object)field));
            appendRecycleBins.add(recycleBin);
        }
        recycleBinService.saveColumns(appendRecycleBins);
        tableCorrespond.setOldTableName(tablelName);
        tableCorrespond.setModelId(newModel.getId());
        tableCorrespond.setDelFields("");
        return tableCorrespond;
    }

    public static TableCorrespond<DataModelFieldBase> compare(List<HeDataModelField> oldFields, List<HeDataModelField> newFields) {
        ArrayList<HeDataModelField> addFields = new ArrayList<HeDataModelField>();
        ArrayList<HeEditDataModelField> editFields = new ArrayList<HeEditDataModelField>();
        TableCorrespond tableCorrespond = new TableCorrespond();
        ArrayList delFields = new ArrayList();
        CollectionUtils.addAll(delFields, (Object[])new Object[oldFields.size()]);
        Collections.copy(delFields, oldFields);
        for (HeDataModelField newField : newFields) {
            boolean has = false;
            for (HeDataModelField oldField : oldFields) {
                if (!oldField.getSourceFieldName().equalsIgnoreCase(newField.getSourceFieldName())) continue;
                if (newField.getDataLength() > oldField.getDataLength() || !HussarUtils.equals((Object)newField.getDataDefaultValue(), (Object)oldField.getDataDefaultValue())) {
                    HeEditDataModelField edit = new HeEditDataModelField();
                    edit.setNewField(newField);
                    edit.setOldField(oldField);
                    editFields.add(edit);
                }
                delFields.remove(oldField);
                has = true;
                break;
            }
            if (has) continue;
            addFields.add(newField);
        }
        tableCorrespond.setAddFields(JSON.toJSONString(addFields));
        tableCorrespond.setDelFields(JSON.toJSONString(delFields));
        tableCorrespond.setModifyFields(JSON.toJSONString(editFields));
        return tableCorrespond;
    }

    public static Optional<List<HeDataModelOperation>> buildOperation(HeDataModelBase dataModelBase, FormSchema form, String operationType) {
        try {
            HeOperationDefault<HeDataModelBase> visitor = NoCodeModelTool.getVisitorDefault(dataModelBase.strategy(), dataModelBase.getFunctionType(), operationType);
            return visitor.build(dataModelBase, form, operationType);
        }
        catch (LcdpException e) {
            ToolUtil.getLogger(BuilderTool.class).error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u7b56\u7565\uff1a{}\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", new Object[]{dataModelBase.strategy(), dataModelBase.getFunctionType(), operationType});
            throw new RuntimeException(e);
        }
    }

    public static void wrapTitle(FormSchema form, TitleSchema title) {
        List widgets = form.getFormCanvas().widgetsWithSys();
        List widgetsCopy = WidgetTool.settingWidgets((List)widgets, widget -> WidgetTool.anyMatch((String)widget.getType(), (String[])new String[]{WidgetType.IMAGE.getType(), WidgetType.FILE.getType(), WidgetType.JXDNRichText.getType()}) || WidgetTool.anyMatch((String)widget.getName(), (String[])new String[]{"createUser_user", "updateUser_user", "post", "dataOrgan", "staff", "postName"}));
        List params = title.getParams();
        for (TitleParam param : params) {
            Optional widgetOpt;
            if (param.getType().equals("field")) {
                // empty if block
            }
            if (!(widgetOpt = WidgetTool.filterWidgets((List)widgetsCopy, widget -> widget.getName().equals(param.getName()))).isPresent()) continue;
            Widget widget2 = (Widget)((List)widgetOpt.get()).get(0);
            widget2.newInstance(form).wrapTitle(title, param);
        }
    }
}

