/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.function.element.task;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.engine.constant.TypeConversionEnum;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationDTO;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.service.HeModelPublishService;
import com.jxdinfo.hussar.formdesign.engine.util.HEDataModelUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEModelBeanUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEOperationUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.NoCodeBaseDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.masterslave.NoCodeMSDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeModelTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class TaskMsDataModel
extends NoCodeMSDataModel {
    public static final String FUNCTION_TYPE = "TASK_MASTER_SLAVE";
    private NoCodeBaseDataModel task;
    private HeRelationshipBase relationship;
    private String processKey;

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)String.format("%s%s", "NO.", FUNCTION_TYPE), TaskMsDataModel.class);
    }

    @Override
    public NoCodeMSDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        return super.parseDataModel(jsonObject);
    }

    public String getProcessKey() {
        return this.processKey;
    }

    public void setProcessKey(String processKey) {
        this.processKey = processKey;
    }

    public NoCodeBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(NoCodeBaseDataModel task) {
        this.task = task;
    }

    public HeRelationshipBase getRelationship() {
        return this.relationship;
    }

    public void setRelationship(HeRelationshipBase relationship) {
        this.relationship = relationship;
    }

    @Override
    public List<ContrastVO<HeDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public List<ContrastVO<HeDataModelField>> tableContrastModel(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel(fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<HeDataModelField>> modelContrastTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTable(fieldsContrastParam);
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        return super.checkTableContrast(modelId);
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        return super.updateTable(fieldsContrastParam) != false && this.task.updateTable(fieldsContrastParam) != false;
    }

    @Override
    public void sync() throws IOException, LcdpException {
        this.task.metaDataSync();
        this.metaDataSync();
        this.syncModel(FUNCTION_TYPE);
    }

    @Override
    public void syncById() throws IOException, LcdpException {
        this.task.metaDataSyncById();
        this.metaDataSyncById();
        this.syncModel(FUNCTION_TYPE);
    }

    @Override
    public void syncModel(String functionType) {
        ModelPublishDTO taskMasterDTO = HEOperationUtil.ModelToEngine((HeDataModelBase)this.task);
        taskMasterDTO.setType(TypeConversionEnum.getValueByKey((String)functionType).getValue());
        HeRelationDTO taskRelation = HEDataModelUtil.slaveRelationSync((ModelPublishDTO)taskMasterDTO, (HeDataModelBase)this.task, Collections.singletonList(this.getMasterTable()), Collections.singletonList(this.relationship), (String)functionType);
        ModelPublishDTO businessMasterDTO = (ModelPublishDTO)taskRelation.getSlavePublishDTO().get(0);
        HeRelationDTO businessMsRelation = HEDataModelUtil.slaveRelationSync((ModelPublishDTO)businessMasterDTO, (HeDataModelBase)this.getMasterTable(), this.getSlaveTables(), this.getRelationships(), (String)functionType);
        businessMasterDTO.setModelColumnsRules(NoCodeModelTool.dealColumnsRules(this.getMasterTable().getFields(), this.getHeColumRule()));
        for (int i = 0; i < this.getSlaveTables().size(); ++i) {
            ((ModelPublishDTO)businessMsRelation.getSlavePublishDTO().get(i)).setModelColumnsRules(NoCodeModelTool.dealColumnsRules(this.getSlaveTables().get(i).getFields(), null));
        }
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        resultList.add(taskRelation.getMasterPublishDTO());
        resultList.addAll(businessMsRelation.getSlavePublishDTO());
        resultList.add(businessMsRelation.getMasterPublishDTO());
        ((ModelRelateService)SpringUtil.getBean(ModelRelateService.class)).save(resultList);
    }

    @Override
    public void syncModelById(String functionType) {
        ModelPublishDTO taskMasterDTO = HEOperationUtil.ModelToEngineById((HeDataModelBase)this.task);
        taskMasterDTO.setType(TypeConversionEnum.getValueByKey((String)functionType).getValue());
        HeRelationDTO taskRelation = HEDataModelUtil.slaveRelationSyncById((ModelPublishDTO)taskMasterDTO, (HeDataModelBase)this.task, Collections.singletonList(this.getMasterTable()), Collections.singletonList(this.relationship), (String)functionType);
        ModelPublishDTO businessMasterDTO = (ModelPublishDTO)taskRelation.getSlavePublishDTO().get(0);
        HeRelationDTO businessMsRelation = HEDataModelUtil.slaveRelationSyncById((ModelPublishDTO)businessMasterDTO, (HeDataModelBase)this.getMasterTable(), this.getSlaveTables(), this.getRelationships(), (String)functionType);
        businessMasterDTO.setModelColumnsRules(NoCodeModelTool.dealColumnsRules(this.getMasterTable().getFields(), this.getHeColumRule()));
        for (int i = 0; i < this.getSlaveTables().size(); ++i) {
            ((ModelPublishDTO)businessMsRelation.getSlavePublishDTO().get(i)).setModelColumnsRules(NoCodeModelTool.dealColumnsRules(this.getSlaveTables().get(i).getFields(), null));
        }
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        resultList.add(taskRelation.getMasterPublishDTO());
        resultList.addAll(businessMsRelation.getSlavePublishDTO());
        resultList.add(businessMsRelation.getMasterPublishDTO());
        ((ModelRelateService)SpringUtil.getBean(ModelRelateService.class)).save(resultList);
    }

    @Override
    public void metaDataSync() throws IOException, LcdpException {
        super.metaDataSync();
    }

    @Override
    public void metaDataSyncById() throws IOException, LcdpException {
        super.metaDataSyncById();
    }

    @Override
    public void delete(String modelId) throws LcdpException {
        super.delete(modelId);
    }

    @Override
    public void delete() {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        modelRelateService.delete(this.task.getId());
        super.delete();
    }

    @Override
    public String copyTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        return super.copyTable(fieldsContrastParam);
    }

    @Override
    public PushBackCtx getPushBackCtx() {
        return super.getPushBackCtx();
    }

    @Override
    public PushBackCtx getPushBackCtxById() {
        return super.getPushBackCtxById();
    }

    @Override
    public List<String> getIds() {
        ArrayList<String> ids = new ArrayList<String>();
        List slaveIds = this.getSlaveTables().stream().map(DataModelBase::getId).collect(Collectors.toList());
        ids.add(this.getMasterTable().getId());
        ids.addAll(slaveIds);
        ids.add(this.task.getId());
        return ids;
    }

    public Map<String, MetadataColumn> getTaskColumnMap() {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.task.getId());
        ids.addAll(this.getIds());
        HashMap<String, MetadataColumn> columnMap = new HashMap<String, MetadataColumn>();
        for (String id : ids) {
            TableInfoDto tableInfo = HeExternalApiUtil.getTableInfoById((String)id, (boolean)true);
            if (!HussarUtils.isNotEmpty((Object)tableInfo)) continue;
            for (MetadataColumn column : tableInfo.getColumnList()) {
                columnMap.putIfAbsent(column.getColumnName(), column);
                columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
            }
        }
        return columnMap;
    }

    public PushBackCtx getTaskPushBackCtx() {
        String modelName = this.getName();
        PushBackCtx ctx = new PushBackCtx();
        ctx.setModelName(modelName);
        ctx.setModelId(((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(this.task.getId()).getRelatedId());
        ctx.setColumnMap(this.getTaskColumnMap());
        ctx.isMs = true;
        ctx.build();
        return ctx;
    }

    @Override
    public String strategy() {
        return "NO_CODE_ENGINE";
    }

    @Override
    public void initMasterSlave(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx) {
        super.initMasterSlave(backCtx);
        HeModelPublishService publishService = (HeModelPublishService)SpringUtil.getBean(HeModelPublishService.class);
        HeDataModelBaseDTO taskMasterDto = publishService.enclosure((HeDataModelBase)this.task);
        backCtx.getDataModelBaseMap().put(this.task.getId(), this.task);
        backCtx.getUseDataModelDtoMap().put(this.task.getId(), taskMasterDto);
        HeDataModelBaseDTO msDto = publishService.enclosure((HeDataModelBase)this);
        HeDataModelBaseDTO masterDto = publishService.enclosure(this.getMasterTable());
        msDto.getFields().clear();
        msDto.setFields(masterDto.getFields());
        msDto.getFields().addAll(taskMasterDto.getFields());
        List<HeDataModelBase> slaveTables = this.getSlaveTables();
        for (HeDataModelBase slaveTable : slaveTables) {
            HeDataModelBaseDTO slaveTableDto = publishService.enclosure(slaveTable);
            msDto.getFields().addAll(slaveTableDto.getFields());
        }
        HashMap<String, HeDataModelBaseDTO> dtoMap = new HashMap<String, HeDataModelBaseDTO>(1);
        dtoMap.put(this.getId(), msDto);
        backCtx.setTaskDtoMap(dtoMap);
    }

    public void customOption(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        HEModelBeanUtil.getCustomOperationBean((String[])new String[]{"NO_CODE_ENGINE", FUNCTION_TYPE, "CUSTOM_OPTION"}).publishCustomOption(backCtx, engineCtx);
    }
}

