/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.function.element.task;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.annotation.BuilderType;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipBase;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.BaseModelBuilder;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.NoCodeBaseDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.masterslave.MsModelBuilder;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.masterslave.NoCodeMSDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.task.TaskModelBuilder;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.task.TaskMsDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.BuilderTool;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineBuildStrategyEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.builder.BuilderCtx;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.flow.FlowFormVO;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@BuilderType(type="NO.TASK_MASTER_SLAVE")
public class TaskMsModelBuilder
extends DataModelBuilder {
    private TaskMsDataModel model;
    private FormSchema form;

    public String strategy() {
        return String.format("%s%s", "NO.", EngineBuildStrategyEnum.TASK_MASTER_SLAVE);
    }

    public void init(FormSchema form) {
        this.form = form;
        this.model = new TaskMsDataModel();
    }

    public NoCodeMSDataModel direct() throws IOException {
        MsModelBuilder msModelBuilder = new MsModelBuilder();
        msModelBuilder.init(this.form);
        NoCodeMSDataModel ms = msModelBuilder.direct();
        BeanUtil.copyProperties((Object)((Object)ms), (Object)((Object)this.model), (String[])new String[]{"functionType", "operations", "queryConditions", "sortConditions", "masterTable"});
        this.model.setFunctionType("TASK_MASTER_SLAVE");
        this.model.setOperations(new ArrayList());
        this.model.setProcessKey(this.form.getFormCanvas().getIdentity());
        return this.buildTask().buildBusiness().buildTaskRelation().buildTaskOperation().build();
    }

    public NoCodeMSDataModel build() {
        return this.model;
    }

    public void build(BuilderCtx ctx) throws IOException {
        ctx.setDataModelBase((DataModelBase)this.direct());
    }

    public FieldsContrastParam<DataModelFieldBase> updateContrast() throws IOException, LcdpException {
        return MsModelBuilder.contrast(this.model);
    }

    public FieldsContrastParam<DataModelFieldBase> createContrast() throws IOException, LcdpException {
        FieldsContrastParam<DataModelFieldBase> contrastParam = this.updateContrast();
        NoCodeBaseDataModel master = this.model.getTask();
        TableCorrespond<DataModelFieldBase> taskTableCorrespond = BuilderTool.contrast(master);
        taskTableCorrespond.setModelId(master.getId());
        taskTableCorrespond.setOldTableName(master.getSourceDataModelName());
        contrastParam.getTableCorresponds().add(taskTableCorrespond);
        return contrastParam;
    }

    public FlowFormVO getFlowFormVO() {
        FlowFormVO flowFormVO = new FlowFormVO();
        flowFormVO.setMasterTableName(this.model.getMasterTable().getSourceDataModelName());
        flowFormVO.setTaskTableName(this.model.getTask().getSourceDataModelName());
        flowFormVO.setMasterTablePrimary(this.primary().getSourceFieldName());
        flowFormVO.setIdentity(this.form.getIdentity());
        flowFormVO.setFormPath("");
        return flowFormVO;
    }

    public void clearFieldForImport(DataModelBase dataModelBase) {
        TaskMsDataModel dataModel = (TaskMsDataModel)dataModelBase;
        HeDataModelBase masterTable = dataModel.getMasterTable();
        List fields = masterTable.getFields();
        for (HeDataModelField field : fields) {
            if (!HussarUtils.isNotEmpty((Object)field.getUsage()) || !WidgetTool.anyMatch((String)field.getUsage(), (String[])new String[]{"createUser", "updateUser", "createTime", "updateTime", "serialNumber", "dataOrgan", "title"})) continue;
            field.setUsage(null);
        }
    }

    public TaskMsModelBuilder buildTask() {
        this.model.setTask(TaskModelBuilder.task(this.form.getFormCanvas(), "/task/process_task_info.json"));
        return this;
    }

    public TaskMsModelBuilder buildBusiness() throws IOException {
        BaseModelBuilder builder = new BaseModelBuilder();
        builder.init(this.form);
        NoCodeBaseDataModel base = builder.buildBase().buildFields().build();
        String content = PageBuilderFactory.getTaskProcessInfo();
        List fields = JSON.parseArray((String)content, HeDataModelField.class);
        base.getFields().addAll(fields);
        base.getFields().forEach(f -> f.setSourceDataModelId(base.getId()));
        this.model.setMasterTable(base);
        return this;
    }

    public TaskMsModelBuilder buildTaskRelation() {
        HeRelationshipBase relationshipBase = new HeRelationshipBase();
        ArrayList<HeRelationshipFieldBase> relationships = new ArrayList<HeRelationshipFieldBase>();
        relationshipBase.setCascadeDelete(false);
        relationshipBase.setCascadeUpdate(false);
        relationshipBase.setRelateModelType("association");
        HeRelationshipFieldBase fieldBase = new HeRelationshipFieldBase();
        fieldBase.setMode("model");
        fieldBase.setSymbol(SqlConnectEnum._EQUAL.getValue());
        fieldBase.setConnect(ConnectEnum._AND.getType());
        relationshipBase.setMasterTableId(this.model.getTask().getId());
        relationshipBase.setSlaveTableId(this.model.getMasterTable().getId());
        relationshipBase.setSlaveTableName(this.model.getMasterTable().getName());
        fieldBase.setMasterTableFieldId(this.model.getTask().getFields().stream().filter(field -> "foreign".equals(field.getUsage())).findFirst().orElseGet(HeDataModelField::new).getId());
        fieldBase.setSlaveTableFieldId(this.primary().getId());
        relationships.add(fieldBase);
        relationshipBase.setRelationships(relationships);
        this.model.setRelationship(relationshipBase);
        return this;
    }

    private HeDataModelField primary() {
        return this.model.getMasterTable().getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElseGet(HeDataModelField::new);
    }

    public TaskMsModelBuilder buildTaskOperation() {
        BuilderTool.buildOperation(this.model, this.form, "TableQuery").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FormQuery").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FormVerify").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "DeleteBatch").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FlagDeleteBatch").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FormSave").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "TableSave").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FormIncrementSave").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "EndProcess").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FlowFormRecall").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FlowFormSubmit").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "InitialNodeReject").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "PrevNodeReject").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "AnyNodeReject").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FlowSubmitReject").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FlowRejectBatch").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FlowSubmitBatch").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "AddOrDelAssignee").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "FreeJump").ifPresent(ops -> this.model.getOperations().addAll(ops));
        BuilderTool.buildOperation(this.model, this.form, "TaskEntrust").ifPresent(ops -> this.model.getOperations().addAll(ops));
        List widgets = this.form.getFormCanvas().widgets();
        Optional<Widget> first = widgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.JXDNSerialNumber.getType())).findFirst();
        if (first.isPresent()) {
            BuilderTool.buildOperation(this.model, this.form, "SelectCount").ifPresent(ops -> this.model.getOperations().addAll(ops));
        }
        return this;
    }
}

