/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.function.element.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.engine.constant.FormDesignEngineExceptionEnum;
import com.jxdinfo.hussar.formdesign.engine.constant.TypeConversionEnum;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationDTO;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.service.HeModelPublishService;
import com.jxdinfo.hussar.formdesign.engine.util.HEDataModelUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEModelBeanUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEOperationUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.formdesign.generator.nocode.function.element.base.NoCodeBaseDataModel;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeModelTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskDataModel
extends NoCodeBaseDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(TaskDataModel.class);
    public static final String FUNCTION_TYPE = "TASK";
    private NoCodeBaseDataModel task;
    private HeRelationshipBase relationship;
    private String processKey;

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)String.format("%s%s", "NO.", FUNCTION_TYPE), TaskDataModel.class);
    }

    @Override
    public TaskDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        TaskDataModel dataModel;
        try {
            dataModel = (TaskDataModel)((Object)JSON.parseObject((String)jsonObject.toString(), TaskDataModel.class));
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, FormDesignEngineExceptionEnum.PARSING_OBJECT_FAILED.getMessage());
        }
        return dataModel;
    }

    public String getProcessKey() {
        return this.processKey;
    }

    public void setProcessKey(String processKey) {
        this.processKey = processKey;
    }

    public NoCodeBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(NoCodeBaseDataModel task) {
        this.task = task;
    }

    public HeRelationshipBase getRelationship() {
        return this.relationship;
    }

    public void setRelationship(HeRelationshipBase relationship) {
        this.relationship = relationship;
    }

    @Override
    public void sync() throws IOException, LcdpException {
        this.task.metaDataSync();
        this.metaDataSync();
        this.syncModel(FUNCTION_TYPE);
    }

    @Override
    public void syncById() throws IOException, LcdpException {
        this.task.metaDataSyncById();
        this.metaDataSyncById();
        this.syncModelById(FUNCTION_TYPE);
    }

    @Override
    public void syncModel(String functionType) {
        ModelPublishDTO masterTableInfo = HEOperationUtil.ModelToEngine((HeDataModelBase)this.task);
        masterTableInfo.setType(TypeConversionEnum.getValueByKey((String)functionType).getValue());
        HeRelationDTO relationDTO = HEDataModelUtil.slaveRelationSync((ModelPublishDTO)masterTableInfo, (HeDataModelBase)this.task, Collections.singletonList(this), Collections.singletonList(this.relationship), (String)functionType);
        ((ModelPublishDTO)relationDTO.getSlavePublishDTO().get(0)).setModelColumnsRules(NoCodeModelTool.dealColumnsRules(this.getFields(), this.getHeColumRule()));
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        resultList.add(relationDTO.getMasterPublishDTO());
        resultList.addAll(relationDTO.getSlavePublishDTO());
        ((ModelRelateService)SpringUtil.getBean(ModelRelateService.class)).save(resultList);
    }

    @Override
    public void syncModelById(String functionType) {
        ModelPublishDTO masterTableInfo = HEOperationUtil.ModelToEngineById((HeDataModelBase)this.task);
        masterTableInfo.setType(TypeConversionEnum.getValueByKey((String)functionType).getValue());
        HeRelationDTO relationDTO = HEDataModelUtil.slaveRelationSyncById((ModelPublishDTO)masterTableInfo, (HeDataModelBase)this.task, Collections.singletonList(this), Collections.singletonList(this.relationship), (String)functionType);
        ((ModelPublishDTO)relationDTO.getSlavePublishDTO().get(0)).setModelColumnsRules(NoCodeModelTool.dealColumnsRules(this.getFields(), this.getHeColumRule()));
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        resultList.add(relationDTO.getMasterPublishDTO());
        resultList.addAll(relationDTO.getSlavePublishDTO());
        ((ModelRelateService)SpringUtil.getBean(ModelRelateService.class)).save(resultList);
    }

    @Override
    public void delete(String modelId) throws LcdpException {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        modelRelateService.delete(this.task.getId());
        super.delete(modelId);
    }

    @Override
    public void delete() {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        modelRelateService.delete(this.task.getId());
        super.delete();
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        return super.updateTable(fieldsContrastParam) != false && this.task.updateTable(fieldsContrastParam) != false;
    }

    public Long getMasterId() {
        ModelTableMappingDTO tableInfo = ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(this.task.getId());
        return tableInfo.getRelatedId();
    }

    public Long getBusinessId() {
        ModelTableMappingDTO tableInfo = ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(this.getId());
        return tableInfo.getRelatedId();
    }

    @Override
    public List<String> getSourceDataModelNames() {
        ArrayList<String> tableName = new ArrayList<String>();
        tableName.add(this.task.getSourceDataModelName());
        tableName.add(this.getSourceDataModelName());
        return tableName;
    }

    @Override
    public List<Long> getTableIds() {
        ArrayList<Long> tableId = new ArrayList<Long>();
        tableId.add(this.task.getTableId());
        tableId.add(this.getTableId());
        return tableId;
    }

    @Override
    public List<String> getIds() {
        ArrayList<String> id = new ArrayList<String>();
        id.add(this.task.getId());
        id.add(this.getId());
        return id;
    }

    @Override
    public Map<String, MetadataColumn> getColumnMap() {
        HashMap<String, MetadataColumn> columnMap = new HashMap<String, MetadataColumn>();
        for (String name : this.getSourceDataModelNames()) {
            TableInfoDto tableInfo = HeExternalApiUtil.getTableByName((String)name, (boolean)true);
            if (!HussarUtils.isNotEmpty((Object)tableInfo)) continue;
            for (MetadataColumn column : tableInfo.getColumnList()) {
                columnMap.putIfAbsent(column.getColumnName(), column);
                columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
            }
        }
        return columnMap;
    }

    @Override
    public Map<String, MetadataColumn> getColumnMapById() {
        HashMap<String, MetadataColumn> columnMap = new HashMap<String, MetadataColumn>();
        for (String id : this.getIds()) {
            TableInfoDto tableInfo = HeExternalApiUtil.getTableInfoById((String)id, (boolean)true);
            if (!HussarUtils.isNotEmpty((Object)tableInfo)) continue;
            for (MetadataColumn column : tableInfo.getColumnList()) {
                columnMap.putIfAbsent(column.getColumnName(), column);
                columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
            }
        }
        return columnMap;
    }

    @Override
    public PushBackCtx getPushBackCtx() {
        String modelName = this.getName();
        PushBackCtx ctx = new PushBackCtx();
        ctx.setModelName(modelName);
        ctx.setColumnMap(this.getColumnMap());
        ctx.isMs = false;
        ctx.build();
        return ctx;
    }

    @Override
    public PushBackCtx getPushBackCtxById() {
        String modelName = this.getName();
        PushBackCtx ctx = new PushBackCtx();
        ctx.setModelName(modelName);
        ctx.setColumnMap(this.getColumnMapById());
        ctx.isMs = false;
        ctx.build();
        return ctx;
    }

    @Override
    public String strategy() {
        return "NO_CODE_ENGINE";
    }

    public void initMasterSlave(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx) {
        HeModelPublishService publishService = (HeModelPublishService)SpringUtil.getBean(HeModelPublishService.class);
        HashMap<String, NoCodeBaseDataModel> baseMap = new HashMap<String, NoCodeBaseDataModel>(2);
        HashMap<String, HeDataModelBaseDTO> useDtoMap = new HashMap<String, HeDataModelBaseDTO>(2);
        HashMap<String, HeDataModelBaseDTO> dtoMap = new HashMap<String, HeDataModelBaseDTO>(2);
        NoCodeBaseDataModel masterTable = this.task;
        HeDataModelBaseDTO taskMasterDto = publishService.enclosure((HeDataModelBase)masterTable);
        baseMap.put(masterTable.getId(), masterTable);
        useDtoMap.put(masterTable.getId(), taskMasterDto);
        HeDataModelBaseDTO businessDto = publishService.enclosure((HeDataModelBase)this);
        baseMap.put(this.getId(), this);
        useDtoMap.put(this.getId(), businessDto);
        HeDataModelBaseDTO taskDto = publishService.enclosure((HeDataModelBase)this);
        taskDto.getFields().addAll(taskMasterDto.getFields());
        dtoMap.put(this.getId(), taskDto);
        backCtx.setDataModelBaseMap(baseMap);
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setTaskDtoMap(dtoMap);
    }

    public void customOption(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        HEModelBeanUtil.getCustomOperationBean((String[])new String[]{"NO_CODE_ENGINE", FUNCTION_TYPE, "CUSTOM_OPTION"}).publishCustomOption(backCtx, engineCtx);
    }
}

