/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.nocode.tool;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.HeOperationVisitor;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.service.HeModelPublishService;
import com.jxdinfo.hussar.formdesign.engine.util.HeEnginePushUtil;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeModelHandler;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="no.code.handler")
@HussarTokenDs
public class NoCodeModelHandlerImpl
implements NoCodeModelHandler<HeDataModelBase, HeDataModelField> {
    private static final Logger logger = LoggerFactory.getLogger(NoCodeModelHandlerImpl.class);
    private static final HeModelPublishService LR_MODEL_PUBLISH_SERVICE = (HeModelPublishService)SpringContextHolder.getBean(HeModelPublishService.class);

    public void updateTable(HeDataModelBase dataModelBase, FieldsContrastParam<HeDataModelField> contrast) throws Exception {
        dataModelBase.updateTable(contrast);
    }

    public void sync(HeDataModelBase dataModelBase) throws Exception {
        dataModelBase.syncById();
    }

    public void generate(HeDataModelBase dataModelBase) throws Exception {
        HeBackCtx backCtx = new HeBackCtx();
        NoCodeModelHandlerImpl.init((HeBackCtx<HeDataModelBase, HeDataModelBaseDTO>)backCtx, dataModelBase);
        NoCodeModelHandlerImpl.visit((HeBackCtx<HeDataModelBase, HeDataModelBaseDTO>)backCtx);
    }

    public void delete(HeDataModelBase dataModelBase) throws Exception {
        dataModelBase.delete();
    }

    private static void init(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx, HeDataModelBase dataModelBase) {
        String modelId = dataModelBase.getId();
        HashMap<String, HeDataModelBaseDTO> useDtoMap = new HashMap<String, HeDataModelBaseDTO>(1);
        useDtoMap.put(modelId, LR_MODEL_PUBLISH_SERVICE.enclosure(dataModelBase));
        backCtx.setUseDataModelBase(dataModelBase);
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(dataModelBase.getFunctionType());
        backCtx.addParam("identity", (Object)dataModelBase.getIdentity());
    }

    private static void visit(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx) throws LcdpException, IOException {
        HeDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        PushBackCtx engineCtx = HeEnginePushUtil.getEngineCtxById((HeDataModelBase)useDataModelBase);
        useDataModelBase.initMasterSlave(backCtx);
        for (HeDataModelOperation operation : useDataModelBase.getOperations()) {
            HeOperationVisitor visitor = null;
            try {
                visitor = useDataModelBase.visitor(useDataModelBase.strategy(), backCtx.getModelFunctionTye(), ToolUtil.isNotEmpty((Object)operation.getFlowBusiness()) ? "" : operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u7b56\u7565\uff1a{}\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", new Object[]{useDataModelBase.strategy(), useDataModelBase.getFunctionType(), operation.getType()});
            }
            if (visitor == null) continue;
            useDataModelBase.accept(visitor, backCtx, operation, engineCtx);
        }
        useDataModelBase.customOption(backCtx, engineCtx);
        HeEnginePushUtil.pushApi((PushBackCtx)engineCtx);
    }
}

