/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.provider;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlModelFunction;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.service.WorkFlowVisitorServiceImpl;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MysqlModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(MysqlModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"MYSQL", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + dataModelBase.getName();
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            return FileUtil.posixPath((String[])new String[]{apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        JSONObject dataModelJson = DataModelUtil.getDataModelJson((String)modelId);
        if (ToolUtil.isEmpty((Object)dataModelJson)) {
            return "";
        }
        MysqlModelFunction modelFunction = MysqlModelBeanUtil.getFunctionModelVisitorBean(dataModelJson.getString("functionType"));
        MysqlDataModelBase lrDataModelBase = modelFunction.parseDataModel(dataModelJson);
        return lrDataModelBase.getFields().stream().filter(e -> "primary".equals(e.getUsage())).findFirst().orElseGet(MysqlDataModelField::new).getName();
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        MysqlModelFunction modelFunction = MysqlModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        MysqlDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if (ToolUtil.isNotEmpty(dataModelBase.getOperations())) {
            for (MysqlDataModelOperation operation : dataModelBase.getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                return operation.getName();
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId, String oldVersion, String organId, String newOrganId) throws LcdpException, IOException, CloneNotSupportedException {
        return new WorkFlowVisitorServiceImpl().visitorGeneration(identityKey, workFlowName, modelName, modelId, workflowId, oldVersion, organId, newOrganId);
    }

    public void sync(String modelId) throws LcdpException, IOException {
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        MysqlModelFunction modelFunction = MysqlModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        MysqlDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        ArrayList<DataModelFieldBase> mysqlDataModelFields = new ArrayList<DataModelFieldBase>();
        List<MysqlDataModelField> fields = dataModelBase.getFields();
        if (ToolUtil.isNotEmpty(fields)) {
            mysqlDataModelFields.addAll(fields);
        } else {
            List<MysqlDataModelBase> slaveTables = null;
            MysqlDataModelBase masterTable = new MysqlBaseDataModel();
            if (modelFunction instanceof MysqlFlowMsDataModel) {
                slaveTables = ((MysqlFlowMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((MysqlFlowMsDataModel)dataModelBase).getMasterTable();
            } else if (modelFunction instanceof MysqlMsDataModel) {
                slaveTables = ((MysqlMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((MysqlFlowMsDataModel)dataModelBase).getMasterTable();
            }
            mysqlDataModelFields.addAll(masterTable.getFields());
            if (ToolUtil.isNotEmpty(slaveTables)) {
                for (MysqlDataModelBase slaveTable : slaveTables) {
                    mysqlDataModelFields.addAll(slaveTable.getFields());
                }
            }
        }
        if (modelFunction instanceof MysqlTaskDataModel) {
            mysqlDataModelFields.addAll(((MysqlTaskDataModel)dataModelBase).getTask().getFields());
        } else if (modelFunction instanceof MysqlTaskMsDataModel) {
            mysqlDataModelFields.addAll(((MysqlTaskMsDataModel)dataModelBase).getTask().getFields());
        }
        return mysqlDataModelFields;
    }

    public void delete(String modelId) throws LcdpException {
    }

    public Map<String, Map<String, Object>> getSlaveModelInfos(String modelId) throws LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        MysqlModelFunction modelFunction = MysqlModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        MysqlDataModelBase model = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return model.getSlaveModelInfo();
    }
}

